/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer.animation;

import com.momosoftworks.coldsweat.client.renderer.model.PartPose;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class AnimationManager {
    static Field CHILDREN_FIELD = null;
    public static Map<Entity, Float> ANIMATION_TIMERS = new ConcurrentHashMap<Entity, Float>();
    static HashMap<EntityType<?>, Map<String, PartPose>> DEFAULT_POSES = new HashMap();
    static Map<Entity, Map<String, PartPose>> ANIMATION_STATES = new ConcurrentHashMap<Entity, Map<String, PartPose>>();

    public static Map<String, ModelRenderer> getChildrenMap(ModelRenderer part) {
        try {
            ConcurrentHashMap<String, ModelRenderer> map = new ConcurrentHashMap<String, ModelRenderer>((Map)CHILDREN_FIELD.get(part));
            for (ModelRenderer child : map.values()) {
                map.putAll(AnimationManager.getChildrenMap(child));
            }
            return map;
        }
        catch (Exception exception) {
            return new HashMap<String, ModelRenderer>();
        }
    }

    public static void storeDefaultPoses(EntityType type, Map<String, ModelRenderer> parts) {
        DEFAULT_POSES.put(type, parts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, partEntry -> {
            ModelRenderer part = (ModelRenderer)partEntry.getValue();
            return PartPose.offsetAndRotation(part.field_78800_c, part.field_78797_d, part.field_78798_e, part.field_78795_f, part.field_78796_g, part.field_78808_h);
        })));
    }

    static Map<String, PartPose> loadDefaultPoses(EntityType<?> type, Map<String, ModelRenderer> parts) {
        Map<String, PartPose> defaultPoses = DEFAULT_POSES.get(type);
        if (defaultPoses != null) {
            defaultPoses.forEach((name, pose) -> {
                ModelRenderer part = (ModelRenderer)parts.get(name);
                part.field_78800_c = pose.offsetX;
                part.field_78797_d = pose.offsetY;
                part.field_78798_e = pose.offsetZ;
                part.field_78795_f = pose.rotationX;
                part.field_78796_g = pose.rotationY;
                part.field_78808_h = pose.rotationZ;
            });
        }
        return defaultPoses;
    }

    public static void saveAnimationStates(Entity entity, Map<String, ModelRenderer> parts) {
        ANIMATION_STATES.put(entity, parts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, partEntry -> {
            ModelRenderer part = (ModelRenderer)partEntry.getValue();
            return PartPose.offsetAndRotation(part.field_78800_c, part.field_78797_d, part.field_78798_e, part.field_78795_f, part.field_78796_g, part.field_78808_h);
        })));
    }

    public static void loadAnimationStates(Entity entity, Map<String, ModelRenderer> parts) {
        Map animationStates = ANIMATION_STATES.computeIfAbsent(entity, ent -> AnimationManager.loadDefaultPoses(entity.func_200600_R(), parts));
        animationStates.forEach((name, pose) -> {
            ModelRenderer part = (ModelRenderer)parts.get(name);
            part.field_78800_c = pose.offsetX;
            part.field_78797_d = pose.offsetY;
            part.field_78798_e = pose.offsetZ;
            part.field_78795_f = pose.rotationX;
            part.field_78796_g = pose.rotationY;
            part.field_78808_h = pose.rotationZ;
        });
    }

    public static void animateEntity(Entity entity, BiFunction<Float, Float, Float> animator) {
        float timer = ANIMATION_TIMERS.computeIfAbsent(entity, ent -> Float.valueOf(0.0f)).floatValue();
        ANIMATION_TIMERS.put(entity, animator.apply(Float.valueOf(timer), Float.valueOf(Minecraft.func_71410_x().func_193989_ak() / 20.0f)));
    }

    static {
        try {
            CHILDREN_FIELD = ObfuscationReflectionHelper.findField(ModelRenderer.class, (String)"field_78805_m");
            CHILDREN_FIELD.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

