/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer.block;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.momosoftworks.coldsweat.common.block.IceboxBlock;
import com.momosoftworks.coldsweat.common.blockentity.IceboxBlockEntity;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class IceboxBlockEntityRenderer
extends TileEntityRenderer<IceboxBlockEntity> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("cold_sweat", "textures/block/icebox.png");
    public static final ResourceLocation TEXTURE_SMOKESTACK = new ResourceLocation("cold_sweat", "textures/block/icebox_smokestack.png");
    public static final ResourceLocation TEXTURE_FROST = new ResourceLocation("cold_sweat", "textures/block/icebox_frost.png");
    private final ModelRenderer lid = new ModelRenderer(64, 48, 0, 0);
    private final ModelRenderer container;

    public IceboxBlockEntityRenderer(TileEntityRendererDispatcher context) {
        super(context);
        this.lid.func_78793_a(0.0f, 11.0f, 8.0f);
        this.lid.func_78784_a(0, 0).func_228303_a_(-8.0f, -3.0f, -16.0f, 16.0f, 3.0f, 16.0f, 0.0f, false);
        this.container = new ModelRenderer(64, 48, 0, 19);
        this.container.func_78793_a(0.0f, 24.0f, 0.0f);
        this.container.func_78784_a(0, 19).func_228303_a_(-8.0f, -13.0f, -8.0f, 16.0f, 13.0f, 16.0f, 0.0f, false);
    }

    public void render(IceboxBlockEntity blockEntity, float partialTick, MatrixStack poseStack, IRenderTypeBuffer buffer, int light, int overlay) {
        BlockState blockstate = blockEntity.func_195044_w();
        poseStack.func_227860_a_();
        float f = ((Direction)blockstate.func_177229_b((Property)ChestBlock.field_176459_a)).func_185119_l();
        poseStack.func_227861_a_(0.5, 0.5, 0.5);
        poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-f));
        poseStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        poseStack.func_227861_a_(0.0, -1.0, 0.0);
        IVertexBuilder vertexes = buffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)IceboxBlockEntityRenderer.getTexture(blockstate)));
        if (!blockEntity.hasSmokeStack()) {
            float openness = blockEntity.func_195480_a(partialTick);
            openness = 1.0f - openness;
            openness = 1.0f - (float)Math.pow(openness, 3.0);
            this.lid.field_78795_f = -(openness * 1.5707964f) * 0.999f;
        } else {
            this.lid.field_78795_f = 0.0f;
        }
        this.container.func_228308_a_(poseStack, vertexes, light, overlay);
        this.lid.func_228308_a_(poseStack, vertexes, light, overlay);
        if (((Boolean)blockstate.func_177229_b((Property)IceboxBlock.FROSTED)).booleanValue()) {
            IVertexBuilder frostedVertexes = buffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)TEXTURE_FROST));
            this.container.func_228308_a_(poseStack, frostedVertexes, light, overlay);
        }
        poseStack.func_227865_b_();
    }

    public static ResourceLocation getTexture(BlockState state) {
        return (Boolean)state.func_177229_b((Property)IceboxBlock.SMOKESTACK) != false ? TEXTURE_SMOKESTACK : TEXTURE;
    }
}

