/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.client.renderer.model.armor.ArmorModels;
import com.momosoftworks.coldsweat.client.renderer.model.armor.ChameleonBootsModel;
import com.momosoftworks.coldsweat.client.renderer.model.armor.ChameleonChestplateModel;
import com.momosoftworks.coldsweat.client.renderer.model.armor.ChameleonHelmetModel;
import com.momosoftworks.coldsweat.client.renderer.model.armor.ChameleonLeggingsModel;
import com.momosoftworks.coldsweat.common.item.ChameleonArmorItem;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ChameleonArmorLayer<T extends LivingEntity, M extends BipedModel<T>, A extends BipedModel<T>>
extends BipedArmorLayer<T, M, A> {
    public static final ResourceLocation GREEN_LAYER_1_LOCATION = new ResourceLocation("cold_sweat", "textures/models/armor/chameleon_layer_1.png");
    public static final ResourceLocation GREEN_LAYER_2_LOCATION = new ResourceLocation("cold_sweat", "textures/models/armor/chameleon_layer_2.png");
    public static final ResourceLocation RED_LAYER_1_LOCATION = new ResourceLocation("cold_sweat", "textures/models/armor/chameleon_layer_1_red.png");
    public static final ResourceLocation RED_LAYER_2_LOCATION = new ResourceLocation("cold_sweat", "textures/models/armor/chameleon_layer_2_red.png");
    public static final ResourceLocation BLUE_LAYER_1_LOCATION = new ResourceLocation("cold_sweat", "textures/models/armor/chameleon_layer_1_blue.png");
    public static final ResourceLocation BLUE_LAYER_2_LOCATION = new ResourceLocation("cold_sweat", "textures/models/armor/chameleon_layer_2_blue.png");

    public ChameleonArmorLayer(IEntityRenderer<T, M> renderer) {
        super(renderer, null, null);
    }

    public void func_225628_a_(MatrixStack poseStack, IRenderTypeBuffer buffer, int light, T entity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        ArmorModels.CHAMELEON_HELMET_MODEL = new ChameleonHelmetModel();
        ArmorModels.CHAMELEON_CHESTPLATE_MODEL = new ChameleonChestplateModel();
        ArmorModels.CHAMELEON_LEGGINGS_MODEL = new ChameleonLeggingsModel();
        ArmorModels.CHAMELEON_BOOTS_MODEL = new ChameleonBootsModel();
        this.renderArmorPiece(poseStack, buffer, entity, EquipmentSlotType.CHEST, light);
        this.renderArmorPiece(poseStack, buffer, entity, EquipmentSlotType.LEGS, light);
        this.renderArmorPiece(poseStack, buffer, entity, EquipmentSlotType.FEET, light);
        this.renderArmorPiece(poseStack, buffer, entity, EquipmentSlotType.HEAD, light);
    }

    protected void renderArmorPiece(MatrixStack poseStack, IRenderTypeBuffer buffer, T livingEntity, EquipmentSlotType slot, int light) {
        ItemStack itemstack = livingEntity.func_184582_a(slot);
        Item item = itemstack.func_77973_b();
        if (item instanceof ChameleonArmorItem) {
            ChameleonArmorItem armorItem = (ChameleonArmorItem)item;
            if (MobEntity.func_184640_d((ItemStack)itemstack) == slot) {
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                boolean isInnerModel = this.func_188363_b(slot);
                Object model = ChameleonArmorItem.Client.getRealArmorModel(livingEntity, itemstack, slot);
                ((BipedModel)this.func_215332_c()).func_217148_a(model);
                this.setPartVisibilities((BipedModel<T>)model, slot);
                this.renderModel(poseStack, buffer, light, armorItem, (Model)model, isInnerModel, 1.0f, 1.0f, 1.0f, 1.0f, Color.GREEN.getLayer(slot));
                double adaptiveFactor = AdaptiveInsulation.getFactorFromArmor(itemstack);
                ResourceLocation overlay = adaptiveFactor < 0.0 ? Color.BLUE.getLayer(slot) : Color.RED.getLayer(slot);
                float alpha = (float)Math.abs(adaptiveFactor);
                this.renderModel(poseStack, buffer, light, armorItem, (Model)model, isInnerModel, 1.0f, 1.0f, 1.0f, alpha, overlay);
                if (itemstack.func_77962_s()) {
                    this.renderGlint(poseStack, buffer, light, (Model)model);
                }
                RenderSystem.disableBlend();
            }
        }
    }

    protected boolean func_188363_b(EquipmentSlotType slot) {
        return slot == EquipmentSlotType.LEGS;
    }

    protected void renderModel(MatrixStack poseStack, IRenderTypeBuffer buffer, int light, ArmorItem armorItem, Model model, boolean showGlint, float red, float green, float blue, float alpha, ResourceLocation armorResource) {
        IVertexBuilder vertexconsumer = buffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)armorResource));
        model.func_225598_a_(poseStack, vertexconsumer, light, OverlayTexture.field_229196_a_, red, green, blue, alpha);
    }

    protected void renderGlint(MatrixStack poseStack, IRenderTypeBuffer buffer, int packedLight, Model model) {
        model.func_225598_a_(poseStack, buffer.getBuffer(RenderType.func_239271_l_()), packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void setPartVisibilities(BipedModel<T> pModel, EquipmentSlotType pSlot) {
        pModel.func_178719_a(false);
        switch (pSlot) {
            case HEAD: {
                pModel.field_78116_c.field_78806_j = true;
                pModel.field_178720_f.field_78806_j = true;
                break;
            }
            case CHEST: {
                pModel.field_78115_e.field_78806_j = true;
                pModel.field_178723_h.field_78806_j = true;
                pModel.field_178724_i.field_78806_j = true;
                break;
            }
            case LEGS: {
                pModel.field_78115_e.field_78806_j = true;
                pModel.field_178721_j.field_78806_j = true;
                pModel.field_178722_k.field_78806_j = true;
                break;
            }
            case FEET: {
                pModel.field_178721_j.field_78806_j = true;
                pModel.field_178722_k.field_78806_j = true;
            }
        }
    }

    public static enum Color {
        GREEN(GREEN_LAYER_1_LOCATION, GREEN_LAYER_2_LOCATION),
        RED(RED_LAYER_1_LOCATION, RED_LAYER_2_LOCATION),
        BLUE(BLUE_LAYER_1_LOCATION, BLUE_LAYER_2_LOCATION);

        private final ResourceLocation layer1;
        private final ResourceLocation layer2;

        private Color(ResourceLocation layer1, ResourceLocation layer2) {
            this.layer1 = layer1;
            this.layer2 = layer2;
        }

        public ResourceLocation getLayer1() {
            return this.layer1;
        }

        public ResourceLocation getLayer2() {
            return this.layer2;
        }

        public ResourceLocation getLayer(EquipmentSlotType slot) {
            return slot == EquipmentSlotType.LEGS ? this.layer2 : this.layer1;
        }
    }
}

