/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer.model.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.momosoftworks.coldsweat.client.renderer.ChameleonAnimations;
import com.momosoftworks.coldsweat.client.renderer.animation.AnimationManager;
import com.momosoftworks.coldsweat.client.renderer.entity.ChameleonEntityRenderer;
import com.momosoftworks.coldsweat.common.entity.ChameleonEntity;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModEntities;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.IHasHead;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class ChameleonModel<T extends ChameleonEntity>
extends AgeableModel<T>
implements IHasHead {
    ChameleonEntity chameleon;
    boolean tongueVisible = false;
    public Map<String, ModelRenderer> modelParts = new HashMap<String, ModelRenderer>();
    private final ModelRenderer body;
    private final ModelRenderer head;
    private final ModelRenderer topFrill;
    private final ModelRenderer jaw;
    private final ModelRenderer rightEye;
    private final ModelRenderer leftEye;
    private final ModelRenderer tongue1;
    private final ModelRenderer tongue2;
    private final ModelRenderer tongue3;
    private final ModelRenderer rightFrontLeg;
    private final ModelRenderer rightFrontLeg2;
    private final ModelRenderer rightFrontFoot1;
    private final ModelRenderer rightFrontFoot2;
    private final ModelRenderer leftFrontLeg;
    private final ModelRenderer leftFrontLeg2;
    private final ModelRenderer leftFrontFoot1;
    private final ModelRenderer leftFrontFoot2;
    private final ModelRenderer rightBackLeg;
    private final ModelRenderer rightBackLeg2;
    private final ModelRenderer rightBackFoot1;
    private final ModelRenderer rightBackFoot2;
    private final ModelRenderer leftBackLeg;
    private final ModelRenderer leftBackLeg2;
    private final ModelRenderer leftBackFoot1;
    private final ModelRenderer leftBackFoot2;
    private final ModelRenderer tail1;
    private final ModelRenderer tail2;
    private final ModelRenderer tail3;

    public ChameleonModel() {
        super(RenderType::func_228644_e_, true, 4.75f, 0.75f, 1.8f, 1.6f, 14.0f);
        this.field_78090_t = 48;
        this.field_78089_u = 32;
        this.body = new ModelRenderer((Model)this);
        this.modelParts.put("Body", this.body);
        this.body.func_78793_a(0.0f, 24.0f, 0.0f);
        this.body.func_78784_a(1, 16).func_228303_a_(-2.0f, -8.0f, -3.0f, 4.0f, 7.0f, 9.0f, 0.0f, false);
        this.head = new ModelRenderer((Model)this);
        this.modelParts.put("Head", this.head);
        this.head.func_78793_a(0.0f, -5.0f, -3.0f);
        this.head.func_78784_a(0, 0).func_228303_a_(-2.0f, -2.0f, -7.0f, 4.0f, 4.0f, 7.0f, 0.0f, false);
        this.topFrill = new ModelRenderer((Model)this);
        this.modelParts.put("TopFrill", this.topFrill);
        this.topFrill.func_78793_a(0.0f, -3.0f, -5.0f);
        this.head.func_78792_a(this.topFrill);
        this.topFrill.field_78795_f = 0.7418f;
        this.topFrill.func_78784_a(30, 0).func_228303_a_(-1.0f, 1.4f, 0.05f, 2.0f, 4.0f, 7.0f, 0.0f, false);
        this.jaw = new ModelRenderer((Model)this);
        this.modelParts.put("Jaw", this.jaw);
        this.jaw.func_78793_a(0.0f, 2.0f, 0.0f);
        this.head.func_78792_a(this.jaw);
        this.jaw.func_78784_a(15, 7).func_228303_a_(-2.0f, 0.0f, -7.0f, 4.0f, 1.0f, 7.0f, 0.0f, false);
        this.jaw.func_78784_a(18, 15).func_228303_a_(0.0f, 1.0f, -6.0f, 0.0f, 1.0f, 6.0f, 0.0f, false);
        this.rightEye = new ModelRenderer((Model)this);
        this.modelParts.put("RightEye", this.rightEye);
        this.rightEye.func_78793_a(-1.5f, 0.0f, -3.5f);
        this.head.func_78792_a(this.rightEye);
        this.rightEye.func_78784_a(15, 1).func_228303_a_(-1.5f, -1.5f, -1.5f, 2.0f, 3.0f, 3.0f, 0.0f, false);
        this.leftEye = new ModelRenderer((Model)this);
        this.modelParts.put("LeftEye", this.leftEye);
        this.leftEye.func_78793_a(1.0005f, -0.0218f, -3.366f);
        this.head.func_78792_a(this.leftEye);
        this.leftEye.func_78784_a(15, 1).func_228303_a_(-5.0E-4f, -1.4782f, -1.634f, 2.0f, 3.0f, 3.0f, 0.0f, true);
        this.tongue1 = new ModelRenderer((Model)this);
        this.modelParts.put("Tongue1", this.tongue1);
        this.tongue1.func_78793_a(0.0f, 2.0f, 0.0f);
        this.head.func_78792_a(this.tongue1);
        this.tongue1.func_78784_a(27, 25).func_228303_a_(-1.0f, 0.0f, -7.0f, 2.0f, 0.0f, 7.0f, 0.0f, false);
        this.tongue2 = new ModelRenderer((Model)this);
        this.modelParts.put("Tongue2", this.tongue2);
        this.tongue2.func_78793_a(0.0f, 3.0f, 3.0f);
        this.tongue1.func_78792_a(this.tongue2);
        this.tongue2.func_78784_a(27, 25).func_228303_a_(-1.0f, -3.0f, -10.0f, 2.0f, 0.0f, 7.0f, 0.0f, false);
        this.tongue3 = new ModelRenderer((Model)this);
        this.modelParts.put("Tongue3", this.tongue3);
        this.tongue3.func_78793_a(0.0f, 0.0f, 0.0f);
        this.tongue2.func_78792_a(this.tongue3);
        this.tongue3.func_78784_a(27, 25).func_228303_a_(-1.0f, -3.0f, -10.0f, 2.0f, 0.0f, 7.0f, 0.0f, false);
        this.rightFrontLeg = new ModelRenderer((Model)this);
        this.modelParts.put("RightFrontLeg", this.rightFrontLeg);
        this.rightFrontLeg.func_78793_a(-2.0f, -3.0f, -1.0f);
        this.body.func_78792_a(this.rightFrontLeg);
        this.rightFrontLeg.func_78784_a(38, 25).func_228303_a_(-4.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, 0.0f, true);
        this.rightFrontLeg2 = new ModelRenderer((Model)this);
        this.modelParts.put("RightFrontLeg2", this.rightFrontLeg2);
        this.rightFrontLeg2.func_78793_a(-4.0f, 0.0f, 0.0f);
        this.rightFrontLeg.func_78792_a(this.rightFrontLeg2);
        this.rightFrontLeg2.func_78784_a(38, 29).func_228303_a_(-4.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, 0.0f, true);
        this.rightFrontFoot1 = new ModelRenderer((Model)this);
        this.modelParts.put("RightFrontFoot1", this.rightFrontFoot1);
        this.rightFrontFoot1.func_78793_a(-4.0f, 0.0f, 0.0f);
        this.rightFrontLeg2.func_78792_a(this.rightFrontFoot1);
        this.rightFrontFoot1.func_78784_a(28, 27).func_228303_a_(0.0f, -3.0f, -1.0f, 0.0f, 3.0f, 2.0f, 0.0f, true);
        this.rightFrontFoot2 = new ModelRenderer((Model)this);
        this.modelParts.put("RightFrontFoot2", this.rightFrontFoot2);
        this.rightFrontFoot2.func_78793_a(-4.0f, 0.0f, 0.0f);
        this.rightFrontLeg2.func_78792_a(this.rightFrontFoot2);
        this.rightFrontFoot2.func_78784_a(28, 24).func_228303_a_(0.0f, 0.0f, -1.0f, 0.0f, 2.0f, 1.0f, 0.0f, true);
        this.leftFrontLeg = new ModelRenderer((Model)this);
        this.modelParts.put("LeftFrontLeg", this.leftFrontLeg);
        this.leftFrontLeg.func_78793_a(2.0f, -3.0f, -1.0f);
        this.body.func_78792_a(this.leftFrontLeg);
        this.leftFrontLeg.func_78784_a(38, 25).func_228303_a_(0.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, 0.0f, false);
        this.leftFrontLeg2 = new ModelRenderer((Model)this);
        this.modelParts.put("LeftFrontLeg2", this.leftFrontLeg2);
        this.leftFrontLeg2.func_78793_a(4.0f, 0.0f, 0.0f);
        this.leftFrontLeg.func_78792_a(this.leftFrontLeg2);
        this.leftFrontLeg2.func_78784_a(38, 29).func_228303_a_(0.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, 0.0f, false);
        this.leftFrontFoot1 = new ModelRenderer((Model)this);
        this.modelParts.put("LeftFrontFoot1", this.leftFrontFoot1);
        this.leftFrontFoot1.func_78793_a(4.0f, 0.0f, 0.0f);
        this.leftFrontLeg2.func_78792_a(this.leftFrontFoot1);
        this.leftFrontFoot1.func_78784_a(28, 27).func_228303_a_(0.0f, -3.0f, -1.0f, 0.0f, 3.0f, 2.0f, 0.0f, false);
        this.leftFrontFoot2 = new ModelRenderer((Model)this);
        this.modelParts.put("LeftFrontFoot2", this.leftFrontFoot2);
        this.leftFrontFoot2.func_78793_a(4.0f, 0.0f, 0.0f);
        this.leftFrontLeg2.func_78792_a(this.leftFrontFoot2);
        this.leftFrontFoot2.func_78784_a(28, 24).func_228303_a_(0.0f, 0.0f, -1.0f, 0.0f, 2.0f, 1.0f, 0.0f, false);
        this.rightBackLeg = new ModelRenderer((Model)this);
        this.modelParts.put("RightBackLeg", this.rightBackLeg);
        this.rightBackLeg.func_78793_a(-2.0f, -3.0f, 4.0f);
        this.body.func_78792_a(this.rightBackLeg);
        this.rightBackLeg.func_78784_a(38, 25).func_228303_a_(-4.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, 0.0f, true);
        this.rightBackLeg2 = new ModelRenderer((Model)this);
        this.modelParts.put("RightBackLeg2", this.rightBackLeg2);
        this.rightBackLeg2.func_78793_a(-4.0f, 0.0f, 0.0f);
        this.rightBackLeg.func_78792_a(this.rightBackLeg2);
        this.rightBackLeg2.func_78784_a(38, 29).func_228303_a_(-4.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, 0.0f, true);
        this.rightBackFoot1 = new ModelRenderer((Model)this);
        this.modelParts.put("RightBackFoot1", this.rightBackFoot1);
        this.rightBackFoot1.func_78793_a(-4.0f, 0.0f, 0.0f);
        this.rightBackLeg2.func_78792_a(this.rightBackFoot1);
        this.rightBackFoot1.func_78784_a(28, 27).func_228303_a_(0.0f, -3.0f, -1.0f, 0.0f, 3.0f, 2.0f, 0.0f, true);
        this.rightBackFoot2 = new ModelRenderer((Model)this);
        this.modelParts.put("RightBackFoot2", this.rightBackFoot2);
        this.rightBackFoot2.func_78793_a(-4.0f, 0.0f, 0.0f);
        this.rightBackLeg2.func_78792_a(this.rightBackFoot2);
        this.rightBackFoot2.func_78784_a(28, 24).func_228303_a_(0.0f, 0.0f, -1.0f, 0.0f, 2.0f, 1.0f, 0.0f, true);
        this.leftBackLeg = new ModelRenderer((Model)this);
        this.modelParts.put("LeftBackLeg", this.leftBackLeg);
        this.leftBackLeg.func_78793_a(2.0f, -3.0f, 4.0f);
        this.body.func_78792_a(this.leftBackLeg);
        this.leftBackLeg.func_78784_a(38, 25).func_228303_a_(0.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, 0.0f, false);
        this.leftBackLeg2 = new ModelRenderer((Model)this);
        this.modelParts.put("LeftBackLeg2", this.leftBackLeg2);
        this.leftBackLeg2.func_78793_a(4.0f, 0.0f, 0.0f);
        this.leftBackLeg.func_78792_a(this.leftBackLeg2);
        this.leftBackLeg2.func_78784_a(38, 29).func_228303_a_(0.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, 0.0f, false);
        this.leftBackFoot1 = new ModelRenderer((Model)this);
        this.modelParts.put("LeftBackFoot1", this.leftBackFoot1);
        this.leftBackFoot1.func_78793_a(4.0f, 0.0f, 0.0f);
        this.leftBackLeg2.func_78792_a(this.leftBackFoot1);
        this.leftBackFoot1.func_78784_a(28, 27).func_228303_a_(0.0f, -3.0f, -1.0f, 0.0f, 3.0f, 2.0f, 0.0f, false);
        this.leftBackFoot2 = new ModelRenderer((Model)this);
        this.modelParts.put("LeftBackFoot2", this.leftBackFoot2);
        this.leftBackFoot2.func_78793_a(4.0f, 0.0f, 0.0f);
        this.leftBackLeg2.func_78792_a(this.leftBackFoot2);
        this.leftBackFoot2.func_78784_a(27, 24).func_228303_a_(0.0f, 0.0f, -1.0f, 0.0f, 2.0f, 1.0f, 0.0f, false);
        this.tail1 = new ModelRenderer((Model)this);
        this.modelParts.put("Tail", this.tail1);
        this.tail1.func_78793_a(0.0f, -3.5f, 6.0f);
        this.body.func_78792_a(this.tail1);
        this.tail1.func_78784_a(34, 18).func_228303_a_(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 4.0f, 0.0f, false);
        this.tail2 = new ModelRenderer((Model)this);
        this.modelParts.put("Tail2", this.tail2);
        this.tail2.func_78793_a(0.0f, 0.0f, 4.0f);
        this.tail1.func_78792_a(this.tail2);
        this.tail2.func_78784_a(38, 13).func_228303_a_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 3.0f, 0.0f, false);
        this.tail3 = new ModelRenderer((Model)this);
        this.modelParts.put("Tail3", this.tail3);
        this.tail3.func_78793_a(0.0f, 0.0f, 3.0f);
        this.tail2.func_78792_a(this.tail3);
        this.tail3.func_78784_a(0, 17).func_228303_a_(-0.5f, -1.0f, 0.0f, 1.0f, 4.0f, 4.0f, 0.0f, false);
        this.head.field_78797_d = 19.2f;
        this.body.field_78797_d -= 0.8f;
        AnimationManager.storeDefaultPoses(ModEntities.CHAMELEON, this.modelParts);
    }

    public ModelRenderer func_205072_a() {
        return this.head;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.chameleon = entity;
        AnimationManager.loadAnimationStates(entity, this.modelParts);
        float tickDelta = Minecraft.func_71410_x().func_193989_ak();
        float partialTick = Minecraft.func_71410_x().func_184121_ak();
        ModelRenderer head = this.modelParts.get("Head");
        ModelRenderer rightEye = this.modelParts.get("RightEye");
        ModelRenderer leftEye = this.modelParts.get("LeftEye");
        float desiredXHead = CSMath.toRadians(headPitch);
        boolean hasLookTarget = ((ChameleonEntity)((Object)entity)).isWalking() || ((ChameleonEntity)((Object)entity)).getEatTimer() > 0.0f;
        ((ChameleonEntity)((Object)entity)).xRotHead = ((ChameleonEntity)((Object)entity)).xRotHead + ((hasLookTarget ? desiredXHead : CSMath.clamp(((ChameleonEntity)((Object)entity)).xRotHead, desiredXHead - 0.4f, desiredXHead + 0.4f)) - ((ChameleonEntity)((Object)entity)).xRotHead) * tickDelta;
        float desiredYHead = CSMath.toRadians(netHeadYaw);
        ((ChameleonEntity)((Object)entity)).yRotHead = ((ChameleonEntity)((Object)entity)).yRotHead + ((hasLookTarget ? desiredYHead : CSMath.clamp(((ChameleonEntity)((Object)entity)).yRotHead, desiredYHead - 0.6f, desiredYHead + 0.6f)) - ((ChameleonEntity)((Object)entity)).yRotHead) * tickDelta;
        if (head.field_78796_g < desiredYHead) {
            ((ChameleonEntity)((Object)entity)).yRotRightEye += (-CSMath.clamp(desiredYHead - head.field_78796_g, -0.5f, 0.5f) - ((ChameleonEntity)((Object)entity)).yRotRightEye) * tickDelta;
            ((ChameleonEntity)((Object)entity)).xRotRightEye += (-CSMath.clamp(desiredXHead - head.field_78795_f, -0.5f, 0.5f) - ((ChameleonEntity)((Object)entity)).xRotRightEye) * tickDelta;
        } else {
            ((ChameleonEntity)((Object)entity)).yRotRightEye += (0.0f - ((ChameleonEntity)((Object)entity)).yRotRightEye) * tickDelta;
            ((ChameleonEntity)((Object)entity)).xRotRightEye += (0.0f - ((ChameleonEntity)((Object)entity)).xRotRightEye) * tickDelta;
        }
        if (head.field_78796_g > desiredYHead) {
            ((ChameleonEntity)((Object)entity)).yRotLeftEye += (CSMath.clamp(head.field_78796_g - desiredYHead, -0.5f, 0.5f) - ((ChameleonEntity)((Object)entity)).yRotLeftEye) * tickDelta;
            ((ChameleonEntity)((Object)entity)).xRotLeftEye += (CSMath.clamp(desiredXHead - head.field_78795_f, -0.5f, 0.5f) - ((ChameleonEntity)((Object)entity)).xRotLeftEye) * tickDelta;
        } else {
            ((ChameleonEntity)((Object)entity)).yRotLeftEye += -((ChameleonEntity)((Object)entity)).yRotLeftEye * tickDelta;
            ((ChameleonEntity)((Object)entity)).xRotLeftEye += -((ChameleonEntity)((Object)entity)).xRotLeftEye * tickDelta;
        }
        head.field_78795_f = ((ChameleonEntity)((Object)entity)).xRotHead;
        head.field_78796_g = ((ChameleonEntity)((Object)entity)).yRotHead;
        rightEye.field_78796_g = ((ChameleonEntity)((Object)entity)).yRotRightEye;
        rightEye.field_78808_h = ((ChameleonEntity)((Object)entity)).xRotRightEye;
        leftEye.field_78796_g = ((ChameleonEntity)((Object)entity)).yRotLeftEye;
        leftEye.field_78808_h = ((ChameleonEntity)((Object)entity)).xRotLeftEye;
        AnimationManager.saveAnimationStates(entity, this.modelParts);
        AnimationManager.animateEntity(entity, (animTime, frameTime) -> {
            Vector3d velocity;
            float prevAnimTime = animTime.floatValue();
            HashMap<String, ModelRenderer> animatedParts = new HashMap<String, ModelRenderer>(this.modelParts);
            animatedParts.remove("Head");
            animatedParts.remove("LeftEye");
            animatedParts.remove("RightEye");
            animatedParts.remove("Tail");
            animatedParts.remove("Tail2");
            animatedParts.remove("Tail3");
            if (this.field_217113_d && entity.func_184187_bx() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entity.func_184187_bx();
                float playerYaw = CSMath.blend(player.field_70758_at, player.field_70759_as, partialTick, 0.0f, 1.0f);
                animTime = Float.valueOf(animTime.floatValue() + frameTime.floatValue());
                ChameleonAnimations.RIDE.animateAll(animatedParts, animTime.floatValue(), false);
                if (!this.chameleon.isTracking()) {
                    ChameleonAnimations.RIDE.animate("Tail", this.tail1, 0.0f, false);
                    ChameleonAnimations.RIDE.animate("Tail2", this.tail2, 0.0f, false);
                    ChameleonAnimations.RIDE.animate("Tail3", this.tail3, 0.0f, false);
                }
                if (this.field_217114_e) {
                    this.body.field_78797_d -= 14.0f;
                    head.field_78797_d -= 4.0f;
                }
                this.body.field_78797_d -= player.func_213302_cg() / 2.0f * 16.0f - 4.0f;
                head.field_78797_d -= player.func_213302_cg() / 2.0f * 16.0f + 11.0f;
                this.body.field_78796_g = CSMath.toRadians(playerYaw) - CSMath.toRadians(CSMath.blend(player.field_70760_ar, player.field_70761_aq, partialTick, 0.0f, 1.0f));
                head.field_78796_g = CSMath.toRadians(entity.func_195046_g(partialTick) - player.func_195046_g(partialTick)) + 0.2f;
                head.field_78795_f = CSMath.clamp(CSMath.toRadians(entity.func_195050_f(partialTick) - player.func_195050_f(partialTick)) + 0.2f, -1.0f, 1.0f);
            } else if (entity.isWalking()) {
                float walkSpeed = Math.min(0.15f, (float)new Vector3d((double)((float)entity.func_213322_ci().field_72450_a), 0.0, (double)((float)entity.func_213322_ci().field_72449_c)).func_72433_c());
                animTime = Float.valueOf(animTime.floatValue() + frameTime.floatValue() * walkSpeed * (float)(this.field_217114_e ? 50 : 30));
                ChameleonAnimations.WALK.animateAll(animatedParts, animTime.floatValue(), true);
                if (!this.chameleon.isTracking()) {
                    ChameleonAnimations.WALK.animate("Tail", this.tail1, animTime.floatValue(), true);
                    ChameleonAnimations.WALK.animate("Tail2", this.tail2, animTime.floatValue(), true);
                    ChameleonAnimations.WALK.animate("Tail3", this.tail3, animTime.floatValue(), true);
                }
            } else {
                animTime = Float.valueOf(animTime.floatValue() + frameTime.floatValue());
                ChameleonAnimations.IDLE.animateAll(animatedParts, animTime.floatValue(), true);
                if (!this.chameleon.isTracking()) {
                    ChameleonAnimations.WALK.animate("Tail", this.tail1, 0.0f, true);
                    ChameleonAnimations.WALK.animate("Tail2", this.tail2, 0.0f, true);
                    ChameleonAnimations.WALK.animate("Tail3", this.tail3, 0.0f, true);
                }
            }
            if (this.chameleon.isTracking()) {
                float rotY;
                BlockPos trackingPos = this.chameleon.getTrackingPos();
                Vector3d entityPos = entity.func_242282_l(partialTick);
                Vector3d trackingDirection = new Vector3d((double)trackingPos.func_177958_n() - entityPos.field_72450_a, 0.0, (double)trackingPos.func_177952_p() - entityPos.field_72449_c);
                float playerRotX = 0.0f;
                if (entity.func_184187_bx() instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)entity.func_184187_bx();
                    playerRotX = player.func_195050_f(partialTick);
                    rotY = CSMath.blend(player.field_70758_at, player.field_70759_as, partialTick, 0.0f, 1.0f);
                } else {
                    rotY = CSMath.blend(entity.field_70760_ar, entity.field_70761_aq, partialTick, 0.0f, 1.0f);
                }
                float angle = (float)Math.atan2(trackingDirection.field_72449_c, trackingDirection.field_72450_a) - CSMath.toRadians(MathHelper.func_76142_g((float)rotY));
                float desiredTailRot = angle + CSMath.toRadians(90.0f);
                this.tail1.field_78796_g = this.tail2.field_78796_g = (float)Math.sin(desiredTailRot) / 1.3f;
                this.tail3.field_78796_g = this.tail2.field_78796_g;
                this.tail2.field_78795_f = Math.max(0.0f, (float)Math.sin((double)desiredTailRot - 1.5707963267948966) + 0.2f);
                this.tail3.field_78795_f = this.tail2.field_78795_f / 1.5f;
                this.tail1.field_78795_f = this.tail3.field_78795_f - CSMath.toRadians(playerRotX) / 1.25f + 0.1f;
            }
            if (entity.getEatTimer() > 0.0f) {
                this.tongueVisible = true;
                ChameleonAnimations.EAT.animateAll(this.modelParts, CSMath.blend(0.5f, 0.0f, entity.getEatTimer() - Minecraft.func_71410_x().func_184121_ak(), 0.0f, entity.getEatAnimLength()), true);
            } else {
                this.tongueVisible = false;
            }
            if (Minecraft.func_71410_x().func_147113_T()) {
                return Float.valueOf(prevAnimTime);
            }
            float playerXHead = 0.0f;
            if (entity.func_184187_bx() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entity.func_184187_bx();
                playerXHead = CSMath.toRadians(player.func_195050_f(partialTick));
            }
            Vector3d vector3d = velocity = playerXHead != 0.0f ? entity.func_184187_bx().func_213322_ci() : entity.func_213322_ci();
            if (!this.chameleon.isTracking()) {
                float speed = (float)Math.sqrt(velocity.field_72450_a * velocity.field_72450_a + velocity.field_72449_c * velocity.field_72449_c);
                float tailSpeed = Math.min(0.1f, speed / 2.0f) + 0.01f;
                float deltaTime = Minecraft.func_71410_x().func_193989_ak();
                this.chameleon.tailPhase = (float)((double)this.chameleon.tailPhase + Math.PI * 2 * (double)deltaTime * (double)tailSpeed);
                float speedStraightFactor = 3.0f + speed * 100.0f;
                float tailRot1 = (float)Math.sin(this.chameleon.tailPhase - 0.0f) / speedStraightFactor;
                float tailRot2 = (float)Math.sin(this.chameleon.tailPhase - 1.0f) / speedStraightFactor;
                float tailRot3 = (float)Math.sin(this.chameleon.tailPhase - 2.0f) / speedStraightFactor;
                float tailRotation = 1.0f + Math.abs(this.tail1.field_78795_f - 0.2f) * 1.0f;
                this.tail1.field_78796_g = tailRot1 / tailRotation;
                this.tail2.field_78796_g = tailRot2 / tailRotation;
                this.tail3.field_78796_g = tailRot3 / tailRotation;
            }
            float playerYVel = (float)velocity.field_72448_b;
            float tailRot = entity.xRotTail = (float)((double)entity.xRotTail + (CSMath.clamp((double)playerYVel, -0.5, 0.5) - (double)entity.xRotTail) * (double)frameTime.floatValue() * 8.0);
            tailRot = (float)((double)tailRot * CSMath.clamp((double)Math.abs(this.tail1.field_78795_f + this.tail2.field_78795_f + this.tail3.field_78795_f + playerXHead) - 2.3, -1.0, 1.0));
            this.tail1.field_78795_f += tailRot;
            this.tail2.field_78795_f += tailRot;
            this.tail3.field_78795_f += tailRot;
            return animTime;
        });
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.renderToBuffer(matrixStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha, false);
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return Arrays.asList(this.head);
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return Arrays.asList(this.body);
    }

    public void renderToBuffer(MatrixStack poseStack, IVertexBuilder vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, boolean isOverlay) {
        if (this.chameleon == null) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float partialTick = Minecraft.func_71410_x().func_184121_ak();
        long tickCount = this.chameleon.field_70173_aa;
        long hurtTime = this.chameleon.getHurtTimestamp();
        if (!isOverlay && this.chameleon.func_70089_S()) {
            if (CSMath.betweenInclusive(tickCount - hurtTime, 0.0, 40.0) && hurtTime != 0L) {
                this.chameleon.opacity = CSMath.blend(alpha, alpha * 0.15f, (float)tickCount + partialTick - (float)hurtTime, 0.0f, 40.0f);
            } else if (this.chameleon.opacity < alpha) {
                this.chameleon.opacity = CSMath.blend(alpha * 0.15f, alpha, (float)tickCount + partialTick - (float)hurtTime, 120.0f, 180.0f);
            }
        }
        this.tongue1.field_78806_j = false;
        super.func_225598_a_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, isOverlay ? alpha : this.chameleon.opacity);
        if (this.tongueVisible && !isOverlay) {
            poseStack.func_227860_a_();
            IVertexBuilder tongueConsumer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_().getBuffer(RenderType.func_228638_b_((ResourceLocation)ChameleonEntityRenderer.CHAMELEON_GREEN));
            this.tongue1.field_78806_j = true;
            poseStack.func_227861_a_(0.0, 1.1555, -0.18755);
            this.tongue1.field_78795_f = this.head.field_78795_f + this.jaw.field_78795_f / 2.0f;
            this.tongue1.field_78796_g = this.head.field_78796_g;
            this.tongue1.func_228309_a_(poseStack, tongueConsumer, packedLight, packedOverlay, red, green, blue, this.chameleon.opacity);
            poseStack.func_227865_b_();
        }
        RenderSystem.disableBlend();
    }
}

