/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.block;

import com.momosoftworks.coldsweat.common.blockentity.BoilerBlockEntity;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.core.init.BlockEntityInit;
import com.momosoftworks.coldsweat.core.itemgroup.ColdSweatGroup;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import java.util.Random;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class BoilerBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;

    public static AbstractBlock.Properties getProperties() {
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_200948_a(2.0f, 10.0f).func_235838_a_(BoilerBlock.getLightValueLit(13)).func_235828_a_(BoilerBlock::conductsRedstone).func_235861_h_();
    }

    public static Item.Properties getItemProperties() {
        return new Item.Properties().func_200916_a((ItemGroup)ColdSweatGroup.COLD_SWEAT);
    }

    private static boolean conductsRedstone(BlockState state, IBlockReader level, BlockPos pos) {
        TileEntity be = level.func_175625_s(pos);
        if (be instanceof HearthBlockEntity) {
            return !((HearthBlockEntity)be).hasSmokeStack();
        }
        return false;
    }

    private static ToIntFunction<BlockState> getLightValueLit(int lightValue) {
        return state -> (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) != false ? lightValue : 0;
    }

    public BoilerBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        TileEntity te;
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == ModItems.SMOKESTACK && rayTraceResult.func_216354_b() == Direction.UP && level.func_180495_p(pos.func_177984_a()).func_196953_a(new BlockItemUseContext(player, hand, stack, rayTraceResult))) {
            return ActionResultType.FAIL;
        }
        if (!level.field_72995_K && (te = level.func_175625_s(pos)) instanceof BoilerBlockEntity) {
            BoilerBlockEntity blockEntity = (BoilerBlockEntity)te;
            int itemFuel = blockEntity.getItemFuel(stack);
            if (itemFuel != 0 && (double)blockEntity.getFuel() + (double)itemFuel * 0.75 < (double)blockEntity.getMaxFuel()) {
                if (!player.func_184812_l_()) {
                    if (stack.hasContainerItem()) {
                        ItemStack container = stack.getContainerItem();
                        stack.func_190918_g(1);
                        player.field_71071_by.func_70441_a(container);
                    } else {
                        stack.func_190918_g(1);
                    }
                }
                blockEntity.setFuel(blockEntity.getFuel() + itemFuel);
                level.func_184133_a(null, pos, SoundEvents.field_187627_L, SoundCategory.BLOCKS, 1.0f, 0.9f + new Random().nextFloat() * 0.2f);
            } else {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)blockEntity, (BlockPos)pos);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighborState, IWorld level, BlockPos pos, BlockPos neighborPos) {
        BoilerBlockEntity boiler;
        boolean hadSmokestack;
        TileEntity be = level.func_175625_s(pos);
        if (neighborPos.equals((Object)pos.func_177984_a()) && be instanceof BoilerBlockEntity && (hadSmokestack = (boiler = (BoilerBlockEntity)be).hasSmokeStack()) != boiler.checkForSmokestack()) {
            level.func_230547_a_(pos, (Block)this);
        }
        return super.func_196271_a(state, direction, neighborState, level, pos, neighborPos);
    }

    public void func_220069_a(BlockState state, World level, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, level, pos, neighborBlock, fromPos, isMoving);
        HearthBlockEntity hearth = (HearthBlockEntity)level.func_175625_s(pos);
        if (hearth != null) {
            hearth.checkInputSignal();
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity te;
        if (state.func_177230_c() != newState.func_177230_c() && (te = world.func_175625_s(pos)) instanceof BoilerBlockEntity) {
            BoilerBlockEntity boiler = (BoilerBlockEntity)te;
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)boiler);
            world.func_195593_d(pos, (Block)this);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public BlockState func_185499_a(BlockState state, Rotation direction) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)direction.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, LIT});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World world, BlockPos pos, Random rand) {
        ParticleStatus status = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        if (((Boolean)stateIn.func_177229_b((Property)LIT)).booleanValue() && status != ParticleStatus.MINIMAL) {
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = pos.func_177956_o();
            double d2 = (double)pos.func_177952_p() + 0.5;
            Direction direction = (Direction)stateIn.func_177229_b((Property)FACING);
            Direction.Axis direction$axis = direction.func_176740_k();
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.func_82601_c() * 0.52 : d4;
            double d6 = rand.nextDouble() * 3.0 / 16.0 + 0.1875;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.func_82599_e() * 0.52 : d4;
            world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)BlockEntityInit.BOILER_BLOCK_ENTITY_TYPE.get()).func_200968_a();
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader level, BlockPos pos, @Nullable Direction direction) {
        return direction != null && direction.func_176740_k() != Direction.Axis.Y && direction != ((Direction)state.func_177229_b((Property)FACING)).func_176734_d() && level.func_180495_p(pos.func_177984_a()).func_203425_a(ModBlocks.SMOKESTACK);
    }

    public boolean func_149740_M(BlockState pState) {
        return true;
    }

    public int func_180641_l(BlockState pState, World level, BlockPos pos) {
        return Container.func_178144_a((TileEntity)level.func_175625_s(pos));
    }
}

