/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.block;

import com.momosoftworks.coldsweat.core.itemgroup.ColdSweatGroup;
import com.momosoftworks.coldsweat.data.tag.ModBlockTags;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class SmokestackBlock
extends Block
implements IWaterLoggable {
    public static final EnumProperty<Facing> FACING = EnumProperty.func_177709_a((String)"facing", Facing.class);
    public static final BooleanProperty END = BooleanProperty.func_177716_a((String)"end");
    public static final BooleanProperty BASE = BooleanProperty.func_177716_a((String)"base");
    public static final BooleanProperty ENCASED = BooleanProperty.func_177716_a((String)"encased");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public SmokestackBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(FACING, (Comparable)((Object)Facing.UP))).func_206870_a((Property)END, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BASE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)ENCASED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static AbstractBlock.Properties getProperties() {
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_200948_a(2.0f, 10.0f).func_235861_h_();
    }

    public static Item.Properties getItemProperties() {
        return new Item.Properties().func_200916_a((ItemGroup)ColdSweatGroup.COLD_SWEAT);
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_213453_ef() && ModItemTags.ENCASES_SMOKESTACK.func_230235_a_((Object)stack.func_77973_b()) && !((Boolean)state.func_177229_b((Property)ENCASED)).booleanValue() && state.func_177229_b(FACING) != Facing.BEND) {
            level.func_180501_a(pos, (BlockState)((BlockState)((BlockState)state.func_206870_a((Property)ENCASED, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)END, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BASE, (Comparable)Boolean.valueOf(false)), 3);
            player.func_226292_a_(hand, true);
            level.func_184133_a(null, pos, this.getSoundType(state, (IWorldReader)level, pos, (Entity)player).func_185841_e(), SoundCategory.BLOCKS, 1.0f, 0.8f);
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            return ActionResultType.CONSUME;
        }
        return super.func_225533_a_(state, level, pos, player, hand, rayTraceResult);
    }

    public boolean func_200123_i(BlockState state, IBlockReader level, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)ENCASED) == false && state.func_177229_b(FACING) != Facing.BEND;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader getter, BlockPos pos, ISelectionContext context) {
        if (((Boolean)state.func_177229_b((Property)ENCASED)).booleanValue()) {
            return Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }
        switch ((Facing)((Object)state.func_177229_b(FACING))) {
            case UP: 
            case DOWN: {
                return Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
            }
            case NORTH: 
            case SOUTH: {
                return Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0);
            }
            case EAST: 
            case WEST: {
                return Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
            }
            case BEND: {
                return Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            }
        }
        return VoxelShapes.func_197868_b();
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a(FACING, (Comparable)((Object)((Facing)((Object)state.func_177229_b(FACING))).rotate(rotation)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return (BlockState)state.func_206870_a(FACING, (Comparable)((Object)((Facing)((Object)state.func_177229_b(FACING))).mirror(mirror)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, END, BASE, ENCASED, WATERLOGGED});
    }

    protected Facing calculateFacing(Facing facing, BlockPos pos, IWorld level) {
        Direction newDir = null;
        for (Direction dir : Direction.values()) {
            BlockState neighborState = level.func_180495_p(pos.func_177972_a(dir));
            if (!neighborState.func_235714_a_(ModBlockTags.CONNECTS_SMOKESTACK) && (dir != Direction.DOWN || !neighborState.func_235714_a_(ModBlockTags.THERMAL_SOURCE))) continue;
            if (newDir != null && newDir.func_176740_k() != dir.func_176740_k()) {
                return Facing.BEND;
            }
            newDir = dir;
        }
        if (newDir != null) {
            BlockState neighbor = level.func_180495_p(pos.func_177972_a(newDir));
            if (neighbor.func_177230_c() instanceof SmokestackBlock) {
                Facing neighborFacing = (Facing)((Object)neighbor.func_177229_b(FACING));
                return neighborFacing == Facing.BEND ? (facing.getAxis() != newDir.func_176740_k() ? Facing.fromDirection(newDir.func_176734_d()) : facing) : (neighborFacing.getAxis() != newDir.func_176740_k() ? Facing.fromDirection(newDir.func_176734_d()) : neighborFacing);
            }
            if (neighbor.func_235714_a_(ModBlockTags.THERMAL_SOURCE) && newDir == Direction.DOWN) {
                return Facing.fromDirection(newDir.func_176734_d());
            }
        }
        return facing;
    }

    protected BlockState calculateConnections(BlockState state, BlockPos pos, IWorld level) {
        Facing facing = (Facing)((Object)state.func_177229_b(FACING));
        if (facing == Facing.BEND) {
            return (BlockState)((BlockState)state.func_206870_a((Property)END, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BASE, (Comparable)Boolean.valueOf(false));
        }
        boolean connectedTop = level.func_180495_p(pos.func_177972_a(facing.toDirection())).func_235714_a_(ModBlockTags.CONNECTS_SMOKESTACK);
        boolean connectedBase = level.func_180495_p(pos.func_177972_a(facing.toDirection().func_176734_d())).func_235714_a_(ModBlockTags.CONNECTS_SMOKESTACK);
        return (BlockState)((BlockState)state.func_206870_a((Property)END, (Comparable)Boolean.valueOf(connectedTop))).func_206870_a((Property)BASE, (Comparable)Boolean.valueOf(connectedBase));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction placeDir = context.func_196000_l();
        BlockPos pos = context.func_195995_a();
        World level = context.func_195991_k();
        Facing facing = Facing.fromDirection(placeDir);
        facing = this.calculateFacing(facing, pos, (IWorld)level);
        BlockState state = (BlockState)this.func_176223_P().func_206870_a(FACING, (Comparable)((Object)facing));
        if (facing != Facing.BEND) {
            state = this.calculateConnections(state, pos, (IWorld)level);
        }
        state = WorldHelper.waterlog(state, level, pos);
        return state;
    }

    protected BlockState updateFluid(IWorld level, BlockState state, BlockPos pos) {
        if (state.func_177229_b(FACING) == Facing.BEND || ((Boolean)state.func_177229_b((Property)ENCASED)).booleanValue()) {
            return (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            level.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)level));
        }
        return state;
    }

    public BlockState func_196271_a(BlockState state, Direction neighborDir, BlockState neighborState, IWorld level, BlockPos pos, BlockPos neighborPos) {
        state = this.updateFluid(level, state, pos);
        Facing facing = this.calculateFacing((Facing)((Object)state.func_177229_b(FACING)), pos, level);
        state = (BlockState)state.func_206870_a(FACING, (Comparable)((Object)facing));
        state = this.calculateConnections(state, pos, level);
        return state;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader ilevel, BlockPos pos) {
        float progress = super.func_180647_a(state, player, ilevel, pos);
        if (((Boolean)state.func_177229_b((Property)ENCASED)).booleanValue()) {
            progress *= 2.0f;
        }
        return progress;
    }

    public boolean removedByPlayer(BlockState state, World level, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (((Boolean)state.func_177229_b((Property)ENCASED)).booleanValue()) {
            state = this.updateFluid((IWorld)level, state, pos);
            level.func_180501_a(pos, (BlockState)this.calculateConnections(state, pos, (IWorld)level).func_206870_a((Property)ENCASED, (Comparable)Boolean.valueOf(false)), 3);
            ClientOnlyHelper.addDestroyBlockEffect(pos, state);
            level.func_184133_a(null, pos, this.getSoundType(state, (IWorldReader)level, pos, (Entity)player).func_185845_c(), SoundCategory.BLOCKS, 1.0f, 0.8f);
            return false;
        }
        return super.removedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public static enum Facing implements IStringSerializable
    {
        UP("up"),
        DOWN("down"),
        NORTH("north"),
        SOUTH("south"),
        EAST("east"),
        WEST("west"),
        BEND("bend");

        private final String name;

        private Facing(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static Facing byName(String name) {
            for (Facing facing : Facing.values()) {
                if (!facing.name.equals(name)) continue;
                return facing;
            }
            return UP;
        }

        public static Facing fromDirection(Direction direction) {
            switch (direction) {
                case DOWN: {
                    return DOWN;
                }
                case NORTH: {
                    return NORTH;
                }
                case SOUTH: {
                    return SOUTH;
                }
                case EAST: {
                    return EAST;
                }
                case WEST: {
                    return WEST;
                }
            }
            return UP;
        }

        public Direction toDirection() {
            switch (this) {
                case DOWN: {
                    return Direction.DOWN;
                }
                case NORTH: {
                    return Direction.NORTH;
                }
                case SOUTH: {
                    return Direction.SOUTH;
                }
                case EAST: {
                    return Direction.EAST;
                }
                case WEST: {
                    return Direction.WEST;
                }
            }
            return Direction.UP;
        }

        public Direction.Axis getAxis() {
            return this.toDirection().func_176740_k();
        }

        public Facing rotate(Rotation rotation) {
            switch (rotation) {
                case CLOCKWISE_90: {
                    switch (this) {
                        case NORTH: {
                            return EAST;
                        }
                        case EAST: {
                            return SOUTH;
                        }
                        case SOUTH: {
                            return WEST;
                        }
                        case WEST: {
                            return NORTH;
                        }
                    }
                    return this;
                }
                case CLOCKWISE_180: {
                    switch (this) {
                        case NORTH: {
                            return SOUTH;
                        }
                        case SOUTH: {
                            return NORTH;
                        }
                        case EAST: {
                            return WEST;
                        }
                        case WEST: {
                            return EAST;
                        }
                    }
                    return this;
                }
                case COUNTERCLOCKWISE_90: {
                    switch (this) {
                        case NORTH: {
                            return WEST;
                        }
                        case WEST: {
                            return SOUTH;
                        }
                        case SOUTH: {
                            return EAST;
                        }
                        case EAST: {
                            return NORTH;
                        }
                    }
                    return this;
                }
            }
            return this;
        }

        public Facing mirror(Mirror mirror) {
            switch (mirror) {
                case FRONT_BACK: {
                    switch (this) {
                        case NORTH: {
                            return SOUTH;
                        }
                        case SOUTH: {
                            return NORTH;
                        }
                    }
                    return this;
                }
                case LEFT_RIGHT: {
                    switch (this) {
                        case EAST: {
                            return WEST;
                        }
                        case WEST: {
                            return EAST;
                        }
                    }
                    return this;
                }
            }
            return this;
        }
    }
}

