/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.block;

import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.itemgroup.ColdSweatGroup;
import com.momosoftworks.coldsweat.data.tag.ModBlockTags;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class SoulStalkBlock
extends Block
implements IPlantable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208171_X;
    public static final IntegerProperty SECTION = IntegerProperty.func_177719_a((String)"section", (int)0, (int)3);
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);

    public SoulStalkBlock(AbstractBlock.Properties p_49795_) {
        super(p_49795_);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)SECTION, (Comparable)Integer.valueOf(0)));
    }

    public static AbstractBlock.Properties getProperties() {
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200947_a(SoundType.field_222472_s).func_200948_a(0.0f, 0.5f).func_200944_c().func_235838_a_(state -> (Integer)state.func_177229_b((Property)SECTION) == 3 ? 6 : 0).func_226896_b_().func_200942_a();
    }

    public static Item.Properties getItemProperties() {
        return new Item.Properties().func_200916_a((ItemGroup)ColdSweatGroup.COLD_SWEAT);
    }

    public void func_225542_b_(BlockState state, ServerWorld level, BlockPos pos, Random rand) {
        if (level.func_175623_d(pos.func_177984_a())) {
            int i = 1;
            while (level.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) {
                ++i;
            }
            if (i < 6 && rand.nextDouble() < 0.05 + CSMath.blend(ConfigSettings.MIN_TEMP.get(), ConfigSettings.MAX_TEMP.get(), WorldHelper.getRoughTemperatureAt((World)level, pos.func_177979_c(i - 1)), 0.0, 0.95)) {
                int j = (Integer)state.func_177229_b((Property)AGE);
                if (ForgeHooks.onCropsGrowPre((World)level, (BlockPos)pos, (BlockState)state, (boolean)true)) {
                    if (j >= 8) {
                        level.func_175656_a(pos.func_177984_a(), (BlockState)this.func_176223_P().func_206870_a((Property)SECTION, (Comparable)Integer.valueOf(3)));
                        int section = rand.nextDouble() < 0.3 ? 2 : 1;
                        level.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)SECTION, (Comparable)Integer.valueOf(section)), 4);
                    } else {
                        level.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(j + 1)), 4);
                    }
                }
            }
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        return context.func_195991_k().func_180495_p(pos.func_177977_b()).func_177230_c() == this ? (BlockState)this.func_176223_P().func_206870_a((Property)SECTION, (Comparable)Integer.valueOf(3)) : (context.func_195991_k().func_180495_p(pos.func_177984_a()).func_196958_f() && this.func_196260_a(this.func_176223_P(), (IWorldReader)context.func_195991_k(), pos) ? this.func_176223_P() : null);
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState lastState, boolean p_60570_) {
        if (world.func_180495_p(pos.func_177977_b()).func_235714_a_(ModBlockTags.SOUL_STALK_PLACEABLE_ON) && world.func_180495_p(pos.func_177984_a()).func_196958_f()) {
            world.func_180501_a(pos.func_177984_a(), (BlockState)ModBlocks.SOUL_STALK.func_176223_P().func_206870_a((Property)SECTION, (Comparable)Integer.valueOf(3)), 3);
        }
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState otherState, IWorld ilevel, BlockPos pos, BlockPos otherPos) {
        if (!this.func_196260_a(state, (IWorldReader)ilevel, pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (direction == Direction.UP) {
            if (otherState.func_177230_c() != this) {
                return Blocks.field_150350_a.func_176223_P();
            }
            if ((Integer)state.func_177229_b((Property)SECTION) == 3) {
                return (BlockState)state.func_206870_a((Property)SECTION, (Comparable)Integer.valueOf(Math.random() < 0.33 ? 2 : 1));
            }
        }
        return state;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader getter, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE, SECTION});
    }

    public BlockState getPlant(IBlockReader level, BlockPos pos) {
        return this.func_176223_P();
    }

    public boolean func_196260_a(BlockState state, IWorldReader level, BlockPos pos) {
        BlockState below = level.func_180495_p(pos.func_177977_b());
        return below.func_235714_a_(ModBlockTags.SOUL_STALK_PLACEABLE_ON) || below.func_177230_c() == this;
    }
}

