/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.blockentity;

import com.momosoftworks.coldsweat.common.block.BoilerBlock;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.container.BoilerContainer;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.BlockEntityInit;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.registries.ModSounds;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.Arrays;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class BoilerBlockEntity
extends HearthBlockEntity
implements ITickableTileEntity,
ISidedInventory {
    public static int[] WATERSKIN_SLOTS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    public static int[] FUEL_SLOT = new int[]{0};
    LazyOptional<? extends IItemHandler>[] slotHandlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public BoilerBlockEntity() {
        super((TileEntityType<? extends HearthBlockEntity>)((TileEntityType)BlockEntityInit.BOILER_BLOCK_ENTITY_TYPE.get()));
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(null, pkt.func_148857_g());
    }

    @Override
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    @Override
    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.cold_sweat.boiler");
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        BlockPos pos = this.func_174877_v();
        BlockState state = this.func_195044_w();
        if (this.getFuel() > 0) {
            if (!((Boolean)state.func_177229_b((Property)BoilerBlock.LIT)).booleanValue()) {
                this.field_145850_b.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BoilerBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
            }
            boolean hasItemStacks = false;
            if (this.ticksExisted % (int)(20.0 / Math.max(1.0, ConfigSettings.TEMP_RATE.get())) == 0) {
                for (int i = 1; i < 10; ++i) {
                    ItemStack stack = this.func_70301_a(i);
                    CompoundNBT tag = NBTHelper.getTagOrEmpty(stack);
                    double itemTemp = tag.func_74769_h("Temperature");
                    if (stack.func_77973_b() != ModItems.FILLED_WATERSKIN || !(itemTemp < 50.0)) continue;
                    hasItemStacks = true;
                    tag.func_74780_a("Temperature", Math.min(50.0, itemTemp + 1.0));
                }
            }
            if (hasItemStacks) {
                this.setFuel(this.getFuel() - 1);
            }
        } else if (((Boolean)state.func_177229_b((Property)BoilerBlock.LIT)).booleanValue()) {
            this.field_145850_b.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BoilerBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @Override
    public int getSpreadRange() {
        return ConfigSettings.BOILER_RANGE.get();
    }

    @Override
    public int getMaxRange() {
        return ConfigSettings.BOILER_MAX_RANGE.get();
    }

    @Override
    public int getMaxPaths() {
        return ConfigSettings.BOILER_MAX_VOLUME.get();
    }

    @Override
    public int getInsulationTime() {
        return ConfigSettings.BOILER_WARM_UP_TIME.get();
    }

    @Override
    public int getMaxInsulationLevel() {
        return ConfigSettings.BOILER_MAX_INSULATION.get();
    }

    @Override
    public SoundEvent getFuelDepleteSound() {
        return ModSounds.BOILER_DEPLETE;
    }

    @Override
    public boolean hasSmokeStack() {
        return this.hasSmokestack;
    }

    @Override
    protected void tickPaths(int firstIndex, int lastIndex) {
        if (this.hasSmokestack) {
            super.tickPaths(firstIndex, lastIndex);
        }
    }

    @Override
    protected void tickDrainFuel() {
        int fuelInterval = ConfigSettings.BOILER_FUEL_INTERVAL.get();
        if (fuelInterval > 0 && this.ticksExisted % fuelInterval == 0) {
            this.drainFuel();
        }
    }

    @Override
    protected boolean hasHeatingSignal() {
        return Arrays.stream(Direction.values()).anyMatch(direction -> this.field_145850_b.func_175709_b(this.field_174879_c.func_177972_a(direction), direction));
    }

    @Override
    protected boolean hasCoolingSignal() {
        return false;
    }

    @Override
    public int getItemFuel(ItemStack item) {
        return ConfigHelper.findFirstFuelMatching(ConfigSettings.BOILER_FUEL, item).map(FuelData::fuel).orElse(0.0).intValue();
    }

    @Override
    protected void storeFuel(ItemStack stack, int amount) {
        if ((double)this.getFuel() < (double)this.getMaxFuel() - (double)Math.abs(amount) * 0.75) {
            if (!stack.hasContainerItem() || stack.func_190916_E() > 1) {
                int consumeCount = Math.min((int)Math.floor((double)(this.getMaxFuel() - this.getFuel()) / (double)Math.abs(amount)), stack.func_190916_E());
                stack.func_190918_g(consumeCount);
                this.addFuel(amount * consumeCount);
            } else {
                this.func_70299_a(0, stack.getContainerItem());
                this.addFuel(amount);
            }
        }
    }

    public int getFuel() {
        return this.getHotFuel();
    }

    public void setFuel(int amount) {
        this.setHotFuel(amount, true);
    }

    @Override
    public void setHotFuel(int amount, boolean update) {
        super.setHotFuel(amount, update);
    }

    @Override
    public void addFuel(int amount) {
        this.setHotFuelAndUpdate(this.getHotFuel() + amount);
    }

    @Override
    protected boolean isFuelChanged() {
        return this.ticksExisted % 10 == 0;
    }

    @Override
    protected Container func_213906_a(int id, PlayerInventory playerInv) {
        return new BoilerContainer(id, playerInv, this);
    }

    @Override
    protected void tickParticles() {
        if (this.hasSmokestack) {
            super.tickParticles();
        }
    }

    @Override
    public int func_70302_i_() {
        return 10;
    }

    @Override
    public int[] func_180463_a(Direction side) {
        return side.func_176740_k() == Direction.Axis.Y ? WATERSKIN_SLOTS : FUEL_SLOT;
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, Direction direction) {
        if (slot == 0) {
            return this.getItemFuel(stack) != 0;
        }
        return ModItemTags.BOILER_VALID.func_230235_a_((Object)stack.func_77973_b());
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.slotHandlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.slotHandlers[1].cast();
            }
            return this.slotHandlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }
}

