/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.blockentity;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.event.vanilla.BlockStateChangedEvent;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.ThermalSourceTempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.event.HearthDebugRenderer;
import com.momosoftworks.coldsweat.common.block.HearthBottomBlock;
import com.momosoftworks.coldsweat.common.block.SmokestackBlock;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.container.HearthContainer;
import com.momosoftworks.coldsweat.common.event.HearthSaveDataHandler;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.BlockEntityInit;
import com.momosoftworks.coldsweat.core.init.ParticleTypesInit;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.HearthResetMessage;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.tag.ModFluidTags;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.entity.DummyPlayer;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import com.momosoftworks.coldsweat.util.registries.ModEffects;
import com.momosoftworks.coldsweat.util.registries.ModSounds;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.world.SpreadPath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import com.simibubi.create.content.contraptions.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.GlassFluidPipeBlock;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PotionItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber
public class HearthBlockEntity
extends LockableLootTileEntity
implements ITickableTileEntity,
ISidedInventory {
    List<SpreadPath> paths = new ArrayList<SpreadPath>(this.getMaxPaths());
    Multimap<BlockPos, Direction> pathLookup = HashMultimap.create((int)this.getMaxPaths(), (int)6);
    Map<Pair<Integer, Integer>, Pair<Integer, Boolean>> seeSkyMap = new FastMap<Pair<Integer, Integer>, Pair<Integer, Boolean>>(this.getMaxPaths());
    List<EffectInstance> effects = new ArrayList<EffectInstance>();
    FluidStack coldFuel = new FluidStack((Fluid)Fluids.field_204546_a, 0);
    FluidStack hotFuel = new FluidStack((Fluid)Fluids.field_204547_b, 0);
    FluidHandler bottomFuelHandler = new BottomFluidHandler();
    final LazyOptional<IFluidHandler> bottomFuelHolder = LazyOptional.of(() -> this.bottomFuelHandler);
    FluidHandler sidesFuelHandler = new SidesFluidHandler();
    final LazyOptional<IFluidHandler> sidesFuelHolder = LazyOptional.of(() -> this.sidesFuelHandler);
    NonNullList<ItemStack> items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    Pair<BlockPos, ResourceLocation> levelPos = Pair.of(null, null);
    int x = 0;
    int y = 0;
    int z = 0;
    int lastHotFuel = 0;
    int lastColdFuel = 0;
    boolean isCoolingOn = false;
    boolean isHeatingOn = false;
    boolean shouldUseHotFuel = false;
    boolean shouldUseColdFuel = false;
    boolean hasHotFuel = false;
    boolean hasColdFuel = false;
    int insulationLevel = 0;
    boolean isPlayerNearby = false;
    List<PlayerEntity> players = new ArrayList<PlayerEntity>();
    int rebuildCooldown = 0;
    boolean forceRebuild = false;
    List<BlockPos> queuedUpdates = new ArrayList<BlockPos>();
    public int ticksExisted = 0;
    boolean registeredLocation = false;
    boolean showParticles = true;
    int frozenPaths = 0;
    boolean spreading = true;
    boolean hasSmokestack = false;
    Map<BlockPos, Direction> pipeEnds = new HashMap<BlockPos, Direction>();
    static final Direction[] DIRECTIONS = Direction.values();
    static Method TICK_DOWN_EFFECT;
    IChunk workingChunk = null;

    public HearthBlockEntity() {
        this((TileEntityType<? extends HearthBlockEntity>)((TileEntityType)BlockEntityInit.HEARTH_BLOCK_ENTITY_TYPE.get()));
    }

    public HearthBlockEntity(TileEntityType<? extends HearthBlockEntity> type) {
        super(type);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onBlockUpdate(BlockStateChangedEvent event) {
        BlockPos pos = event.getPosition();
        World level = event.getWorld();
        if (level == this.field_145850_b && this.pathLookup.containsKey((Object)pos) && !event.getOldState().func_196952_d((IBlockReader)level, pos).equals(event.getNewState().func_196952_d((IBlockReader)level, pos))) {
            if (!level.func_201670_d()) {
                this.sendBlockUpdate(pos);
            }
            if (this.isTransferPipe(event.getOldState()) || this.isTransferPipe(event.getNewState())) {
                this.searchForPipeEnds(this.func_174877_v().func_177984_a(), Direction.UP);
            }
        }
    }

    public int getSpreadRange() {
        return ConfigSettings.HEARTH_RANGE.get();
    }

    public int getMaxRange() {
        return ConfigSettings.HEARTH_MAX_RANGE.get();
    }

    public int getMaxPaths() {
        return ConfigSettings.HEARTH_MAX_VOLUME.get();
    }

    public int getMaxFuel() {
        return 1000;
    }

    public int getInsulationTime() {
        return ConfigSettings.HEARTH_WARM_UP_TIME.get();
    }

    public int getCoolingLevel() {
        return this.shouldUseColdFuel ? this.insulationLevel : 0;
    }

    public int getHeatingLevel() {
        return this.shouldUseHotFuel ? this.insulationLevel : 0;
    }

    public int getMaxInsulationLevel() {
        return ConfigSettings.HEARTH_MAX_INSULATION.get();
    }

    public boolean hasSmokeStack() {
        return true;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.cold_sweat.hearth");
    }

    public ITextComponent func_145748_c_() {
        return this.func_200201_e() != null ? this.func_200201_e() : this.func_213907_g();
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.items;
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public void func_73660_a() {
        BlockPos pos = this.func_174877_v();
        if (this.ticksExisted == 0) {
            this.init();
        }
        boolean isClient = this.field_145850_b.field_72995_K;
        ++this.ticksExisted;
        if (this.rebuildCooldown > 0) {
            --this.rebuildCooldown;
        }
        if (this.field_145850_b != null && this.ticksExisted % 20 == 0) {
            this.isPlayerNearby = false;
            this.players.clear();
            for (PlayerEntity player : this.field_145850_b.func_217369_A()) {
                if (!player.func_233580_cy_().func_218141_a((Vector3i)pos, (double)this.getMaxRange())) continue;
                this.players.add(player);
                this.isPlayerNearby = true;
            }
        }
        this.tickPotionEffects();
        boolean wasUsingColdFuel = this.shouldUseColdFuel;
        boolean wasUsingHotFuel = this.shouldUseHotFuel;
        if (!ConfigSettings.SMART_HEARTH.get().booleanValue()) {
            this.shouldUseColdFuel = this.isCoolingOn && this.getColdFuel() > 0;
            boolean bl = this.shouldUseHotFuel = this.isHeatingOn && this.getHotFuel() > 0;
        }
        if (!(this.shouldUseColdFuel || this.shouldUseHotFuel || this.paths.isEmpty())) {
            this.forceUpdate();
        }
        if (this.forceRebuild || this.rebuildCooldown <= 0 && !this.queuedUpdates.isEmpty()) {
            this.resetPaths();
        }
        if (this.getColdFuel() > 0 || this.getHotFuel() > 0) {
            if (this.insulationLevel < this.getInsulationTime()) {
                ++this.insulationLevel;
            }
            if (this.shouldUseColdFuel || this.shouldUseHotFuel || ConfigSettings.SMART_HEARTH.get().booleanValue() && this.isPlayerNearby) {
                if (this.ticksExisted % 20 == 0) {
                    boolean bl = this.showParticles = isClient && Minecraft.func_71410_x().field_71474_y.field_74362_aa == ParticleStatus.ALL && !HearthSaveDataHandler.DISABLED_HEARTHS.contains(this.levelPos);
                }
                if (this.paths.isEmpty()) {
                    this.addPath(new SpreadPath(pos.func_177981_b(1)).setOrigin(pos.func_177981_b(1)));
                    this.pathLookup.put((Object)pos.func_177981_b(1), (Object)Direction.UP);
                    this.searchForPipeEnds(this.func_174877_v().func_177984_a(), Direction.UP);
                }
                this.spreading = this.frozenPaths < this.paths.size();
                int pathCount = this.paths.size();
                int partSize = this.spreading ? CSMath.clamp(pathCount / 3, 100, 4000) : CSMath.clamp(pathCount / 20, 10, 100);
                int partCount = (int)Math.ceil((float)pathCount / (float)partSize);
                int lastIndex = partSize * (this.ticksExisted % partCount + 1);
                int firstIndex = Math.max(0, lastIndex - partSize);
                if (this.paths.size() > 1 || this.ticksExisted % 20 == 0) {
                    this.tickPaths(firstIndex, lastIndex);
                }
                if (isClient && this.spreading && this.paths.size() != pathCount) {
                    HearthDebugRenderer.updatePaths(this);
                }
                if (!isClient && this.ticksExisted % 5 == 0) {
                    if (ConfigSettings.SMART_HEARTH.get().booleanValue()) {
                        this.resetFuelStatus();
                    }
                    for (int i = 0; i < this.players.size(); ++i) {
                        PlayerEntity player = this.players.get(i);
                        if (player == null || player instanceof DummyPlayer) continue;
                        AxisAlignedBB playerBB = player.func_174813_aQ().func_186662_g(-0.1);
                        playerBB = new AxisAlignedBB(playerBB.field_72340_a, playerBB.field_72338_b, playerBB.field_72339_c, playerBB.field_72336_d, Math.max(playerBB.field_72337_e, playerBB.field_72338_b + 2.0), playerBB.field_72334_f);
                        if (!this.isAffectingPos(WorldHelper.getOccupiedPositions(playerBB)) || WorldHelper.canSeeSky((IWorld)this.field_145850_b, new BlockPos(playerBB.func_189972_c()), 64)) continue;
                        this.insulatePlayer(player);
                    }
                    this.players.clear();
                }
                if (!isClient) {
                    this.tickDrainFuel();
                }
                if (this.field_145850_b.field_72995_K) {
                    this.spawnRandomAirParticles();
                }
            }
        }
        if (this.ticksExisted % 40 == 0) {
            this.checkForFuel();
        }
        if (!this.field_145850_b.field_72995_K && (this.isFuelChanged() || wasUsingColdFuel != this.shouldUseColdFuel || wasUsingHotFuel != this.shouldUseHotFuel)) {
            this.updateFuelState();
        }
        if (isClient) {
            this.tickParticles();
        }
    }

    protected void tickPaths(int firstIndex, int lastIndex) {
        int pathCount = this.paths.size();
        for (int i = firstIndex; i < Math.min(this.paths.size(), lastIndex); ++i) {
            SpreadPath spreadPath = this.paths.get(i);
            BlockPos pathPos = spreadPath.pos;
            if (spreadPath.origin == null) {
                spreadPath.setOrigin(this.func_174877_v());
            }
            int spX = spreadPath.x;
            int spY = spreadPath.y;
            int spZ = spreadPath.z;
            if (spreadPath.frozen) {
                if (this.spreading || Math.abs(spY % 2) == 0 != (Math.abs(spX % 2) == Math.abs(spZ % 2))) continue;
                this.paths.remove(i);
                --i;
                continue;
            }
            if (pathCount < this.getMaxPaths() && spreadPath.withinDistance((Vector3i)spreadPath.origin, this.getSpreadRange()) && CSMath.withinCubeDistance(spreadPath.origin, this.func_174877_v(), this.getMaxRange())) {
                boolean canSeeSky;
                if (this.workingChunk == null || !this.workingChunk.func_76632_l().equals((Object)new ChunkPos(pathPos))) {
                    this.workingChunk = WorldHelper.getChunk((IWorld)this.field_145850_b, pathPos);
                }
                BlockState state = this.workingChunk != null ? this.workingChunk.func_180495_p(pathPos) : this.field_145850_b.func_180495_p(pathPos);
                Pair flatPos = Pair.of((Object)spX, (Object)spZ);
                Pair<Integer, Boolean> seeSkyState = this.seeSkyMap.get(flatPos);
                if (seeSkyState == null || (Integer)seeSkyState.getFirst() < spY != (Boolean)seeSkyState.getSecond()) {
                    canSeeSky = WorldHelper.canSeeSky((IWorld)this.field_145850_b, pathPos.func_177984_a(), 64);
                    this.seeSkyMap.put((Pair<Integer, Integer>)flatPos, (Pair<Integer, Boolean>)Pair.of((Object)spY, (Object)canSeeSky));
                } else {
                    canSeeSky = (Boolean)seeSkyState.getSecond();
                }
                if (!canSeeSky || this.isTransferPipe(state)) {
                    for (int d = 0; d < DIRECTIONS.length; ++d) {
                        Direction direction = DIRECTIONS[d];
                        Direction pathDir = spreadPath.direction;
                        if (direction == pathDir.func_176734_d()) continue;
                        BlockPos tryPos = pathPos.func_177972_a(direction);
                        SpreadPath newPath = new SpreadPath(tryPos, direction).setOrigin(spreadPath.origin);
                        if (!this.pathLookup.put((Object)tryPos, (Object)direction) || !this.canSpread(this.field_145850_b, pathPos, tryPos, state, spreadPath.direction, direction, newPath)) continue;
                        this.addPath(newPath);
                    }
                } else {
                    this.pathLookup.removeAll((Object)pathPos);
                    this.paths.remove(i);
                    --i;
                    continue;
                }
            }
            spreadPath.frozen = true;
            ++this.frozenPaths;
        }
    }

    protected void spawnRandomAirParticles() {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && this.showParticles && (!Minecraft.func_71410_x().field_71474_y.field_74330_P || !ConfigSettings.HEARTH_DEBUG.get().booleanValue())) {
            Random random = this.field_145850_b.field_73012_v;
            int count = this.paths.size() / 100;
            for (int i = 0; i < count; ++i) {
                SpreadPath path = this.paths.get(random.nextInt(this.paths.size()));
                this.spawnAirParticle(path.x, path.y, path.z, random);
            }
        }
    }

    public void checkInputSignal() {
        if (!this.field_145850_b.func_201670_d()) {
            boolean isHearth = this.func_195044_w().func_203425_a(ModBlocks.HEARTH_BOTTOM);
            if (ConfigSettings.SMART_HEARTH.get().booleanValue() && isHearth && !((Boolean)this.func_195044_w().func_177229_b((Property)HearthBottomBlock.SMART)).booleanValue()) {
                this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)((BlockState)((BlockState)this.func_195044_w().func_206870_a((Property)HearthBottomBlock.HEATING, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HearthBottomBlock.COOLING, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HearthBottomBlock.SMART, (Comparable)Boolean.valueOf(true)), 2);
                return;
            }
            boolean wasHeatingOn = this.isHeatingOn;
            boolean wasCoolingOn = this.isCoolingOn;
            this.isHeatingOn = this.hasHeatingSignal();
            this.isCoolingOn = this.hasCoolingSignal();
            if (isHearth) {
                if (wasHeatingOn != this.isHeatingOn) {
                    this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)HearthBottomBlock.HEATING, (Comparable)Boolean.valueOf(this.isHeatingOn)), 3);
                }
                if (wasCoolingOn != this.isCoolingOn) {
                    this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)HearthBottomBlock.COOLING, (Comparable)Boolean.valueOf(this.isCoolingOn)), 3);
                }
            }
            this.syncInputSignal(wasHeatingOn, wasCoolingOn);
        }
    }

    protected boolean hasCoolingSignal() {
        Direction facing = (Direction)this.func_195044_w().func_177229_b((Property)HearthBottomBlock.FACING);
        return this.field_145850_b.func_175709_b(this.func_174877_v().func_177972_a(facing.func_176735_f()), facing.func_176735_f()) || this.field_145850_b.func_175709_b(this.func_174877_v().func_177972_a(Direction.DOWN), Direction.DOWN);
    }

    protected boolean hasHeatingSignal() {
        Direction facing = (Direction)this.func_195044_w().func_177229_b((Property)HearthBottomBlock.FACING);
        return this.field_145850_b.func_175709_b(this.func_174877_v().func_177972_a(facing.func_176734_d()), facing.func_176734_d()) || this.field_145850_b.func_175709_b(this.func_174877_v().func_177972_a(facing.func_176746_e()), facing.func_176746_e());
    }

    protected void syncInputSignal(boolean wasHeatingOn, boolean wasCoolingOn) {
        if (this.field_145850_b instanceof ServerWorld && (wasHeatingOn != this.isHeatingOn || wasCoolingOn != this.isCoolingOn)) {
            ServerWorld serverLevel = (ServerWorld)this.field_145850_b;
            serverLevel.func_72863_F().func_217217_a(this.func_174877_v());
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.checkForFuel();
    }

    public void checkForFuel() {
        BlockPos pos = this.func_174877_v();
        ItemStack fuelStack = (ItemStack)this.func_190576_q().get(0);
        if (!fuelStack.func_190926_b()) {
            List itemEffects = PotionUtils.func_185189_a((ItemStack)fuelStack);
            if (ConfigSettings.HEARTH_POTIONS_ENABLED.get().booleanValue() && !itemEffects.isEmpty() && !itemEffects.equals(this.effects) && itemEffects.stream().noneMatch(eff -> ConfigSettings.HEARTH_POTION_BLACKLIST.get().contains(eff.func_188419_a()))) {
                if (fuelStack.func_77973_b() instanceof PotionItem) {
                    this.func_190576_q().set(0, (Object)Items.field_151069_bo.func_190903_i());
                } else if (!fuelStack.hasContainerItem() || fuelStack.func_190916_E() > 1) {
                    fuelStack.func_190918_g(1);
                } else {
                    this.func_190576_q().set(0, (Object)fuelStack.getContainerItem());
                }
                this.field_145850_b.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187621_J, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.effects.clear();
                this.effects.addAll(itemEffects.stream().map(eff -> eff.func_82719_a(new CompoundNBT())).map(EffectInstance::func_82722_b).collect(Collectors.toList()));
                WorldHelper.syncBlockEntityData((TileEntity)this);
            } else if (fuelStack.func_77973_b() == Items.field_151117_aB && !this.effects.isEmpty()) {
                this.func_190576_q().set(0, (Object)fuelStack.getContainerItem());
                this.field_145850_b.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.effects.clear();
                WorldHelper.syncBlockEntityData((TileEntity)this);
            } else {
                int itemFuel = this.getItemFuel(fuelStack);
                if (itemFuel != 0) {
                    this.storeFuel(fuelStack, itemFuel);
                }
            }
        }
    }

    protected boolean isFuelChanged() {
        return this.getColdFuel() != this.lastColdFuel || this.getHotFuel() != this.lastHotFuel;
    }

    protected void storeFuel(ItemStack stack, int amount) {
        int fuel;
        int n = fuel = amount > 0 ? this.getHotFuel() : this.getColdFuel();
        if ((double)fuel < (double)this.getMaxFuel() - (double)Math.abs(amount) * 0.75) {
            if (!stack.hasContainerItem() || stack.func_190916_E() > 1) {
                int consumeCount = Math.min((int)Math.floor((double)(this.getMaxFuel() - fuel) / (double)Math.abs(amount)), stack.func_190916_E());
                stack.func_190918_g(consumeCount);
                this.addFuel(amount * consumeCount);
            } else {
                this.func_70299_a(0, stack.getContainerItem());
                this.addFuel(amount);
            }
        }
    }

    protected void drainFuel() {
        if (this.shouldUseColdFuel) {
            this.setColdFuel(this.getColdFuel() - 1, true);
        }
        if (this.shouldUseHotFuel) {
            this.setHotFuel(this.getHotFuel() - 1, true);
        }
    }

    protected void tickDrainFuel() {
        int fuelInterval = ConfigSettings.HEARTH_FUEL_INTERVAL.get();
        if (fuelInterval > 0 && this.ticksExisted % fuelInterval == 0) {
            this.drainFuel();
        }
    }

    protected void resetFuelStatus() {
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
            this.shouldUseColdFuel = false;
            this.shouldUseHotFuel = false;
        }
    }

    void insulatePlayer(PlayerEntity player) {
        for (int i = 0; i < this.effects.size(); ++i) {
            EffectInstance effect = this.effects.get(i);
            player.func_195064_c(new EffectInstance(effect.func_188419_a(), effect.func_188419_a() == Effects.field_76439_r ? 399 : 119, effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e(), effect.func_205348_f()));
        }
        if (!ConfigSettings.SMART_HEARTH.get().booleanValue() || this.shouldInsulatePlayer(player)) {
            int maxEffect = this.getMaxInsulationLevel() - 1;
            int effectLevel = (int)Math.min((double)maxEffect, (double)this.insulationLevel / (double)this.getInsulationTime() * (double)maxEffect);
            if (this.shouldUseColdFuel) {
                player.func_195064_c(new EffectInstance(ModEffects.FRIGIDNESS, 60, effectLevel, false, false, true));
            }
            if (this.shouldUseHotFuel) {
                player.func_195064_c(new EffectInstance(ModEffects.WARMTH, 60, effectLevel, false, false, true));
            }
        }
    }

    protected boolean shouldInsulatePlayer(PlayerEntity player) {
        AtomicBoolean shouldInsulate = new AtomicBoolean(false);
        if (!this.shouldUseColdFuel || !this.shouldUseHotFuel) {
            EntityTempManager.getTemperatureCap((Entity)player).ifPresent(cap -> {
                double temp = CSMath.getIfNotNull(Temperature.getModifier(cap, Temperature.Trait.WORLD, ThermalSourceTempModifier.class).orElse(null), TempModifier::getLastInput, cap.getTrait(Temperature.Trait.WORLD));
                double min = cap.getTrait(Temperature.Trait.FREEZING_POINT);
                double max = cap.getTrait(Temperature.Trait.BURNING_POINT);
                this.shouldUseHotFuel |= this.getHotFuel() > 0 && temp < min;
                this.shouldUseColdFuel |= this.getColdFuel() > 0 && temp > max;
                shouldInsulate.set(!CSMath.betweenInclusive(temp, min, max));
            });
        }
        return shouldInsulate.get();
    }

    protected boolean canSpread(World level, BlockPos fromPos, BlockPos toPos, BlockState fromState, Direction fromDirection, Direction toDirection, SpreadPath newPath) {
        Block fromBlock = fromState.func_177230_c();
        if (fromBlock instanceof SmokestackBlock) {
            SmokestackBlock.Facing toFacing;
            SmokestackBlock.Facing facing = (SmokestackBlock.Facing)((Object)fromState.func_177229_b(SmokestackBlock.FACING));
            boolean isJunction = facing == SmokestackBlock.Facing.BEND;
            BlockState toState = level.func_180495_p(toPos);
            boolean isToSmokestack = toState.func_177230_c() instanceof SmokestackBlock;
            SmokestackBlock.Facing facing2 = toFacing = isToSmokestack ? (SmokestackBlock.Facing)((Object)toState.func_177229_b(SmokestackBlock.FACING)) : null;
            if (isJunction) {
                return isToSmokestack && (toFacing == SmokestackBlock.Facing.BEND || toFacing.getAxis() == toDirection.func_176740_k());
            }
            if (facing.getAxis() == toDirection.func_176740_k()) {
                newPath.setOrigin(toPos);
                return true;
            }
            return false;
        }
        if (CompatManager.isCreateLoaded() && (fromBlock instanceof FluidPipeBlock && (Boolean)fromState.func_177229_b((Property)FluidPipeBlock.field_196491_B.get(toDirection)) != false || fromBlock instanceof GlassFluidPipeBlock && fromState.func_177229_b((Property)RotatedPillarBlock.field_176298_M) == toDirection.func_176740_k() || fromBlock instanceof EncasedPipeBlock && ((Boolean)fromState.func_177229_b((Property)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(toDirection))).booleanValue())) {
            newPath.setOrigin(toPos);
            return true;
        }
        return !WorldHelper.isSpreadBlocked((IWorld)level, fromState, fromPos, fromDirection, toDirection);
    }

    protected boolean isTransferPipe(BlockState state) {
        return state.func_177230_c() instanceof SmokestackBlock || CompatManager.Create.isFluidPipe(state);
    }

    protected boolean connectsTo(BlockState state, BlockState otherState, Direction direction) {
        boolean otherIsSamePipe = state.func_177230_c() instanceof SmokestackBlock == otherState.func_177230_c() instanceof SmokestackBlock && CompatManager.Create.isFluidPipe(otherState) == CompatManager.Create.isFluidPipe(state);
        return this.pipePointingTo(state, otherState, direction) && otherIsSamePipe;
    }

    protected boolean pipePointingTo(BlockState state, BlockState otherState, Direction direction) {
        if (state.func_177230_c() instanceof SmokestackBlock) {
            SmokestackBlock.Facing facing = (SmokestackBlock.Facing)((Object)state.func_177229_b(SmokestackBlock.FACING));
            return facing == SmokestackBlock.Facing.BEND ? otherState.func_177230_c() instanceof SmokestackBlock : facing.getAxis() == direction.func_176740_k();
        }
        if (CompatManager.isCreateLoaded()) {
            if (state.func_177230_c() instanceof FluidPipeBlock) {
                return (Boolean)state.func_177229_b((Property)FluidPipeBlock.field_196491_B.get(direction));
            }
            if (state.func_177230_c() instanceof GlassFluidPipeBlock) {
                return state.func_177229_b((Property)RotatedPillarBlock.field_176298_M) == direction.func_176740_k();
            }
            if (state.func_177230_c() instanceof EncasedPipeBlock) {
                return (Boolean)state.func_177229_b((Property)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(direction));
            }
        }
        return false;
    }

    protected void searchForPipeEnds(BlockPos startPos, Direction fromDir) {
        if (this.hasSmokestack && this.field_145850_b != null) {
            this.pipeEnds.clear();
            this.searchForPipeEndsRecursive(startPos, this.field_145850_b.func_180495_p(startPos), fromDir, new HashSet<BlockPos>());
        }
    }

    protected void searchForPipeEndsRecursive(BlockPos pos, BlockState state, Direction fromDir, Set<BlockPos> visited) {
        visited.add(pos);
        for (int d = 0; d < DIRECTIONS.length; ++d) {
            BlockPos tryPos;
            Direction direction = DIRECTIONS[d];
            if (direction == fromDir.func_176734_d() || visited.contains(tryPos = pos.func_177972_a(direction)) || !CSMath.withinCubeDistance(this.func_174877_v(), tryPos, this.getMaxRange())) continue;
            BlockState otherState = this.field_145850_b.func_180495_p(tryPos);
            if (this.isTransferPipe(otherState) && this.connectsTo(state, otherState, direction)) {
                this.searchForPipeEndsRecursive(tryPos, otherState, direction, visited);
                continue;
            }
            if (WorldHelper.isSpreadBlocked((IWorld)this.field_145850_b, otherState, tryPos, fromDir.func_176734_d(), direction) || !this.pipePointingTo(state, otherState, direction)) continue;
            this.pipeEnds.put(tryPos, direction.func_176734_d());
        }
    }

    protected void init() {
        this.registerLocation();
        this.checkForSmokestack();
        this.checkInputSignal();
    }

    private void registerLocation() {
        if (!this.registeredLocation) {
            this.levelPos = Pair.of((Object)this.func_174877_v(), (Object)this.field_145850_b.func_234923_W_().func_240901_a_());
            HearthSaveDataHandler.HEARTH_POSITIONS.add(this.levelPos);
            this.x = this.func_174877_v().func_177958_n();
            this.y = this.func_174877_v().func_177956_o();
            this.z = this.func_174877_v().func_177952_p();
            this.registeredLocation = true;
        }
    }

    private void unregisterLocation() {
        if (this.registeredLocation) {
            HearthSaveDataHandler.HEARTH_POSITIONS.remove(this.levelPos);
            this.registeredLocation = false;
        }
    }

    protected void tickPotionEffects() {
        if (!this.effects.isEmpty()) {
            this.effects.removeIf(effect -> {
                try {
                    TICK_DOWN_EFFECT.invoke(effect, new Object[0]);
                    if (effect.func_76459_b() <= 0) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            });
        }
    }

    public boolean isAffectingPos(List<BlockPos> positions) {
        for (int i = 0; i < this.paths.size(); ++i) {
            SpreadPath path = this.paths.get(i);
            for (int j = 0; j < positions.size(); ++j) {
                if (!path.pos.equals((Object)positions.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    void resetPaths() {
        this.rebuildCooldown = 100;
        this.paths.clear();
        this.pathLookup.clear();
        if (this.forceRebuild) {
            this.seeSkyMap.clear();
        } else {
            for (int i = 0; i < this.queuedUpdates.size(); ++i) {
                BlockPos pos = this.queuedUpdates.get(i);
                this.seeSkyMap.remove(Pair.of((Object)pos.func_177958_n(), (Object)pos.func_177952_p()));
            }
        }
        this.frozenPaths = 0;
        this.spreading = true;
        this.sendResetPacket();
        if (this.field_145850_b.field_72995_K) {
            HearthDebugRenderer.updatePaths(this);
        }
        this.forceRebuild = false;
        this.queuedUpdates.clear();
        this.searchForPipeEnds(this.func_174877_v().func_177984_a(), Direction.UP);
    }

    public List<EffectInstance> getEffects() {
        return this.effects;
    }

    public int getItemFuel(ItemStack item) {
        return ConfigHelper.findFirstFuelMatching(ConfigSettings.HEARTH_FUEL, item).map(FuelData::fuel).orElse(0.0).intValue();
    }

    public int getHotFuel() {
        return this.hotFuel.getAmount();
    }

    public int getColdFuel() {
        return this.coldFuel.getAmount();
    }

    public void setHotFuel(int amount, boolean update) {
        boolean shouldUpdate;
        boolean bl = shouldUpdate = update && this.hotFuel.getAmount() != amount;
        if (this.hotFuel.isEmpty()) {
            this.hotFuel = new FluidStack((Fluid)Fluids.field_204547_b, amount);
        } else {
            this.hotFuel.setAmount(amount);
        }
        if (amount == 0) {
            if (this.hasHotFuel) {
                this.hasHotFuel = false;
                if (this.field_145850_b != null) {
                    this.field_145850_b.func_184133_a(null, this.func_174877_v(), this.getFuelDepleteSound(), SoundCategory.BLOCKS, 1.0f, (float)Math.random() * 0.2f + 0.9f);
                }
            }
        } else {
            this.hasHotFuel = true;
        }
        if (shouldUpdate) {
            this.updateFuelState();
        }
    }

    public void setHotFuelAndUpdate(int amount) {
        this.setHotFuel(amount, true);
    }

    public void setColdFuel(int amount, boolean update) {
        boolean shouldUpdate;
        boolean bl = shouldUpdate = update && this.coldFuel.getAmount() != amount;
        if (this.coldFuel.isEmpty()) {
            this.coldFuel = new FluidStack((Fluid)Fluids.field_204546_a, amount);
        } else {
            this.coldFuel.setAmount(amount);
        }
        if (amount <= 0) {
            if (this.hasColdFuel) {
                this.hasColdFuel = false;
                if (this.field_145850_b != null) {
                    this.field_145850_b.func_184133_a(null, this.func_174877_v(), this.getFuelDepleteSound(), SoundCategory.BLOCKS, 1.0f, (float)Math.random() * 0.2f + 0.9f);
                }
            }
        } else {
            this.hasColdFuel = true;
        }
        if (shouldUpdate) {
            this.updateFuelState();
        }
    }

    public void setColdFuelAndUpdate(int amount) {
        this.setColdFuel(amount, true);
    }

    public void addFuel(int amount) {
        if (amount > 0) {
            this.setHotFuelAndUpdate(this.getHotFuel() + amount);
        } else if (amount < 0) {
            this.setColdFuelAndUpdate(this.getColdFuel() + Math.abs(amount));
        }
    }

    public void updateFuelState() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            WorldHelper.syncBlockEntityData((TileEntity)this);
            this.lastColdFuel = this.getColdFuel();
            this.lastHotFuel = this.getHotFuel();
        }
    }

    protected SoundEvent getFuelDepleteSound() {
        return ModSounds.HEARTH_DEPLETE;
    }

    public boolean checkForSmokestack() {
        if (this.field_145850_b == null) {
            return false;
        }
        BlockState aboveState = this.field_145850_b.func_180495_p(this.func_174877_v().func_177984_a());
        boolean hadSmokestack = this.hasSmokestack;
        this.hasSmokestack = aboveState.func_177230_c() instanceof SmokestackBlock;
        if (this.hasSmokestack && !hadSmokestack) {
            this.registerLocation();
            if (this.field_145850_b.field_72995_K) {
                ClientOnlyHelper.addHearthPosition(this.func_174877_v());
            }
            this.func_195044_w().func_235734_a_((IWorld)this.field_145850_b, this.func_174877_v(), 3);
        } else if (!this.hasSmokestack && hadSmokestack) {
            this.forceUpdate();
            this.resetPaths();
            this.unregisterLocation();
            if (this.field_145850_b.field_72995_K) {
                ClientOnlyHelper.removeHearthPosition(this.func_174877_v());
            }
        }
        return this.hasSmokestack;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void tickParticles() {
        ParticleStatus status = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        if (status == ParticleStatus.MINIMAL) {
            return;
        }
        Random rand = this.field_145850_b.field_73012_v;
        for (Map.Entry<BlockPos, Direction> entry : this.pipeEnds.entrySet()) {
            double d5;
            double d4;
            double d3;
            double d2;
            double d1;
            double d0;
            BlockPos pos = entry.getKey();
            Direction face = entry.getValue();
            if (this.shouldUseColdFuel && rand.nextDouble() < (double)this.getColdFuel() / 3000.0) {
                d0 = (double)pos.func_177958_n() + 0.5 + (double)face.func_82601_c() * 0.35;
                d1 = (double)pos.func_177956_o() + 0.5 + (double)face.func_96559_d() * 0.35;
                d2 = (double)pos.func_177952_p() + 0.5 + (double)face.func_82599_e() * 0.35;
                d3 = (rand.nextDouble() - 0.5) / 4.0;
                d4 = (rand.nextDouble() - 0.5) / 4.0;
                d5 = (rand.nextDouble() - 0.5) / 4.0;
                this.field_145850_b.func_195594_a((IParticleData)ParticleTypesInit.STEAM.get(), d0 + d3, d1 + d4, d2 + d5, 0.0, 0.04, 0.0);
            }
            if (!this.shouldUseHotFuel || !(rand.nextDouble() < (double)this.getHotFuel() / 3000.0)) continue;
            d0 = (double)pos.func_177958_n() + 0.5 + (double)face.func_82601_c() * 0.35;
            d1 = (double)pos.func_177956_o() + 0.5 + (double)face.func_96559_d() * 0.35;
            d2 = (double)pos.func_177952_p() + 0.5 + (double)face.func_82599_e() * 0.35;
            d3 = (rand.nextDouble() - 0.5) / 2.0;
            d4 = (rand.nextDouble() - 0.5) / 2.0;
            d5 = (rand.nextDouble() - 0.5) / 2.0;
            BasicParticleType particle = rand.nextDouble() < 0.5 ? ParticleTypes.field_197594_E : ParticleTypes.field_197601_L;
            this.field_145850_b.func_195594_a((IParticleData)particle, d0 + d3, d1 + d4, d2 + d5, 0.0, 0.0, 0.0);
        }
    }

    public BasicParticleType getAirParticle() {
        return (BasicParticleType)ParticleTypesInit.HEARTH_AIR.get();
    }

    public void spawnAirParticle(int x, int y, int z, Random rand) {
        ParticleStatus status = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        if (status != ParticleStatus.ALL) {
            return;
        }
        float f = rand.nextFloat();
        float f2 = this.spreading ? 0.016f : 0.032f;
        if (f > f2) {
            return;
        }
        float xr = rand.nextFloat();
        float yr = rand.nextFloat();
        float zr = rand.nextFloat();
        float xm = rand.nextFloat() / 20.0f - 0.025f;
        float zm = rand.nextFloat() / 20.0f - 0.025f;
        this.field_145850_b.func_195590_a((IParticleData)this.getAirParticle(), false, (double)((float)x + xr), (double)((float)y + yr), (double)((float)z + zr), (double)xm, 0.0, (double)zm);
    }

    public int func_70302_i_() {
        return 1;
    }

    protected Container func_213906_a(int id, PlayerInventory playerInv) {
        return new HearthContainer(id, playerInv, this);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)tag, this.items);
        this.loadEffects(tag);
        this.coldFuel = FluidStack.loadFluidStackFromNBT((CompoundNBT)tag.func_74775_l("ColdFuel"));
        this.hotFuel = FluidStack.loadFluidStackFromNBT((CompoundNBT)tag.func_74775_l("HotFuel"));
        this.insulationLevel = tag.func_74762_e("InsulationLevel");
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        ItemStackHelper.func_191282_a((CompoundNBT)tag, this.items);
        this.saveEffects(tag);
        tag.func_218657_a("ColdFuel", (INBT)this.coldFuel.writeToNBT(new CompoundNBT()));
        tag.func_218657_a("HotFuel", (INBT)this.hotFuel.writeToNBT(new CompoundNBT()));
        tag.func_74768_a("InsulationLevel", this.insulationLevel);
        return tag;
    }

    void saveEffects(CompoundNBT tag) {
        if (!this.effects.isEmpty()) {
            ListNBT list = new ListNBT();
            for (EffectInstance effect : this.effects) {
                list.add((Object)effect.func_82719_a(new CompoundNBT()));
            }
            tag.func_218657_a("Effects", (INBT)list);
        }
    }

    void loadEffects(CompoundNBT tag) {
        this.effects.clear();
        if (tag.func_74764_b("Effects")) {
            ListNBT list = tag.func_150295_c("Effects", 10);
            for (int i = 0; i < list.size(); ++i) {
                this.effects.add(EffectInstance.func_82722_b((CompoundNBT)list.func_150305_b(i)));
            }
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        tag.func_74768_a("HotFuel", this.getHotFuel());
        tag.func_74768_a("ColdFuel", this.getColdFuel());
        tag.func_74757_a("ShouldUseColdFuel", this.shouldUseColdFuel);
        tag.func_74757_a("ShouldUseHotFuel", this.shouldUseHotFuel);
        tag.func_74768_a("InsulationLevel", this.insulationLevel);
        tag.func_74757_a("IsCooling", this.isCoolingOn);
        tag.func_74757_a("IsHeating", this.isHeatingOn);
        tag.func_74757_a("HasSmokestack", this.hasSmokestack);
        this.saveEffects(tag);
        return tag;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.setHotFuel(tag.func_74762_e("HotFuel"), false);
        this.setColdFuel(tag.func_74762_e("ColdFuel"), false);
        this.shouldUseColdFuel = tag.func_74767_n("ShouldUseColdFuel");
        this.shouldUseHotFuel = tag.func_74767_n("ShouldUseHotFuel");
        this.insulationLevel = tag.func_74762_e("InsulationLevel");
        this.isCoolingOn = tag.func_74767_n("IsCooling");
        this.isHeatingOn = tag.func_74767_n("IsHeating");
        this.hasSmokestack = tag.func_74767_n("HasSmokestack");
        this.loadEffects(tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(null, pkt.func_148857_g());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        Direction facingDir = (Direction)this.func_195044_w().func_177229_b((Property)HearthBottomBlock.FACING);
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null ? (facing == Direction.DOWN || facing == facingDir.func_176734_d() ? this.bottomFuelHolder.cast() : (facing != Direction.UP && facing != facingDir ? this.sidesFuelHolder.cast() : super.getCapability(capability, facing))) : super.getCapability(capability, facing);
    }

    public void addPath(SpreadPath path) {
        this.paths.add(path);
    }

    public void addPaths(Collection<SpreadPath> newPaths) {
        this.paths.addAll(newPaths);
    }

    public void sendResetPacket() {
        if (this.field_145850_b instanceof ServerWorld) {
            ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> (Chunk)WorldHelper.getChunk((IWorld)this.field_145850_b, this.func_174877_v())), (Object)new HearthResetMessage(this.func_174877_v()));
        }
    }

    public void sendBlockUpdate(BlockPos pos) {
        this.queuedUpdates.add(pos);
    }

    public void forceUpdate() {
        this.forceRebuild = true;
        this.sendBlockUpdate(this.func_174877_v());
    }

    public void func_145843_s() {
        super.func_145843_s();
        HearthSaveDataHandler.HEARTH_POSITIONS.remove(Pair.of((Object)this.func_174877_v(), (Object)this.func_145831_w().func_234923_W_().func_240901_a_()));
        if (this.field_145850_b.field_72995_K) {
            ClientOnlyHelper.removeHearthPosition(this.func_174877_v());
        }
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    public Multimap<BlockPos, Direction> getPathLookup() {
        return this.pathLookup;
    }

    public List<SpreadPath> getPaths() {
        return this.paths;
    }

    public boolean isSpreading() {
        return this.spreading;
    }

    public boolean isCoolingOn() {
        return this.isCoolingOn;
    }

    public boolean isBackPowered() {
        return this.isHeatingOn;
    }

    public void setCooling(boolean isPowered) {
        this.isCoolingOn = isPowered;
    }

    public void setHeating(boolean isPowered) {
        this.isHeatingOn = isPowered;
    }

    public Map<BlockPos, Direction> getPipeEnds() {
        return this.pipeEnds;
    }

    public int[] func_180463_a(Direction side) {
        return new int[0];
    }

    public boolean func_180462_a(int slot, ItemStack stack, @Nullable Direction pDirection) {
        return this.getItemFuel(stack) != 0;
    }

    public boolean func_180461_b(int slot, ItemStack stack, Direction direction) {
        return true;
    }

    static {
        try {
            TICK_DOWN_EFFECT = ObfuscationReflectionHelper.findMethod(EffectInstance.class, (String)"func_76454_e", (Class[])new Class[0]);
            TICK_DOWN_EFFECT.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class BottomFluidHandler
    extends FluidHandler {
        private BottomFluidHandler() {
        }

        @Override
        public FluidStack drain(int amount, IFluidHandler.FluidAction fluidAction) {
            int drained = Math.min(HearthBlockEntity.this.hotFuel.getAmount(), amount);
            FluidStack stack = new FluidStack(HearthBlockEntity.this.hotFuel, drained);
            if (fluidAction.execute() && drained > 0) {
                HearthBlockEntity.this.hotFuel.shrink(drained);
            }
            HearthBlockEntity.this.func_70296_d();
            return stack;
        }
    }

    private class SidesFluidHandler
    extends FluidHandler {
        private SidesFluidHandler() {
        }

        @Override
        public FluidStack drain(int amount, IFluidHandler.FluidAction fluidAction) {
            int drained = Math.min(HearthBlockEntity.this.coldFuel.getAmount(), amount);
            FluidStack stack = new FluidStack(HearthBlockEntity.this.coldFuel, drained);
            if (fluidAction.execute() && drained > 0) {
                HearthBlockEntity.this.coldFuel.shrink(drained);
            }
            HearthBlockEntity.this.func_70296_d();
            return stack;
        }
    }

    public abstract class FluidHandler
    implements IFluidHandler {
        public int getTanks() {
            return 2;
        }

        public FluidStack getFluidInTank(int tank) {
            return tank == 0 ? HearthBlockEntity.this.coldFuel : HearthBlockEntity.this.hotFuel;
        }

        public int getTankCapacity(int tank) {
            return HearthBlockEntity.this.getMaxFuel();
        }

        public boolean isFluidValid(int tank, FluidStack fluidStack) {
            return tank == 0 ? fluidStack.getFluid() == Fluids.field_204546_a : fluidStack.getFluid() == Fluids.field_204547_b;
        }

        public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            if (fluidStack.getFluid().func_207185_a(ModFluidTags.COLD)) {
                int amount = Math.min(fluidStack.getAmount(), this.getTankCapacity(0) - HearthBlockEntity.this.coldFuel.getAmount());
                if (fluidAction.execute()) {
                    if (HearthBlockEntity.this.coldFuel.isEmpty()) {
                        HearthBlockEntity.this.coldFuel = fluidStack.copy();
                    } else {
                        HearthBlockEntity.this.coldFuel.grow(amount);
                    }
                }
                return amount;
            }
            if (fluidStack.getFluid().func_207185_a(ModFluidTags.HOT)) {
                int amount = Math.min(fluidStack.getAmount(), this.getTankCapacity(1) - HearthBlockEntity.this.hotFuel.getAmount());
                if (fluidAction.execute()) {
                    if (HearthBlockEntity.this.hotFuel.isEmpty()) {
                        HearthBlockEntity.this.hotFuel = fluidStack.copy();
                    } else {
                        HearthBlockEntity.this.hotFuel.grow(amount);
                    }
                }
                return amount;
            }
            return 0;
        }

        public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            return this.isFluidValid(0, fluidStack) || this.isFluidValid(1, fluidStack) ? this.drain(fluidStack.getAmount(), fluidAction) : FluidStack.EMPTY;
        }

        public abstract FluidStack drain(int var1, IFluidHandler.FluidAction var2);
    }
}

