/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.handler;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.event.common.temperautre.TempModifierEvent;
import com.momosoftworks.coldsweat.api.event.core.init.GatherDefaultTempModifiersEvent;
import com.momosoftworks.coldsweat.api.event.vanilla.ContainerChangedEvent;
import com.momosoftworks.coldsweat.api.event.vanilla.LivingEntityLoadAdditionalEvent;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.temperature.modifier.BiomeTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.BlockTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.ElevationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.EntitiesTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FoodTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FrigidnessTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.InventoryItemsTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.MountTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.SoulSproutTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.ThermalSourceTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WarmthTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WaterTempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.ModCapabilities;
import com.momosoftworks.coldsweat.common.capability.SidedCapabilityCache;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.capability.temperature.AbstractTempCap;
import com.momosoftworks.coldsweat.common.capability.temperature.EntityTempCap;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.common.capability.temperature.PlayerTempCap;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.data.codec.configuration.FoodData;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemCarryTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.MountData;
import com.momosoftworks.coldsweat.util.entity.DummyPlayer;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.registries.ModAttributes;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import com.momosoftworks.coldsweat.util.registries.ModEffects;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class EntityTempManager {
    public static final Temperature.Trait[] VALID_TEMPERATURE_TRAITS = (Temperature.Trait[])Arrays.stream(Temperature.Trait.values()).filter(Temperature.Trait::isForTemperature).toArray(Temperature.Trait[]::new);
    public static final Temperature.Trait[] VALID_MODIFIER_TRAITS = (Temperature.Trait[])Arrays.stream(Temperature.Trait.values()).filter(Temperature.Trait::isForModifiers).toArray(Temperature.Trait[]::new);
    public static final Temperature.Trait[] VALID_ATTRIBUTE_TRAITS = (Temperature.Trait[])Arrays.stream(Temperature.Trait.values()).filter(Temperature.Trait::isForAttributes).toArray(Temperature.Trait[]::new);
    public static final Set<EntityType<? extends LivingEntity>> TEMPERATURE_ENABLED_ENTITIES = new HashSet<EntityType>(Arrays.asList(EntityType.field_200729_aH));
    public static SidedCapabilityCache<ITemperatureCap, Entity> CAP_CACHE = new SidedCapabilityCache(() -> ModCapabilities.ENTITY_TEMPERATURE);
    public static Map<Entity, Map<ResourceLocation, Double>> TEMP_MODIFIER_IMMUNITIES = new WeakHashMap<Entity, Map<ResourceLocation, Double>>();
    private static final Field MENU_OWNER = ObfuscationReflectionHelper.findField(PlayerContainer.class, (String)"field_82862_h");

    public static LazyOptional<ITemperatureCap> getTemperatureCap(Entity entity) {
        return EntityTempManager.isTemperatureEnabled(entity) ? CAP_CACHE.get(entity) : LazyOptional.empty();
    }

    @SubscribeEvent
    public static void attachCapabilityToEntityHandler(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity && TEMPERATURE_ENABLED_ENTITIES.contains(((Entity)event.getObject()).func_200600_R())) {
            LivingEntity entity = (LivingEntity)event.getObject();
            final AbstractTempCap tempCap = entity instanceof PlayerEntity ? new PlayerTempCap() : new EntityTempCap();
            final LazyOptional capOptional = LazyOptional.of(() -> tempCap);
            ICapabilitySerializable<CompoundNBT> provider = new ICapabilitySerializable<CompoundNBT>(){

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
                    if (cap == ModCapabilities.ENTITY_TEMPERATURE) {
                        return capOptional.cast();
                    }
                    return LazyOptional.empty();
                }

                public CompoundNBT serializeNBT() {
                    return tempCap.serializeNBT();
                }

                public void deserializeNBT(CompoundNBT nbt) {
                    tempCap.deserializeNBT(nbt);
                }
            };
            event.addCapability(new ResourceLocation("cold_sweat", "temperature"), (ICapabilityProvider)provider);
        }
    }

    @SubscribeEvent
    public static void initModifiersOnEntity(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof LivingEntity && !event.getWorld().func_201670_d() && EntityTempManager.isTemperatureEnabled(event.getEntity())) {
            LivingEntity living = (LivingEntity)event.getEntity();
            EntityTempManager.getTemperatureCap((Entity)living).ifPresent(cap -> {
                for (Temperature.Trait trait : VALID_MODIFIER_TRAITS) {
                    GatherDefaultTempModifiersEvent gatherEvent = new GatherDefaultTempModifiersEvent(living, trait);
                    MinecraftForge.EVENT_BUS.post((Event)gatherEvent);
                    cap.getModifiers(trait).clear();
                    cap.getModifiers(trait).addAll(gatherEvent.getModifiers());
                }
                TaskScheduler.scheduleServer(() -> {
                    cap.tick(living);
                    Temperature.updateTemperature(living, cap, true);
                }, 1);
            });
        }
    }

    @SubscribeEvent
    public static void cleanRemovedEntities(EntityLeaveWorldEvent event) {
        if (EntityTempManager.isTemperatureEnabled(event.getEntity())) {
            CAP_CACHE.removeIf(ent -> ent.field_70128_L);
            TEMP_MODIFIER_IMMUNITIES.entrySet().removeIf(e -> ((Entity)e.getKey()).field_70128_L);
        }
    }

    @SubscribeEvent
    public static void fixOldAttributeData(LivingEntityLoadAdditionalEvent event) {
        if (EntityTempManager.isTemperatureEnabled((Entity)event.getEntity()) && event.getNBT().func_150295_c("Attributes", 10).stream().anyMatch(attribute -> ((CompoundNBT)attribute).func_74779_i("Name").equals("cold_sweat:world_temperature_offset"))) {
            TaskScheduler.scheduleServer(() -> {
                for (Temperature.Trait attributeType : VALID_ATTRIBUTE_TRAITS) {
                    CSMath.doIfNotNull(EntityTempManager.getAttribute(attributeType, event.getEntity()), attribute -> {
                        attribute.func_225505_c_().forEach(arg_0 -> ((ModifiableAttributeInstance)attribute).func_111124_b(arg_0));
                        attribute.func_111128_a(attribute.func_111123_a().func_111110_b());
                    });
                }
            }, 1);
        }
    }

    @SubscribeEvent
    public static void tickTemperature(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!EntityTempManager.getEntitiesWithTemperature().contains(entity.func_200600_R())) {
            return;
        }
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> {
            if (!entity.field_70170_p.field_72995_K) {
                cap.tick(entity);
            } else {
                cap.tickDummy(entity);
            }
            AtomicBoolean sync = new AtomicBoolean(false);
            for (Temperature.Trait trait : VALID_MODIFIER_TRAITS) {
                cap.getModifiers(trait).removeIf(modifier -> {
                    int expireTime = modifier.getExpireTime();
                    if (modifier.isDirty()) {
                        sync.set(true);
                        modifier.markClean();
                    }
                    return modifier.setTicksExisted(modifier.getTicksExisted() + 1) > expireTime && expireTime != -1;
                });
            }
            if (sync.get()) {
                Temperature.updateModifiers(entity, cap);
            }
        });
    }

    @SubscribeEvent
    public static void tickInventoryTempItems(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.field_70173_aa % 10 != 0 || !EntityTempManager.isTemperatureEnabled(event.getEntity())) {
            return;
        }
        Map effectsPerTrait = Arrays.stream(VALID_MODIFIER_TRAITS).collect(() -> new EnumMap(Temperature.Trait.class), (map, type) -> map.put(type, 0.0), EnumMap::putAll);
        FastMap effectsPerCarriedTemp = new FastMap();
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            ItemStack stack = entity.func_184582_a(slot);
            if (stack.func_190926_b()) continue;
            Item item = stack.func_77973_b();
            ConfigSettings.CARRIED_ITEM_TEMPERATURES.get().get((Object)item).forEach(carried -> EntityTempManager.checkAndAddCarriedTemp(entity, stack, null, slot, carried, effectsPerCarriedTemp));
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            for (Slot slot : player.field_71069_bz.field_75151_b) {
                ItemStack stack = slot.func_75211_c();
                if (stack.func_190926_b()) continue;
                Item item = stack.func_77973_b();
                ConfigSettings.CARRIED_ITEM_TEMPERATURES.get().get((Object)item).forEach(carried -> EntityTempManager.checkAndAddCarriedTemp(entity, stack, slot.field_75222_d, null, carried, effectsPerCarriedTemp));
            }
        }
        for (Map.Entry entry : effectsPerCarriedTemp.entrySet()) {
            Temperature.Trait trait2 = ((ItemCarryTempData)entry.getKey()).trait();
            double temp2 = (Double)entry.getValue();
            effectsPerTrait.put(trait2, (Double)effectsPerTrait.get(trait2) + temp2);
        }
        effectsPerTrait.forEach((trait, temp) -> {
            Optional<InventoryItemsTempModifier> modifier = Temperature.getModifier(entity, trait, InventoryItemsTempModifier.class);
            if (!modifier.isPresent()) {
                Temperature.addModifier(entity, new InventoryItemsTempModifier((double)temp), trait, Placement.Duplicates.BY_CLASS);
            } else {
                modifier.get().getNBT().func_74780_a("Effect", temp.doubleValue());
            }
        });
    }

    private static void checkAndAddCarriedTemp(LivingEntity entity, ItemStack stack, Integer slot, EquipmentSlotType equipmentSlot, ItemCarryTempData carried, Map<ItemCarryTempData, Double> effectsPerCarriedTemp) {
        if (carried.test((Entity)entity, stack, slot, equipmentSlot)) {
            double temp = carried.temperature() * (double)stack.func_190916_E();
            double currentEffect = effectsPerCarriedTemp.getOrDefault(carried, 0.0);
            double newEffect = Math.min(carried.maxEffect(), Math.abs(currentEffect + temp)) * (double)CSMath.sign(currentEffect + temp);
            effectsPerCarriedTemp.put(carried, newEffect);
        }
    }

    @SubscribeEvent
    public static void carryOverPersistentAttributes(PlayerEvent.Clone event) {
        PlayerEntity oldPlayer = event.getOriginal();
        PlayerEntity newPlayer = event.getPlayer();
        if (!newPlayer.field_70170_p.field_72995_K) {
            ((Collection)EntityTempManager.getTemperatureCap((Entity)oldPlayer).map(ITemperatureCap::getPersistentAttributes).orElse(new HashSet())).forEach(attr -> {
                newPlayer.func_110148_a(attr).func_111128_a(oldPlayer.func_110148_a(attr).func_111125_b());
                EntityTempManager.getTemperatureCap((Entity)newPlayer).ifPresent(cap -> cap.markPersistentAttribute((Attribute)attr));
            });
        }
    }

    @SubscribeEvent
    public static void handlePlayerReset(PlayerEvent.Clone event) {
        PlayerEntity oldPlayer = event.getOriginal();
        PlayerEntity newPlayer = event.getPlayer();
        EntityTempManager.getTemperatureCap((Entity)newPlayer).ifPresent(cap -> {
            if (!event.isWasDeath()) {
                EntityTempManager.getTemperatureCap((Entity)oldPlayer).ifPresent(cap::copy);
            }
        });
        CAP_CACHE.remove((Entity)oldPlayer);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void defineDefaultModifiers(GatherDefaultTempModifiersEvent event) {
        int fastTickRate;
        boolean isPlayer = event.getEntity() instanceof PlayerEntity;
        int slowTickRate = 60;
        int mediumTickRate = isPlayer ? 10 : 40;
        int mediumTickRate2 = isPlayer ? 10 : 20;
        int n = fastTickRate = isPlayer ? 5 : 20;
        if (event.getTrait() == Temperature.Trait.WORLD) {
            event.addModifier((TempModifier)new BiomeTempModifier(isPlayer ? 49 : 16).tickRate(mediumTickRate), Placement.Duplicates.BY_CLASS, Placement.BEFORE_FIRST);
            event.addModifier((TempModifier)new ElevationTempModifier(isPlayer ? 49 : 16).tickRate(mediumTickRate), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.AFTER, Placement.Order.FIRST, mod -> mod instanceof BiomeTempModifier));
            event.addModifier((TempModifier)new BlockTempModifier(isPlayer ? -1 : 4).tickRate(fastTickRate), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
            event.addModifier((TempModifier)new EntitiesTempModifier().tickRate(mediumTickRate2), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
            event.addModifierById(new ResourceLocation("sereneseasons:season"), mod -> mod.tickRate(slowTickRate), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.BEFORE, Placement.Order.FIRST, mod2 -> mod2 instanceof ElevationTempModifier));
            event.addModifierById(new ResourceLocation("weather2:storm"), mod -> mod.tickRate(slowTickRate), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.BEFORE, Placement.Order.FIRST, mod2 -> mod2 instanceof ElevationTempModifier));
            event.addModifierById(new ResourceLocation("valkyrienskies:ship_blocks"), mod -> mod.tickRate(mediumTickRate2), Placement.Duplicates.BY_CLASS, Placement.of(Placement.Mode.AFTER, Placement.Order.FIRST, mod2 -> mod2 instanceof BlockTempModifier));
        } else if (isPlayer && event.getTrait().isForModifiers()) {
            event.addModifier((TempModifier)new InventoryItemsTempModifier().tickRate(5), Placement.Duplicates.BY_CLASS, Placement.AFTER_LAST);
        }
    }

    @SubscribeEvent
    public static void addInventoryListeners(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            final PlayerEntity player = (PlayerEntity)event.getEntity();
            player.field_71070_bA.func_75132_a(new IContainerListener(){

                public void func_71111_a(Container menu, int slotIndex, ItemStack stack) {
                    Slot slot = menu.func_75139_a(slotIndex);
                    if (!(slot instanceof CraftingResultSlot) && slot.field_75224_c == player.field_71071_by && ConfigSettings.INSULATION_ITEMS.get().containsKey((Object)stack.func_77973_b())) {
                        player.func_193102_a(new ResourceLocation[]{new ResourceLocation("cold_sweat", "sewing_table")});
                    }
                }

                public void func_71112_a(Container container, int slot, int value) {
                }

                public void func_71110_a(Container container, NonNullList<ItemStack> stacks) {
                }
            });
        }
    }

    @SubscribeEvent
    public static void cancelDisabledModifiers(TempModifierEvent.Calculate.Pre event) {
        TempModifier modifier = event.getModifier();
        ResourceLocation modifierKey = TempModifierRegistry.getKey(modifier);
        if (modifierKey != null && ConfigSettings.DISABLED_MODIFIERS.get().contains(modifierKey)) {
            modifier.expires(0);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void calculateModifierImmunity(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!entity.field_70170_p.func_201670_d() && entity.field_70173_aa % 20 == 0 && EntityTempManager.isTemperatureEnabled((Entity)entity)) {
            FastMap<ResourceLocation, Double> immunities = new FastMap<ResourceLocation, Double>();
            for (Map.Entry<ItemStack, InsulatorData> entry : EntityTempManager.getInsulatorsOnEntity(entity).entrySet()) {
                ItemStack stack;
                InsulatorData insulator = entry.getValue();
                if (!insulator.test((Entity)entity, stack = entry.getKey())) continue;
                immunities.putAll(insulator.immuneTempModifiers());
            }
            if (entity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entity;
                for (Map.Entry<ItemStack, Pair<ItemCarryTempData, Either<Integer, ItemCarryTempData.SlotType>>> entry : EntityTempManager.getInventoryTemperaturesOnEntity(player).entrySet()) {
                    ItemCarryTempData invTemp = (ItemCarryTempData)entry.getValue().getFirst();
                    ItemStack stack = entry.getKey();
                    if (!((Boolean)((Either)entry.getValue().getSecond()).map(slot -> invTemp.test((Entity)player, stack, (Integer)slot, null), slot -> invTemp.test((Entity)entity, stack, (ItemCarryTempData.SlotType)slot))).booleanValue()) continue;
                    immunities.putAll(invTemp.immuneTempModifiers());
                }
            }
            TEMP_MODIFIER_IMMUNITIES.put((Entity)entity, immunities);
        }
    }

    @SubscribeEvent
    public static void checkModifierImmunity(TempModifierEvent.Calculate.Post event) {
        if (event.getEntity() instanceof DummyPlayer) {
            return;
        }
        if (!event.getTrait().isForAttributes()) {
            return;
        }
        TempModifier modifier = event.getModifier();
        ResourceLocation modifierKey = TempModifierRegistry.getKey(modifier);
        LivingEntity entity = event.getEntity();
        double immunity = TEMP_MODIFIER_IMMUNITIES.getOrDefault(entity, Collections.emptyMap()).getOrDefault(modifierKey, 0.0);
        if (immunity > 0.0) {
            Function<Double, Double> oldFunction = event.getFunction();
            event.setFunction(temp -> {
                double lastInput = modifier instanceof BiomeTempModifier ? Temperature.getNeutralWorldTemp(entity) : temp;
                return CSMath.blend((Double)oldFunction.apply((Double)temp), lastInput, immunity, 0.0, 1.0);
            });
        }
    }

    @SubscribeEvent
    public static void preventFullyImmuneModifiers(TempModifierEvent.Add event) {
        if (event.getEntity() instanceof DummyPlayer) {
            return;
        }
        if (!event.getTrait().isForAttributes()) {
            return;
        }
        TempModifier modifier = event.getModifier();
        ResourceLocation modifierKey = TempModifierRegistry.getKey(modifier);
        LivingEntity entity = event.getEntity();
        double immunity = TEMP_MODIFIER_IMMUNITIES.getOrDefault(entity, Collections.emptyMap()).getOrDefault(modifierKey, 0.0);
        if (immunity == 1.0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void handleWaterAndFreezing(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (!player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.START && player.field_70173_aa % 5 == 0 && !player.func_175149_v() && (WorldHelper.isInWater((Entity)player) || player.field_70173_aa % 40 == 0 && WorldHelper.isRainingAt(player.field_70170_p, player.func_233580_cy_()))) {
            Temperature.addModifier((LivingEntity)player, new WaterTempModifier(0.01f).tickRate(5), Temperature.Trait.WORLD, Placement.Duplicates.BY_CLASS);
        }
    }

    @SubscribeEvent
    public static void tickInventoryAttributeChanges(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.player.field_70173_aa % 20 == 0) {
            for (ItemStack item : event.player.field_71071_by.field_70462_a) {
                EntityTempManager.updateInventoryTempAttributes(item, item, (LivingEntity)event.player);
            }
        }
    }

    @SubscribeEvent
    public static void updateInventoryAttributesOnSlotChange(ContainerChangedEvent event) {
        if (event.getContainer() instanceof PlayerContainer) {
            PlayerContainer inventory = (PlayerContainer)event.getContainer();
            EntityTempManager.updateInventoryTempAttributes(event.getOldStack(), event.getNewStack(), (LivingEntity)EntityTempManager.getOwner(inventory));
        }
    }

    private static void updateInventoryTempAttributes(ItemStack oldStack, ItemStack newStack, LivingEntity entity) {
        for (ItemCarryTempData carryTempData : ConfigSettings.CARRIED_ITEM_TEMPERATURES.get().get((Object)oldStack.func_77973_b())) {
            entity.func_233645_dx_().func_233785_a_(carryTempData.attributeModifiers().getMap());
        }
        for (ItemCarryTempData carryTempData : ConfigSettings.CARRIED_ITEM_TEMPERATURES.get().get((Object)newStack.func_77973_b())) {
            if (!carryTempData.test((Entity)entity, newStack)) continue;
            entity.func_233645_dx_().func_233793_b_(carryTempData.attributeModifiers().getMap());
        }
    }

    private static PlayerEntity getOwner(PlayerContainer menu) {
        try {
            return (PlayerEntity)MENU_OWNER.get(menu);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @SubscribeEvent
    public static void tickInsulationAttributeChanges(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.field_70173_aa % 20 == 0) {
            for (ItemStack armor : entity.func_184193_aE()) {
                if (armor.func_190926_b()) continue;
                EntityTempManager.updateInsulationAttributeModifiers(entity, armor, armor);
            }
        }
    }

    @SubscribeEvent
    public static void updateInsulationAttributesOnEquipmentChange(LivingEquipmentChangeEvent event) {
        EntityTempManager.updateInsulationAttributeModifiers(event.getEntityLiving(), event.getFrom(), event.getTo());
        for (ItemStack armor : event.getEntity().func_184193_aE()) {
            if (armor.func_190926_b()) continue;
            EntityTempManager.updateInsulationAttributeModifiers(event.getEntityLiving(), armor, armor);
        }
    }

    public static void updateInsulationAttributeModifiers(LivingEntity entity, ItemStack from, ItemStack to) {
        for (InsulatorData insulatorData : ItemInsulationManager.getAllInsulatorsForStack(from)) {
            entity.func_233645_dx_().func_233785_a_(insulatorData.attributes().getMap());
        }
        for (InsulatorData insulatorData : ItemInsulationManager.getAllEffectiveInsulation(to, entity)) {
            entity.func_233645_dx_().func_233793_b_(insulatorData.attributes().getMap());
        }
    }

    @SubscribeEvent
    public static void onInsulationAdded(PotionEvent.PotionAddedEvent event) {
        LivingEntity entity = event.getEntityLiving();
        EffectInstance effect = event.getPotionEffect();
        if (!entity.field_70170_p.field_72995_K && EntityTempManager.isTemperatureEnabled((Entity)entity) && (effect.func_188419_a() == ModEffects.FRIGIDNESS || effect.func_188419_a() == ModEffects.WARMTH)) {
            boolean isWarmth = effect.func_188419_a() == ModEffects.WARMTH;
            int strength = effect.func_76458_c() + 1;
            ThermalSourceTempModifier newMod = (ThermalSourceTempModifier)(isWarmth ? new WarmthTempModifier(strength) : new FrigidnessTempModifier(strength)).expires(effect.func_76459_b());
            ThermalSourceTempModifier oldMod = Temperature.getModifier(entity, Temperature.Trait.WORLD, ThermalSourceTempModifier.class).orElse(null);
            if (oldMod == null || oldMod.getStrength() <= strength) {
                Temperature.addOrReplaceModifier(entity, newMod, Temperature.Trait.WORLD, Placement.Duplicates.BY_CLASS);
            }
        }
    }

    @SubscribeEvent
    public static void onInsulationRemoved(PotionEvent.PotionRemoveEvent event) {
        Optional<ThermalSourceTempModifier> modifier;
        LivingEntity entity = event.getEntityLiving();
        EffectInstance effect = event.getPotionEffect();
        if (effect != null && !entity.field_70170_p.field_72995_K && EntityTempManager.isTemperatureEnabled((Entity)entity) && (effect.func_188419_a() == ModEffects.FRIGIDNESS || effect.func_188419_a() == ModEffects.WARMTH) && (modifier = Temperature.getModifier(entity, Temperature.Trait.WORLD, ThermalSourceTempModifier.class)).isPresent()) {
            boolean isWarmth = effect.func_188419_a() == ModEffects.WARMTH;
            CompoundNBT nbt = modifier.get().getNBT();
            if (isWarmth) {
                nbt.func_74768_a("Warming", 0);
            } else {
                nbt.func_74768_a("Cooling", 0);
            }
            if (isWarmth ? !entity.func_70644_a(ModEffects.FRIGIDNESS) : !entity.func_70644_a(ModEffects.WARMTH)) {
                Temperature.removeModifiers(entity, Temperature.Trait.WORLD, mod -> mod instanceof ThermalSourceTempModifier);
            }
        }
    }

    @SubscribeEvent
    public static void onSleep(SleepFinishedTimeEvent event) {
        if (!event.getWorld().func_201670_d()) {
            event.getWorld().func_217369_A().forEach(player -> {
                if (player.func_70608_bn()) {
                    double temp = Temperature.get((LivingEntity)player, Temperature.Trait.CORE);
                    Temperature.set((LivingEntity)player, Temperature.Trait.CORE, temp / 4.0);
                }
            });
        }
    }

    @SubscribeEvent
    public static void playerRiding(TickEvent.PlayerTickEvent event) {
        PlayerEntity player;
        if (event.phase == TickEvent.Phase.START && !event.player.field_70170_p.func_201670_d() && event.player.field_70173_aa % 5 == 0 && (player = event.player).func_184187_bx() != null) {
            Entity mount = player.func_184187_bx();
            if (mount instanceof MinecartEntity && ((MinecartEntity)mount).func_174897_t().func_177230_c() == ModBlocks.MINECART_INSULATION) {
                Temperature.addOrReplaceModifier((LivingEntity)player, ((TempModifier)new MountTempModifier(1.0, 1.0).tickRate(5)).expires(5), Temperature.Trait.RATE, Placement.Duplicates.BY_CLASS);
            } else {
                MountData entityInsul = ConfigSettings.INSULATED_MOUNTS.get().get((Object)mount.func_200600_R()).stream().filter(mnt -> mnt.test(mount)).findFirst().orElse(null);
                if (entityInsul != null && entityInsul.test(mount)) {
                    Temperature.addOrReplaceModifier((LivingEntity)player, ((TempModifier)new MountTempModifier(entityInsul.coldInsulation(), entityInsul.heatInsulation()).tickRate(5)).expires(5), Temperature.Trait.RATE, Placement.Duplicates.BY_CLASS);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEatFood(LivingEntityUseItemEvent.Finish event) {
        ItemStack item = event.getItem();
        if (event.getEntity() instanceof PlayerEntity && (item.func_77975_n() == UseAction.DRINK || item.func_77975_n() == UseAction.EAT) && !event.getEntity().field_70170_p.field_72995_K) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            for (FoodData foodData : ConfigSettings.FOOD_TEMPERATURES.get().get((Object)item.func_77973_b())) {
                if (foodData == null || !foodData.test(item)) continue;
                double temperature = foodData.temperature();
                int duration = foodData.duration();
                Temperature.Trait trait = foodData.duration() > 0 ? Temperature.Trait.BASE : Temperature.Trait.CORE;
                FoodTempModifier foodModifier = item.func_77973_b() == ModItems.SOUL_SPROUT ? new SoulSproutTempModifier(temperature) : new FoodTempModifier(temperature);
                foodModifier.getNBT().func_74778_a("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item.func_77973_b()).toString());
                foodModifier.getNBT().func_74780_a("temperature", temperature);
                foodModifier.getNBT().func_74768_a("duration", duration);
                Temperature.addOrReplaceModifier((LivingEntity)player, foodModifier.expires(duration), trait, Placement.Duplicates.EXACT);
            }
        }
    }

    public static Set<EntityType<? extends LivingEntity>> getEntitiesWithTemperature() {
        return ImmutableSet.copyOf(TEMPERATURE_ENABLED_ENTITIES);
    }

    public static boolean isTemperatureEnabled(EntityType<?> type) {
        return TEMPERATURE_ENABLED_ENTITIES.contains(type);
    }

    public static boolean isTemperatureEnabled(Entity entity) {
        return TEMPERATURE_ENABLED_ENTITIES.contains(entity.func_200600_R());
    }

    public static boolean isPeacefulMode(LivingEntity entity) {
        return entity.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && ConfigSettings.USE_PEACEFUL_MODE.get() != false;
    }

    public static Map<ItemStack, InsulatorData> getInsulatorsOnEntity(LivingEntity entity) {
        HashMap<ItemStack, InsulatorData> insulators = new HashMap<ItemStack, InsulatorData>();
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            ItemStack stack;
            if (slot.func_188453_a() != EquipmentSlotType.Group.ARMOR || (stack = entity.func_184582_a(slot)).func_190926_b()) continue;
            ConfigSettings.INSULATING_ARMORS.get().get((Object)stack.func_77973_b()).forEach(insul -> insulators.put(stack, (InsulatorData)insul));
            ItemInsulationManager.getInsulationCap(stack).ifPresent(cap -> cap.getInsulation().stream().map(Pair::getFirst).forEach(item -> ConfigSettings.INSULATION_ITEMS.get().get((Object)item.func_77973_b()).forEach(insul -> insulators.put((ItemStack)item, (InsulatorData)insul))));
        }
        for (ItemStack curio : CompatManager.Curios.getCurios(entity)) {
            ConfigSettings.INSULATING_CURIOS.get().get((Object)curio.func_77973_b()).forEach(insul -> insulators.put(curio, (InsulatorData)insul));
        }
        return insulators;
    }

    public static Map<ItemStack, Pair<ItemCarryTempData, Either<Integer, ItemCarryTempData.SlotType>>> getInventoryTemperaturesOnEntity(PlayerEntity player) {
        HashMap<ItemStack, Pair<ItemCarryTempData, Either<Integer, ItemCarryTempData.SlotType>>> tempItems = new HashMap<ItemStack, Pair<ItemCarryTempData, Either<Integer, ItemCarryTempData.SlotType>>>();
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (stack.func_190926_b()) continue;
            int slotIndex = i;
            ConfigSettings.CARRIED_ITEM_TEMPERATURES.get().get((Object)stack.func_77973_b()).forEach(temp -> tempItems.put(stack, Pair.of((Object)temp, (Object)Either.left((Object)slotIndex))));
        }
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            ItemStack stack;
            if (slot.func_188453_a() != EquipmentSlotType.Group.ARMOR || (stack = player.func_184582_a(slot)).func_190926_b()) continue;
            ItemCarryTempData.SlotType slotType = ItemCarryTempData.SlotType.fromEquipment(slot);
            ConfigSettings.CARRIED_ITEM_TEMPERATURES.get().get((Object)stack.func_77973_b()).forEach(temp -> tempItems.put(stack, Pair.of((Object)temp, (Object)Either.right((Object)slotType))));
        }
        for (ItemStack curio : CompatManager.Curios.getCurios((LivingEntity)player)) {
            ConfigSettings.CARRIED_ITEM_TEMPERATURES.get().get((Object)curio.func_77973_b()).forEach(temp -> tempItems.put(curio, Pair.of((Object)temp, (Object)Either.right((Object)ItemCarryTempData.SlotType.CURIO))));
        }
        ItemStack offhand = player.func_184592_cb();
        if (!offhand.func_190926_b()) {
            ConfigSettings.CARRIED_ITEM_TEMPERATURES.get().get((Object)offhand.func_77973_b()).forEach(temp -> tempItems.put(offhand, Pair.of((Object)temp, (Object)Either.right((Object)ItemCarryTempData.SlotType.HAND))));
        }
        return tempItems;
    }

    public static void setAttribute(Temperature.Trait trait, LivingEntity entity, double value) {
        switch (trait) {
            case WORLD: {
                CSMath.doIfNotNull(entity.func_110148_a(ModAttributes.WORLD_TEMPERATURE), att -> att.func_111128_a(value));
                break;
            }
            case BASE: {
                CSMath.doIfNotNull(entity.func_110148_a(ModAttributes.BASE_BODY_TEMPERATURE), att -> att.func_111128_a(value));
                break;
            }
            case HEAT_RESISTANCE: {
                CSMath.doIfNotNull(entity.func_110148_a(ModAttributes.HEAT_RESISTANCE), att -> att.func_111128_a(value));
                break;
            }
            case COLD_RESISTANCE: {
                CSMath.doIfNotNull(entity.func_110148_a(ModAttributes.COLD_RESISTANCE), att -> att.func_111128_a(value));
                break;
            }
            case HEAT_DAMPENING: {
                CSMath.doIfNotNull(entity.func_110148_a(ModAttributes.HEAT_DAMPENING), att -> att.func_111128_a(value));
                break;
            }
            case COLD_DAMPENING: {
                CSMath.doIfNotNull(entity.func_110148_a(ModAttributes.COLD_DAMPENING), att -> att.func_111128_a(value));
                break;
            }
            case FREEZING_POINT: {
                CSMath.doIfNotNull(entity.func_110148_a(ModAttributes.FREEZING_POINT), att -> att.func_111128_a(value));
                break;
            }
            case BURNING_POINT: {
                CSMath.doIfNotNull(entity.func_110148_a(ModAttributes.BURNING_POINT), att -> att.func_111128_a(value));
            }
        }
    }

    @Nullable
    public static ModifiableAttributeInstance getAttribute(Temperature.Trait trait, LivingEntity entity) {
        switch (trait) {
            case WORLD: {
                return entity.func_110148_a(ModAttributes.WORLD_TEMPERATURE);
            }
            case BASE: {
                return entity.func_110148_a(ModAttributes.BASE_BODY_TEMPERATURE);
            }
            case FREEZING_POINT: {
                return entity.func_110148_a(ModAttributes.FREEZING_POINT);
            }
            case BURNING_POINT: {
                return entity.func_110148_a(ModAttributes.BURNING_POINT);
            }
            case HEAT_RESISTANCE: {
                return entity.func_110148_a(ModAttributes.HEAT_RESISTANCE);
            }
            case COLD_RESISTANCE: {
                return entity.func_110148_a(ModAttributes.COLD_RESISTANCE);
            }
            case HEAT_DAMPENING: {
                return entity.func_110148_a(ModAttributes.HEAT_DAMPENING);
            }
            case COLD_DAMPENING: {
                return entity.func_110148_a(ModAttributes.COLD_DAMPENING);
            }
        }
        throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("\"" + trait + "\" is not a valid trait!"));
    }

    public static Collection<AttributeModifier> getAllAttributeModifiers(LivingEntity entity, ModifiableAttributeInstance attribute, @Nullable AttributeModifier.Operation operation) {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>(operation == null ? attribute.func_225505_c_() : attribute.func_225504_a_(operation));
        modifiers.addAll(EntityTempManager.getAllEquipmentAttributeModifiers(entity, attribute, operation));
        return modifiers;
    }

    public static Collection<AttributeModifier> getAllEquipmentAttributeModifiers(LivingEntity entity, ModifiableAttributeInstance attribute, @Nullable AttributeModifier.Operation operation) {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            ItemStack stack;
            if (slot.func_188453_a() != EquipmentSlotType.Group.ARMOR || (stack = entity.func_184582_a(slot)).func_190926_b()) continue;
            modifiers.addAll(ItemInsulationManager.getAttributeModifiersForSlot(stack, attribute.func_111123_a(), slot, operation, (Entity)entity));
        }
        return modifiers;
    }

    public static AttributeModifier makeAttributeModifier(Temperature.Trait trait, double value, AttributeModifier.Operation operation) {
        switch (trait) {
            case WORLD: {
                return new AttributeModifier("World Temperature Modifier", value, operation);
            }
            case BASE: {
                return new AttributeModifier("Base Body Temperature Modifier", value, operation);
            }
            case FREEZING_POINT: {
                return new AttributeModifier("Freezing Point Modifier", value, operation);
            }
            case BURNING_POINT: {
                return new AttributeModifier("Burning Point Modifier", value, operation);
            }
            case HEAT_RESISTANCE: {
                return new AttributeModifier("Heat Resistance Modifier", value, operation);
            }
            case COLD_RESISTANCE: {
                return new AttributeModifier("Cold Resistance Modifier", value, operation);
            }
            case HEAT_DAMPENING: {
                return new AttributeModifier("Heat Dampening Modifier", value, operation);
            }
            case COLD_DAMPENING: {
                return new AttributeModifier("Cold Dampening Modifier", value, operation);
            }
        }
        throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("\"" + trait + "\" is not a valid trait!"));
    }

    public static boolean isTemperatureAttribute(Attribute attribute) {
        return ForgeRegistries.ATTRIBUTES.getKey((IForgeRegistryEntry)attribute).func_110624_b().equals("cold_sweat");
    }

    public static List<ModifiableAttributeInstance> getAllTemperatureAttributes(LivingEntity entity) {
        return Arrays.stream(VALID_ATTRIBUTE_TRAITS).map(trait -> EntityTempManager.getAttribute(trait, entity)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<TempModifier> getAllModifiers(LivingEntity entity) {
        ArrayList<TempModifier> allModifiers = new ArrayList<TempModifier>();
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> {
            for (Temperature.Trait trait : VALID_MODIFIER_TRAITS) {
                allModifiers.addAll(cap.getModifiers(trait));
            }
        });
        return allModifiers;
    }

    static {
        MENU_OWNER.setAccessible(true);
    }
}

