/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.handler;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.common.capability.ModCapabilities;
import com.momosoftworks.coldsweat.common.capability.SidedCapabilityCache;
import com.momosoftworks.coldsweat.common.capability.insulation.IInsulatableCap;
import com.momosoftworks.coldsweat.common.capability.insulation.ItemInsulationCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.util.TypedField;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.IArmorVanishable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber
public class ItemInsulationManager {
    public static SidedCapabilityCache<IInsulatableCap, ItemStack> CAP_CACHE = new SidedCapabilityCache(() -> ModCapabilities.ITEM_INSULATION, stack -> stack.func_190926_b() || !ItemInsulationManager.isInsulatable(stack));
    static IContainerListener INSULATION_LISTENER = new IContainerListener(){

        public void func_71111_a(Container sendingContainer, int slot, ItemStack stack) {
            ItemStack containerStack = sendingContainer.func_75139_a(slot).func_75211_c();
            ItemInsulationManager.getInsulationCap(containerStack).ifPresent(cap -> {
                containerStack.func_196082_o().func_82580_o("Insulation");
                containerStack.func_196082_o().func_197643_a(cap.serializeNBT());
            });
        }

        public void func_71110_a(Container pContainerToSend, NonNullList<ItemStack> pItemsList) {
        }

        public void func_71112_a(Container pContainer, int pVarToUpdate, int pNewValue) {
        }
    };
    static final TypedField<List<IContainerListener>> SLOT_LISTENERS = TypedField.of(ObfuscationReflectionHelper.findField(Container.class, (String)"field_75149_d"));

    @SubscribeEvent
    public static void attachCapabilityToItemHandler(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        if (ItemInsulationManager.isInsulatable(stack)) {
            final ItemInsulationCap itemInsulationCap = new ItemInsulationCap();
            final LazyOptional capOptional = LazyOptional.of(() -> itemInsulationCap);
            final Capability<IInsulatableCap> capability = ModCapabilities.ITEM_INSULATION;
            ICapabilitySerializable<CompoundNBT> provider = new ICapabilitySerializable<CompoundNBT>(){

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
                    if (cap == capability) {
                        return capOptional.cast();
                    }
                    return LazyOptional.empty();
                }

                public CompoundNBT serializeNBT() {
                    return itemInsulationCap.serializeNBT();
                }

                public void deserializeNBT(CompoundNBT nbt) {
                    itemInsulationCap.deserializeNBT(nbt);
                }
            };
            event.addCapability(new ResourceLocation("cold_sweat", "item_insulation"), (ICapabilityProvider)provider);
            CompoundNBT stackNBT = NBTHelper.getTagOrEmpty(stack);
            if (stack.func_77973_b() instanceof ArmorItem) {
                ArmorItem armor = (ArmorItem)stack.func_77973_b();
                if (stackNBT.func_74767_n("insulated")) {
                    stackNBT.func_82580_o("insulated");
                    switch (armor.func_185083_B_()) {
                        case HEAD: {
                            itemInsulationCap.addInsulationItem(Items.field_151024_Q.func_190903_i());
                            break;
                        }
                        case CHEST: {
                            itemInsulationCap.addInsulationItem(Items.field_151027_R.func_190903_i());
                            break;
                        }
                        case LEGS: {
                            itemInsulationCap.addInsulationItem(Items.field_151026_S.func_190903_i());
                            break;
                        }
                        case FEET: {
                            itemInsulationCap.addInsulationItem(Items.field_151021_T.func_190903_i());
                            break;
                        }
                        default: {
                            itemInsulationCap.addInsulationItem(ItemStack.field_190927_a);
                        }
                    }
                }
            }
        }
    }

    public static LazyOptional<IInsulatableCap> getInsulationCap(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof IArmorVanishable)) {
            return LazyOptional.empty();
        }
        return ItemInsulationManager.isInsulatable(stack) ? CAP_CACHE.get(stack) : LazyOptional.empty();
    }

    @SubscribeEvent
    public static void handleInventoryOpen(PlayerContainerEvent event) {
        event.getPlayer().getPersistentData().func_74757_a("InventoryOpen", event instanceof PlayerContainerEvent.Open);
    }

    @SubscribeEvent
    public static void onContainerOpen(PlayerContainerEvent.Open event) {
        event.getContainer().func_75132_a(INSULATION_LISTENER);
    }

    @SubscribeEvent
    public static void onContainerClose(PlayerContainerEvent.Close event) {
        SLOT_LISTENERS.get(event.getContainer()).remove(INSULATION_LISTENER);
        event.getContainer().func_75142_b();
    }

    public static int getInsulationSlots(ItemStack item) {
        return ItemInsulationManager.isInsulatable(item) ? ConfigSettings.INSULATION_SLOTS.get().getSlots(MobEntity.func_184640_d((ItemStack)item), item) : 0;
    }

    public static boolean isInsulatable(ItemStack stack) {
        return stack.func_77973_b() instanceof IArmorVanishable && ItemInsulationManager.getBuiltinInsulation(stack).isEmpty();
    }

    public static List<Insulation> getBuiltinInsulation(ItemStack stack) {
        return Stream.of(ConfigSettings.INSULATION_ITEMS.get().get((Object)stack.func_77973_b()), ConfigSettings.INSULATING_ARMORS.get().get((Object)stack.func_77973_b()), ConfigSettings.INSULATING_CURIOS.get().get((Object)stack.func_77973_b())).flatMap(Collection::stream).map(InsulatorData::insulation).flatMap(Collection::stream).filter(ins -> !ins.isEmpty()).collect(Collectors.toList());
    }

    public static List<InsulatorData> getAllInsulatorsForStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return new ArrayList<InsulatorData>();
        }
        ArrayList<InsulatorData> insulators = new ArrayList<InsulatorData>();
        if (ItemInsulationManager.isInsulatable(stack)) {
            ItemInsulationManager.getInsulationCap(stack).ifPresent(cap -> {
                for (Pair<ItemStack, Collection<InsulatorData>> pair : cap.getInsulation()) {
                    insulators.addAll(ConfigSettings.INSULATION_ITEMS.get().get((Object)((ItemStack)pair.getFirst()).func_77973_b()));
                }
            });
        }
        insulators.addAll(ConfigSettings.INSULATION_ITEMS.get().get((Object)stack.func_77973_b()));
        insulators.addAll(ConfigSettings.INSULATING_ARMORS.get().get((Object)stack.func_77973_b()));
        insulators.addAll(ConfigSettings.INSULATING_CURIOS.get().get((Object)stack.func_77973_b()));
        return insulators;
    }

    public static List<InsulatorData> getEffectiveAppliedInsulation(ItemStack armor, @Nullable LivingEntity entity) {
        return ((List)ItemInsulationManager.getInsulationCap(armor).map(IInsulatableCap::getInsulation).orElse(new ArrayList())).stream().map(pair -> pair.mapSecond(insulators -> insulators.stream().filter(entry -> entry.test((Entity)entity, (ItemStack)pair.getFirst())).collect(Collectors.toList()))).map(Pair::getSecond).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static List<InsulatorData> getAllEffectiveInsulation(ItemStack armor, @Nullable LivingEntity entity) {
        ArrayList<InsulatorData> insulation = new ArrayList<InsulatorData>(ItemInsulationManager.getEffectiveAppliedInsulation(armor, entity));
        insulation.addAll(ConfigSettings.INSULATING_ARMORS.get().get((Object)armor.func_77973_b()).stream().filter(insulator -> insulator.test((Entity)entity, armor)).collect(Collectors.toList()));
        return ImmutableList.copyOf(insulation);
    }

    public static List<AttributeModifier> getAppliedInsulationAttributes(ItemStack stack, Attribute attribute, @Nullable AttributeModifier.Operation operation, @Nullable Entity owner) {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();
        for (InsulatorData insulator : ItemInsulationManager.getAllInsulatorsForStack(stack)) {
            if (!insulator.test(owner, stack)) continue;
            modifiers.addAll(insulator.attributes().get(attribute).stream().filter(mod -> operation == null || mod.func_220375_c() == operation).collect(Collectors.toList()));
        }
        return modifiers;
    }

    public static List<AttributeModifier> getAttributeModifiersForSlot(ItemStack stack, Attribute attribute, EquipmentSlotType slot, @Nullable AttributeModifier.Operation operation, @Nullable Entity owner) {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>(operation != null ? (Collection)stack.func_111283_C(slot).get((Object)attribute).stream().filter(mod -> mod.func_220375_c() == operation).collect(Collectors.toList()) : stack.func_111283_C(slot).get((Object)attribute));
        modifiers.addAll(ItemInsulationManager.getAppliedInsulationAttributes(stack, attribute, operation, owner));
        return modifiers;
    }

    public static List<AttributeModifier> getAttributeModifiersForSlot(ItemStack stack, Attribute attribute, EquipmentSlotType slot) {
        return ItemInsulationManager.getAttributeModifiersForSlot(stack, attribute, slot, null, null);
    }

    static {
        SLOT_LISTENERS.field().setAccessible(true);
    }
}

