/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.insulation;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.capability.insulation.IInsulatableCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;

public class ItemInsulationCap
implements IInsulatableCap {
    private final List<Pair<ItemStack, Collection<InsulatorData>>> insulation = new ArrayList<Pair<ItemStack, Collection<InsulatorData>>>();
    private boolean changed = false;
    private CompoundNBT oldSerialized = null;

    @Override
    public List<Pair<ItemStack, Collection<InsulatorData>>> getInsulation() {
        return this.insulation;
    }

    @Override
    public List<InsulatorData> getInsulators() {
        return this.insulation.stream().map(Pair::getSecond).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void calcAdaptiveInsulation(double worldTemp, double minTemp, double maxTemp) {
        for (Pair<ItemStack, Collection<InsulatorData>> entry : this.insulation) {
            for (InsulatorData insulatorData : (Collection)entry.getSecond()) {
                List<Insulation> entryDataList = insulatorData.insulation();
                for (int i = 0; i < entryDataList.size(); ++i) {
                    Insulation entryInsul = entryDataList.get(i);
                    if (!(entryInsul instanceof AdaptiveInsulation)) continue;
                    AdaptiveInsulation insul = (AdaptiveInsulation)entryInsul;
                    double newFactor = AdaptiveInsulation.calculateChange(insul, worldTemp, minTemp, maxTemp);
                    insul.setFactor(newFactor);
                }
            }
        }
        this.changed = true;
    }

    @Override
    public void addInsulationItem(ItemStack stack) {
        Collection insulation = ConfigSettings.INSULATION_ITEMS.get().get((Object)stack.func_77973_b()).stream().map(InsulatorData::copy).collect(Collectors.toList());
        if (!insulation.isEmpty()) {
            this.insulation.add((Pair<ItemStack, Collection<InsulatorData>>)Pair.of((Object)stack, (Object)insulation));
            this.changed = true;
        }
    }

    @Override
    public ItemStack removeInsulationItem(ItemStack stack) {
        Optional<Pair> toRemove = this.insulation.stream().filter(entry -> ((ItemStack)entry.getFirst()).equals(stack)).findFirst();
        toRemove.ifPresent(pair -> {
            this.insulation.remove(pair);
            this.changed = true;
        });
        return stack;
    }

    @Override
    public ItemStack getInsulationItem(int index) {
        return (ItemStack)this.insulation.get(index).getFirst();
    }

    @Override
    public boolean canAddInsulationItem(ItemStack armorItem, ItemStack insulationItem) {
        Collection insulation = ConfigSettings.INSULATION_ITEMS.get().get((Object)insulationItem.func_77973_b()).stream().filter(insulator -> insulator.test(null, insulationItem)).collect(Collectors.toList());
        if (insulation.isEmpty()) {
            return false;
        }
        int appliedInsulators = 0;
        boolean hasSingleSlot = false;
        for (InsulatorData data : CSMath.merge(insulation, this.getInsulators())) {
            if (data.fillSlots()) {
                appliedInsulators += Insulation.splitList(data.insulation()).size();
                continue;
            }
            if (hasSingleSlot) continue;
            hasSingleSlot = true;
            ++appliedInsulators;
        }
        return (appliedInsulators = Math.max(1, appliedInsulators)) + this.insulation.size() <= ItemInsulationManager.getInsulationSlots(armorItem);
    }

    @Override
    public CompoundNBT serializeNBT() {
        if (!this.changed && this.oldSerialized != null) {
            return this.oldSerialized;
        }
        ListNBT insulNBT = new ListNBT();
        for (int i = 0; i < this.insulation.size(); ++i) {
            Pair<ItemStack, Collection<InsulatorData>> entry = this.insulation.get(i);
            CompoundNBT entryNBT = new CompoundNBT();
            Collection insulators = (Collection)entry.getSecond();
            entryNBT.func_218657_a("Item", (INBT)((ItemStack)entry.getFirst()).func_77955_b(new CompoundNBT()));
            ListNBT entryInsulList = new ListNBT();
            for (InsulatorData insulMapping : insulators) {
                CompoundNBT mappingNBT = new CompoundNBT();
                mappingNBT.func_218657_a("Insulator", (INBT)insulMapping.serialize());
                entryInsulList.add((Object)mappingNBT);
            }
            entryNBT.func_218657_a("Values", (INBT)entryInsulList);
            insulNBT.add((Object)entryNBT);
        }
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("Insulation", (INBT)insulNBT);
        this.oldSerialized = tag;
        this.changed = false;
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundNBT tag) {
        this.insulation.clear();
        ListNBT insulNBT = tag.func_150295_c("Insulation", 10);
        for (int i = 0; i < insulNBT.size(); ++i) {
            CompoundNBT entryNBT = insulNBT.func_150305_b(i);
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)entryNBT.func_74775_l("Item"));
            ArrayList<InsulatorData> insulators = new ArrayList<InsulatorData>();
            ListNBT pairListNBT = entryNBT.func_150295_c("Values", 10);
            if (!pairListNBT.isEmpty() && !pairListNBT.func_150305_b(0).func_74764_b("Insulator")) {
                for (InsulatorData insulator : ConfigSettings.INSULATION_ITEMS.get().get((Object)stack.func_77973_b())) {
                    insulators.add(insulator.copy());
                }
            } else {
                for (int j = 0; j < pairListNBT.size(); ++j) {
                    CompoundNBT mappingNBT = pairListNBT.func_150305_b(j);
                    InsulatorData.CODEC.decode((DynamicOps)NBTDynamicOps.field_210820_a, (Object)mappingNBT.func_74775_l("Insulator")).map(Pair::getFirst).result().ifPresent(insulators::add);
                }
            }
            this.insulation.add((Pair<ItemStack, Collection<InsulatorData>>)Pair.of((Object)stack, insulators));
        }
        if (!tag.equals((Object)this.oldSerialized)) {
            this.changed = true;
        }
    }

    @Override
    public void copy(IInsulatableCap cap) {
        this.insulation.clear();
        this.insulation.addAll(cap.getInsulation());
    }
}

