/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.temperature;

import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.event.common.temperautre.TemperatureChangedEvent;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.advancement.trigger.ModAdvancementTriggers;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModDamageSources;
import com.momosoftworks.coldsweat.util.registries.ModEffects;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AbstractTempCap
implements ITemperatureCap {
    boolean changed = true;
    int syncTimer = 0;
    Temperature.Units preferredUnits = Temperature.Units.F;
    private final Set<Attribute> persistentAttributes = new HashSet<Attribute>();
    private final EnumMap<Temperature.Trait, Double> traits = Arrays.stream(EntityTempManager.VALID_TEMPERATURE_TRAITS).collect(() -> new EnumMap(Temperature.Trait.class), (map, type) -> map.put(type, 0.0), EnumMap::putAll);
    private final EnumMap<Temperature.Trait, List<TempModifier>> modifiers = Arrays.stream(EntityTempManager.VALID_MODIFIER_TRAITS).collect(() -> new EnumMap(Temperature.Trait.class), (map, type) -> {
        List cfr_ignored_0 = map.put(type, new ArrayList());
    }, EnumMap::putAll);
    public boolean showBodyTemp;
    public boolean showWorldTemp;

    @Override
    public double getTrait(Temperature.Trait trait) {
        if (trait == Temperature.Trait.BODY) {
            return this.getTrait(Temperature.Trait.CORE) + this.getTrait(Temperature.Trait.BASE);
        }
        if (!this.traits.containsKey(trait)) {
            throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Invalid temperature trait: " + trait));
        }
        return this.traits.get(trait);
    }

    @Override
    public EnumMap<Temperature.Trait, Double> getTraits() {
        return new EnumMap<Temperature.Trait, Double>(this.traits);
    }

    @Override
    public void setTrait(Temperature.Trait trait, double value) {
        switch (trait) {
            case CORE: {
                this.changed |= (int)value != (int)this.getTrait(Temperature.Trait.CORE);
                break;
            }
            case BASE: {
                this.changed |= (int)value != (int)this.getTrait(Temperature.Trait.BASE);
                break;
            }
            case WORLD: {
                this.changed |= Math.abs(value - this.getTrait(Temperature.Trait.WORLD)) >= 0.02;
                break;
            }
            default: {
                this.changed |= true;
            }
        }
        if (this.traits.replace(trait, value) == null) {
            throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Invalid temperature trait: " + trait));
        }
    }

    public void setTrait(Temperature.Trait trait, double value, LivingEntity entity) {
        double oldTemp = this.getTrait(trait);
        this.setTrait(trait, value);
        if (entity.field_70173_aa > 5 && oldTemp != value && entity instanceof ServerPlayerEntity) {
            ModAdvancementTriggers.TEMPERATURE_CHANGED.trigger((ServerPlayerEntity)entity, this.getTraits());
        }
    }

    @Override
    public void addModifier(TempModifier modifier, Temperature.Trait trait) {
        this.modifiers.get(trait).add(modifier);
    }

    @Override
    public List<TempModifier> getModifiers(Temperature.Trait trait) {
        return this.modifiers.computeIfAbsent(trait, t -> {
            throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Invalid modifier trait: " + t));
        });
    }

    @Override
    public boolean hasModifier(Temperature.Trait trait, Class<? extends TempModifier> mod) {
        return this.getModifiers(trait).stream().anyMatch(mod::isInstance);
    }

    @Override
    public void markPersistentAttribute(Attribute attribute) {
        this.persistentAttributes.add(attribute);
    }

    @Override
    public void clearPersistentAttribute(Attribute attribute) {
        this.persistentAttributes.remove(attribute);
    }

    @Override
    public Collection<Attribute> getPersistentAttributes() {
        return this.persistentAttributes;
    }

    @Override
    public void clearModifiers(Temperature.Trait trait) {
        this.getModifiers(trait).clear();
    }

    @Override
    public Temperature.Units getPreferredUnits() {
        return this.preferredUnits;
    }

    @Override
    public void setPreferredUnits(Temperature.Units units) {
        this.preferredUnits = units;
    }

    public boolean shouldShowBodyTemp() {
        return this.showBodyTemp;
    }

    public boolean showAdvancedWorldTemp() {
        return this.showWorldTemp;
    }

    @Override
    public void tickDummy(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        Temperature.apply(0.0, (LivingEntity)player, Temperature.Trait.WORLD, this.getModifiers(Temperature.Trait.WORLD));
        Temperature.apply(this.getTrait(Temperature.Trait.CORE), (LivingEntity)player, Temperature.Trait.CORE, this.getModifiers(Temperature.Trait.CORE));
        Temperature.apply(0.0, (LivingEntity)player, Temperature.Trait.BASE, this.getModifiers(Temperature.Trait.BASE));
    }

    @Override
    public void tick(LivingEntity entity) {
        boolean isFullyHeatDampened;
        double newWorldTemp = this.modifyFromAttribute(entity, Temperature.Trait.WORLD, 0.0);
        double newBaseTemp = this.modifyFromAttribute(entity, Temperature.Trait.BASE, 0.0);
        double newCoreTemp = Temperature.apply(this.getTrait(Temperature.Trait.CORE), entity, Temperature.Trait.CORE, this.getModifiers(Temperature.Trait.CORE));
        double maxTemp = this.modifyFromAttribute(entity, Temperature.Trait.BURNING_POINT, ConfigSettings.MAX_TEMP.get());
        double minTemp = this.modifyFromAttribute(entity, Temperature.Trait.FREEZING_POINT, ConfigSettings.MIN_TEMP.get());
        double coldDampening = this.modifyFromAttribute(entity, Temperature.Trait.COLD_DAMPENING, 0.0);
        double heatDampening = this.modifyFromAttribute(entity, Temperature.Trait.HEAT_DAMPENING, 0.0);
        double coldResistance = this.modifyFromAttribute(entity, Temperature.Trait.COLD_RESISTANCE, 0.0);
        double heatResistance = this.modifyFromAttribute(entity, Temperature.Trait.HEAT_RESISTANCE, 0.0);
        int worldTempSign = CSMath.signForRange(newWorldTemp, minTemp, maxTemp);
        boolean immuneToTemp = EntityTempManager.isPeacefulMode(entity);
        boolean isFullyColdDampened = worldTempSign < 0 && (coldDampening >= 1.0 || immuneToTemp);
        boolean bl = isFullyHeatDampened = worldTempSign > 0 && (heatDampening >= 1.0 || immuneToTemp);
        if (!(worldTempSign == 0 || entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_() || entity.func_175149_v() || EntityTempManager.isPeacefulMode(entity))) {
            double difference = Math.abs(newWorldTemp - CSMath.clamp(newWorldTemp, minTemp, maxTemp));
            double changeBy = Math.max(difference / 7.0 * (double)ConfigSettings.TEMP_RATE.get().floatValue(), Math.abs((double)ConfigSettings.TEMP_RATE.get().floatValue() / 50.0)) * (double)worldTempSign;
            if (changeBy < 0.0) {
                changeBy = coldDampening < 0.0 ? changeBy * (1.0 + Math.abs(coldDampening)) : CSMath.blend(changeBy, 0.0, coldDampening, 0.0, 1.0);
            } else if (changeBy > 0.0) {
                changeBy = heatDampening < 0.0 ? changeBy * (1.0 + Math.abs(heatDampening)) : CSMath.blend(changeBy, 0.0, heatDampening, 0.0, 1.0);
            }
            newCoreTemp += Temperature.apply(changeBy, entity, Temperature.Trait.RATE, this.getModifiers(Temperature.Trait.RATE));
        }
        int coreTempSign = CSMath.sign(newCoreTemp);
        List<TempModifier> coreModifiers = this.getModifiers(Temperature.Trait.CORE);
        boolean hasCoreModifiers = !coreModifiers.isEmpty() && coreModifiers.get(0).getLastInput() == coreModifiers.get(coreModifiers.size() - 1).getLastOutput();
        double amount = 0.0;
        if (isFullyColdDampened && coreTempSign < 0) {
            amount = ConfigSettings.TEMP_RATE.get() / 10.0;
        } else if (isFullyHeatDampened && coreTempSign > 0) {
            amount = ConfigSettings.TEMP_RATE.get() / -10.0;
        } else if (coreTempSign != 0 && coreTempSign != worldTempSign) {
            amount = (coreTempSign == 1 ? newWorldTemp - maxTemp : newWorldTemp - minTemp) / 3.0;
        }
        if (amount != 0.0) {
            double changeBy = CSMath.maxAbs(amount * ConfigSettings.TEMP_RATE.get(), ConfigSettings.TEMP_RATE.get() / 10.0 * (double)(-coreTempSign));
            if (hasCoreModifiers) {
                changeBy /= 2.0;
            }
            newCoreTemp += CSMath.minAbs(changeBy, -this.getTrait(Temperature.Trait.CORE));
        }
        this.setTrait(Temperature.Trait.CORE, CSMath.clamp(newCoreTemp, -150.0, 150.0), entity);
        this.setTrait(Temperature.Trait.BASE, CSMath.clamp(newBaseTemp, -150.0, 150.0), entity);
        this.setTrait(Temperature.Trait.WORLD, newWorldTemp, entity);
        this.setTrait(Temperature.Trait.BURNING_POINT, maxTemp);
        this.setTrait(Temperature.Trait.FREEZING_POINT, minTemp);
        this.setTrait(Temperature.Trait.COLD_RESISTANCE, coldResistance);
        this.setTrait(Temperature.Trait.HEAT_RESISTANCE, heatResistance);
        this.setTrait(Temperature.Trait.COLD_DAMPENING, coldDampening);
        this.setTrait(Temperature.Trait.HEAT_DAMPENING, heatDampening);
        if (this.syncTimer > 0) {
            --this.syncTimer;
        }
        if (this.changed && this.syncTimer <= 0) {
            this.syncValues(entity);
        }
        this.tickHurting(entity, heatResistance, coldResistance);
    }

    private double modifyFromAttribute(LivingEntity entity, Temperature.Trait type, double baseValue) {
        double newValue;
        Supplier<Double> defaultSupplier = () -> Temperature.apply(baseValue, entity, type, this.getModifiers(type));
        ModifiableAttributeInstance attribute = EntityTempManager.getAttribute(type, entity);
        if (attribute == null) {
            newValue = defaultSupplier.get();
        } else {
            double base = CSMath.safeDouble(attribute.func_111125_b()).orElse(defaultSupplier.get());
            for (AttributeModifier mod : attribute.func_225504_a_(AttributeModifier.Operation.ADDITION)) {
                base += mod.func_111164_d();
            }
            double value = base;
            for (AttributeModifier mod : attribute.func_225504_a_(AttributeModifier.Operation.MULTIPLY_BASE)) {
                value += base * mod.func_111164_d();
            }
            for (AttributeModifier mod : attribute.func_225504_a_(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
                value *= 1.0 + mod.func_111164_d();
            }
            newValue = value;
        }
        if (newValue != baseValue) {
            MinecraftForge.EVENT_BUS.post((Event)new TemperatureChangedEvent(entity, type, this.getTrait(type), newValue));
        }
        NBTHelper.getOrPutTag(entity, "Temperature", new CompoundNBT()).func_74780_a(type.func_176610_l(), newValue);
        return newValue;
    }

    @Override
    public void syncValues(LivingEntity entity) {
        Temperature.updateTemperature(entity, this, false);
        this.changed = false;
        this.syncTimer = 5;
    }

    public void tickHurting(LivingEntity entity, double heatResistance, double coldResistance) {
        if (EntityTempManager.isPeacefulMode(entity)) {
            return;
        }
        double bodyTemp = this.getTrait(Temperature.Trait.BODY);
        boolean hasGrace = entity.func_70644_a(ModEffects.GRACE);
        boolean hasFireResist = entity.func_70644_a(Effects.field_76426_n);
        boolean hasIceResist = entity.func_70644_a(ModEffects.ICE_RESISTANCE);
        if (!hasGrace && entity.field_70173_aa % 40 == 0) {
            if (!(!(bodyTemp >= 100.0) || hasFireResist && ConfigSettings.FIRE_RESISTANCE_ENABLED.get().booleanValue())) {
                DamageSource hot = ModDamageSources.HOT;
                entity.func_70097_a(hot, (float)CSMath.blend(ConfigSettings.TEMP_DAMAGE.get(), 0.0, heatResistance, 0.0, 1.0));
            } else if (!(!(bodyTemp <= -100.0) || hasIceResist && ConfigSettings.ICE_RESISTANCE_ENABLED.get().booleanValue())) {
                DamageSource cold = ModDamageSources.COLD;
                entity.func_70097_a(cold, (float)CSMath.blend(ConfigSettings.TEMP_DAMAGE.get(), 0.0, coldResistance, 0.0, 1.0));
            }
        }
    }

    @Override
    public void copy(ITemperatureCap cap) {
        for (Temperature.Trait trait : EntityTempManager.VALID_TEMPERATURE_TRAITS) {
            this.setTrait(trait, cap.getTrait(trait));
        }
        for (Temperature.Trait trait : EntityTempManager.VALID_MODIFIER_TRAITS) {
            this.getModifiers(trait).clear();
            this.getModifiers(trait).addAll(cap.getModifiers(trait));
        }
        this.persistentAttributes.clear();
        this.persistentAttributes.addAll(cap.getPersistentAttributes());
        this.setPreferredUnits(cap.getPreferredUnits());
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Traits", (INBT)this.serializeTraits());
        nbt.func_218657_a("TempModifiers", (INBT)this.serializeModifiers());
        ListNBT attributes = new ListNBT();
        for (Attribute attribute : this.getPersistentAttributes()) {
            attributes.add((Object)StringNBT.func_229705_a_((String)ForgeRegistries.ATTRIBUTES.getKey((IForgeRegistryEntry)attribute).toString()));
        }
        nbt.func_218657_a("PersistentAttributes", (INBT)attributes);
        return nbt;
    }

    @Override
    public CompoundNBT serializeTraits() {
        CompoundNBT nbt = new CompoundNBT();
        for (Map.Entry<Temperature.Trait, Double> trait : this.traits.entrySet()) {
            nbt.func_74780_a(NBTHelper.getTraitTagKey(trait.getKey()), trait.getValue().doubleValue());
        }
        return nbt;
    }

    @Override
    public CompoundNBT serializeModifiers() {
        CompoundNBT nbt = new CompoundNBT();
        for (Temperature.Trait trait : EntityTempManager.VALID_MODIFIER_TRAITS) {
            ListNBT modifiers = new ListNBT();
            for (TempModifier modifier : this.getModifiers(trait)) {
                modifiers.add((Object)NBTHelper.modifierToTag(modifier));
            }
            nbt.func_218657_a(NBTHelper.getTraitTagKey(trait), (INBT)modifiers);
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        this.deserializeTraits(nbt.func_74775_l("Traits"));
        this.deserializeModifiers(nbt.func_74775_l("TempModifiers"));
        ListNBT attributes = nbt.func_150295_c("PersistentAttributes", 8);
        for (int i = 0; i < attributes.size(); ++i) {
            this.markPersistentAttribute((Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(attributes.func_150307_f(i))));
        }
    }

    @Override
    public void deserializeTraits(CompoundNBT nbt) {
        for (Temperature.Trait trait : EntityTempManager.VALID_TEMPERATURE_TRAITS) {
            this.setTrait(trait, nbt.func_74769_h(NBTHelper.getTraitTagKey(trait)));
        }
    }

    @Override
    public void deserializeModifiers(CompoundNBT nbt) {
        for (Temperature.Trait trait : EntityTempManager.VALID_MODIFIER_TRAITS) {
            this.getModifiers(trait).clear();
            ListNBT modifiers = nbt.func_150295_c(NBTHelper.getTraitTagKey(trait), 10);
            modifiers.forEach(modNBT -> NBTHelper.tagToModifier((CompoundNBT)modNBT).ifPresent(modifier -> this.getModifiers(trait).add((TempModifier)modifier)));
        }
    }
}

