/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.command.impl;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.common.command.BaseCommand;
import com.momosoftworks.coldsweat.common.command.argument.TempAttributeTraitArgument;
import com.momosoftworks.coldsweat.common.command.argument.TempModifierTraitArgument;
import com.momosoftworks.coldsweat.common.command.argument.TemperatureTraitArgument;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.server.command.EnumArgument;

public class TempCommand
extends BaseCommand {
    public TempCommand(String name, int permissionLevel, boolean enabled) {
        super(name, permissionLevel, enabled);
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> setExecution() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.builder.then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"entities", (ArgumentType)EntityArgument.func_197093_b()).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)-150, (int)150)).executes(source -> this.executeSetEntityTemp((CommandSource)source.getSource(), EntityArgument.func_197097_b((CommandContext)source, (String)"entities"), IntegerArgumentType.getInteger((CommandContext)source, (String)"amount"), Temperature.Trait.BODY)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"get").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"entities", (ArgumentType)EntityArgument.func_197093_b()).executes(source -> this.executeGetEntityTemp((CommandSource)source.getSource(), EntityArgument.func_197097_b((CommandContext)source, (String)"entities"), Temperature.Trait.BODY))).then(Commands.func_197056_a((String)"trait", (ArgumentType)TemperatureTraitArgument.temperatureGet()).executes(source -> this.executeGetEntityTemp((CommandSource)source.getSource(), EntityArgument.func_197097_b((CommandContext)source, (String)"entities"), TemperatureTraitArgument.getTemperature((CommandContext<CommandSource>)source, "trait")))))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).executes(source -> {
            BlockPos pos = BlockPosArgument.func_197273_a((CommandContext)source, (String)"pos");
            return this.executeGetWorldTemp((CommandSource)source.getSource(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), ((CommandSource)source.getSource()).func_197023_e());
        })).then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).executes(source -> this.executeGetWorldTemp((CommandSource)source.getSource(), IntegerArgumentType.getInteger((CommandContext)source, (String)"x"), IntegerArgumentType.getInteger((CommandContext)source, (String)"y"), IntegerArgumentType.getInteger((CommandContext)source, (String)"z"), DimensionArgument.func_212592_a((CommandContext)source, (String)"dimension"))))))).then(Commands.func_197057_a((String)"debug").then(Commands.func_197056_a((String)"entity", (ArgumentType)EntityArgument.func_197086_a()).then(Commands.func_197056_a((String)"type", (ArgumentType)TempModifierTraitArgument.modifier()).executes(source -> this.executeDebugModifiers((CommandSource)source.getSource(), EntityArgument.func_197088_a((CommandContext)source, (String)"entity"), TempModifierTraitArgument.getModifier((CommandContext<CommandSource>)source, "type"))))))).then(Commands.func_197057_a((String)"modify").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"entities", (ArgumentType)EntityArgument.func_197093_b()).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"clear").then(Commands.func_197056_a((String)"type", (ArgumentType)TempAttributeTraitArgument.attribute()).executes(source -> this.executeClearModifier((CommandSource)source.getSource(), EntityArgument.func_197097_b((CommandContext)source, (String)"entities"), TempAttributeTraitArgument.getAttribute((CommandContext<CommandSource>)source, "type"))))).executes(source -> this.executeClearAllModifiers((CommandSource)source.getSource(), EntityArgument.func_197097_b((CommandContext)source, (String)"entities"))))).then(Commands.func_197056_a((String)"operation", (ArgumentType)EnumArgument.enumArgument(AttributeModifier.Operation.class)).then(Commands.func_197056_a((String)"type", (ArgumentType)TempAttributeTraitArgument.attribute()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.func_197056_a((String)"permanent", (ArgumentType)BoolArgumentType.bool()).executes(source -> this.executeModifyEntityTemp((CommandSource)source.getSource(), EntityArgument.func_197097_b((CommandContext)source, (String)"entities"), TempAttributeTraitArgument.getAttribute((CommandContext<CommandSource>)source, "type"), DoubleArgumentType.getDouble((CommandContext)source, (String)"amount"), (AttributeModifier.Operation)source.getArgument("operation", AttributeModifier.Operation.class), BoolArgumentType.getBool((CommandContext)source, (String)"permanent"))))).executes(source -> this.executeModifyEntityTemp((CommandSource)source.getSource(), EntityArgument.func_197097_b((CommandContext)source, (String)"entities"), TempAttributeTraitArgument.getAttribute((CommandContext<CommandSource>)source, "type"), DoubleArgumentType.getDouble((CommandContext)source, (String)"amount"), (AttributeModifier.Operation)source.getArgument("operation", AttributeModifier.Operation.class), false)))))).then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"type", (ArgumentType)TempAttributeTraitArgument.attribute()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.func_197056_a((String)"permanent", (ArgumentType)BoolArgumentType.bool()).executes(source -> this.executeModifyEntityTemp((CommandSource)source.getSource(), EntityArgument.func_197097_b((CommandContext)source, (String)"entities"), TempAttributeTraitArgument.getAttribute((CommandContext<CommandSource>)source, "type"), DoubleArgumentType.getDouble((CommandContext)source, (String)"amount"), null, BoolArgumentType.getBool((CommandContext)source, (String)"permanent"))))).executes(source -> this.executeModifyEntityTemp((CommandSource)source.getSource(), EntityArgument.func_197097_b((CommandContext)source, (String)"entities"), TempAttributeTraitArgument.getAttribute((CommandContext<CommandSource>)source, "type"), DoubleArgumentType.getDouble((CommandContext)source, (String)"amount"), null, false)))))));
    }

    private int executeSetEntityTemp(CommandSource source, Collection<? extends Entity> entities, double temp, Temperature.Trait trait) {
        if (entities.stream().anyMatch(entity -> !(entity instanceof PlayerEntity) && !EntityTempManager.getEntitiesWithTemperature().contains(entity.func_200600_R()))) {
            source.func_197021_a((ITextComponent)new TranslationTextComponent("commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        for (Entity entity2 : entities) {
            if (!(entity2 instanceof LivingEntity)) continue;
            Temperature.set((LivingEntity)entity2, trait == Temperature.Trait.BODY ? Temperature.Trait.CORE : trait, temp);
        }
        Temperature.Units preferredUnits = CSMath.getIfNotNull(source.func_197022_f(), player -> EntityTempManager.getTemperatureCap(player).map(ITemperatureCap::getPreferredUnits).orElse(Temperature.Units.F), Temperature.Units.F);
        String string = trait.isForWorld() ? " " + preferredUnits.getFormattedName() : "";
        double convertedTemp = Temperature.convertIfNeeded(temp, trait, preferredUnits);
        if (entities.size() == 1) {
            Entity target = entities.iterator().next();
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.cold_sweat.temperature.set.single.result", new Object[]{trait.func_176610_l(), target.func_200200_C_().getString(), CSMath.truncate(convertedTemp, 1) + string}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.cold_sweat.temperature.set.many.result", new Object[]{trait.func_176610_l(), entities.size(), CSMath.truncate(convertedTemp, 1) + string}), true);
        }
        return entities.size();
    }

    private int executeGetEntityTemp(CommandSource source, Collection<? extends Entity> entities, Temperature.Trait trait) {
        if (entities.stream().anyMatch(entity -> !(entity instanceof PlayerEntity) && !EntityTempManager.getEntitiesWithTemperature().contains(entity.func_200600_R()))) {
            source.func_197021_a((ITextComponent)new TranslationTextComponent("commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        Temperature.Units preferredUnits = CSMath.getIfNotNull(source.func_197022_f(), player -> EntityTempManager.getTemperatureCap(player).map(ITemperatureCap::getPreferredUnits).orElse(Temperature.Units.F), Temperature.Units.F);
        for (Entity target : entities.stream().sorted(Comparator.comparing(player -> player.func_200200_C_().getString())).collect(Collectors.toList())) {
            double temp = CSMath.truncate(Temperature.convertIfNeeded(Temperature.get((LivingEntity)target, trait), trait, preferredUnits), 1);
            String unitsName = trait.isForWorld() ? " " + preferredUnits.getFormattedName() : "";
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.cold_sweat.temperature.get.result", new Object[]{target.func_200200_C_().getString(), trait.func_176610_l(), temp + unitsName}), false);
        }
        return entities.size();
    }

    private int executeGetWorldTemp(CommandSource source, int x, int y, int z, ServerWorld level) {
        Temperature.Units units = CSMath.getIfNotNull(source.func_197022_f(), ent -> EntityTempManager.getTemperatureCap(ent).map(ITemperatureCap::getPreferredUnits).orElse(Temperature.Units.F), Temperature.Units.F);
        int worldTemp = (int)Temperature.convert(WorldHelper.getTemperatureAt((World)(level != null ? level : source.func_197023_e()), new BlockPos(x, y, z)), Temperature.Units.MC, units, true);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.cold_sweat.temperature.get.world.result", new Object[]{x, y, z, worldTemp, units.getFormattedName()}), true);
        return 1;
    }

    private int executeDebugModifiers(CommandSource source, Entity entity, Temperature.Trait trait) {
        if (!(entity instanceof PlayerEntity) && !EntityTempManager.getEntitiesWithTemperature().contains(entity.func_200600_R())) {
            source.func_197021_a((ITextComponent)new TranslationTextComponent("commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        LivingEntity living = (LivingEntity)entity;
        ModifiableAttributeInstance attribute = trait.isForAttributes() ? EntityTempManager.getAttribute(trait, living) : null;
        Temperature.Units preferredUnits = EntityTempManager.getTemperatureCap(entity).map(ITemperatureCap::getPreferredUnits).orElse(Temperature.Units.F);
        double lastValue = trait == Temperature.Trait.BURNING_POINT ? ConfigSettings.MAX_TEMP.get() : (trait == Temperature.Trait.FREEZING_POINT ? ConfigSettings.MIN_TEMP.get() : 0.0);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.cold_sweat.temperature.debug", new Object[]{living.func_145748_c_(), trait.func_176610_l()}).func_240699_a_(TextFormatting.WHITE), false);
        if (attribute != null && CSMath.safeDouble(attribute.func_111125_b()).isPresent()) {
            source.func_197030_a((ITextComponent)new StringTextComponent(ForgeRegistries.ATTRIBUTES.getKey((IForgeRegistryEntry)attribute.func_111123_a()).toString()).func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)new StringTextComponent(" \u2192 ").func_240699_a_(TextFormatting.WHITE)).func_230529_a_((ITextComponent)new StringTextComponent(attribute.func_111126_e() + "").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.AQUA).func_240716_a_(TempCommand.getConvertedUnitHover(trait, attribute.func_111126_e(), preferredUnits)))), false);
            lastValue = attribute.func_111125_b();
        } else {
            for (TempModifier modifier : Temperature.getModifiers(living, trait)) {
                double lastInput = modifier.getLastInput();
                double lastOutput = modifier.getLastOutput();
                source.func_197030_a((ITextComponent)new StringTextComponent("").func_230529_a_((ITextComponent)new StringTextComponent(CSMath.truncate(modifier.getLastInput(), 2) + "").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.WHITE).func_240716_a_(TempCommand.getConvertedUnitHover(trait, lastInput, preferredUnits)))).func_230529_a_((ITextComponent)new StringTextComponent(" \u2192 ").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.WHITE).func_240716_a_(null))).func_230529_a_((ITextComponent)new StringTextComponent(modifier.toString()).func_240699_a_(TextFormatting.GRAY)).func_230529_a_((ITextComponent)new StringTextComponent(" \u2192 ").func_240699_a_(TextFormatting.WHITE)).func_230529_a_((ITextComponent)new StringTextComponent(CSMath.truncate(modifier.getLastOutput(), 2) + "").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.AQUA).func_240716_a_(TempCommand.getConvertedUnitHover(trait, lastOutput, preferredUnits)))), false);
                lastValue = modifier.getLastOutput();
            }
        }
        if (attribute != null) {
            double newBase = lastValue;
            for (AttributeModifier modifier : attribute.func_225504_a_(AttributeModifier.Operation.ADDITION)) {
                TempCommand.printAttributeModifierLine(source, modifier, lastValue, newBase += modifier.func_111164_d(), trait, preferredUnits);
            }
            double newValue = newBase;
            for (AttributeModifier modifier : attribute.func_225504_a_(AttributeModifier.Operation.MULTIPLY_BASE)) {
                TempCommand.printAttributeModifierLine(source, modifier, lastValue, newValue += newBase * modifier.func_111164_d(), trait, preferredUnits);
            }
            for (AttributeModifier modifier : attribute.func_225504_a_(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
                TempCommand.printAttributeModifierLine(source, modifier, lastValue, newValue *= 1.0 + modifier.func_111164_d(), trait, preferredUnits);
            }
        }
        return 1;
    }

    static void printAttributeModifierLine(CommandSource source, AttributeModifier modifier, double lastValueStore, double newValueStore, Temperature.Trait trait, Temperature.Units preferredUnits) {
        source.func_197030_a((ITextComponent)new StringTextComponent(CSMath.truncate(lastValueStore, 2) + "").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.WHITE).func_240716_a_(TempCommand.getConvertedUnitHover(trait, lastValueStore, preferredUnits))).func_230529_a_((ITextComponent)new StringTextComponent(" \u2192 ").func_240699_a_(TextFormatting.WHITE)).func_230529_a_((ITextComponent)new StringTextComponent(modifier.func_111166_b()).func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.LIGHT_PURPLE).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent(modifier.func_111167_a().toString()).func_230529_a_((ITextComponent)new StringTextComponent("\n")).func_230529_a_((ITextComponent)new TranslationTextComponent("chat.copy.click").func_240699_a_(TextFormatting.GRAY)))).func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, modifier.func_111167_a().toString())))).func_230529_a_((ITextComponent)new StringTextComponent(" \u2192 ").func_240699_a_(TextFormatting.WHITE)).func_230529_a_((ITextComponent)new StringTextComponent(CSMath.truncate(newValueStore, 2) + "").func_240703_c_(Style.field_240709_b_.func_240712_a_(TextFormatting.AQUA).func_240716_a_(TempCommand.getConvertedUnitHover(trait, newValueStore, preferredUnits)))), false);
    }

    static double getFormattedTraitValue(Temperature.Trait trait, double rawValue, Temperature.Units units) {
        double converted = rawValue;
        if (trait == Temperature.Trait.WORLD || trait == Temperature.Trait.BURNING_POINT || trait == Temperature.Trait.FREEZING_POINT) {
            converted = Temperature.convert(converted, Temperature.Units.MC, units, true);
        }
        return converted;
    }

    static HoverEvent getConvertedUnitHover(Temperature.Trait trait, double value, Temperature.Units units) {
        return new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent(CSMath.truncate(TempCommand.getFormattedTraitValue(trait, value, units), 1) + " " + units.getFormattedName()));
    }

    private int executeModifyEntityTemp(CommandSource source, Collection<? extends Entity> entities, Temperature.Trait attribute, double amount, AttributeModifier.Operation operation, boolean permanent) {
        for (Entity entity : entities) {
            if (EntityTempManager.getEntitiesWithTemperature().contains(entity.func_200600_R()) && entity instanceof LivingEntity) {
                ModifiableAttributeInstance instance = EntityTempManager.getAttribute(attribute, (LivingEntity)entity);
                if (instance == null) continue;
                if (operation != null) {
                    AttributeModifier modifier = EntityTempManager.makeAttributeModifier(attribute, amount, operation);
                    instance.func_233769_c_(modifier);
                } else {
                    EntityTempManager.getAttribute(attribute, (LivingEntity)entity).func_111128_a(amount);
                }
                EntityTempManager.getTemperatureCap(entity).ifPresent(cap -> {
                    if (permanent) {
                        cap.markPersistentAttribute(instance.func_111123_a());
                    } else {
                        cap.clearPersistentAttribute(instance.func_111123_a());
                    }
                });
                continue;
            }
            source.func_197021_a((ITextComponent)new TranslationTextComponent("commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        if (entities.size() == 1) {
            if (operation == null) {
                source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.cold_sweat.temperature.modify.set.single.result", new Object[]{attribute.func_176610_l(), entities.iterator().next().func_200200_C_().getString(), amount}), true);
            } else {
                source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.cold_sweat.temperature.modify.add_modifier.single.result", new Object[]{attribute.func_176610_l(), entities.iterator().next().func_200200_C_().getString()}), true);
            }
        } else if (operation == null) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.cold_sweat.temperature.modify.set.many.result", new Object[]{attribute.func_176610_l(), entities.size(), amount}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.cold_sweat.temperature.modify.add_modifier.many.result", new Object[]{attribute.func_176610_l(), entities.size()}), true);
        }
        return entities.size();
    }

    private int executeClearModifier(CommandSource source, Collection<? extends Entity> entities, Temperature.Trait attribute) {
        for (Entity entity : entities) {
            if (EntityTempManager.getEntitiesWithTemperature().contains(entity.func_200600_R()) && entity instanceof LivingEntity) {
                EntityTempManager.getTemperatureCap(entity).ifPresent(cap -> {
                    ModifiableAttributeInstance instance = EntityTempManager.getAttribute(attribute, (LivingEntity)entity);
                    if (instance == null) {
                        return;
                    }
                    instance.func_225505_c_().forEach(arg_0 -> ((ModifiableAttributeInstance)instance).func_111124_b(arg_0));
                    EntityTempManager.getAttribute(attribute, (LivingEntity)entity).func_111128_a(Double.NaN);
                    cap.clearPersistentAttribute(instance.func_111123_a());
                });
                continue;
            }
            source.func_197021_a((ITextComponent)new TranslationTextComponent("commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        if (entities.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.cold_sweat.temperature.clear.single.result", new Object[]{attribute.func_176610_l(), entities.iterator().next().func_200200_C_().getString()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.cold_sweat.temperature.clear.many.result", new Object[]{attribute.func_176610_l(), entities.size()}), true);
        }
        return entities.size();
    }

    private int executeClearAllModifiers(CommandSource source, Collection<? extends Entity> entities) {
        for (Entity entity : entities) {
            if (EntityTempManager.getEntitiesWithTemperature().contains(entity.func_200600_R()) && entity instanceof LivingEntity) {
                EntityTempManager.getTemperatureCap(entity).ifPresent(cap -> {
                    for (Temperature.Trait attribute : EntityTempManager.VALID_ATTRIBUTE_TRAITS) {
                        ModifiableAttributeInstance instance = EntityTempManager.getAttribute(attribute, (LivingEntity)entity);
                        if (instance == null) continue;
                        instance.func_225505_c_().forEach(arg_0 -> ((ModifiableAttributeInstance)instance).func_111124_b(arg_0));
                        instance.func_111128_a(instance.func_111123_a().func_111110_b());
                        cap.clearPersistentAttribute(instance.func_111123_a());
                    }
                });
                continue;
            }
            source.func_197021_a((ITextComponent)new TranslationTextComponent("commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        if (entities.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.cold_sweat.temperature.clear.all.single.result", new Object[]{entities.iterator().next().func_200200_C_().getString()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.cold_sweat.temperature.clear.all.many.result", new Object[]{entities.size()}), true);
        }
        return entities.size();
    }
}

