/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.entity;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.renderer.animation.AnimationManager;
import com.momosoftworks.coldsweat.common.entity.data.edible.ChameleonEdibles;
import com.momosoftworks.coldsweat.common.entity.data.edible.Edible;
import com.momosoftworks.coldsweat.common.entity.goal.EatObjectsGoal;
import com.momosoftworks.coldsweat.common.entity.goal.LazyLookGoal;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.EntityInit;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.ChameleonEatMessage;
import com.momosoftworks.coldsweat.core.network.message.EntityMountMessage;
import com.momosoftworks.coldsweat.data.loot.ModLootTables;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.registries.ModSounds;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber
public class ChameleonEntity
extends AnimalEntity {
    static Method GET_DATA_ITEM = ObfuscationReflectionHelper.findMethod(EntityDataManager.class, (String)"func_187219_c", (Class[])new Class[]{DataParameter.class});
    static final DataParameter<Boolean> SHEDDING;
    static final DataParameter<Integer> LAST_SHED;
    static final DataParameter<Integer> HURT_TIMESTAMP;
    static final DataParameter<CompoundNBT> TRUSTED_PLAYERS;
    static final DataParameter<BlockPos> TRACKING_POS;
    static final DataParameter<Integer> EAT_TIMESTAMP;
    static final DataParameter<Float> TEMPERATURE;
    static final DataParameter<CompoundNBT> EDIBLE_COOLDOWNS;
    static final DataParameter<Boolean> SEARCHING;
    static final DataParameter<Integer> AGE_SECS;
    public float xRotHead = 0.0f;
    public float yRotHead = 0.0f;
    public float xRotLeftEye = 0.0f;
    public float yRotLeftEye = 0.0f;
    public float xRotRightEye = 0.0f;
    public float yRotRightEye = 0.0f;
    public float xRotTail = 0.0f;
    public float tailPhase = 0.0f;
    float eatAnimationTimer = 0.0f;
    private int feedCooldown = 0;
    public float opacity = 1.0f;
    float desiredTemp = 1.0f;
    boolean mountSneaking = false;
    int mountSneakCount = 0;
    int lastMountSneak = 0;

    public ChameleonEntity(EntityType<ChameleonEntity> type, World world) {
        super(type, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.6));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new EatObjectsGoal(this, Arrays.asList(EntityType.field_200740_af)));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199804_a((IItemProvider[])((IItemProvider[])ChameleonEdibles.EDIBLES.stream().map(edible -> edible.associatedItems().func_230236_b_()).flatMap(Collection::stream).map(item -> () -> item).toArray(IItemProvider[]::new))), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (Goal)new LazyLookGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return TameableEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.16).func_233815_a_(Attributes.field_233824_g_, 0.0).func_233815_a_(Attributes.field_233823_f_, 4.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHEDDING, (Object)false);
        this.field_70180_af.func_187214_a(LAST_SHED, (Object)0);
        this.field_70180_af.func_187214_a(HURT_TIMESTAMP, (Object)0);
        this.field_70180_af.func_187214_a(TRUSTED_PLAYERS, (Object)new CompoundNBT());
        this.field_70180_af.func_187214_a(TRACKING_POS, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(EAT_TIMESTAMP, (Object)0);
        this.field_70180_af.func_187214_a(TEMPERATURE, (Object)Float.valueOf((float)CSMath.average(ConfigSettings.MIN_TEMP.get(), ConfigSettings.MAX_TEMP.get())));
        this.field_70180_af.func_187214_a(EDIBLE_COOLDOWNS, (Object)new CompoundNBT());
        this.field_70180_af.func_187214_a(SEARCHING, (Object)false);
        this.field_70180_af.func_187214_a(AGE_SECS, (Object)0);
    }

    public boolean func_180431_b(DamageSource source) {
        if (this.func_184187_bx() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)this.func_184187_bx();
            if (source.equals(DamageSource.field_76368_d) || source.equals(DamageSource.field_76379_h)) {
                return true;
            }
            return player.func_184812_l_() || player.func_180431_b(source);
        }
        return super.func_180431_b(source);
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        if (this.field_70729_aU) {
            this.func_110142_aN().func_94547_a(source, this.func_110143_aJ(), 1.0f);
            ITextComponent deathMessage = this.func_110142_aN().func_151521_b();
            ListNBT trustedPlayers = this.getTrustedPlayers().func_150295_c("Players", 8);
            if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223609_l)) {
                trustedPlayers.forEach(string -> {
                    PlayerEntity player = this.field_70170_p.func_217371_b(UUID.fromString(string.func_150285_a_()));
                    if (player != null) {
                        player.func_145747_a(deathMessage, Util.field_240973_b_);
                    }
                });
            }
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Edible edible = ChameleonEdibles.getEdible(stack).orElse(null);
        if (edible != null) {
            if (this.feedCooldown <= 0 && this.isPlayerTrusted(player) ^ this.isTamingItem(stack) && this.getCooldown(edible) <= 0 || this.func_204701_dC() && this.func_70877_b(stack)) {
                if (!player.field_70170_p.field_72995_K) {
                    ItemStack dropStack = stack.func_77946_l();
                    dropStack.func_190920_e(1);
                    ItemEntity dropped = player.func_71019_a(dropStack, true);
                    if (dropped != null) {
                        dropped.getPersistentData().func_186854_a("Recipient", this.func_110124_au());
                    }
                    player.func_184602_cy();
                    this.func_175505_a(player, stack);
                }
                this.feedCooldown = 10;
                return ActionResultType.SUCCESS;
            }
            player.func_184609_a(hand);
            return ActionResultType.CONSUME;
        }
        if (this.isPlayerTrusted(player) && player.func_184188_bt().isEmpty() && !this.field_70170_p.field_72995_K) {
            if (this.func_184220_m((Entity)player) && player instanceof ServerPlayerEntity) {
                ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new EntityMountMessage(this.func_145782_y(), player.func_145782_y(), EntityMountMessage.Action.MOUNT));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean func_70877_b(ItemStack pStack) {
        return ModItemTags.CHAMELEON_TAMING.func_230235_a_((Object)pStack.func_77973_b());
    }

    public boolean func_204701_dC() {
        return super.func_204701_dC() && !this.func_70631_g_() && !this.func_70880_s() && !this.getPersistentData().func_74767_n("HasBred");
    }

    protected void func_175500_n() {
        super.func_175500_n();
        if (!this.func_70631_g_()) {
            this.shedItems();
        }
    }

    private void shedItems() {
        for (ItemStack stack : ModLootTables.getEntityDropsLootTable((Entity)this, null, ModLootTables.CHAMELEON_SHEDDING)) {
            WorldHelper.entityDropItem((Entity)this, stack, 40000);
        }
        WorldHelper.playEntitySound(ModSounds.CHAMELEON_SHED, (Entity)this, this.func_184176_by(), 1.0f, this.func_70647_i());
    }

    protected float func_213348_b(Pose pPose, EntitySize pDimensions) {
        return this.func_70631_g_() ? 0.25f : 0.3f;
    }

    @SubscribeEvent
    public static void setHeight(EntityEvent.Size event) {
        ChameleonEntity chameleon;
        if (event.getEntity().isAddedToWorld() && event.getEntity() instanceof ChameleonEntity && (chameleon = (ChameleonEntity)event.getEntity()).func_70631_g_()) {
            event.setNewSize(EntitySize.func_220311_c((float)0.65f, (float)0.5f));
        }
    }

    @SubscribeEvent
    public static void onHitFromOwner(LivingHurtEvent event) {
        ChameleonEntity chameleon;
        if (event.getEntity() instanceof ChameleonEntity && (chameleon = (ChameleonEntity)event.getEntity()).func_184187_bx() != null && chameleon.func_184187_bx() == event.getSource().func_76346_g()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void cancelProjectileHit(ProjectileImpactEvent event) {
        if (!(event.getRayTraceResult() instanceof EntityRayTraceResult)) {
            return;
        }
        EntityRayTraceResult hitResult = (EntityRayTraceResult)event.getRayTraceResult();
        if (hitResult.func_216348_a() instanceof ChameleonEntity && hitResult.func_216348_a().func_184187_bx() instanceof PlayerEntity) {
            ChameleonEntity chameleon = (ChameleonEntity)hitResult.func_216348_a();
            event.setCanceled(true);
            chameleon.setHurtTimestamp(chameleon.field_70173_aa - 20);
        }
    }

    public int getTimeToShed() {
        return 600;
    }

    public int getEatAnimLength() {
        return 6;
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity parent) {
        return (AgeableEntity)((EntityType)EntityInit.CHAMELEON.get()).func_200721_a((World)world);
    }

    public void func_234177_a_(ServerWorld level, AnimalEntity mate) {
        super.func_234177_a_(level, mate);
        this.getPersistentData().func_74757_a("HasBred", true);
        mate.getPersistentData().func_74757_a("HasBred", true);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return ModSounds.CHAMELEON_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.CHAMELEON_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.CHAMELEON_DEATH;
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (!this.field_70170_p.field_72995_K && soundevent != null && !this.isSearching()) {
            WorldHelper.playEntitySound(soundevent, (Entity)this, this.func_184176_by(), this.func_70599_aP(), this.func_70647_i());
        }
    }

    protected void func_184581_c(DamageSource damageSource) {
        SoundEvent soundevent = this.func_184601_bQ(damageSource);
        if (soundevent != null) {
            WorldHelper.playEntitySound(soundevent, (Entity)this, this.func_184176_by(), this.func_70599_aP(), this.func_70647_i());
        }
    }

    public boolean isWalking() {
        return new Vector3d((double)((float)this.func_213322_ci().field_72450_a), 0.0, (double)((float)this.func_213322_ci().field_72449_c)).func_72433_c() > 0.005;
    }

    public int func_213396_dB() {
        return 20;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.eatAnimationTimer > 0.0f) {
            this.eatAnimationTimer -= 1.0f;
        }
        if (this.feedCooldown > 0) {
            --this.feedCooldown;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 0) {
            this.setAgeSecs(this.getAgeSecs() + 1);
        }
        if (!this.field_70170_p.field_72995_K) {
            boolean shedding = this.isShedding();
            int shedCheckInterval = ConfigSettings.SHED_TIMINGS.get().interval();
            int shedCooldown = ConfigSettings.SHED_TIMINGS.get().cooldown();
            double shedChance = ConfigSettings.SHED_TIMINGS.get().chance();
            if (this.field_70173_aa % shedCheckInterval == 0 && !shedding && this.field_70146_Z.nextDouble() < shedChance && this.getAgeSecs() * 20 - this.getLastShed() > shedCooldown) {
                this.setShedding(true);
                this.setLastShed(this.getAgeSecs() * 20);
            }
            if (shedding && this.getAgeSecs() * 20 - this.getLastShed() > this.getTimeToShed()) {
                this.shedItems();
                this.setLastShed(this.getAgeSecs() * 20);
                this.setShedding(false);
            }
        }
        if (this.func_184187_bx() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)this.func_184187_bx();
            float playerHeadYaw = player.field_70759_as;
            this.field_70759_as = CSMath.clamp(this.field_70759_as, playerHeadYaw - 50.0f, playerHeadYaw + 50.0f);
            this.field_70761_aq = playerHeadYaw;
        }
        if (this.field_70173_aa % 20 == 0 || this.field_70173_aa == 1) {
            this.desiredTemp = (float)CSMath.clamp(Temperature.get((LivingEntity)this, Temperature.Trait.WORLD), ConfigSettings.MIN_TEMP.get(), ConfigSettings.MAX_TEMP.get());
        }
        this.setTemperature(this.getTemperature() + (this.desiredTemp - this.getTemperature()) * 0.03f);
        if (this.func_184187_bx() instanceof PlayerEntity && !this.field_70170_p.field_72995_K) {
            PlayerEntity player = (PlayerEntity)this.func_184187_bx();
            if (player.func_213453_ef()) {
                if (!this.mountSneaking) {
                    this.mountSneakCount = player.field_70173_aa - this.lastMountSneak < 8 || this.mountSneakCount == 0 ? ++this.mountSneakCount : 0;
                    this.lastMountSneak = player.field_70173_aa;
                    this.mountSneaking = true;
                    if (this.mountSneakCount >= 2) {
                        this.func_184210_p();
                        if (player instanceof ServerPlayerEntity) {
                            ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new EntityMountMessage(this.func_145782_y(), player.func_145782_y(), EntityMountMessage.Action.DISMOUNT));
                        }
                        this.field_184245_j = 10;
                        this.mountSneakCount = 0;
                    }
                }
            } else {
                this.mountSneaking = false;
            }
        }
        if (this.field_70173_aa % 5 == 0 && this.isTracking()) {
            if (this.field_70146_Z.nextDouble() < 0.3) {
                WorldHelper.spawnParticle(this.field_70170_p, (IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + Math.random() - 0.5, this.func_226278_cu_() + Math.random() - 0.5 + (double)(this.func_213302_cg() / 2.0f), this.func_226281_cx_() + Math.random() - 0.5, 0.01, 0.01, 0.01);
            }
            if (this.field_70173_aa % 20 == 0) {
                if ((long)this.getAgeSecs() * 20L - this.getEatTimestamp() > 6000L) {
                    this.clearTrackingPos();
                }
                if ((Math.sqrt(Math.pow(this.func_226277_ct_() - (double)this.getTrackingPos().func_177958_n(), 2.0) + Math.pow(this.func_226281_cx_() - (double)this.getTrackingPos().func_177952_p(), 2.0)) < 20.0 || this.getTrackingPos().equals((Object)BlockPos.field_177992_a)) && this.func_184102_h() != null) {
                    Advancement advancement = this.func_184102_h().func_191949_aK().func_192778_a(new ResourceLocation("cold_sweat", "chameleon_find_biome"));
                    for (ServerPlayerEntity player : this.field_70170_p.func_217357_a(ServerPlayerEntity.class, this.func_174813_aQ().func_186662_g(20.0))) {
                        if (advancement == null || player.func_192039_O().func_192747_a(advancement).func_192105_a()) continue;
                        player.func_192039_O().func_192750_a(advancement, "requirement");
                    }
                    this.clearTrackingPos();
                }
            }
        }
        if (this.func_70880_s() && this.field_70146_Z.nextDouble() < 0.8 && this.field_70173_aa % 8 == 0) {
            WorldHelper.spawnParticleBatch(this.field_70170_p, (IParticleData)ParticleTypes.field_197633_z, this.func_226277_ct_(), this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f), this.func_226281_cx_(), (double)this.func_213311_cf() / 1.5, (double)this.func_213302_cg() / 1.5, (double)this.func_213311_cf() / 1.5, 1.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K) {
            CompoundNBT cooldowns = this.getCooldowns();
            for (String tag : cooldowns.func_150296_c()) {
                int time = cooldowns.func_74762_e(tag);
                if (time <= 0) continue;
                cooldowns.func_74768_a(tag, time - 1);
            }
            this.field_70180_af.func_187227_b(EDIBLE_COOLDOWNS, (Object)cooldowns);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() != null && !this.func_180431_b(source)) {
            this.setHurtTimestamp(this.field_70173_aa);
        }
        return super.func_70097_a(source, amount);
    }

    public Entity changeDimension(ServerWorld world, ITeleporter teleporter) {
        this.clearTrackingPos();
        return super.changeDimension(world, teleporter);
    }

    public void onEatEntity(Entity entity) {
        if (!this.field_70170_p.field_72995_K) {
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                ItemStack item = itemEntity.func_92059_d();
                if (this.isTamingItem(item)) {
                    PlayerEntity player;
                    PlayerEntity playerEntity = player = itemEntity.func_200214_m() != null ? this.field_70170_p.func_217371_b(itemEntity.func_200214_m()) : null;
                    if (player != null) {
                        if (!this.isPlayerTrusted(player)) {
                            if (player.func_184812_l_() || Math.random() < 0.3) {
                                this.func_110163_bv();
                                this.addTrustedPlayer(itemEntity.func_200214_m());
                                WorldHelper.spawnParticleBatch(this.field_70170_p, (IParticleData)ParticleTypes.field_197633_z, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), 1.0, 1.0, 1.0, 6.0, 0.01);
                            } else {
                                WorldHelper.spawnParticleBatch(this.field_70170_p, (IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), 1.0, 1.0, 1.0, 6.0, 0.01);
                            }
                        } else if (this.func_204701_dC()) {
                            this.func_146082_f(player);
                        }
                    }
                }
                ChameleonEdibles.getEdible(item).ifPresent(edible -> {
                    if (edible.onEaten(this, itemEntity) == Edible.Result.SUCCESS) {
                        this.setCooldown((Edible)edible, edible.getCooldown());
                    } else {
                        this.setCooldown((Edible)edible, edible.getCooldown() / 4);
                    }
                });
            }
            this.setEatTimestamp(this.getAgeSecs() * 20);
        }
    }

    public double func_70033_W() {
        return this.func_184187_bx() instanceof PlayerEntity ? (((PlayerEntity)this.func_184187_bx()).func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == ModItems.HOGLIN_HEADPIECE ? 0.65 : 0.5) : 0.0;
    }

    public int func_184649_cE() {
        return 60;
    }

    public void eatAnimation() {
        if (this.eatAnimationTimer <= 0.0f) {
            if (!this.field_70170_p.field_72995_K) {
                ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ChameleonEatMessage(this.func_145782_y()));
            } else {
                AnimationManager.ANIMATION_TIMERS.put((Entity)this, Float.valueOf(0.0f));
            }
            this.eatAnimationTimer = this.getEatAnimLength();
        }
    }

    public void manualSync(DataParameter<?> param) {
        try {
            ((EntityDataManager.DataEntry)GET_DATA_ITEM.invoke((Object)this.field_70180_af, param)).func_187208_a(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public float getEatTimer() {
        return this.eatAnimationTimer;
    }

    public boolean isShedding() {
        return (Boolean)this.field_70180_af.func_187225_a(SHEDDING);
    }

    public void setShedding(boolean shedding) {
        this.field_70180_af.func_187227_b(SHEDDING, (Object)shedding);
    }

    public CompoundNBT getTrustedPlayers() {
        return (CompoundNBT)this.field_70180_af.func_187225_a(TRUSTED_PLAYERS);
    }

    public void addTrustedPlayer(UUID player) {
        StringNBT uuid;
        CompoundNBT trustedPlayers = this.getTrustedPlayers();
        ListNBT players = trustedPlayers.func_150295_c("Players", 8);
        if (!players.contains((Object)(uuid = StringNBT.func_229705_a_((String)player.toString())))) {
            players.add((Object)uuid);
        }
        trustedPlayers.func_218657_a("Players", (INBT)players);
        this.field_70180_af.func_187227_b(TRUSTED_PLAYERS, (Object)trustedPlayers);
        this.manualSync(TRUSTED_PLAYERS);
    }

    public void removeTrustedPlayer(UUID player) {
        CompoundNBT trustedPlayers = this.getTrustedPlayers();
        trustedPlayers.func_150295_c("Players", 8).removeIf(tag -> tag.func_150285_a_().equals(player.toString()));
        this.field_70180_af.func_187227_b(TRUSTED_PLAYERS, (Object)trustedPlayers);
    }

    public boolean isPlayerTrusted(PlayerEntity player) {
        return this.isPlayerTrusted(player.func_110124_au());
    }

    public boolean isPlayerTrusted(UUID player) {
        return this.getTrustedPlayers().func_150295_c("Players", 8).contains((Object)StringNBT.func_229705_a_((String)player.toString()));
    }

    public int getLastShed() {
        return (Integer)this.field_70180_af.func_187225_a(LAST_SHED);
    }

    public void setLastShed(int lastShed) {
        this.field_70180_af.func_187227_b(LAST_SHED, (Object)lastShed);
    }

    public float getTemperature() {
        return ((Float)this.field_70180_af.func_187225_a(TEMPERATURE)).floatValue();
    }

    public void setTemperature(float temperature) {
        this.field_70180_af.func_187227_b(TEMPERATURE, (Object)Float.valueOf(temperature));
    }

    public void setSearching(boolean searching) {
        this.field_70180_af.func_187227_b(SEARCHING, (Object)searching);
    }

    public boolean isSearching() {
        return (Boolean)this.field_70180_af.func_187225_a(SEARCHING);
    }

    public int getHurtTimestamp() {
        return (Integer)this.field_70180_af.func_187225_a(HURT_TIMESTAMP);
    }

    public void setHurtTimestamp(int hurtTimestamp) {
        this.field_70180_af.func_187227_b(HURT_TIMESTAMP, (Object)hurtTimestamp);
    }

    public void setTrackingPos(BlockPos pos) {
        this.field_70180_af.func_187227_b(TRACKING_POS, (Object)pos);
    }

    public void clearTrackingPos() {
        this.field_70180_af.func_187227_b(TRACKING_POS, (Object)BlockPos.field_177992_a);
    }

    public BlockPos getTrackingPos() {
        return (BlockPos)this.field_70180_af.func_187225_a(TRACKING_POS);
    }

    public boolean isTracking() {
        return !((BlockPos)this.field_70180_af.func_187225_a(TRACKING_POS)).equals((Object)BlockPos.field_177992_a);
    }

    public long getEatTimestamp() {
        return ((Integer)this.field_70180_af.func_187225_a(EAT_TIMESTAMP)).intValue();
    }

    public void setEatTimestamp(int eatTimestamp) {
        this.field_70180_af.func_187227_b(EAT_TIMESTAMP, (Object)eatTimestamp);
    }

    public void setCooldown(Edible edible, Integer time) {
        CompoundNBT map = (CompoundNBT)this.field_70180_af.func_187225_a(EDIBLE_COOLDOWNS);
        map.func_74768_a(edible.getName(), time.intValue());
        this.field_70180_af.func_187227_b(EDIBLE_COOLDOWNS, (Object)map);
    }

    public Integer getCooldown(Edible edible) {
        return ((CompoundNBT)this.field_70180_af.func_187225_a(EDIBLE_COOLDOWNS)).func_74762_e(edible.getName());
    }

    public CompoundNBT getCooldowns() {
        return (CompoundNBT)this.field_70180_af.func_187225_a(EDIBLE_COOLDOWNS);
    }

    public int getAgeSecs() {
        return (Integer)this.field_70180_af.func_187225_a(AGE_SECS);
    }

    public void setAgeSecs(int ageSecs) {
        this.field_70180_af.func_187227_b(AGE_SECS, (Object)ageSecs);
    }

    public boolean isTamingItem(ItemStack item) {
        return ModItemTags.CHAMELEON_TAMING.func_230235_a_((Object)item.func_77973_b());
    }

    public CompoundNBT func_189511_e(CompoundNBT tag) {
        super.func_189511_e(tag);
        tag.func_218657_a("TrustedPlayers", (INBT)this.getTrustedPlayers().func_150295_c("Players", 8));
        tag.func_74768_a("LastShed", this.getLastShed());
        tag.func_74757_a("Shedding", this.isShedding());
        tag.func_74768_a("HurtTimestamp", this.getHurtTimestamp());
        tag.func_74768_a("AgeInSeconds", this.getAgeSecs());
        tag.func_74772_a("EatTimestamp", this.getEatTimestamp());
        if (this.isTracking()) {
            tag.func_74772_a("TrackingPos", this.getTrackingPos().func_218275_a());
        } else {
            tag.func_82580_o("TrackingPos");
        }
        ListNBT edibleCooldowns = new ListNBT();
        for (String key : this.getCooldowns().func_150296_c()) {
            CompoundNBT cooldownTag = new CompoundNBT();
            cooldownTag.func_74778_a("Edible", key);
            cooldownTag.func_74768_a("Cooldown", this.getCooldowns().func_74762_e(key));
            edibleCooldowns.add((Object)cooldownTag);
        }
        tag.func_218657_a("EdibleCooldowns", (INBT)edibleCooldowns);
        tag.func_74776_a("Temperature", this.getTemperature());
        return tag;
    }

    public void func_70020_e(CompoundNBT nbt) {
        super.func_70020_e(nbt);
        CompoundNBT players = new CompoundNBT();
        players.func_218657_a("Players", (INBT)nbt.func_150295_c("TrustedPlayers", 8));
        this.field_70180_af.func_187227_b(TRUSTED_PLAYERS, (Object)players);
        this.setLastShed(nbt.func_74762_e("LastShed"));
        this.setShedding(nbt.func_74767_n("Shedding"));
        this.setHurtTimestamp(nbt.func_74762_e("HurtTimestamp"));
        this.setAgeSecs(nbt.func_74762_e("AgeInSeconds"));
        this.setEatTimestamp(nbt.func_74762_e("EatTimestamp"));
        if (nbt.func_74764_b("TrackingPos")) {
            this.setTrackingPos(BlockPos.func_218283_e((long)nbt.func_74763_f("TrackingPos")));
        }
        ListNBT edibleCooldowns = nbt.func_150295_c("EdibleCooldowns", 10);
        for (int i = 0; i < edibleCooldowns.size(); ++i) {
            CompoundNBT cooldownTag = edibleCooldowns.func_150305_b(i);
            ChameleonEdibles.EDIBLES.stream().filter(ed -> ed.getName().equals(cooldownTag.func_74779_i("Item"))).findFirst().ifPresent(edible -> this.setCooldown((Edible)edible, cooldownTag.func_74762_e("Cooldown")));
        }
        this.setTemperature(nbt.func_74760_g("Temperature"));
        this.desiredTemp = this.getTemperature();
    }

    static {
        GET_DATA_ITEM.setAccessible(true);
        SHEDDING = EntityDataManager.func_187226_a(ChameleonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
        LAST_SHED = EntityDataManager.func_187226_a(ChameleonEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
        HURT_TIMESTAMP = EntityDataManager.func_187226_a(ChameleonEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
        TRUSTED_PLAYERS = EntityDataManager.func_187226_a(ChameleonEntity.class, (IDataSerializer)DataSerializers.field_192734_n);
        TRACKING_POS = EntityDataManager.func_187226_a(ChameleonEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
        EAT_TIMESTAMP = EntityDataManager.func_187226_a(ChameleonEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
        TEMPERATURE = EntityDataManager.func_187226_a(ChameleonEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
        EDIBLE_COOLDOWNS = EntityDataManager.func_187226_a(ChameleonEntity.class, (IDataSerializer)DataSerializers.field_192734_n);
        SEARCHING = EntityDataManager.func_187226_a(ChameleonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
        AGE_SECS = EntityDataManager.func_187226_a(ChameleonEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    }
}

