/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.entity.goal;

import com.momosoftworks.coldsweat.common.entity.ChameleonEntity;
import com.momosoftworks.coldsweat.common.entity.data.edible.ChameleonEdibles;
import com.momosoftworks.coldsweat.common.entity.data.edible.Edible;
import com.momosoftworks.coldsweat.common.entity.goal.LazyLookGoal;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.util.registries.ModSounds;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;

public class EatObjectsGoal
extends Goal {
    List<EntityType<?>> wantedEntities;
    ChameleonEntity entity;
    Entity target;
    boolean stoppedTasks;
    Vector3d lookPos = null;

    public EatObjectsGoal(ChameleonEntity chameleon, List<EntityType<?>> wantedEntities) {
        this.wantedEntities = wantedEntities;
        this.entity = chameleon;
    }

    public boolean func_75253_b() {
        return this.target != null && this.target.func_70089_S() || this.entity.getEatTimer() > 0.0f;
    }

    public boolean func_220685_C_() {
        return false;
    }

    public void func_75249_e() {
        List items = this.entity.field_70170_p.func_72839_b((Entity)this.entity, new AxisAlignedBB(this.entity.func_233580_cy_()).func_186662_g(5.0));
        for (Entity ent : items) {
            if (ent instanceof ItemEntity && ((ItemEntity)ent).func_200214_m() != null && (this.entity.isPlayerTrusted(((ItemEntity)ent).func_200214_m()) || this.entity.isTamingItem(((ItemEntity)ent).func_92059_d()))) {
                ItemEntity itemEntity = (ItemEntity)ent;
                ItemStack item = itemEntity.func_92059_d();
                Optional<Edible> edible = ChameleonEdibles.getEdible(item);
                if (!edible.isPresent() || itemEntity.getPersistentData().func_74764_b("Recipient") && !itemEntity.getPersistentData().func_186857_a("Recipient").equals(this.entity.func_110124_au()) || (this.entity.getCooldown(edible.get()) > 0 || !edible.get().shouldEat(this.entity, itemEntity)) && !this.isBreedingItem(itemEntity.func_92059_d())) continue;
                this.target = ent;
                this.lookPos = ent.func_213303_ch();
                break;
            }
            if (!this.wantedEntities.contains(ent.func_200600_R())) continue;
            this.target = ent;
            this.lookPos = ent.func_213303_ch();
            break;
        }
    }

    public void func_75251_c() {
        this.stoppedTasks = false;
        this.target = null;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void func_75246_d() {
        if ((this.target == null || !this.target.func_70089_S()) && this.entity.getEatTimer() <= 0.0f) {
            this.func_75251_c();
            return;
        }
        this.lookPos = this.target.func_213303_ch().func_178787_e(this.target.func_213322_ci());
        this.entity.func_70671_ap().func_220674_a(this.lookPos);
        if (this.entity.getEatTimer() <= 0.0f) {
            PathNavigator navigator = this.entity.func_70661_as();
            Path path = navigator.func_75494_a(this.target, 0);
            if (path != null) {
                navigator.func_75484_a(path, 1.5);
            }
            if (Math.sqrt(this.entity.func_70068_e(this.target)) < 1.5 && Math.abs(this.entity.func_226278_cu_() - this.target.func_226278_cu_()) < 1.0 && this.target.func_70089_S()) {
                navigator.func_75499_g();
                this.entity.func_70671_ap().func_220674_a(this.lookPos);
                this.entity.eatAnimation();
                WorldHelper.playEntitySound(ModSounds.CHAMELEON_TONGUE_OUT, (Entity)this.entity, this.entity.func_184176_by(), 1.0f, (float)Math.random() * 0.2f + 0.9f);
                TaskScheduler.scheduleServer(() -> {
                    if (this.target != null && this.target.func_70089_S()) {
                        this.entity.onEatEntity(this.target);
                        this.target.func_70106_y();
                        if (this.target instanceof ItemEntity) {
                            ItemEntity item = (ItemEntity)this.target;
                            this.entity.func_233630_a_(item);
                            UUID thrower = item.func_200214_m();
                            if (thrower != null && item.func_92059_d().func_190916_E() > 0) {
                                ItemStack stack = item.func_92059_d().func_77946_l();
                                stack.func_190918_g(1);
                                if (!stack.func_190926_b()) {
                                    ItemEntity remainingStack = WorldHelper.entityDropItem((Entity)this.entity, stack);
                                    remainingStack.func_200216_c(thrower);
                                    remainingStack.getPersistentData().func_186854_a("Recipient", this.entity.func_110124_au());
                                }
                            }
                        }
                        WorldHelper.playEntitySound(ModSounds.CHAMELEON_TONGUE_IN, (Entity)this.entity, this.entity.func_184176_by(), 1.0f, (float)Math.random() * 0.2f + 0.9f);
                    }
                }, this.entity.getEatAnimLength() / 2 + 2);
                TaskScheduler.scheduleServer(() -> this.target.func_213317_d(this.entity.func_213303_ch().func_178788_d(this.target.func_213303_ch()).func_72432_b().func_186678_a(0.75)), this.entity.getEatAnimLength() / 2);
            }
            this.entity.field_70714_bg.func_220888_c().forEach(goal -> {
                Goal g = goal.func_220772_j();
                if (g instanceof TemptGoal || g instanceof LookAtGoal || g instanceof LookRandomlyGoal || g instanceof LazyLookGoal) {
                    this.stoppedTasks = true;
                    goal.func_75251_c();
                }
            });
        }
    }

    public boolean func_75250_a() {
        return this.entity.func_70643_av() == null;
    }

    private boolean isBreedingItem(ItemStack stack) {
        return this.entity.func_204701_dC() && this.entity.func_70877_b(stack);
    }
}

