/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModAttributes;
import com.momosoftworks.coldsweat.util.registries.ModEffects;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TempEffectsCommon {
    @SubscribeEvent
    public static void onPlayerMine(PlayerEvent.BreakSpeed event) {
        PlayerEntity player = event.getPlayer();
        if (EntityTempManager.isPeacefulMode((LivingEntity)player)) {
            return;
        }
        float miningSpeed = 1.0f - ConfigSettings.COLD_MINING_IMPAIRMENT.get().floatValue();
        if (miningSpeed == 1.0f || player.func_70644_a(ModEffects.ICE_RESISTANCE) || player.func_70644_a(ModEffects.GRACE)) {
            return;
        }
        float temp = (float)Temperature.get((LivingEntity)player, Temperature.Trait.BODY);
        if (temp < -50.0f) {
            float minMiningSpeed = (float)CSMath.blend((double)miningSpeed, 1.0, Temperature.get((LivingEntity)player, Temperature.Trait.COLD_RESISTANCE), 0.0, 1.0);
            event.setNewSpeed(event.getNewSpeed() * CSMath.blend(minMiningSpeed, 1.0f, temp, -100.0f, -50.0f));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        float temp;
        PlayerEntity player = event.player;
        if (EntityTempManager.isPeacefulMode((LivingEntity)player)) {
            return;
        }
        if (event.phase == TickEvent.Phase.END && (temp = (float)Temperature.get((LivingEntity)player, Temperature.Trait.BODY)) < -50.0f) {
            float minMoveMultiplier;
            double movementReduction = ConfigSettings.COLD_MOVEMENT_SLOWDOWN.get();
            double movementSpeed = 1.0 - movementReduction;
            if (movementSpeed == 1.0 || player.func_70644_a(ModEffects.ICE_RESISTANCE) || player.func_70644_a(ModEffects.GRACE)) {
                return;
            }
            if (!player.func_184613_cA() && (minMoveMultiplier = (float)CSMath.blend(player.func_233570_aj_() ? movementSpeed : movementSpeed * 1.25, 1.0, Temperature.get((LivingEntity)player, Temperature.Trait.COLD_RESISTANCE), 0.0, 1.0)) != 1.0f) {
                float moveSpeed = CSMath.blend(minMoveMultiplier, 1.0f, temp, -100.0f, -50.0f);
                player.func_213317_d(player.func_213322_ci().func_216372_d((double)moveSpeed, 1.0, (double)moveSpeed));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerKnockback(LivingKnockBackEvent event) {
        if (event.getEntityLiving().func_70643_av() instanceof PlayerEntity) {
            float liningProtFactor;
            PlayerEntity player = (PlayerEntity)event.getEntityLiving().func_70643_av();
            if (EntityTempManager.isPeacefulMode((LivingEntity)player)) {
                return;
            }
            double knockbackReduction = ConfigSettings.COLD_KNOCKBACK_REDUCTION.get();
            if (knockbackReduction <= 0.0 || player.func_70644_a(ModEffects.ICE_RESISTANCE) || player.func_70644_a(ModEffects.GRACE)) {
                return;
            }
            float temp = (float)Temperature.get((LivingEntity)player, Temperature.Trait.BODY);
            if (temp < -50.0f && (liningProtFactor = (float)CSMath.blend(1.0 - knockbackReduction, 1.0, Temperature.get((LivingEntity)player, Temperature.Trait.COLD_RESISTANCE), 0.0, 1.0)) != 1.0f) {
                event.setStrength(event.getStrength() * CSMath.blend(liningProtFactor, 1.0f, temp, -100.0f, -50.0f));
            }
        }
    }

    @SubscribeEvent
    public static void onHeal(LivingHealEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            float unfrozenHealth;
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (EntityTempManager.isPeacefulMode((LivingEntity)player)) {
                return;
            }
            double frozenHeartsPercentage = ConfigSettings.HEARTS_FREEZING_PERCENTAGE.get();
            if (frozenHeartsPercentage <= 0.0 || player.func_70644_a(ModEffects.ICE_RESISTANCE) || player.func_70644_a(ModEffects.GRACE)) {
                return;
            }
            float healing = event.getAmount();
            float temp = (float)Temperature.get((LivingEntity)player, Temperature.Trait.BODY);
            if (temp < -50.0f && (unfrozenHealth = (float)CSMath.blend(1.0 - frozenHeartsPercentage, 1.0, Temperature.get((LivingEntity)player, Temperature.Trait.COLD_RESISTANCE), 0.0, 1.0)) != 1.0f) {
                event.setAmount(CSMath.clamp(healing, 0.0f, (float)CSMath.ceil(player.func_110138_aP() * CSMath.blend(unfrozenHealth, 1.0f, temp, -100.0f, -50.0f)) - player.func_110143_aJ()));
            }
        }
    }

    public static int getTempResistance(PlayerEntity player, boolean cold) {
        ModifiableAttributeInstance tempAttribute;
        ModifiableAttributeInstance modifiableAttributeInstance = tempAttribute = cold ? player.func_110148_a(ModAttributes.COLD_RESISTANCE) : player.func_110148_a(ModAttributes.HEAT_RESISTANCE);
        if (tempAttribute == null) {
            return 0;
        }
        return (int)CSMath.blend(0.0, 4.0, tempAttribute.func_111126_e(), 0.0, 1.0);
    }
}

