/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.item;

import com.momosoftworks.coldsweat.api.event.common.ItemSwappedInInventoryEvent;
import com.momosoftworks.coldsweat.api.event.util.ClickAction;
import com.momosoftworks.coldsweat.api.temperature.modifier.SoulLampTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.advancement.trigger.ModAdvancementTriggers;
import com.momosoftworks.coldsweat.core.itemgroup.ColdSweatGroup;
import com.momosoftworks.coldsweat.core.network.message.ParticleBatchMessage;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.registries.ModSounds;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SoulspringLampItem
extends Item {
    public SoulspringLampItem() {
        super(new Item.Properties().func_200916_a((ItemGroup)ColdSweatGroup.COLD_SWEAT).func_200917_a(1).func_234689_a_().func_208103_a(Rarity.UNCOMMON));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_77663_a(ItemStack stack, World level, Entity entity, int itemSlot, boolean isSelected) {
        boolean shouldBeOn;
        LivingEntity living;
        block17: {
            if (!(entity instanceof LivingEntity) || entity.field_70173_aa % 5 != 0) return;
            living = (LivingEntity)entity;
            shouldBeOn = false;
            if (isSelected || living.func_184592_cb() == stack) break block17;
            if (level.field_72995_K) return;
            CompoundNBT itemTag = stack.func_196082_o();
            if (itemTag.func_74762_e("stateChangeTimer") <= 0 && itemTag.func_74767_n("Lit") != shouldBeOn) {
                itemTag.func_74768_a("stateChangeTimer", 2);
                itemTag.func_74757_a("Lit", shouldBeOn);
                if (SoulspringLampItem.getFuel(stack) < 0.5) {
                    SoulspringLampItem.setFuel(stack, 0.0);
                }
                WorldHelper.playEntitySound(shouldBeOn ? ModSounds.NETHER_LAMP_ON : ModSounds.NETHER_LAMP_OFF, (Entity)living, living.func_184176_by(), 1.5f, (float)Math.random() / 5.0f + 0.9f);
                return;
            } else {
                NBTHelper.incrementTag(stack, "stateChangeTimer", -1, tag -> tag > 0);
            }
            return;
        }
        try {
            double max = Temperature.get(living, Temperature.Trait.BURNING_POINT);
            double temp = Temperature.getModifier(living, Temperature.Trait.WORLD, SoulLampTempModifier.class).map(TempModifier::getLastInput).orElseGet(() -> Temperature.get(living, Temperature.Trait.WORLD));
            if (ConfigSettings.LAMP_DIMENSIONS.get(level.func_241828_r()).contains(level.func_230315_m_()) && temp > max && SoulspringLampItem.getFuel(stack) > 0.0) {
                if (!(living instanceof PlayerEntity && ((PlayerEntity)living).func_184812_l_() || living.func_175149_v())) {
                    SoulspringLampItem.addFuel(stack, -0.005 * CSMath.clamp(temp - max, 1.0, 3.0));
                }
                double radius = 5.0;
                AxisAlignedBB bb = new AxisAlignedBB(living.func_226277_ct_() - radius, living.func_226278_cu_() + (double)(living.func_213302_cg() / 2.0f) - radius, living.func_226281_cx_() - radius, living.func_226277_ct_() + radius, living.func_226278_cu_() + (double)(living.func_213302_cg() / 2.0f) + radius, living.func_226281_cx_() + radius);
                if (Math.random() < 0.6) {
                    AxisAlignedBB bb2 = bb.func_186662_g(-3.0);
                    double x = bb2.field_72340_a + (bb2.field_72336_d - bb2.field_72340_a) * Math.random();
                    double y = bb2.field_72338_b + (bb2.field_72337_e - bb2.field_72338_b) * Math.random();
                    double z = bb2.field_72339_c + (bb2.field_72334_f - bb2.field_72339_c) * Math.random();
                    double xSpeed = (Math.random() - 0.5) * 0.02;
                    double zSpeed = (Math.random() - 0.5) * 0.02;
                    new ParticleBatchMessage(0).addParticle((IParticleData)ParticleTypes.field_239811_B_, x, y, z, xSpeed, 0.0, zSpeed).sendEntity((Entity)living);
                }
                for (LivingEntity ent : level.func_217357_a(LivingEntity.class, bb)) {
                    if (!EntityTempManager.isTemperatureEnabled((Entity)ent)) continue;
                    Optional<SoulLampTempModifier> mod = Temperature.getModifier(ent, Temperature.Trait.WORLD, SoulLampTempModifier.class);
                    if (mod.isPresent()) {
                        mod.get().setTicksExisted(0);
                        continue;
                    }
                    Temperature.addOrReplaceModifier(ent, ((TempModifier)new SoulLampTempModifier().expires(5)).tickRate(5), Temperature.Trait.WORLD, Placement.Duplicates.BY_CLASS);
                }
                shouldBeOn = true;
            }
            if (level.field_72995_K) return;
        }
        catch (Throwable throwable) {
            if (level.field_72995_K) throw throwable;
            CompoundNBT itemTag = stack.func_196082_o();
            if (itemTag.func_74762_e("stateChangeTimer") <= 0 && itemTag.func_74767_n("Lit") != shouldBeOn) {
                itemTag.func_74768_a("stateChangeTimer", 2);
                itemTag.func_74757_a("Lit", shouldBeOn);
                if (SoulspringLampItem.getFuel(stack) < 0.5) {
                    SoulspringLampItem.setFuel(stack, 0.0);
                }
                WorldHelper.playEntitySound(shouldBeOn ? ModSounds.NETHER_LAMP_ON : ModSounds.NETHER_LAMP_OFF, (Entity)living, living.func_184176_by(), 1.5f, (float)Math.random() / 5.0f + 0.9f);
                throw throwable;
            } else {
                NBTHelper.incrementTag(stack, "stateChangeTimer", -1, tag -> tag > 0);
            }
            throw throwable;
        }
        CompoundNBT itemTag = stack.func_196082_o();
        if (itemTag.func_74762_e("stateChangeTimer") <= 0 && itemTag.func_74767_n("Lit") != shouldBeOn) {
            itemTag.func_74768_a("stateChangeTimer", 2);
            itemTag.func_74757_a("Lit", shouldBeOn);
            if (SoulspringLampItem.getFuel(stack) < 0.5) {
                SoulspringLampItem.setFuel(stack, 0.0);
            }
            WorldHelper.playEntitySound(shouldBeOn ? ModSounds.NETHER_LAMP_ON : ModSounds.NETHER_LAMP_OFF, (Entity)living, living.func_184176_by(), 1.5f, (float)Math.random() / 5.0f + 0.9f);
            return;
        } else {
            NBTHelper.incrementTag(stack, "stateChangeTimer", -1, tag -> tag > 0);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    private static void setFuel(ItemStack stack, double fuel) {
        stack.func_196082_o().func_74780_a("Fuel", fuel);
    }

    private static void addFuel(ItemStack stack, double amount) {
        SoulspringLampItem.setFuel(stack, Math.min(64.0, SoulspringLampItem.getFuel(stack) + amount));
    }

    private static void addFuel(ItemStack stack, ItemStack fuelStack) {
        SoulspringLampItem.addFuel(stack, SoulspringLampItem.getFuelForStack(fuelStack) * (double)fuelStack.func_190916_E());
    }

    private static double getFuel(ItemStack stack) {
        return stack.func_196082_o().func_74769_h("Fuel");
    }

    public static double getFuelForStack(ItemStack item) {
        return ConfigHelper.findFirstFuelMatching(ConfigSettings.SOULSPRING_LAMP_FUEL, item).map(FuelData::fuel).orElse(0.0).intValue();
    }

    @SubscribeEvent
    public static void onEntityHit(LivingAttackEvent event) {
        if (event.getSource().func_76346_g() instanceof PlayerEntity && !(event.getEntityLiving() instanceof PlayerEntity)) {
            PlayerEntity attacker = (PlayerEntity)event.getSource().func_76346_g();
            ItemStack stack = attacker.func_184614_ca();
            if (!(stack.func_77973_b() instanceof SoulspringLampItem)) {
                return;
            }
            LivingEntity target = event.getEntityLiving();
            if (SoulspringLampItem.getFuel(stack) < 64.0 && target.func_70668_bt() != CreatureAttribute.field_223223_b_ && !target.getPersistentData().func_74767_n("SoulSucked")) {
                target.getPersistentData().func_74757_a("SoulSucked", true);
                SoulspringLampItem.addFuel(stack, (int)Math.min(8.0f, target.func_110138_aP() / 2.0f));
                float extraDamage = Math.max(0.0f, 8.0f - event.getAmount());
                if (extraDamage > 0.0f) {
                    target.func_70097_a((DamageSource)new EntityDamageSource(DamageSource.field_76376_m.field_76373_n, (Entity)attacker), extraDamage);
                }
                if (!target.field_70170_p.field_72995_K) {
                    int particleCount = (int)CSMath.clamp(target.func_213311_cf() * target.func_213311_cf() * target.func_213302_cg() * 3.0f, 5.0f, 50.0f);
                    WorldHelper.spawnParticleBatch(attacker.field_70170_p, (IParticleData)ParticleTypes.field_239812_C_, target.func_226277_ct_(), target.func_226278_cu_() + (double)(target.func_213302_cg() / 2.0f), target.func_226281_cx_(), target.func_213311_cf() / 2.0f, target.func_213302_cg() / 2.0f, target.func_213311_cf() / 2.0f, particleCount, 0.05);
                }
                if (attacker.field_70170_p.field_72995_K) {
                    WorldHelper.playEntitySound(ModSounds.NETHER_LAMP_ON, (Entity)attacker, attacker.func_184176_by(), 1.0f, (float)Math.random() / 5.0f + 1.3f);
                }
            }
        }
    }

    public boolean func_195938_a(BlockState state, World level, BlockPos blockPos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> itemList) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            stack.func_196082_o().func_74757_a("Lit", true);
            stack.func_196082_o().func_74780_a("Fuel", 64.0);
            itemList.add((Object)stack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World level, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        if (advanced.func_194127_a()) {
            tooltip.add((ITextComponent)new StringTextComponent("Fuel: " + (int)stack.func_196082_o().func_74769_h("Fuel") + " / " + 64));
        }
        super.func_77624_a(stack, level, tooltip, advanced);
    }

    @SubscribeEvent
    public static void onItemClickedInGUI(ItemSwappedInInventoryEvent event) {
        ItemStack thisStack = event.getSlotItem();
        if (thisStack.func_77973_b() != ModItems.SOULSPRING_LAMP) {
            return;
        }
        ItemStack fuelStack = event.getHeldItem();
        PlayerEntity player = event.getPlayer();
        ClickAction action = event.getClickAction();
        FuelData fuel = ConfigHelper.findFirstFuelMatching(ConfigSettings.SOULSPRING_LAMP_FUEL, fuelStack).orElse(null);
        if (fuel != null && fuel.test(fuelStack) && SoulspringLampItem.getFuel(thisStack) < 64.0) {
            double currentFuel = SoulspringLampItem.getFuel(thisStack);
            if (action == ClickAction.PRIMARY) {
                SoulspringLampItem.addFuel(thisStack, fuelStack);
                fuelStack.func_190918_g((int)((64.0 - currentFuel) / SoulspringLampItem.getFuelForStack(fuelStack)));
            } else if (action == ClickAction.SECONDARY) {
                ItemStack singleFuelItem = fuelStack.func_77946_l();
                singleFuelItem.func_190920_e(1);
                SoulspringLampItem.addFuel(thisStack, singleFuelItem);
                fuelStack.func_190918_g(1);
            }
            if (player instanceof ServerPlayerEntity) {
                ModAdvancementTriggers.SOUL_LAMP_FUELLED.trigger((ServerPlayerEntity)player, fuelStack, thisStack);
            }
            event.setCanceled(true);
        }
    }
}

