/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.item;

import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.itemgroup.ColdSweatGroup;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.registries.ModSounds;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class WaterskinItem
extends Item {
    public static final int FLUID_VALUE_MB = 250;

    public WaterskinItem() {
        super(new Item.Properties().func_200916_a((ItemGroup)ColdSweatGroup.COLD_SWEAT).func_200917_a(16));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        World level = context.func_195991_k();
        BlockState state = level.func_180495_p(pos);
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            WorldHelper.dropItem(level, pos, WaterskinItem.getFilledItem(context.func_195996_i(), level, pos));
            return super.func_195939_a(context);
        }
        if (player.field_71075_bZ.field_75099_e && state.func_177230_c() == Blocks.field_150383_bp && (Integer)state.func_177229_b((Property)BlockStateProperties.field_208130_ae) > 0) {
            if (!player.func_184812_l_()) {
                int newLevel = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208130_ae) - 1;
                level.func_175656_a(pos, newLevel == 0 ? Blocks.field_150383_bp.func_176223_P() : (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208130_ae, (Comparable)Integer.valueOf(newLevel)));
            }
            WaterskinItem.handleFillWaterskin(player, context.func_195996_i(), context.func_221531_n(), pos);
            WorldHelper.spawnParticleBatch(level, (IParticleData)ParticleTypes.field_218422_X, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.65, (double)pos.func_177952_p() + 0.5, 0.5, 0.5, 0.5, 10.0, 0.0);
            return ActionResultType.SUCCESS;
        }
        TileEntity blockEntity = level.func_175625_s(pos);
        if (blockEntity != null) {
            blockEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, context.func_196000_l()).ifPresent(cap -> {
                for (int i = 0; i < cap.getTanks(); ++i) {
                    FluidStack fluidStack = cap.getFluidInTank(i);
                    if (!fluidStack.getFluid().func_207185_a((ITag)FluidTags.field_206959_a) || fluidStack.getAmount() < 250) continue;
                    FluidStack drainStack = fluidStack.copy();
                    drainStack.setAmount(250);
                    cap.drain(drainStack, IFluidHandler.FluidAction.EXECUTE);
                    WaterskinItem.handleFillWaterskin(player, context.func_195996_i(), context.func_221531_n(), pos);
                    return;
                }
            });
        }
        return super.func_195939_a(context);
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        ActionResult ar = super.func_77659_a(level, player, hand);
        ItemStack itemstack = (ItemStack)ar.func_188398_b();
        BlockRayTraceResult blockhitresult = WaterskinItem.func_219968_a((World)level, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        BlockPos hitPos = blockhitresult.func_216350_a();
        BlockState lookingAt = level.func_180495_p(hitPos);
        if (blockhitresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        if (lookingAt.func_204520_s().func_206889_d() && lookingAt.func_204520_s().func_206886_c().func_207187_a((Fluid)Fluids.field_204546_a)) {
            WaterskinItem.handleFillWaterskin(player, itemstack, hand, hitPos);
            WorldHelper.spawnParticleBatch(level, (IParticleData)ParticleTypes.field_218422_X, (double)hitPos.func_177958_n() + 0.5, hitPos.func_177956_o() + 1, (double)hitPos.func_177952_p() + 0.5, 0.5, 0.5, 0.5, 10.0, 0.0);
        }
        return ar;
    }

    public static ItemStack getFilledItem(ItemStack stack, World level, BlockPos pos) {
        ItemStack filledWaterskin = ModItems.FILLED_WATERSKIN.func_190903_i();
        filledWaterskin.func_77982_d(stack.func_77978_p());
        filledWaterskin.func_196082_o().func_74780_a("Temperature", CSMath.clamp((WorldHelper.getTemperatureAt(level, pos) - CSMath.average(ConfigSettings.MAX_TEMP.get(), ConfigSettings.MIN_TEMP.get())) * 15.0, -50.0, 50.0));
        return filledWaterskin;
    }

    public static void handleFillWaterskin(PlayerEntity player, ItemStack thisStack, Hand usedHand, BlockPos filledAtPos) {
        World level = player.field_70170_p;
        ItemStack filledWaterskin = WaterskinItem.getFilledItem(thisStack, level, filledAtPos);
        if (thisStack.func_190916_E() > 1 || player.field_71075_bZ.field_75098_d) {
            ItemEntity itementity;
            if (!player.func_191521_c(filledWaterskin) && (itementity = player.func_71019_a(filledWaterskin, false)) != null) {
                itementity.func_174868_q();
                itementity.func_200216_c(player.func_110124_au());
            }
            thisStack.func_190918_g(1);
        } else {
            player.func_184611_a(usedHand, filledWaterskin);
        }
        level.func_217384_a(null, (Entity)player, SoundEvents.field_204326_e, SoundCategory.PLAYERS, 1.0f, (float)Math.random() / 5.0f + 0.9f);
        player.func_184609_a(usedHand);
        player.func_184811_cZ().func_185145_a(ModItems.FILLED_WATERSKIN, 10);
        player.func_184811_cZ().func_185145_a(ModItems.WATERSKIN, 10);
        player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)thisStack.func_77973_b()));
        level.func_184133_a(null, filledAtPos, ModSounds.WATERSKIN_FILL, SoundCategory.PLAYERS, 2.0f, (float)Math.random() / 5.0f + 0.9f);
    }

    public boolean func_195938_a(BlockState pState, World pLevel, BlockPos pPos, PlayerEntity pPlayer) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }
}

