/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.compat.kubejs.event;

import com.momosoftworks.coldsweat.api.event.core.init.GatherDefaultTempModifiersEvent;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import dev.latvian.kubejs.entity.LivingEntityEventJS;
import dev.latvian.kubejs.entity.LivingEntityJS;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class DefaultModifiersEventJS
extends LivingEntityEventJS {
    private final GatherDefaultTempModifiersEvent event;

    public DefaultModifiersEventJS(GatherDefaultTempModifiersEvent event) {
        this.event = event;
    }

    public LivingEntityJS getEntity() {
        return new LivingEntityJS(this.worldOf((Entity)this.event.getEntity()), this.event.getEntity());
    }

    public List<TempModifier> getModifiers() {
        return this.event.getModifiers();
    }

    public Temperature.Trait getTrait() {
        return this.event.getTrait();
    }

    public void addModifier(TempModifier modifier) {
        this.event.getModifiers().add(modifier);
    }

    public void addModifiers(TempModifier ... modifiers) {
        this.event.getModifiers().addAll(Arrays.asList(modifiers));
    }

    public void addModifier(TempModifier modifier, String duplicatePolicy, Placement params) {
        Temperature.addModifier(this.event.getModifiers(), modifier, Placement.Duplicates.byName(duplicatePolicy), 1, params);
    }

    public void addModifierById(ResourceLocation id, Consumer<TempModifier> modifierBuilder, String duplicatePolicy, Placement params) {
        TempModifierRegistry.getValue(id).ifPresent(mod -> {
            modifierBuilder.accept((TempModifier)mod);
            this.addModifier((TempModifier)mod, duplicatePolicy, params);
        });
    }

    public void removeModifiers(TempModifier modifier, String matchPolicy) {
        Placement.Duplicates policy = Placement.Duplicates.byName(matchPolicy);
        this.event.getModifiers().removeIf(mod -> Placement.Duplicates.check(policy, mod, modifier));
    }

    public Placement placed(String mode, String order, Predicate<TempModifier> predicate) {
        return Placement.of(Placement.Mode.byName(mode), Placement.Order.byName(order), predicate);
    }
}

