/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config;

import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.event.core.registry.CreateRegistriesEvent;
import com.momosoftworks.coldsweat.api.event.vanilla.ServerConfigsLoadedEvent;
import com.momosoftworks.coldsweat.api.registry.BlockTempRegistry;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTempConfig;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.TempModifierInit;
import com.momosoftworks.coldsweat.data.ModRegistries;
import com.momosoftworks.coldsweat.data.codec.configuration.BiomeTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.BlockTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DepthTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DimensionTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DryingItemData;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.FoodData;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemCarryTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.MountData;
import com.momosoftworks.coldsweat.data.codec.configuration.RemoveRegistryData;
import com.momosoftworks.coldsweat.data.codec.configuration.SpawnBiomeData;
import com.momosoftworks.coldsweat.data.codec.configuration.StructureTempData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.data.tag.ModBlockTags;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.math.RegistryMultiMap;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.resources.IResource;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class ConfigLoadingHandler {
    public static final Multimap<RegistryKey<Registry<? extends ConfigData>>, RemoveRegistryData<?>> REMOVED_REGISTRIES = new RegistryMultiMap();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void loadConfigs(ServerConfigsLoadedEvent event) {
        ConfigSettings.clear();
        BlockTempRegistry.flush();
        DynamicRegistries registryAccess = event.getServer().func_244267_aX();
        RegistryMultiMap registries = new RegistryMultiMap();
        ColdSweat.LOGGER.info("Loading registries from configs...");
        registries.putAll(ConfigLoadingHandler.collectUserRegistries(registryAccess));
        ColdSweat.LOGGER.info("Loading registries from data resources...");
        registries.putAll(ConfigLoadingHandler.collectDataRegistries(registryAccess));
        ConfigLoadingHandler.logAndAddRegistries(registryAccess, registries);
        ColdSweat.LOGGER.info("Loading TOML configs...");
        ConfigSettings.load(registryAccess, false);
        TempModifierInit.buildBlockConfigs();
        ColdSweat.LOGGER.info("Loading BlockTemps...");
        TempModifierInit.buildBlockRegistries();
    }

    public static Multimap<RegistryKey<Registry<? extends ConfigData>>, ? extends ConfigData> collectDataRegistries(DynamicRegistries registryAccess) {
        if (registryAccess == null) {
            ColdSweat.LOGGER.error("Failed to load registries from null DynamicRegistries");
            return new RegistryMultiMap();
        }
        ConfigSettings.THERMAL_SOURCE_SPREAD_WHITELIST.get().addAll(ModBlockTags.HEARTH_SPREAD_WHITELIST.func_230236_b_().stream().peek(holder -> ColdSweat.LOGGER.info("Adding block {} to hearth spread whitelist", holder)).collect(Collectors.toSet()));
        ConfigSettings.THERMAL_SOURCE_SPREAD_BLACKLIST.get().addAll(ModBlockTags.HEARTH_SPREAD_BLACKLIST.func_230236_b_().stream().peek(holder -> ColdSweat.LOGGER.info("Adding block {} to hearth spread blacklist", holder)).collect(Collectors.toSet()));
        ConfigSettings.SLEEP_CHECK_IGNORE_BLOCKS.get().addAll(ModBlockTags.IGNORE_SLEEP_CHECK.func_230236_b_().stream().peek(holder -> ColdSweat.LOGGER.info("Disabling sleeping conditions check for block {}", holder)).collect(Collectors.toSet()));
        ConfigSettings.INSULATION_BLACKLIST.get().addAll(ModItemTags.NOT_INSULATABLE.func_230236_b_().stream().peek(holder -> ColdSweat.LOGGER.info("Adding item {} to insulation blacklist", holder)).collect(Collectors.toSet()));
        RegistryMultiMap registries = new RegistryMultiMap();
        for (ModRegistries.ConfigRegistry<?> registry : ModRegistries.getRegistries().values()) {
            registry.flush();
            try {
                ResourceLocation registryPath = new ResourceLocation("cold_sweat", "config/" + registry.key().func_240901_a_().func_110623_a());
                for (ResourceLocation resourceLocation : ModRegistries.getResourceManager().func_199003_a(registryPath.func_110623_a(), file -> file.endsWith(".json"))) {
                    IResource resource = ModRegistries.getResourceManager().func_199002_a(resourceLocation);
                    try {
                        InputStream inputStream = resource.func_199027_b();
                        Throwable throwable = null;
                        try {
                            registry.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)JSONUtils.func_212743_a((Reader)new InputStreamReader(inputStream))).resultOrPartial(arg_0 -> ((Logger)ColdSweat.LOGGER).error(arg_0)).ifPresent(data -> {
                                registry.register(resourceLocation, data);
                                ((RegistryMultiMap)registries).put(registry.key(), data);
                            });
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (inputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            inputStream.close();
                        }
                    }
                    catch (Exception e) {
                        ColdSweat.LOGGER.error("Failed to load JSON registry: {}", registry.key(), (Object)e);
                    }
                }
            }
            catch (IOException iOException) {
            }
        }
        return registries;
    }

    public static Multimap<RegistryKey<Registry<? extends ConfigData>>, ? extends ConfigData> collectUserRegistries(DynamicRegistries registryAccess) {
        if (registryAccess == null) {
            ColdSweat.LOGGER.error("Failed to load registries from null DynamicRegistries");
            return new RegistryMultiMap();
        }
        RegistryMultiMap registries = new RegistryMultiMap();
        for (Map.Entry<String, ModRegistries.ConfigRegistry<?>> entry : ModRegistries.getRegistries().entrySet()) {
            RegistryKey<Registry<?>> key = entry.getValue().key();
            Codec<?> codec = entry.getValue().codec();
            registries.putAll(key, ConfigLoadingHandler.parseConfigData(key, codec, registryAccess));
        }
        return registries;
    }

    private static void logAndAddRegistries(DynamicRegistries registryAccess, Multimap<RegistryKey<Registry<? extends ConfigData>>, ? extends ConfigData> registries) {
        ConfigLoadingHandler.setDefaultRegistryPriority(registries, registryAccess);
        ConfigLoadingHandler.loadRegistryRemovals(registryAccess);
        for (ConfigData data : registries.values()) {
            data.setType(ConfigData.Type.JSON);
        }
        CreateRegistriesEvent.Pre event = new CreateRegistriesEvent.Pre(registryAccess, registries, REMOVED_REGISTRIES);
        MinecraftForge.EVENT_BUS.post((Event)event);
        ConfigLoadingHandler.removeRegistries(event.getRegistries());
        Collection<InsulatorData> insulators = event.getRegistry(ModRegistries.INSULATOR_DATA);
        ConfigLoadingHandler.addInsulatorConfigs(insulators);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s insulators", insulators.size()), insulators);
        Collection<FuelData> fuels = event.getRegistry(ModRegistries.FUEL_DATA);
        ConfigLoadingHandler.addFuelConfigs(fuels);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s fuels", fuels.size()), fuels);
        Collection<FoodData> foods = event.getRegistry(ModRegistries.FOOD_DATA);
        ConfigLoadingHandler.addFoodConfigs(foods);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s foods", foods.size()), foods);
        Collection<ItemCarryTempData> carryTemps = event.getRegistry(ModRegistries.CARRY_TEMP_DATA);
        ConfigLoadingHandler.addCarryTempConfigs(carryTemps);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s carried item temperatures", carryTemps.size()), carryTemps);
        Collection<DryingItemData> dryingItems = event.getRegistry(ModRegistries.DRYING_ITEM_DATA);
        ConfigLoadingHandler.addDryingItemConfigs(dryingItems);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s drying items", dryingItems.size()), dryingItems);
        Collection<BlockTempData> blockTemps = event.getRegistry(ModRegistries.BLOCK_TEMP_DATA);
        ConfigLoadingHandler.addBlockTempConfigs(blockTemps);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s block temperatures", blockTemps.size()), blockTemps);
        Collection<BiomeTempData> biomeTemps = event.getRegistry(ModRegistries.BIOME_TEMP_DATA);
        ConfigLoadingHandler.addBiomeTempConfigs(biomeTemps, registryAccess);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s biome temperatures", biomeTemps.size()), biomeTemps);
        Collection<DimensionTempData> dimensionTemps = event.getRegistry(ModRegistries.DIMENSION_TEMP_DATA);
        ConfigLoadingHandler.addDimensionTempConfigs(dimensionTemps, registryAccess);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s dimension temperatures", dimensionTemps.size()), dimensionTemps);
        Collection<StructureTempData> structureTemps = event.getRegistry(ModRegistries.STRUCTURE_TEMP_DATA);
        ConfigLoadingHandler.addStructureTempConfigs(structureTemps, registryAccess);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s structure temperatures", structureTemps.size()), structureTemps);
        Collection<DepthTempData> depthTemps = event.getRegistry(ModRegistries.DEPTH_TEMP_DATA);
        ConfigLoadingHandler.addDepthTempConfigs(depthTemps);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s depth temperatures", depthTemps.size()), depthTemps);
        Collection<MountData> mounts = event.getRegistry(ModRegistries.MOUNT_DATA);
        ConfigLoadingHandler.addMountConfigs(mounts);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s insulated mounts", mounts.size()), mounts);
        Collection<SpawnBiomeData> spawnBiomes = event.getRegistry(ModRegistries.ENTITY_SPAWN_BIOME_DATA);
        ConfigLoadingHandler.addSpawnBiomeConfigs(spawnBiomes, registryAccess);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s entity spawn biomes", spawnBiomes.size()), spawnBiomes);
        Collection<EntityTempData> entityTemps = event.getRegistry(ModRegistries.ENTITY_TEMP_DATA);
        ConfigLoadingHandler.addEntityTempConfigs(entityTemps);
        ConfigLoadingHandler.logRegistryLoaded(String.format("Loaded %s entity temperatures", entityTemps.size()), entityTemps);
        CreateRegistriesEvent.Post postEvent = new CreateRegistriesEvent.Post(registryAccess, event.getRegistries());
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
    }

    private static void logRegistryLoaded(String message, Collection<?> registry) {
        message = registry.isEmpty() ? message + "." : message + ":";
        ColdSweat.LOGGER.info(message, (Object)registry.size());
        if (registry.isEmpty()) {
            return;
        }
        for (Object entry : registry) {
            ColdSweat.LOGGER.info("{}", entry);
        }
    }

    private static void setDefaultRegistryPriority(Multimap<RegistryKey<Registry<? extends ConfigData>>, ? extends ConfigData> registries, DynamicRegistries dynamicRegistries) {
        for (RegistryKey key : registries.keySet()) {
            ArrayList<ConfigData> sortedHolders = new ArrayList<ConfigData>(registries.get((Object)key));
            sortedHolders.sort(Comparator.comparing(holder -> RegistryHelper.getKey(holder).func_110623_a().equals("default") ? 1 : 0));
            registries.replaceValues((Object)key, sortedHolders);
        }
    }

    private static void loadRegistryRemovals(DynamicRegistries registryAccess) {
        REMOVED_REGISTRIES.clear();
        Collection<RemoveRegistryData<?>> removals = ModRegistries.REMOVE_REGISTRY_DATA.data().values();
        removals.addAll(ConfigLoadingHandler.parseConfigData(ModRegistries.REMOVE_REGISTRY_DATA.key(), RemoveRegistryData.CODEC, registryAccess));
        removals.forEach(data -> {
            RegistryKey key = data.registry();
            REMOVED_REGISTRIES.put(key, data);
        });
    }

    private static void removeRegistries(Multimap<RegistryKey<Registry<? extends ConfigData>>, ? extends ConfigData> registries) {
        ColdSweat.LOGGER.info("Handling registry removals...");
        for (Map.Entry entry : REMOVED_REGISTRIES.asMap().entrySet()) {
            ConfigLoadingHandler.removeEntries((Collection)entry.getValue(), registries.get(entry.getKey()));
        }
    }

    private static <T extends ConfigData, H extends T> void removeEntries(Collection<RemoveRegistryData<T>> removals, Collection<H> registry) {
        for (RemoveRegistryData<T> data : removals) {
            registry.removeIf(data::matches);
        }
    }

    public static <T extends ConfigData> Collection<T> removeEntries(Collection<T> registries, ModRegistries.ConfigRegistry<T> registry) {
        REMOVED_REGISTRIES.get(registry.key()).forEach(data -> {
            RemoveRegistryData removeData = (RemoveRegistryData)data;
            if (removeData.registry().equals(registry.key())) {
                registries.removeIf(removeData::matches);
            }
        });
        return registries;
    }

    public static <T extends ConfigData> boolean isRemoved(T entry, ModRegistries.ConfigRegistry<T> registry) {
        return REMOVED_REGISTRIES.get(registry.key()).stream().anyMatch(data -> ((RemoveRegistryData)data).matches(entry));
    }

    private static void addInsulatorConfigs(Collection<InsulatorData> insulators) {
        insulators.forEach(insulator -> {
            if (!insulator.areRequiredModsLoaded()) {
                return;
            }
            ArrayList items = new ArrayList(RegistryHelper.mapTaggableList(insulator.item().flatListMap(ItemRequirement::items)));
            if (items.isEmpty()) {
                items.add(null);
            }
            for (Item item : items) {
                switch (insulator.slot()) {
                    case ITEM: {
                        ConfigSettings.INSULATION_ITEMS.get().put((Object)item, insulator);
                        break;
                    }
                    case ARMOR: {
                        ConfigSettings.INSULATING_ARMORS.get().put((Object)item, insulator);
                        break;
                    }
                    case CURIO: {
                        if (!CompatManager.isCuriosLoaded()) break;
                        ConfigSettings.INSULATING_CURIOS.get().put((Object)item, insulator);
                    }
                }
            }
        });
    }

    private static void addFuelConfigs(Collection<FuelData> fuels) {
        fuels.forEach(fuelData -> {
            if (!fuelData.areRequiredModsLoaded()) {
                return;
            }
            ArrayList items = new ArrayList(RegistryHelper.mapTaggableList(fuelData.item().flatListMap(ItemRequirement::items)));
            if (items.isEmpty()) {
                items.add(null);
            }
            for (Item item : items) {
                switch (fuelData.type()) {
                    case BOILER: {
                        ConfigSettings.BOILER_FUEL.get().put((Object)item, fuelData);
                        break;
                    }
                    case ICEBOX: {
                        ConfigSettings.ICEBOX_FUEL.get().put((Object)item, fuelData);
                        break;
                    }
                    case HEARTH: {
                        ConfigSettings.HEARTH_FUEL.get().put((Object)item, fuelData);
                        break;
                    }
                    case SOUL_LAMP: {
                        ConfigSettings.SOULSPRING_LAMP_FUEL.get().put((Object)item, fuelData);
                    }
                }
            }
        });
    }

    private static void addFoodConfigs(Collection<FoodData> foods) {
        foods.forEach(foodData -> {
            if (!foodData.areRequiredModsLoaded()) {
                return;
            }
            ArrayList items = new ArrayList(RegistryHelper.mapTaggableList(foodData.item().flatListMap(ItemRequirement::items)));
            if (items.isEmpty()) {
                items.add(null);
            }
            for (Item item : items) {
                ConfigSettings.FOOD_TEMPERATURES.get().put((Object)item, foodData);
            }
        });
    }

    private static void addCarryTempConfigs(Collection<ItemCarryTempData> carryTemps) {
        carryTemps.forEach(carryTempData -> {
            if (!carryTempData.areRequiredModsLoaded()) {
                return;
            }
            ArrayList items = new ArrayList(RegistryHelper.mapTaggableList(carryTempData.item().flatListMap(ItemRequirement::items)));
            if (items.isEmpty()) {
                items.add(null);
            }
            for (Item item : items) {
                ConfigSettings.CARRIED_ITEM_TEMPERATURES.get().put((Object)item, carryTempData);
            }
        });
    }

    private static void addDryingItemConfigs(Collection<DryingItemData> dryingItems) {
        dryingItems.forEach(dryingItemData -> {
            if (!dryingItemData.areRequiredModsLoaded()) {
                return;
            }
            ArrayList items = new ArrayList(RegistryHelper.mapTaggableList(dryingItemData.item().flatListMap(ItemRequirement::items)));
            if (items.isEmpty()) {
                items.add(null);
            }
            for (Item item : items) {
                ConfigSettings.DRYING_ITEMS.get().put((Object)item, dryingItemData);
            }
        });
    }

    private static void addBlockTempConfigs(Collection<BlockTempData> blockTemps) {
        blockTemps.forEach(blockTempData -> {
            if (!blockTempData.areRequiredModsLoaded()) {
                return;
            }
            BlockTempConfig blockTemp = new BlockTempConfig((BlockTempData)blockTempData, (BlockTempData)blockTempData){
                final double temperature;
                final NegatableList locationRequirement;
                final NegatableList entityRequirement;
                final /* synthetic */ BlockTempData val$blockTempData;
                {
                    this.val$blockTempData = blockTempData;
                    super(data);
                    this.temperature = this.val$blockTempData.getTemperature();
                    this.locationRequirement = this.val$blockTempData.location();
                    this.entityRequirement = this.val$blockTempData.entity();
                }

                @Override
                public double getTemperature(World level, LivingEntity entity, BlockState state, BlockPos pos, double distance) {
                    if (this.locationRequirement.test(req -> req.test(level, pos)) && this.entityRequirement.test(req -> req.test((Entity)entity))) {
                        return this.temperature;
                    }
                    return 0.0;
                }
            };
            BlockTempRegistry.register(blockTemp);
        });
    }

    private static void addBiomeTempConfigs(Collection<BiomeTempData> biomeTemps, DynamicRegistries registryAccess) {
        biomeTemps.forEach(biomeTempData -> {
            if (!biomeTempData.areRequiredModsLoaded()) {
                return;
            }
            for (Biome biome : biomeTempData.biomes().flatten()) {
                if (biomeTempData.isOffset()) {
                    ConfigSettings.BIOME_OFFSETS.get(registryAccess).put(biome, (BiomeTempData)biomeTempData);
                    continue;
                }
                ConfigSettings.BIOME_TEMPS.get(registryAccess).put(biome, (BiomeTempData)biomeTempData);
            }
        });
    }

    private static void addDimensionTempConfigs(Collection<DimensionTempData> dimensionTemps, DynamicRegistries registryAccess) {
        dimensionTemps.forEach(dimensionTempData -> {
            if (!dimensionTempData.areRequiredModsLoaded()) {
                return;
            }
            for (DimensionType dimension : dimensionTempData.dimensions().flatten()) {
                if (dimensionTempData.isOffset()) {
                    ConfigSettings.DIMENSION_OFFSETS.get(registryAccess).put(dimension, (DimensionTempData)dimensionTempData);
                    continue;
                }
                ConfigSettings.DIMENSION_TEMPS.get(registryAccess).put(dimension, (DimensionTempData)dimensionTempData);
            }
        });
    }

    private static void addStructureTempConfigs(Collection<StructureTempData> structureTemps, DynamicRegistries registryAccess) {
        structureTemps.forEach(structureTempData -> {
            if (!structureTempData.areRequiredModsLoaded()) {
                return;
            }
            for (StructureFeature<?, ?> structure : structureTempData.structures().flatten()) {
                if (structureTempData.isOffset()) {
                    ConfigSettings.STRUCTURE_OFFSETS.get(registryAccess).put(structure, (StructureTempData)structureTempData);
                    continue;
                }
                ConfigSettings.STRUCTURE_TEMPS.get(registryAccess).put(structure, (StructureTempData)structureTempData);
            }
        });
    }

    private static void addDepthTempConfigs(Collection<DepthTempData> depthTemps) {
        for (DepthTempData depthData : depthTemps) {
            if (!depthData.areRequiredModsLoaded()) {
                return;
            }
            ConfigSettings.DEPTH_REGIONS.get().add(depthData);
        }
    }

    private static void addMountConfigs(Collection<MountData> mounts) {
        mounts.forEach(mountData -> {
            if (!mountData.areRequiredModsLoaded()) {
                return;
            }
            ArrayList entities = new ArrayList(RegistryHelper.mapTaggableList(mountData.entity().flatListMap(EntityRequirement::entities)));
            if (entities.isEmpty()) {
                entities.add(null);
            }
            for (EntityType entity : entities) {
                ConfigSettings.INSULATED_MOUNTS.get().put((Object)entity, mountData);
            }
        });
    }

    private static void addSpawnBiomeConfigs(Collection<SpawnBiomeData> spawnBiomes, DynamicRegistries registryAccess) {
        spawnBiomes.forEach(spawnBiomeData -> {
            if (!spawnBiomeData.areRequiredModsLoaded()) {
                return;
            }
            for (Biome biome : spawnBiomeData.biomes()) {
                ConfigSettings.ENTITY_SPAWN_BIOMES.get(registryAccess).put((Object)biome, spawnBiomeData);
            }
        });
    }

    private static void addEntityTempConfigs(Collection<EntityTempData> entityTemps) {
        entityTemps.forEach(entityTempData -> {
            if (!entityTempData.areRequiredModsLoaded()) {
                return;
            }
            ArrayList entities = new ArrayList(RegistryHelper.mapTaggableList(entityTempData.entity().flatListMap(EntityRequirement::entities)));
            if (entities.isEmpty()) {
                entities.add(null);
            }
            for (EntityType entity : entities) {
                ConfigSettings.ENTITY_TEMPERATURES.get().put((Object)entity, entityTempData);
            }
        });
    }

    private static <T> List<T> parseConfigData(RegistryKey<Registry<T>> registry, Codec<T> codec, DynamicRegistries registryAccess) {
        ArrayList output = new ArrayList();
        JsonOps registryOps = JsonOps.INSTANCE;
        Path coldSweatDataPath = FMLPaths.CONFIGDIR.get().resolve("coldsweat/data").resolve(registry.func_240901_a_().func_110623_a());
        File jsonDirectory = coldSweatDataPath.toFile();
        if (!jsonDirectory.exists()) {
            return output;
        }
        for (File file : ConfigLoadingHandler.findFilesRecursive(jsonDirectory)) {
            if (!file.getName().endsWith(".json")) continue;
            try {
                FileReader reader = new FileReader(file);
                Throwable throwable = null;
                try {
                    JsonObject json = JSONUtils.func_212743_a((Reader)reader);
                    if (!ConfigLoadingHandler.shouldLoadJSON(registry, file.getPath(), json)) continue;
                    codec.decode((DynamicOps)registryOps, (Object)JSONUtils.func_212743_a((Reader)reader)).resultOrPartial(arg_0 -> ((Logger)ColdSweat.LOGGER).error(arg_0)).map(Pair::getFirst).ifPresent(insulator -> output.add(insulator));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (Exception e) {
                ColdSweat.LOGGER.error("Failed to parse JSON config setting in {}: {}", (Object)registry.func_240901_a_(), (Object)file.getName(), (Object)e);
            }
        }
        return output;
    }

    private static boolean shouldLoadJSON(RegistryKey registryKey, String elementName, JsonObject json) {
        if (json.has("required_mods")) {
            JsonArray requiredMods = json.getAsJsonArray("required_mods");
            for (JsonElement requiredMod : requiredMods) {
                if (CompatManager.modLoaded(requiredMod.getAsString())) continue;
                ColdSweat.LOGGER.warn("Skipping registration of {} {}: missing mod \"{}\"", (Object)registryKey.func_240901_a_(), (Object)elementName, (Object)requiredMod.getAsString());
                return false;
            }
        }
        return true;
    }

    public static List<File> findFilesRecursive(File directory) {
        ArrayList<File> files = new ArrayList<File>();
        File[] filesInDirectory = directory.listFiles();
        if (filesInDirectory == null) {
            return files;
        }
        for (File file : filesInDirectory) {
            if (file.isDirectory()) {
                files.addAll(ConfigLoadingHandler.findFilesRecursive(file));
                continue;
            }
            files.add(file);
        }
        return files;
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static final class ClientConfigs {
        @SubscribeEvent
        public static void loadClientConfigs(FMLLoadCompleteEvent event) {
            ConfigSettings.CLIENT_SETTINGS.forEach((id, holder) -> holder.load(true));
        }
    }
}

