/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Either;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.insulation.slot.ScalingFormula;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigLoadingHandler;
import com.momosoftworks.coldsweat.config.spec.ClientSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.EntitySettingsConfig;
import com.momosoftworks.coldsweat.config.spec.ItemSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.MainSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.WorldSettingsConfig;
import com.momosoftworks.coldsweat.data.ModRegistries;
import com.momosoftworks.coldsweat.data.codec.configuration.BiomeTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DepthTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DimensionTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DryingItemData;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityDropData;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.FoodData;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemCarryTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.MountData;
import com.momosoftworks.coldsweat.data.codec.configuration.SeasonalTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.SpawnBiomeData;
import com.momosoftworks.coldsweat.data.codec.configuration.StructureTempData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.math.RegistryMultiMap;
import com.momosoftworks.coldsweat.util.math.Vec2i;
import com.momosoftworks.coldsweat.util.registries.ModEntities;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.DynamicHolder;
import com.momosoftworks.coldsweat.util.serialization.ListBuilder;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import com.momosoftworks.coldsweat.util.serialization.StringRepresentable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.potion.Effect;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.util.TriConsumer;

public class ConfigSettings {
    public static final BiMap<String, DynamicHolder<?>> CONFIG_SETTINGS = HashBiMap.create();
    public static final BiMap<String, DynamicHolder<?>> CLIENT_SETTINGS = HashBiMap.create();
    public static Difficulty DEFAULT_DIFFICULTY = Difficulty.NORMAL;
    public static final DynamicHolder<Difficulty> DIFFICULTY = ConfigSettings.addSyncedSetting("difficulty", () -> Difficulty.NORMAL, holder -> holder.set(Difficulty.byId((Integer)MainSettingsConfig.DIFFICULTY.get())), encoder -> ConfigHelper.serializeNbtInt(encoder.getId(), "Difficulty"), decoder -> Difficulty.byId(decoder.func_74762_e("Difficulty")), saver -> MainSettingsConfig.DIFFICULTY.set((Object)saver.getId()), DynamicHolder.SyncType.BOTH_WAYS);
    public static final DynamicHolder<Double> MAX_TEMP = ConfigSettings.addSyncedSetting("max_temp", () -> 1.7, holder -> holder.set(MainSettingsConfig.MAX_HABITABLE_TEMPERATURE.get()), encoder -> ConfigHelper.serializeNbtDouble(encoder, "MaxTemp"), decoder -> decoder.func_74769_h("MaxTemp"), saver -> MainSettingsConfig.MAX_HABITABLE_TEMPERATURE.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
    public static final DynamicHolder<Double> MIN_TEMP = ConfigSettings.addSyncedSetting("min_temp", () -> 0.5, holder -> holder.set(MainSettingsConfig.MIN_HABITABLE_TEMPERATURE.get()), encoder -> ConfigHelper.serializeNbtDouble(encoder, "MinTemp"), decoder -> decoder.func_74769_h("MinTemp"), saver -> MainSettingsConfig.MIN_HABITABLE_TEMPERATURE.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
    public static final DynamicHolder<Double> TEMP_RATE = ConfigSettings.addSyncedSetting("temp_rate", () -> 1.0, holder -> holder.set(MainSettingsConfig.TEMP_RATE_MULTIPLIER.get()), encoder -> ConfigHelper.serializeNbtDouble(encoder, "TempRate"), decoder -> decoder.func_74769_h("TempRate"), saver -> MainSettingsConfig.TEMP_RATE_MULTIPLIER.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
    public static final DynamicHolder<Double> TEMP_DAMAGE = ConfigSettings.addSyncedSetting("temp_damage", () -> 2.0, holder -> holder.set(MainSettingsConfig.TEMP_DAMAGE.get()), encoder -> ConfigHelper.serializeNbtDouble(encoder, "TempDamage"), decoder -> decoder.func_74769_h("TempDamage"), saver -> MainSettingsConfig.TEMP_DAMAGE.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
    public static final DynamicHolder<Boolean> FIRE_RESISTANCE_ENABLED = ConfigSettings.addSyncedSetting("fire_resistance_enabled", () -> true, holder -> holder.set(MainSettingsConfig.FIRE_RESISTANCE_BLOCKS_OVERHEATING.get()), encoder -> ConfigHelper.serializeNbtBool(encoder, "FireResistanceEnabled"), decoder -> decoder.func_74767_n("FireResistanceEnabled"), saver -> MainSettingsConfig.FIRE_RESISTANCE_BLOCKS_OVERHEATING.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
    public static final DynamicHolder<Boolean> ICE_RESISTANCE_ENABLED = ConfigSettings.addSyncedSetting("ice_resistance_enabled", () -> true, holder -> holder.set(MainSettingsConfig.ICE_RESISTANCE_BLOCKS_FREEZING.get()), encoder -> ConfigHelper.serializeNbtBool(encoder, "IceResistanceEnabled"), decoder -> decoder.func_74767_n("IceResistanceEnabled"), saver -> MainSettingsConfig.ICE_RESISTANCE_BLOCKS_FREEZING.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
    public static final DynamicHolder<Boolean> USE_PEACEFUL_MODE = ConfigSettings.addSyncedSetting("use_peaceful", () -> true, holder -> holder.set(MainSettingsConfig.NULLIFY_IN_PEACEFUL.get()), encoder -> ConfigHelper.serializeNbtBool(encoder, "UsePeaceful"), decoder -> decoder.func_74767_n("UsePeaceful"), saver -> MainSettingsConfig.NULLIFY_IN_PEACEFUL.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
    public static final DynamicHolder<Boolean> REQUIRE_THERMOMETER = ConfigSettings.addSyncedSetting("require_thermometer", () -> true, holder -> holder.set(MainSettingsConfig.REQUIRE_THERMOMETER.get()), encoder -> ConfigHelper.serializeNbtBool(encoder, "RequireThermometer"), decoder -> decoder.func_74767_n("RequireThermometer"), saver -> MainSettingsConfig.REQUIRE_THERMOMETER.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
    public static final DynamicHolder<Integer> GRACE_LENGTH = ConfigSettings.addSyncedSetting("grace_length", () -> 6000, holder -> holder.set(MainSettingsConfig.GRACE_PERIOD_LENGTH.get()), encoder -> ConfigHelper.serializeNbtInt(encoder, "GraceLength"), decoder -> decoder.func_74762_e("GraceLength"), saver -> MainSettingsConfig.GRACE_PERIOD_LENGTH.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
    public static final DynamicHolder<Boolean> GRACE_ENABLED = ConfigSettings.addSyncedSetting("grace_enabled", () -> true, holder -> holder.set(MainSettingsConfig.ENABLE_GRACE_PERIOD.get()), encoder -> ConfigHelper.serializeNbtBool(encoder, "GraceEnabled"), decoder -> decoder.func_74767_n("GraceEnabled"), saver -> MainSettingsConfig.ENABLE_GRACE_PERIOD.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
    public static final DynamicHolder<Double> HEARTS_FREEZING_PERCENTAGE = ConfigSettings.addSyncedSetting("hearts_freezing_percentage", () -> 0.5, holder -> holder.set(MainSettingsConfig.FREEZING_HEARTS.get()), encoder -> ConfigHelper.serializeNbtDouble(encoder, "HeartsFreezingPercentage"), decoder -> decoder.func_74769_h("HeartsFreezingPercentage"), saver -> MainSettingsConfig.FREEZING_HEARTS.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
    public static final DynamicHolder<Double> COLD_MINING_IMPAIRMENT = ConfigSettings.addSyncedSetting("cold_mining_slowdown", () -> 0.5, holder -> holder.set(MainSettingsConfig.COLD_MINING.get()), encoder -> ConfigHelper.serializeNbtDouble(encoder, "ColdMiningImpairment"), decoder -> decoder.func_74769_h("ColdMiningImpairment"), saver -> MainSettingsConfig.COLD_MINING.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
    public static final DynamicHolder<Double> COLD_MOVEMENT_SLOWDOWN = ConfigSettings.addSyncedSetting("cold_movement_slowdown", () -> 0.5, holder -> holder.set(MainSettingsConfig.COLD_MOVEMENT.get()), encoder -> ConfigHelper.serializeNbtDouble(encoder, "ColdMovementSlowdown"), decoder -> decoder.func_74769_h("ColdMovementSlowdown"), saver -> MainSettingsConfig.COLD_MOVEMENT.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
    public static final DynamicHolder<Double> COLD_KNOCKBACK_REDUCTION = ConfigSettings.addSyncedSetting("cold_knockback_reduction", () -> 0.5, holder -> holder.set(MainSettingsConfig.COLD_KNOCKBACK.get()), encoder -> ConfigHelper.serializeNbtDouble(encoder, "ColdKnockbackReduction"), decoder -> decoder.func_74769_h("ColdKnockbackReduction"), saver -> MainSettingsConfig.COLD_KNOCKBACK.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
    public static final DynamicHolder<Double> HEATSTROKE_FOG_DISTANCE = ConfigSettings.addSyncedSetting("heatstroke_fog_distance", () -> 6.0, holder -> holder.set(MainSettingsConfig.HEATSTROKE_FOG.get()), encoder -> ConfigHelper.serializeNbtDouble(encoder, "HeatstrokeFogDistance"), decoder -> decoder.func_74769_h("HeatstrokeFogDistance"), saver -> MainSettingsConfig.HEATSTROKE_FOG.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
    public static final DynamicHolder<Map<Biome, BiomeTempData>> BIOME_TEMPS = ConfigSettings.addSyncedSettingWithRegistries("biome_temps", FastMap::new, (holder, registryAccess) -> {
        Map dataMap = ConfigHelper.getRegistryMap((List)WorldSettingsConfig.BIOME_TEMPERATURES.get(), Registry.field_239720_u_, toml -> BiomeTempData.fromToml(toml, false, registryAccess), data -> data.biomes().flatten());
        ConfigLoadingHandler.removeEntries(dataMap.values(), ModRegistries.BIOME_TEMP_DATA);
        ((Map)holder.get(registryAccess)).putAll(dataMap);
    }, (encoder, registryAccess) -> ConfigHelper.serializeHolderRegistry(encoder, "BiomeTemps", Registry.field_239720_u_, ModRegistries.BIOME_TEMP_DATA, registryAccess), (decoder, registryAccess) -> ConfigHelper.deserializeHolderRegistry(decoder, "BiomeTemps", Registry.field_239720_u_, ModRegistries.BIOME_TEMP_DATA, registryAccess), (saver, registryAccess) -> {}, DynamicHolder.SyncType.ONE_WAY);
    public static final DynamicHolder<Map<Biome, BiomeTempData>> BIOME_OFFSETS = ConfigSettings.addSyncedSettingWithRegistries("biome_offsets", FastMap::new, (holder, registryAccess) -> {
        Map dataMap = ConfigHelper.getRegistryMap((List)WorldSettingsConfig.BIOME_TEMP_OFFSETS.get(), Registry.field_239720_u_, toml -> BiomeTempData.fromToml(toml, true, registryAccess), data -> data.biomes().flatten());
        ConfigLoadingHandler.removeEntries(dataMap.values(), ModRegistries.BIOME_TEMP_DATA);
        ((Map)holder.get(registryAccess)).putAll(dataMap);
    }, (encoder, registryAccess) -> ConfigHelper.serializeHolderRegistry(encoder, "BiomeOffsets", Registry.field_239720_u_, ModRegistries.BIOME_TEMP_DATA, registryAccess), (decoder, registryAccess) -> ConfigHelper.deserializeHolderRegistry(decoder, "BiomeOffsets", Registry.field_239720_u_, ModRegistries.BIOME_TEMP_DATA, registryAccess), (saver, registryAccess) -> {}, DynamicHolder.SyncType.ONE_WAY);
    public static final DynamicHolder<Map<DimensionType, DimensionTempData>> DIMENSION_TEMPS = ConfigSettings.addSyncedSettingWithRegistries("dimension_temps", FastMap::new, (holder, registryAccess) -> {
        Map dataMap = ConfigHelper.getRegistryMap((List)WorldSettingsConfig.DIMENSION_TEMPERATURES.get(), Registry.field_239698_ad_, toml -> DimensionTempData.fromToml(toml, false, registryAccess), data -> data.dimensions().flatten());
        ConfigLoadingHandler.removeEntries(dataMap.values(), ModRegistries.DIMENSION_TEMP_DATA);
        ((Map)holder.get(registryAccess)).putAll(dataMap);
    }, (encoder, registryAccess) -> ConfigHelper.serializeHolderRegistry(encoder, "DimensionTemps", Registry.field_239698_ad_, ModRegistries.DIMENSION_TEMP_DATA, registryAccess), (decoder, registryAccess) -> ConfigHelper.deserializeHolderRegistry(decoder, "DimensionTemps", Registry.field_239698_ad_, ModRegistries.DIMENSION_TEMP_DATA, registryAccess), (saver, registryAccess) -> {}, DynamicHolder.SyncType.ONE_WAY);
    public static final DynamicHolder<Map<DimensionType, DimensionTempData>> DIMENSION_OFFSETS = ConfigSettings.addSyncedSettingWithRegistries("dimension_offsets", FastMap::new, (holder, registryAccess) -> {
        Map dataMap = ConfigHelper.getRegistryMap((List)WorldSettingsConfig.DIMENSION_TEMP_OFFSETS.get(), Registry.field_239698_ad_, toml -> DimensionTempData.fromToml(toml, true, registryAccess), data -> data.dimensions().flatten());
        ConfigLoadingHandler.removeEntries(dataMap.values(), ModRegistries.DIMENSION_TEMP_DATA);
        ((Map)holder.get(registryAccess)).putAll(dataMap);
    }, (encoder, registryAccess) -> ConfigHelper.serializeHolderRegistry(encoder, "DimensionOffsets", Registry.field_239698_ad_, ModRegistries.DIMENSION_TEMP_DATA, registryAccess), (decoder, registryAccess) -> ConfigHelper.deserializeHolderRegistry(decoder, "DimensionOffsets", Registry.field_239698_ad_, ModRegistries.DIMENSION_TEMP_DATA, registryAccess), (saver, registryAccess) -> {}, DynamicHolder.SyncType.ONE_WAY);
    public static final DynamicHolder<Map<StructureFeature<?, ?>, StructureTempData>> STRUCTURE_TEMPS = ConfigSettings.addSettingWithRegistries("structure_temperatures", FastMap::new, (holder, registryAccess) -> {
        Map dataMap = ConfigHelper.getRegistryMap((List)WorldSettingsConfig.STRUCTURE_TEMPERATURES.get(), Registry.field_243553_av, toml -> StructureTempData.fromToml(toml, false, registryAccess), data -> data.structures().flatten());
        ConfigLoadingHandler.removeEntries(dataMap.values(), ModRegistries.STRUCTURE_TEMP_DATA);
        ((Map)holder.get(registryAccess)).putAll(dataMap);
    });
    public static final DynamicHolder<Map<StructureFeature<?, ?>, StructureTempData>> STRUCTURE_OFFSETS = ConfigSettings.addSettingWithRegistries("structure_offsets", FastMap::new, (holder, registryAccess) -> {
        Map dataMap = ConfigHelper.getRegistryMap((List)WorldSettingsConfig.STRUCTURE_TEMP_OFFSETS.get(), Registry.field_243553_av, toml -> StructureTempData.fromToml(toml, true, registryAccess), data -> data.structures().flatten());
        ConfigLoadingHandler.removeEntries(dataMap.values(), ModRegistries.STRUCTURE_TEMP_DATA);
        ((Map)holder.get(registryAccess)).putAll(dataMap);
    });
    public static final DynamicHolder<List<DepthTempData>> DEPTH_REGIONS;
    public static final DynamicHolder<Boolean> CHECK_SLEEP_CONDITIONS;
    public static final DynamicHolder<SeasonalTempData> SUMMER_TEMPS;
    public static final DynamicHolder<SeasonalTempData> AUTUMN_TEMPS;
    public static final DynamicHolder<SeasonalTempData> WINTER_TEMPS;
    public static final DynamicHolder<SeasonalTempData> SPRING_TEMPS;
    public static final DynamicHolder<Double> OVERCAST_TEMP_OFFSET;
    public static final DynamicHolder<Integer> BLOCK_RANGE;
    public static final DynamicHolder<Boolean> COLD_SOUL_FIRE;
    public static final DynamicHolder<List<Block>> THERMAL_SOURCE_SPREAD_WHITELIST;
    public static final DynamicHolder<List<Block>> THERMAL_SOURCE_SPREAD_BLACKLIST;
    public static final DynamicHolder<Double> THERMAL_SOURCE_STRENGTH;
    public static final DynamicHolder<Boolean> SMART_HEARTH;
    public static final DynamicHolder<Integer> HEARTH_MAX_RANGE;
    public static final DynamicHolder<Integer> HEARTH_RANGE;
    public static final DynamicHolder<Integer> HEARTH_MAX_VOLUME;
    public static final DynamicHolder<Integer> HEARTH_WARM_UP_TIME;
    public static final DynamicHolder<Integer> HEARTH_MAX_INSULATION;
    public static final DynamicHolder<Integer> HEARTH_FUEL_INTERVAL;
    public static final DynamicHolder<Boolean> SMART_BOILER;
    public static final DynamicHolder<Integer> BOILER_MAX_RANGE;
    public static final DynamicHolder<Integer> BOILER_RANGE;
    public static final DynamicHolder<Integer> BOILER_MAX_VOLUME;
    public static final DynamicHolder<Integer> BOILER_WARM_UP_TIME;
    public static final DynamicHolder<Integer> BOILER_MAX_INSULATION;
    public static final DynamicHolder<Integer> BOILER_FUEL_INTERVAL;
    public static final DynamicHolder<Boolean> SMART_ICEBOX;
    public static final DynamicHolder<Integer> ICEBOX_MAX_RANGE;
    public static final DynamicHolder<Integer> ICEBOX_RANGE;
    public static final DynamicHolder<Integer> ICEBOX_MAX_VOLUME;
    public static final DynamicHolder<Integer> ICEBOX_WARM_UP_TIME;
    public static final DynamicHolder<Integer> ICEBOX_MAX_INSULATION;
    public static final DynamicHolder<Integer> ICEBOX_FUEL_INTERVAL;
    public static final DynamicHolder<List<Block>> SLEEP_CHECK_IGNORE_BLOCKS;
    public static final DynamicHolder<Boolean> USE_CUSTOM_WATER_FREEZE_BEHAVIOR;
    public static final DynamicHolder<Boolean> USE_CUSTOM_ICE_DROPS;
    public static final DynamicHolder<Multimap<Item, InsulatorData>> INSULATION_ITEMS;
    public static final DynamicHolder<Multimap<Item, InsulatorData>> INSULATING_ARMORS;
    public static final DynamicHolder<Multimap<Item, InsulatorData>> INSULATING_CURIOS;
    public static final DynamicHolder<ScalingFormula> INSULATION_SLOTS;
    public static final DynamicHolder<List<Item>> INSULATION_BLACKLIST;
    public static final DynamicHolder<Multimap<Item, DryingItemData>> DRYING_ITEMS;
    public static final DynamicHolder<Multimap<Item, FoodData>> FOOD_TEMPERATURES;
    public static final DynamicHolder<Multimap<Item, ItemCarryTempData>> CARRIED_ITEM_TEMPERATURES;
    public static final DynamicHolder<Integer> WATERSKIN_STRENGTH;
    public static final DynamicHolder<Double> SOULSPRING_LAMP_STRENGTH;
    public static final DynamicHolder<List<DimensionType>> LAMP_DIMENSIONS;
    public static final DynamicHolder<Multimap<Item, FuelData>> BOILER_FUEL;
    public static final DynamicHolder<Multimap<Item, FuelData>> ICEBOX_FUEL;
    public static final DynamicHolder<Multimap<Item, FuelData>> HEARTH_FUEL;
    public static final DynamicHolder<Multimap<Item, FuelData>> SOULSPRING_LAMP_FUEL;
    public static final DynamicHolder<Boolean> HEARTH_POTIONS_ENABLED;
    public static final DynamicHolder<List<Effect>> HEARTH_POTION_BLACKLIST;
    public static final DynamicHolder<EntityDropData> FUR_TIMINGS;
    public static final DynamicHolder<EntityDropData> SHED_TIMINGS;
    public static final DynamicHolder<Multimap<Biome, SpawnBiomeData>> ENTITY_SPAWN_BIOMES;
    public static final DynamicHolder<Multimap<EntityType<?>, MountData>> INSULATED_MOUNTS;
    public static final DynamicHolder<Multimap<EntityType<?>, EntityTempData>> ENTITY_TEMPERATURES;
    public static final DynamicHolder<Double> INSULATION_STRENGTH;
    public static final DynamicHolder<List<ResourceLocation>> DISABLED_MODIFIERS;
    public static final DynamicHolder<Double> MODIFIER_TICK_RATE;
    public static final DynamicHolder<Double> DRYOFF_SPEED;
    public static final DynamicHolder<Boolean> CELSIUS;
    public static final DynamicHolder<Integer> TEMP_OFFSET;
    public static final DynamicHolder<Double> TEMP_SMOOTHING;
    public static final DynamicHolder<Vec2i> BODY_ICON_POS;
    public static final DynamicHolder<Boolean> BODY_ICON_ENABLED;
    public static final DynamicHolder<Boolean> MOVE_BODY_ICON_WHEN_ADVANCED;
    public static final DynamicHolder<Vec2i> BODY_READOUT_POS;
    public static final DynamicHolder<Boolean> BODY_READOUT_ENABLED;
    public static final DynamicHolder<Vec2i> WORLD_GAUGE_POS;
    public static final DynamicHolder<Boolean> WORLD_GAUGE_ENABLED;
    public static final DynamicHolder<Boolean> CUSTOM_HOTBAR_LAYOUT;
    public static final DynamicHolder<Boolean> ICON_BOBBING;
    public static final DynamicHolder<Boolean> HEARTH_DEBUG;
    public static final DynamicHolder<Boolean> SHOW_CONFIG_BUTTON;
    public static final DynamicHolder<Vec2i> CONFIG_BUTTON_POS;
    public static final DynamicHolder<Boolean> DISTORTION_EFFECTS;
    public static final DynamicHolder<Boolean> HIGH_CONTRAST;
    public static final DynamicHolder<Boolean> SHOW_CREATIVE_WARNING;
    public static final DynamicHolder<Boolean> HIDE_TOOLTIPS;
    public static final DynamicHolder<Boolean> EXPAND_TOOLTIPS;
    public static final DynamicHolder<WaterEffectSetting> WATER_EFFECT_SETTING;
    public static final DynamicHolder<IntegerBounds> WATER_DROPLET_SCALE;

    public static String getKey(DynamicHolder<?> setting) {
        return (String)CONFIG_SETTINGS.inverse().get(setting);
    }

    public static DynamicHolder<?> getSetting(String key) {
        return (DynamicHolder)CONFIG_SETTINGS.get((Object)key);
    }

    public static <T> DynamicHolder<T> addSetting(String id, Supplier<T> defaultVal, Consumer<DynamicHolder<T>> loader) {
        DynamicHolder<T> holder = DynamicHolder.create(defaultVal, loader);
        CONFIG_SETTINGS.put((Object)id, holder);
        return holder;
    }

    public static <T> DynamicHolder<T> addSettingWithRegistries(String id, Supplier<T> defaultVal, DynamicHolder.Loader<T> loader) {
        DynamicHolder<T> holder = DynamicHolder.createWithRegistries(defaultVal, loader);
        CONFIG_SETTINGS.put((Object)id, holder);
        return holder;
    }

    public static <T> DynamicHolder<T> addSyncedSetting(String id, Supplier<T> defaultVal, Consumer<DynamicHolder<T>> loader, Function<T, CompoundNBT> writer, Function<CompoundNBT, T> reader, Consumer<T> saver, DynamicHolder.SyncType syncType) {
        DynamicHolder<T> holder = DynamicHolder.createSynced(defaultVal, loader, writer, reader, saver, syncType);
        CONFIG_SETTINGS.put((Object)id, holder);
        return holder;
    }

    public static <T> DynamicHolder<T> addSyncedSettingWithRegistries(String id, Supplier<T> defaultVal, DynamicHolder.Loader<T> loader, DynamicHolder.Writer<T> writer, DynamicHolder.Reader<T> reader, DynamicHolder.Saver<T> saver, DynamicHolder.SyncType syncType) {
        DynamicHolder<T> holder = DynamicHolder.createSyncedWithRegistries(defaultVal, loader, writer, reader, saver, syncType);
        CONFIG_SETTINGS.put((Object)id, holder);
        return holder;
    }

    public static <T> DynamicHolder<T> addClientSetting(String id, Supplier<T> defaultVal, Consumer<DynamicHolder<T>> loader) {
        if (EffectiveSide.get().isClient()) {
            DynamicHolder<T> holder = DynamicHolder.create(defaultVal, loader);
            CLIENT_SETTINGS.put((Object)id, holder);
            return holder;
        }
        return DynamicHolder.create(() -> null, value -> {});
    }

    public static CompoundNBT encode(DynamicRegistries registryAccess) {
        CompoundNBT map = new CompoundNBT();
        CONFIG_SETTINGS.forEach((key, value) -> {
            if (value.getSyncType().canSend()) {
                CompoundNBT encoded = value.encode(registryAccess);
                map.func_197643_a(encoded);
            }
        });
        return map;
    }

    public static void decode(CompoundNBT tag, DynamicRegistries registryAccess) {
        for (DynamicHolder config : CONFIG_SETTINGS.values()) {
            if (!config.getSyncType().canReceive()) continue;
            config.decode(tag, registryAccess);
        }
    }

    public static void saveValues(DynamicRegistries registryAccess) {
        CONFIG_SETTINGS.values().forEach(value -> {
            if (value.isSynced()) {
                value.save(registryAccess);
            }
        });
    }

    public static void load(DynamicRegistries registryAccess, boolean replace) {
        if (registryAccess != null) {
            CONFIG_SETTINGS.values().forEach(dynamicHolder -> dynamicHolder.load(registryAccess, replace));
        } else {
            ColdSweat.LOGGER.warn("Loading Cold Sweat config settings without registry access. This is normal during startup.");
            CONFIG_SETTINGS.values().forEach(dynamicHolder -> {
                if (!dynamicHolder.requiresRegistries()) {
                    dynamicHolder.load(replace);
                }
            });
        }
    }

    public static void clear() {
        for (Map.Entry entry : CONFIG_SETTINGS.entrySet()) {
            ((DynamicHolder)entry.getValue()).reset();
        }
    }

    private static <K extends IForgeRegistryEntry<K>, V> void putRegistryEntries(Multimap<K, V> map, IForgeRegistry<K> registry, List<Either<ITag<K>, K>> list, V data) {
        RegistryHelper.mapTaggableList(list).forEach(entry -> map.put(entry, data));
    }

    static {
        OVERCAST_TEMP_OFFSET = ConfigSettings.addSetting("overcast_temp_offset", () -> 0.35, holder -> {
            List setting = (List)WorldSettingsConfig.OVERCAST_TEMP_OFFSET.get();
            double temperature = ((Number)setting.get(0)).doubleValue();
            Temperature.Units units = setting.size() > 1 ? Temperature.Units.fromID((String)setting.get(1)) : Temperature.Units.MC;
            holder.set(Temperature.convert(temperature, units, Temperature.Units.MC, false));
        });
        DEPTH_REGIONS = ConfigSettings.addSetting("depth_regions", ArrayList::new, holder -> {});
        TriConsumer fuelAdder = (fuelType, configValue, holder) -> {
            RegistryMultiMap dataMap = new RegistryMultiMap();
            for (List list : (List)configValue.get()) {
                FuelData data = FuelData.fromToml(list, fuelType);
                if (data == null) continue;
                data.setType(ConfigData.Type.TOML);
                ConfigSettings.putRegistryEntries(dataMap, ForgeRegistries.ITEMS, data.item().flatListMap(ItemRequirement::items), data);
            }
            ConfigLoadingHandler.removeEntries(dataMap.values(), ModRegistries.FUEL_DATA);
            ((Multimap)holder.get()).putAll(dataMap);
        };
        BOILER_FUEL = ConfigSettings.addSetting("boiler_fuel_items", RegistryMultiMap::new, holder -> fuelAdder.accept((Object)FuelData.FuelType.BOILER, ItemSettingsConfig.BOILER_FUELS, holder));
        ICEBOX_FUEL = ConfigSettings.addSetting("icebox_fuel_items", RegistryMultiMap::new, holder -> fuelAdder.accept((Object)FuelData.FuelType.ICEBOX, ItemSettingsConfig.ICEBOX_FUELS, holder));
        HEARTH_FUEL = ConfigSettings.addSetting("hearth_fuel_items", RegistryMultiMap::new, holder -> fuelAdder.accept((Object)FuelData.FuelType.HEARTH, ItemSettingsConfig.HEARTH_FUELS, holder));
        SOULSPRING_LAMP_FUEL = ConfigSettings.addSyncedSetting("lamp_fuel_items", RegistryMultiMap::new, holder -> fuelAdder.accept((Object)FuelData.FuelType.SOUL_LAMP, ItemSettingsConfig.SOULSPRING_LAMP_FUELS, holder), encoder -> ConfigHelper.serializeMultimapRegistry(encoder, "LampFuelItems", Registry.field_239714_o_, ModRegistries.FUEL_DATA, arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0)), decoder -> ConfigHelper.deserializeMultimapRegistry(decoder, "LampFuelItems", ModRegistries.FUEL_DATA, arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)), saver -> {}, DynamicHolder.SyncType.ONE_WAY);
        HEARTH_POTIONS_ENABLED = ConfigSettings.addSetting("hearth_potions_enabled", () -> true, holder -> holder.set(ItemSettingsConfig.ALLOW_POTIONS_IN_HEARTH.get()));
        HEARTH_POTION_BLACKLIST = ConfigSettings.addSetting("hearth_potion_blacklist", ArrayList::new, holder -> ((List)holder.get()).addAll(((List)ItemSettingsConfig.HEARTH_POTION_BLACKLIST.get()).stream().map(entry -> (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(entry))).collect(ArrayList::new, List::add, List::addAll)));
        TriConsumer insulatorAdder = (configValue, holder, slot) -> {
            RegistryMultiMap dataMap = new RegistryMultiMap();
            for (List list : (List)configValue.get()) {
                InsulatorData data = InsulatorData.fromToml(list, slot);
                if (data == null) continue;
                data.setType(ConfigData.Type.TOML);
                ConfigSettings.putRegistryEntries(dataMap, ForgeRegistries.ITEMS, data.item().flatListMap(ItemRequirement::items), data);
            }
            ConfigLoadingHandler.removeEntries(dataMap.values(), ModRegistries.INSULATOR_DATA);
            ((Multimap)holder.get()).putAll(dataMap);
        };
        INSULATION_ITEMS = ConfigSettings.addSyncedSetting("insulation_items", RegistryMultiMap::new, holder -> insulatorAdder.accept(ItemSettingsConfig.INSULATION_ITEMS, holder, (Object)Insulation.Slot.ITEM), encoder -> ConfigHelper.serializeMultimapRegistry(encoder, "InsulationItems", Registry.field_239714_o_, ModRegistries.INSULATOR_DATA, arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0)), decoder -> ConfigHelper.deserializeMultimapRegistry(decoder, "InsulationItems", ModRegistries.INSULATOR_DATA, arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)), saver -> {}, DynamicHolder.SyncType.ONE_WAY);
        INSULATING_ARMORS = ConfigSettings.addSyncedSetting("insulating_armors", RegistryMultiMap::new, holder -> insulatorAdder.accept(ItemSettingsConfig.INSULATING_ARMOR, holder, (Object)Insulation.Slot.ARMOR), encoder -> ConfigHelper.serializeMultimapRegistry(encoder, "InsulatingArmors", Registry.field_239714_o_, ModRegistries.INSULATOR_DATA, arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0)), decoder -> ConfigHelper.deserializeMultimapRegistry(decoder, "InsulatingArmors", ModRegistries.INSULATOR_DATA, arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)), saver -> {}, DynamicHolder.SyncType.ONE_WAY);
        INSULATING_CURIOS = ConfigSettings.addSyncedSetting("insulating_curios", RegistryMultiMap::new, holder -> {
            if (CompatManager.isCuriosLoaded()) {
                insulatorAdder.accept(ItemSettingsConfig.INSULATING_CURIOS, holder, (Object)Insulation.Slot.CURIO);
            }
        }, encoder -> ConfigHelper.serializeMultimapRegistry(encoder, "InsulatingCurios", Registry.field_239714_o_, ModRegistries.INSULATOR_DATA, arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0)), decoder -> ConfigHelper.deserializeMultimapRegistry(decoder, "InsulatingCurios", ModRegistries.INSULATOR_DATA, arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)), saver -> {}, DynamicHolder.SyncType.ONE_WAY);
        INSULATION_SLOTS = ConfigSettings.addSyncedSetting("insulation_slots", () -> new ScalingFormula.Static(0, 0, 0, 0), holder -> {
            List<Object> list = (List<Object>)ItemSettingsConfig.INSULATION_SLOTS.get();
            if (list.size() == 4 && list.stream().allMatch(el -> el instanceof Integer)) {
                list = Arrays.asList("static", list.get(0), list.get(1), list.get(2), list.get(3));
            }
            String mode = (String)list.get(0);
            ScalingFormula.Type scalingType = ScalingFormula.Type.byName(mode);
            List values = list.subList(1, list.size()).stream().map(o -> (Number)o).collect(Collectors.toList());
            holder.set(scalingType == ScalingFormula.Type.STATIC ? new ScalingFormula.Static(((Number)values.get(0)).intValue(), ((Number)values.get(1)).intValue(), ((Number)values.get(2)).intValue(), ((Number)values.get(3)).intValue()) : new ScalingFormula.Dynamic(scalingType, ((Number)values.get(0)).doubleValue(), values.size() > 2 ? ((Number)values.get(2)).doubleValue() : Double.POSITIVE_INFINITY));
        }, encoder -> encoder.serialize(), decoder -> ScalingFormula.deserialize(decoder), saver -> {
            ArrayList<String> list = ListBuilder.begin(saver.getType().func_176610_l()).addAll(saver.getValues()).build();
            ItemSettingsConfig.INSULATION_SLOTS.set(list);
        }, DynamicHolder.SyncType.BOTH_WAYS);
        INSULATION_BLACKLIST = ConfigSettings.addSetting("insulation_blacklist", ArrayList::new, holder -> ((List)holder.get()).addAll(((List)ItemSettingsConfig.INSULATION_BLACKLIST.get()).stream().map(entry -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entry))).collect(ArrayList::new, List::add, List::addAll)));
        DRYING_ITEMS = ConfigSettings.addSyncedSetting("drying_items", RegistryMultiMap::new, holder -> {
            RegistryMultiMap dataMap = new RegistryMultiMap();
            for (List entry : (List)ItemSettingsConfig.DRYING_ITEMS.get()) {
                DryingItemData data = DryingItemData.fromToml(entry);
                if (data == null) continue;
                data.setType(ConfigData.Type.TOML);
                ConfigSettings.putRegistryEntries(dataMap, ForgeRegistries.ITEMS, data.item().flatListMap(ItemRequirement::items), data);
            }
            ConfigLoadingHandler.removeEntries(dataMap.values(), ModRegistries.DRYING_ITEM_DATA);
            ((Multimap)holder.get()).putAll(dataMap);
        }, encoder -> ConfigHelper.serializeMultimapRegistry(encoder, "DryingItems", Registry.field_239714_o_, ModRegistries.DRYING_ITEM_DATA, arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0)), decoder -> ConfigHelper.deserializeMultimapRegistry(decoder, "DryingItems", ModRegistries.DRYING_ITEM_DATA, arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)), saver -> {}, DynamicHolder.SyncType.ONE_WAY);
        CHECK_SLEEP_CONDITIONS = ConfigSettings.addSetting("check_sleep_conditions", () -> true, holder -> holder.set(WorldSettingsConfig.SHOULD_CHECK_SLEEP.get()));
        SLEEP_CHECK_IGNORE_BLOCKS = ConfigSettings.addSetting("sleep_check_override_blocks", ArrayList::new, holder -> {
            List blocks = ConfigHelper.getBlocks(((List)WorldSettingsConfig.SLEEPING_OVERRIDE_BLOCKS.get()).toArray(new String[0]));
            ((List)holder.get()).addAll(RegistryHelper.mapTaggableList(blocks));
        });
        USE_CUSTOM_WATER_FREEZE_BEHAVIOR = ConfigSettings.addSetting("custom_freeze_check", () -> true, holder -> holder.set(WorldSettingsConfig.CUSTOM_WATER_FREEZE_BEHAVIOR.get()));
        USE_CUSTOM_ICE_DROPS = ConfigSettings.addSetting("custom_ice_drops", () -> true, holder -> holder.set(WorldSettingsConfig.CUSTOM_ICE_DROPS.get()));
        FOOD_TEMPERATURES = ConfigSettings.addSyncedSetting("food_temperatures", RegistryMultiMap::new, holder -> {
            RegistryMultiMap dataMap = new RegistryMultiMap();
            for (List list : (List)ItemSettingsConfig.FOOD_TEMPERATURES.get()) {
                FoodData data = FoodData.fromToml(list);
                if (data == null) continue;
                ConfigSettings.putRegistryEntries(dataMap, ForgeRegistries.ITEMS, data.item().flatListMap(ItemRequirement::items), data);
            }
            ConfigLoadingHandler.removeEntries(dataMap.values(), ModRegistries.FOOD_DATA);
            ((Multimap)holder.get()).putAll(dataMap);
        }, encoder -> ConfigHelper.serializeMultimapRegistry(encoder, "FoodTemperatures", Registry.field_239714_o_, ModRegistries.FOOD_DATA, arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0)), decoder -> ConfigHelper.deserializeMultimapRegistry(decoder, "FoodTemperatures", ModRegistries.FOOD_DATA, arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)), saver -> {}, DynamicHolder.SyncType.ONE_WAY);
        CARRIED_ITEM_TEMPERATURES = ConfigSettings.addSyncedSetting("carried_item_temps", RegistryMultiMap::new, holder -> {
            RegistryMultiMap dataMap = new RegistryMultiMap();
            for (List list : (List)ItemSettingsConfig.CARRIED_ITEM_TEMPERATURES.get()) {
                ItemCarryTempData data = ItemCarryTempData.fromToml(list);
                if (data == null) continue;
                ConfigSettings.putRegistryEntries(dataMap, ForgeRegistries.ITEMS, data.item().flatListMap(ItemRequirement::items), data);
            }
            ConfigLoadingHandler.removeEntries(dataMap.values(), ModRegistries.CARRY_TEMP_DATA);
            ((Multimap)holder.get()).putAll(dataMap);
        }, encoder -> ConfigHelper.serializeMultimapRegistry(encoder, "CarriedItemTemps", Registry.field_239714_o_, ModRegistries.CARRY_TEMP_DATA, arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0)), decoder -> ConfigHelper.deserializeMultimapRegistry(decoder, "CarriedItemTemps", ModRegistries.CARRY_TEMP_DATA, arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)), saver -> {}, DynamicHolder.SyncType.ONE_WAY);
        WATERSKIN_STRENGTH = ConfigSettings.addSetting("waterskin_strength", () -> 50, holder -> holder.set(ItemSettingsConfig.WATERSKIN_STRENGTH.get()));
        SOULSPRING_LAMP_STRENGTH = ConfigSettings.addSetting("soulspring_lamp_strength", () -> 0.6, holder -> holder.set(ItemSettingsConfig.SOULSPRING_LAMP_STRENGTH.get()));
        LAMP_DIMENSIONS = ConfigSettings.addSettingWithRegistries("valid_lamp_dimensions", ArrayList::new, (holder, registryAccess) -> ((List)holder.get(registryAccess)).addAll(new ArrayList(((List)ItemSettingsConfig.SOULSPRING_LAMP_DIMENSIONS.get()).stream().map(entry -> (DimensionType)registryAccess.func_243612_b(Registry.field_239698_ad_).func_82594_a(new ResourceLocation(entry))).collect(ArrayList::new, List::add, List::addAll))));
        FUR_TIMINGS = ConfigSettings.addSyncedSetting("fur_timings", () -> new EntityDropData(0, 0, 0.0), holder -> {
            List entry = (List)EntitySettingsConfig.GOAT_FUR_GROWTH_STATS.get();
            holder.set(new EntityDropData(((Number)entry.get(0)).intValue(), ((Number)entry.get(1)).intValue(), ((Number)entry.get(2)).doubleValue()));
        }, encoder -> {
            CompoundNBT tag = new CompoundNBT();
            tag.func_218657_a("FurTimings", (INBT)encoder.serialize());
            return tag;
        }, decoder -> EntityDropData.deserialize(decoder.func_74775_l("FurTimings")), saver -> {
            ArrayList<Number> list = new ArrayList<Number>();
            list.add(saver.interval());
            list.add(saver.cooldown());
            list.add(saver.chance());
            EntitySettingsConfig.GOAT_FUR_GROWTH_STATS.set(list);
        }, DynamicHolder.SyncType.BOTH_WAYS);
        SHED_TIMINGS = ConfigSettings.addSyncedSetting("shed_timings", () -> new EntityDropData(0, 0, 0.0), holder -> {
            List entry = (List)EntitySettingsConfig.CHAMELEON_SHED_STATS.get();
            holder.set(new EntityDropData(((Number)entry.get(0)).intValue(), ((Number)entry.get(1)).intValue(), ((Number)entry.get(2)).doubleValue()));
        }, encoder -> {
            CompoundNBT tag = new CompoundNBT();
            tag.func_218657_a("ShedTimings", (INBT)encoder.serialize());
            return tag;
        }, decoder -> EntityDropData.deserialize(decoder.func_74775_l("ShedTimings")), saver -> {
            ArrayList<Number> list = new ArrayList<Number>();
            list.add(saver.interval());
            list.add(saver.cooldown());
            list.add(saver.chance());
            EntitySettingsConfig.CHAMELEON_SHED_STATS.set(list);
        }, DynamicHolder.SyncType.BOTH_WAYS);
        ENTITY_SPAWN_BIOMES = ConfigSettings.addSettingWithRegistries("entity_spawn_biomes", RegistryMultiMap::new, (holder, registryAccess) -> {
            BiConsumer<EntityType, List> configReader = (entityType, configBiomes) -> {
                Multimap dataMap = ConfigHelper.getRegistryMultimap(configBiomes, Registry.field_239720_u_, toml -> SpawnBiomeData.fromToml(toml, entityType, registryAccess), SpawnBiomeData::biomes);
                ConfigLoadingHandler.removeEntries(dataMap.values(), ModRegistries.ENTITY_SPAWN_BIOME_DATA);
                ((Multimap)holder.get(registryAccess)).putAll(dataMap);
            };
            configReader.accept(ModEntities.CHAMELEON, (List)EntitySettingsConfig.CHAMELEON_SPAWN_BIOMES.get());
            configReader.accept(ModEntities.GOAT, (List)EntitySettingsConfig.GOAT_SPAWN_BIOMES.get());
        });
        INSULATED_MOUNTS = ConfigSettings.addSetting("insulated_entities", RegistryMultiMap::new, holder -> {
            RegistryMultiMap dataMap = new RegistryMultiMap();
            for (List list : (List)EntitySettingsConfig.INSULATED_MOUNTS.get()) {
                MountData data = MountData.fromToml(list);
                if (data == null) continue;
                data.setType(ConfigData.Type.TOML);
                ConfigSettings.putRegistryEntries(dataMap, ForgeRegistries.ENTITIES, data.entity().flatListMap(EntityRequirement::entities), data);
            }
            ConfigLoadingHandler.removeEntries(dataMap.values(), ModRegistries.MOUNT_DATA);
            ((Multimap)holder.get()).putAll(dataMap);
        });
        ENTITY_TEMPERATURES = ConfigSettings.addSetting("entity_temperatures", RegistryMultiMap::new, holder -> {
            RegistryMultiMap dataMap = new RegistryMultiMap();
            for (List list : (List)EntitySettingsConfig.ENTITY_TEMPERATURES.get()) {
                EntityTempData data = EntityTempData.fromToml(list);
                if (data == null) continue;
                data.setType(ConfigData.Type.TOML);
                ConfigSettings.putRegistryEntries(dataMap, ForgeRegistries.ENTITIES, data.entity().flatListMap(EntityRequirement::entities), data);
            }
            ConfigLoadingHandler.removeEntries(dataMap.values(), ModRegistries.ENTITY_TEMP_DATA);
            ((Multimap)holder.get()).putAll(dataMap);
        });
        BLOCK_RANGE = ConfigSettings.addSyncedSetting("block_range", () -> 7, holder -> holder.set(WorldSettingsConfig.MAX_BLOCK_TEMP_RANGE.get()), encoder -> ConfigHelper.serializeNbtInt(encoder, "BlockRange"), decoder -> decoder.func_74762_e("BlockRange"), saver -> WorldSettingsConfig.MAX_BLOCK_TEMP_RANGE.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        COLD_SOUL_FIRE = ConfigSettings.addSetting("cold_soul_fire", () -> true, holder -> holder.set(WorldSettingsConfig.IS_SOUL_FIRE_COLD.get()));
        THERMAL_SOURCE_SPREAD_WHITELIST = ConfigSettings.addSyncedSetting("hearth_spread_whitelist", ArrayList::new, holder -> {
            List blocks = ConfigHelper.getBlocks(((List)WorldSettingsConfig.SOURCE_SPREAD_WHITELIST.get()).toArray(new String[0]));
            ((List)holder.get()).addAll(RegistryHelper.mapTaggableList(blocks));
        }, encoder -> {
            CompoundNBT tag = new CompoundNBT();
            ListNBT list = new ListNBT();
            for (Block entry : encoder) {
                list.add((Object)StringNBT.func_229705_a_((String)ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)entry).toString()));
            }
            tag.func_218657_a("HearthWhitelist", (INBT)list);
            return tag;
        }, decoder -> {
            ArrayList<IForgeRegistryEntry> list = new ArrayList<IForgeRegistryEntry>();
            for (INBT entry : decoder.func_150295_c("HearthWhitelist", 8)) {
                list.add(ForgeRegistries.BLOCKS.getValue(new ResourceLocation(entry.func_150285_a_())));
            }
            return list;
        }, saver -> WorldSettingsConfig.SOURCE_SPREAD_WHITELIST.set(saver.stream().map(block -> ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block).toString()).collect(Collectors.toList())), DynamicHolder.SyncType.ONE_WAY);
        THERMAL_SOURCE_SPREAD_BLACKLIST = ConfigSettings.addSyncedSetting("hearth_spread_blacklist", ArrayList::new, holder -> {
            List blocks = ConfigHelper.getBlocks(((List)WorldSettingsConfig.SOURCE_SPREAD_BLACKLIST.get()).toArray(new String[0]));
            ((List)holder.get()).addAll(RegistryHelper.mapTaggableList(blocks));
        }, encoder -> {
            CompoundNBT tag = new CompoundNBT();
            ListNBT list = new ListNBT();
            for (Block entry : encoder) {
                list.add((Object)StringNBT.func_229705_a_((String)ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)entry).toString()));
            }
            tag.func_218657_a("HearthBlacklist", (INBT)list);
            return tag;
        }, decoder -> {
            ArrayList<IForgeRegistryEntry> list = new ArrayList<IForgeRegistryEntry>();
            for (INBT entry : decoder.func_150295_c("HearthBlacklist", 8)) {
                list.add(ForgeRegistries.BLOCKS.getValue(new ResourceLocation(entry.func_150285_a_())));
            }
            return list;
        }, saver -> WorldSettingsConfig.SOURCE_SPREAD_WHITELIST.set(saver.stream().map(block -> ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block).toString()).collect(Collectors.toList())), DynamicHolder.SyncType.ONE_WAY);
        THERMAL_SOURCE_STRENGTH = ConfigSettings.addSetting("hearth_effect", () -> 0.75, holder -> holder.set(WorldSettingsConfig.SOURCE_EFFECT_STRENGTH.get()));
        SMART_HEARTH = ConfigSettings.addSyncedSetting("smart_hearth", () -> false, holder -> holder.set(WorldSettingsConfig.ENABLE_SMART_HEARTH.get()), encoder -> ConfigHelper.serializeNbtBool(encoder, "SmartHearth"), decoder -> decoder.func_74767_n("SmartHearth"), saver -> WorldSettingsConfig.ENABLE_SMART_HEARTH.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        SMART_BOILER = ConfigSettings.addSyncedSetting("smart_boiler", () -> false, holder -> holder.set(WorldSettingsConfig.ENABLE_SMART_BOILER.get()), encoder -> ConfigHelper.serializeNbtBool(encoder, "SmartBoiler"), decoder -> decoder.func_74767_n("SmartBoiler"), saver -> WorldSettingsConfig.ENABLE_SMART_BOILER.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        SMART_ICEBOX = ConfigSettings.addSyncedSetting("smart_icebox", () -> false, holder -> holder.set(WorldSettingsConfig.ENABLE_SMART_ICEBOX.get()), encoder -> ConfigHelper.serializeNbtBool(encoder, "SmartIcebox"), decoder -> decoder.func_74767_n("SmartIcebox"), saver -> WorldSettingsConfig.ENABLE_SMART_ICEBOX.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        HEARTH_MAX_RANGE = ConfigSettings.addSyncedSetting("hearth_max_range", () -> 16, holder -> holder.set(WorldSettingsConfig.HEARTH_MAX_RANGE.get()), encoder -> ConfigHelper.serializeNbtInt(encoder, "HearthMaxRange"), decoder -> decoder.func_74762_e("HearthMaxRange"), saver -> WorldSettingsConfig.HEARTH_MAX_RANGE.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        HEARTH_RANGE = ConfigSettings.addSyncedSetting("hearth_range", () -> 8, holder -> holder.set(WorldSettingsConfig.HEARTH_RANGE.get()), encoder -> ConfigHelper.serializeNbtInt(encoder, "HearthRange"), decoder -> decoder.func_74762_e("HearthRange"), saver -> WorldSettingsConfig.HEARTH_RANGE.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        HEARTH_MAX_VOLUME = ConfigSettings.addSyncedSetting("hearth_max_volume", () -> 1000, holder -> holder.set(WorldSettingsConfig.HEARTH_MAX_VOLUME.get()), encoder -> ConfigHelper.serializeNbtInt(encoder, "HearthMaxVolume"), decoder -> decoder.func_74762_e("HearthMaxVolume"), saver -> WorldSettingsConfig.HEARTH_MAX_VOLUME.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        HEARTH_WARM_UP_TIME = ConfigSettings.addSyncedSetting("hearth_warm_up_time", () -> 20, holder -> holder.set(WorldSettingsConfig.HEARTH_WARM_UP_TIME.get()), encoder -> ConfigHelper.serializeNbtInt(encoder, "HearthWarmUpTime"), decoder -> decoder.func_74762_e("HearthWarmUpTime"), saver -> WorldSettingsConfig.HEARTH_WARM_UP_TIME.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        HEARTH_MAX_INSULATION = ConfigSettings.addSyncedSetting("hearth_max_insulation", () -> 1, holder -> holder.set(WorldSettingsConfig.HEARTH_MAX_INSULATION.get()), encoder -> ConfigHelper.serializeNbtInt(encoder, "HearthMaxInsulation"), decoder -> decoder.func_74762_e("HearthMaxInsulation"), saver -> WorldSettingsConfig.HEARTH_MAX_INSULATION.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        HEARTH_FUEL_INTERVAL = ConfigSettings.addSyncedSetting("hearth_fuel_rate", () -> 1, holder -> holder.set(WorldSettingsConfig.HEARTH_FUEL_INTERVAL.get()), encoder -> ConfigHelper.serializeNbtInt(encoder, "HearthFuelRate"), decoder -> decoder.func_74762_e("HearthFuelRate"), saver -> WorldSettingsConfig.HEARTH_FUEL_INTERVAL.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        BOILER_MAX_RANGE = ConfigSettings.addSyncedSetting("boiler_max_range", () -> 16, holder -> holder.set(WorldSettingsConfig.BOILER_MAX_RANGE.get()), encoder -> ConfigHelper.serializeNbtInt(encoder, "BoilerMaxRange"), decoder -> decoder.func_74762_e("BoilerMaxRange"), saver -> WorldSettingsConfig.BOILER_MAX_RANGE.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        BOILER_RANGE = ConfigSettings.addSyncedSetting("boiler_range", () -> 8, holder -> holder.set(WorldSettingsConfig.BOILER_RANGE.get()), encoder -> ConfigHelper.serializeNbtInt(encoder, "BoilerRange"), decoder -> decoder.func_74762_e("BoilerRange"), saver -> WorldSettingsConfig.BOILER_RANGE.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        BOILER_MAX_VOLUME = ConfigSettings.addSyncedSetting("boiler_max_volume", () -> 1000, holder -> holder.set(WorldSettingsConfig.BOILER_MAX_VOLUME.get()), encoder -> ConfigHelper.serializeNbtInt(encoder, "BoilerMaxVolume"), decoder -> decoder.func_74762_e("BoilerMaxVolume"), saver -> WorldSettingsConfig.BOILER_MAX_VOLUME.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        BOILER_WARM_UP_TIME = ConfigSettings.addSyncedSetting("boiler_warm_up_time", () -> 20, holder -> holder.set(WorldSettingsConfig.BOILER_WARM_UP_TIME.get()), encoder -> ConfigHelper.serializeNbtInt(encoder, "BoilerWarmUpTime"), decoder -> decoder.func_74762_e("BoilerWarmUpTime"), saver -> WorldSettingsConfig.BOILER_WARM_UP_TIME.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        BOILER_MAX_INSULATION = ConfigSettings.addSyncedSetting("boiler_max_insulation", () -> 1, holder -> holder.set(WorldSettingsConfig.BOILER_MAX_INSULATION.get()), encoder -> ConfigHelper.serializeNbtInt(encoder, "BoilerMaxInsulation"), decoder -> decoder.func_74762_e("BoilerMaxInsulation"), saver -> WorldSettingsConfig.BOILER_MAX_INSULATION.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        BOILER_FUEL_INTERVAL = ConfigSettings.addSyncedSetting("boiler_fuel_rate", () -> 1, holder -> holder.set(WorldSettingsConfig.BOILER_FUEL_INTERVAL.get()), encoder -> ConfigHelper.serializeNbtInt(encoder, "BoilerFuelRate"), decoder -> decoder.func_74762_e("BoilerFuelRate"), saver -> WorldSettingsConfig.BOILER_FUEL_INTERVAL.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        ICEBOX_MAX_RANGE = ConfigSettings.addSyncedSetting("icebox_max_range", () -> 16, holder -> holder.set(WorldSettingsConfig.ICEBOX_MAX_RANGE.get()), encoder -> ConfigHelper.serializeNbtInt(encoder, "IceboxMaxRange"), decoder -> decoder.func_74762_e("IceboxMaxRange"), saver -> WorldSettingsConfig.ICEBOX_MAX_RANGE.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        ICEBOX_RANGE = ConfigSettings.addSyncedSetting("icebox_range", () -> 8, holder -> holder.set(WorldSettingsConfig.ICEBOX_RANGE.get()), encoder -> ConfigHelper.serializeNbtInt(encoder, "IceboxRange"), decoder -> decoder.func_74762_e("IceboxRange"), saver -> WorldSettingsConfig.ICEBOX_RANGE.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        ICEBOX_MAX_VOLUME = ConfigSettings.addSyncedSetting("icebox_max_volume", () -> 1000, holder -> holder.set(WorldSettingsConfig.ICEBOX_MAX_VOLUME.get()), encoder -> ConfigHelper.serializeNbtInt(encoder, "IceboxMaxVolume"), decoder -> decoder.func_74762_e("IceboxMaxVolume"), saver -> WorldSettingsConfig.ICEBOX_MAX_VOLUME.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        ICEBOX_WARM_UP_TIME = ConfigSettings.addSyncedSetting("icebox_warm_up_time", () -> 20, holder -> holder.set(WorldSettingsConfig.ICEBOX_WARM_UP_TIME.get()), encoder -> ConfigHelper.serializeNbtInt(encoder, "IceboxWarmUpTime"), decoder -> decoder.func_74762_e("IceboxWarmUpTime"), saver -> WorldSettingsConfig.ICEBOX_WARM_UP_TIME.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        ICEBOX_MAX_INSULATION = ConfigSettings.addSyncedSetting("icebox_max_insulation", () -> 1, holder -> holder.set(WorldSettingsConfig.ICEBOX_MAX_INSULATION.get()), encoder -> ConfigHelper.serializeNbtInt(encoder, "IceboxMaxInsulation"), decoder -> decoder.func_74762_e("IceboxMaxInsulation"), saver -> WorldSettingsConfig.ICEBOX_MAX_INSULATION.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        ICEBOX_FUEL_INTERVAL = ConfigSettings.addSyncedSetting("icebox_fuel_rate", () -> 1, holder -> holder.set(WorldSettingsConfig.ICEBOX_FUEL_INTERVAL.get()), encoder -> ConfigHelper.serializeNbtInt(encoder, "IceboxFuelRate"), decoder -> decoder.func_74762_e("IceboxFuelRate"), saver -> WorldSettingsConfig.ICEBOX_FUEL_INTERVAL.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        INSULATION_STRENGTH = ConfigSettings.addSyncedSetting("insulation_strength", () -> 1.0, holder -> holder.set(ItemSettingsConfig.INSULATION_STRENGTH.get()), encoder -> ConfigHelper.serializeNbtDouble(encoder, "InsulationStrength"), decoder -> decoder.func_74769_h("InsulationStrength"), saver -> ItemSettingsConfig.INSULATION_STRENGTH.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        DISABLED_MODIFIERS = ConfigSettings.addSetting("disabled_modifiers", ArrayList::new, holder -> ((List)holder.get()).addAll(((List)MainSettingsConfig.DISABLED_TEMP_MODIFIERS.get()).stream().map(ResourceLocation::new).collect(Collectors.toList())));
        MODIFIER_TICK_RATE = ConfigSettings.addSyncedSetting("modifier_tick_rate", () -> 1.0, holder -> holder.set(MainSettingsConfig.MODIFIER_TICK_RATE.get()), encoder -> ConfigHelper.serializeNbtDouble(encoder, "ModifierTickRate"), decoder -> decoder.func_74769_h("ModifierTickRate"), saver -> MainSettingsConfig.MODIFIER_TICK_RATE.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        DRYOFF_SPEED = ConfigSettings.addSyncedSetting("dryoff_speed", () -> 1.0, holder -> holder.set(MainSettingsConfig.DRYOFF_SPEED.get()), encoder -> ConfigHelper.serializeNbtDouble(encoder, "DryoffSpeed"), decoder -> decoder.func_74769_h("DryoffSpeed"), saver -> MainSettingsConfig.DRYOFF_SPEED.set(saver), DynamicHolder.SyncType.BOTH_WAYS);
        CELSIUS = ConfigSettings.addClientSetting("celsius", () -> false, holder -> holder.set(ClientSettingsConfig.USE_CELSIUS.get()));
        TEMP_OFFSET = ConfigSettings.addClientSetting("temp_offset", () -> 0, holder -> holder.set(ClientSettingsConfig.TEMPERATURE_OFFSET.get()));
        TEMP_SMOOTHING = ConfigSettings.addClientSetting("temp_smoothing", () -> 10.0, holder -> holder.set(ClientSettingsConfig.TEMPERATURE_SMOOTHING.get()));
        BODY_ICON_POS = ConfigSettings.addClientSetting("body_icon_pos", Vec2i::new, holder -> holder.set(ClientSettingsConfig.getBodyIconPos()));
        BODY_ICON_ENABLED = ConfigSettings.addClientSetting("body_icon_enabled", () -> true, holder -> holder.set(ClientSettingsConfig.SHOW_BODY_TEMP_ICON.get()));
        MOVE_BODY_ICON_WHEN_ADVANCED = ConfigSettings.addClientSetting("move_body_icon_for_advanced", () -> true, holder -> holder.set(ClientSettingsConfig.MOVE_BODY_TEMP_ICON_ADVANCED.get()));
        BODY_READOUT_POS = ConfigSettings.addClientSetting("body_readout_pos", Vec2i::new, holder -> holder.set(ClientSettingsConfig.getBodyReadoutPos()));
        BODY_READOUT_ENABLED = ConfigSettings.addClientSetting("body_readout_enabled", () -> true, holder -> holder.set(ClientSettingsConfig.SHOW_BODY_TEMP_READOUT.get()));
        WORLD_GAUGE_POS = ConfigSettings.addClientSetting("world_gauge_pos", Vec2i::new, holder -> holder.set(ClientSettingsConfig.getWorldGaugePos()));
        WORLD_GAUGE_ENABLED = ConfigSettings.addClientSetting("world_gauge_enabled", () -> true, holder -> holder.set(ClientSettingsConfig.SHOW_WORLD_TEMP_GAUGE.get()));
        CUSTOM_HOTBAR_LAYOUT = ConfigSettings.addClientSetting("custom_hotbar_layout", () -> true, holder -> holder.set(ClientSettingsConfig.USE_CUSTOM_HOTBAR_LAYOUT.get()));
        ICON_BOBBING = ConfigSettings.addClientSetting("icon_bobbing", () -> true, holder -> holder.set(ClientSettingsConfig.ENABLE_ICON_BOBBING.get()));
        HEARTH_DEBUG = ConfigSettings.addClientSetting("hearth_debug", () -> true, holder -> holder.set(ClientSettingsConfig.SHOW_HEARTH_DEBUG_VISUALS.get()));
        SHOW_CONFIG_BUTTON = ConfigSettings.addClientSetting("show_config_button", () -> true, holder -> holder.set(ClientSettingsConfig.SHOW_CONFIG_BUTTON.get()));
        CONFIG_BUTTON_POS = ConfigSettings.addClientSetting("config_button_pos", Vec2i::new, holder -> holder.set(ClientSettingsConfig.getConfigButtonPos()));
        DISTORTION_EFFECTS = ConfigSettings.addClientSetting("distortion_effects", () -> true, holder -> holder.set(ClientSettingsConfig.SHOW_SCREEN_DISTORTIONS.get()));
        HIGH_CONTRAST = ConfigSettings.addClientSetting("high_contrast", () -> false, holder -> holder.set(ClientSettingsConfig.HIGH_CONTRAST_MODE.get()));
        SHOW_CREATIVE_WARNING = ConfigSettings.addClientSetting("show_creative_warning", () -> true, holder -> holder.set(ClientSettingsConfig.ENABLE_CREATIVE_WARNING.get()));
        HIDE_TOOLTIPS = ConfigSettings.addClientSetting("hide_tooltips", () -> false, holder -> holder.set(ClientSettingsConfig.HIDE_INSULATION_TOOLTIPS.get()));
        EXPAND_TOOLTIPS = ConfigSettings.addClientSetting("expand_tooltips", () -> true, holder -> holder.set(ClientSettingsConfig.EXPAND_TOOLTIPS.get()));
        WATER_EFFECT_SETTING = ConfigSettings.addClientSetting("show_water_effect", () -> WaterEffectSetting.ALL, holder -> holder.set(WaterEffectSetting.values()[(Integer)ClientSettingsConfig.WATER_EFFECT_SETTING.get()]));
        WATER_DROPLET_SCALE = ConfigSettings.addClientSetting("water_droplet_scale", () -> new IntegerBounds(40, 48), holder -> holder.set(new IntegerBounds(((List)ClientSettingsConfig.WATER_DROPLET_SCALE.get()).toArray(new Integer[0]))));
        boolean seasonsModLoaded = !CompatManager.getSeasonsMods().isEmpty();
        SUMMER_TEMPS = ConfigSettings.addSetting("summer_temps", SeasonalTempData::new, holder -> holder.set(seasonsModLoaded ? SeasonalTempData.fromToml(WorldSettingsConfig.getSummerTemps()) : new SeasonalTempData()));
        AUTUMN_TEMPS = ConfigSettings.addSetting("autumn_temps", SeasonalTempData::new, holder -> holder.set(seasonsModLoaded ? SeasonalTempData.fromToml(WorldSettingsConfig.getAutumnTemps()) : new SeasonalTempData()));
        WINTER_TEMPS = ConfigSettings.addSetting("winter_temps", SeasonalTempData::new, holder -> holder.set(seasonsModLoaded ? SeasonalTempData.fromToml(WorldSettingsConfig.getWinterTemps()) : new SeasonalTempData()));
        SPRING_TEMPS = ConfigSettings.addSetting("spring_temps", SeasonalTempData::new, holder -> holder.set(seasonsModLoaded ? SeasonalTempData.fromToml(WorldSettingsConfig.getSpringTemps()) : new SeasonalTempData()));
    }

    public static enum WaterEffectSetting implements StringRepresentable
    {
        OFF("options.off", false, false),
        PARTICLES("cold_sweat.config.show_water_effect.particles", true, false),
        SCREEN("cold_sweat.config.show_water_effect.screen", false, true),
        ALL("cold_sweat.config.show_water_effect.all", true, true);

        private final String translationKey;
        private final boolean showParticles;
        private final boolean showGui;

        private WaterEffectSetting(String translationKey, boolean showParticles, boolean showGui) {
            this.translationKey = translationKey;
            this.showParticles = showParticles;
            this.showGui = showGui;
        }

        @Override
        public String func_176610_l() {
            return this.translationKey;
        }

        public boolean showParticles() {
            return this.showParticles;
        }

        public boolean showGui() {
            return this.showGui;
        }
    }

    public static enum Difficulty {
        SUPER_EASY(() -> CSMath.mapOf(ConfigSettings.getKey(MIN_TEMP), () -> Temperature.convert(40.0, Temperature.Units.F, Temperature.Units.MC, true), ConfigSettings.getKey(MAX_TEMP), () -> Temperature.convert(120.0, Temperature.Units.F, Temperature.Units.MC, true), ConfigSettings.getKey(TEMP_RATE), () -> 0.5, ConfigSettings.getKey(REQUIRE_THERMOMETER), () -> false, ConfigSettings.getKey(FIRE_RESISTANCE_ENABLED), () -> true, ConfigSettings.getKey(ICE_RESISTANCE_ENABLED), () -> true)),
        EASY(() -> CSMath.mapOf(ConfigSettings.getKey(MIN_TEMP), () -> Temperature.convert(45.0, Temperature.Units.F, Temperature.Units.MC, true), ConfigSettings.getKey(MAX_TEMP), () -> Temperature.convert(110.0, Temperature.Units.F, Temperature.Units.MC, true), ConfigSettings.getKey(TEMP_RATE), () -> 0.75, ConfigSettings.getKey(REQUIRE_THERMOMETER), () -> false, ConfigSettings.getKey(FIRE_RESISTANCE_ENABLED), () -> true, ConfigSettings.getKey(ICE_RESISTANCE_ENABLED), () -> true)),
        NORMAL(() -> CSMath.mapOf(ConfigSettings.getKey(MIN_TEMP), () -> Temperature.convert(50.0, Temperature.Units.F, Temperature.Units.MC, true), ConfigSettings.getKey(MAX_TEMP), () -> Temperature.convert(100.0, Temperature.Units.F, Temperature.Units.MC, true), ConfigSettings.getKey(TEMP_RATE), () -> 1.0, ConfigSettings.getKey(REQUIRE_THERMOMETER), () -> true, ConfigSettings.getKey(FIRE_RESISTANCE_ENABLED), () -> true, ConfigSettings.getKey(ICE_RESISTANCE_ENABLED), () -> true)),
        HARD(() -> CSMath.mapOf(ConfigSettings.getKey(MIN_TEMP), () -> Temperature.convert(55.0, Temperature.Units.F, Temperature.Units.MC, true), ConfigSettings.getKey(MAX_TEMP), () -> Temperature.convert(90.0, Temperature.Units.F, Temperature.Units.MC, true), ConfigSettings.getKey(TEMP_RATE), () -> 1.25, ConfigSettings.getKey(REQUIRE_THERMOMETER), () -> true, ConfigSettings.getKey(FIRE_RESISTANCE_ENABLED), () -> false, ConfigSettings.getKey(ICE_RESISTANCE_ENABLED), () -> false)),
        CUSTOM(() -> CSMath.mapOf());

        private final Supplier<Map<String, Supplier<?>>> settingsSupplier;
        private Map<String, Supplier<?>> settings;

        private Difficulty(Supplier<Map<String, Supplier<?>>> settings) {
            this.settingsSupplier = settings;
        }

        private void ensureSettingsGenerated() {
            if (this.settings == null) {
                this.settings = this.settingsSupplier.get();
            }
        }

        public <T> T getSetting(String id) {
            this.ensureSettingsGenerated();
            return (T)this.settings.get(id).get();
        }

        public <T> T getSetting(DynamicHolder<T> config) {
            this.ensureSettingsGenerated();
            return (T)this.settings.get(ConfigSettings.getKey(config)).get();
        }

        public <T> T getOrDefault(String id, T defaultValue) {
            this.ensureSettingsGenerated();
            return (T)this.settings.getOrDefault(id, () -> defaultValue).get();
        }

        public <T> T getOrDefault(DynamicHolder<T> config, T defaultValue) {
            this.ensureSettingsGenerated();
            return (T)this.settings.getOrDefault(ConfigSettings.getKey(config), () -> defaultValue).get();
        }

        public void load() {
            this.ensureSettingsGenerated();
            this.settings.forEach((id, loader) -> ConfigSettings.getSetting(id).setUnsafe(loader.get()));
        }

        public int getId() {
            return this.ordinal();
        }

        public static Difficulty byId(int id) {
            return Difficulty.values()[id];
        }

        public static IFormattableTextComponent getFormattedName(Difficulty difficulty) {
            switch (difficulty) {
                case SUPER_EASY: {
                    return new TranslationTextComponent("cold_sweat.config.difficulty.super_easy.name");
                }
                case EASY: {
                    return new TranslationTextComponent("cold_sweat.config.difficulty.easy.name");
                }
                case NORMAL: {
                    return new TranslationTextComponent("cold_sweat.config.difficulty.normal.name");
                }
                case HARD: {
                    return new TranslationTextComponent("cold_sweat.config.difficulty.hard.name");
                }
            }
            return new TranslationTextComponent("cold_sweat.config.difficulty.custom.name");
        }
    }
}

