/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config;

import com.google.common.io.Files;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigLoadingHandler;
import com.momosoftworks.coldsweat.config.spec.ItemSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.MainSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.WorldSettingsConfig;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public class ConfigUpdater {
    public static void updateConfigs() {
        if (!((Boolean)MainSettingsConfig.AUTO_UPDATE.get()).booleanValue()) {
            return;
        }
        String version = ColdSweat.getVersion();
        String configVersion = (String)MainSettingsConfig.VERSION.get();
        if (ConfigUpdater.isBehind(configVersion, "2.3-b05b")) {
            ColdSweat.LOGGER.error("Cancelling config auto-updater. Version {} is older than minimum supported version: 2.3-b05b", (Object)configVersion);
            return;
        }
        if (ConfigUpdater.isBehind(configVersion, "2.3")) {
            ConfigUpdater.replaceConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "minecraft:magma_block", blockTemp -> {
                blockTemp.clear();
                blockTemp.addAll(Arrays.asList("minecraft:magma_block", 0.25, 3, "mc", 1.0));
            });
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.ICEBOX_FUELS, "minecraft:ice", iceFuel -> iceFuel.set(1, 250));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.HEARTH_FUELS, "minecraft:ice", iceFuel -> iceFuel.set(1, -250));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.ICEBOX_FUELS, "minecraft:snow_block", snowFuel -> snowFuel.set(1, 100));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.HEARTH_FUELS, "minecraft:snow_block", snowFuel -> snowFuel.set(1, -100));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.ICEBOX_FUELS, "minecraft:powder_snow_bucket", powderSnowFuel -> powderSnowFuel.set(1, 100));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.HEARTH_FUELS, "minecraft:powder_snow_bucket", powderSnowFuel -> powderSnowFuel.set(1, -100));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.ICEBOX_FUELS, "minecraft:snowball", snowballFuel -> snowballFuel.set(1, 10));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.HEARTH_FUELS, "minecraft:snowball", snowballFuel -> snowballFuel.set(1, -10));
        }
        if (ConfigUpdater.isBehind(configVersion, "2.3.1")) {
            ConfigUpdater.removeConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "minecraft:ice");
            ConfigUpdater.removeConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "minecraft:packed_ice");
            ConfigUpdater.removeConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "minecraft:blue_ice");
        }
        if (ConfigUpdater.isBehind(configVersion, "2.3.2")) {
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:fur", insulator -> insulator.set(0, "cold_sweat:goat_fur"));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:fur_cap", insulator -> insulator.set(0, "cold_sweat:goat_fur_cap"));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:fur_parka", insulator -> insulator.set(0, "cold_sweat:goat_fur_parka"));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:fur_pants", insulator -> insulator.set(0, "cold_sweat:goat_fur_pants"));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:fur_boots", insulator -> insulator.set(0, "cold_sweat:goat_fur_boots"));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:fur_cap", insulator -> insulator.set(0, "cold_sweat:goat_fur_cap"));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:fur_parka", insulator -> insulator.set(0, "cold_sweat:goat_fur_parka"));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:fur_pants", insulator -> insulator.set(0, "cold_sweat:goat_fur_pants"));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:fur_boots", insulator -> insulator.set(0, "cold_sweat:goat_fur_boots"));
        }
        if (ConfigUpdater.isBehind(configVersion, "2.3.4")) {
            ConfigUpdater.removeConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "minecraft:soul_fire");
            ConfigUpdater.removeConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "minecraft:soul_campfire");
            ConfigUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, Arrays.asList("cold_sweat:boiler", 0.27, 7, "mc", 0.88, "lit=true", "{}", 4));
            ConfigUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, Arrays.asList("cold_sweat:icebox", -0.27, 7, "mc", 0.88, "frosted=true", "{}", 0));
            ConfigUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, Arrays.asList("minecraft:ice", -0.15, 4, "mc", 0.6, "", "{}", -0.7));
            ConfigUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, Arrays.asList("minecraft:packed_ice", -0.25, 4, "mc", 1.0, "", "{}", -0.7));
            ConfigUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, Arrays.asList("minecraft:blue_ice", -0.35, 4, "mc", 1.4, "", "{}", -0.7));
            ConfigUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, Arrays.asList("#minecraft:ice", -0.15, 4, "mc", 0.6, "", "{}", -0.7));
            ConfigUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, Arrays.asList("#minecraft:campfires", 0.476, 7, "mc", 0.9, "lit=true", " ", 8));
        }
        if (ConfigUpdater.isBehind(configVersion, "2.3.10")) {
            ArrayList blockTemps = new ArrayList((Collection)WorldSettingsConfig.BLOCK_TEMPERATURES.get());
            for (int i = 0; i < blockTemps.size(); ++i) {
                ArrayList<String> blockTemp2 = new ArrayList<String>((List)blockTemps.get(i));
                if (blockTemp2.size() <= 3 || blockTemp2.get(3) instanceof String) continue;
                blockTemp2.add(3, "mc");
                blockTemps.set(i, blockTemp2);
            }
            WorldSettingsConfig.BLOCK_TEMPERATURES.set(blockTemps);
        }
        if (ConfigUpdater.isBehind(configVersion, "2.4-b02a")) {
            ArrayList itemInsulations = new ArrayList((Collection)ItemSettingsConfig.INSULATION_ITEMS.get());
            for (List entry : itemInsulations) {
                if (!entry.contains("adaptive")) {
                    CSMath.setOrAppend(entry, 3, "static");
                }
                CSMath.setOrAppend(entry, 4, "");
                CSMath.setOrAppend(entry, 5, true);
            }
            ItemSettingsConfig.INSULATION_ITEMS.set(itemInsulations);
            ConfigUpdater.addConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, Arrays.asList("cold_sweat:chameleon_scale_helmet", 8, 0.0085, "adaptive", "", true));
            ConfigUpdater.addConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, Arrays.asList("cold_sweat:chameleon_scale_chestplate", 12, 0.0085, "adaptive", "", true));
            ConfigUpdater.addConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, Arrays.asList("cold_sweat:chameleon_scale_leggings", 10, 0.0085, "adaptive", "", true));
            ConfigUpdater.addConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, Arrays.asList("cold_sweat:chameleon_scale_boots", 8, 0.0085, "adaptive", "", true));
            ConfigUpdater.addConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, Arrays.asList("cold_sweat:chameleon_scale_helmet", 8, 0.0085, "adaptive"));
            ConfigUpdater.addConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, Arrays.asList("cold_sweat:chameleon_scale_chestplate", 12, 0.0085, "adaptive"));
            ConfigUpdater.addConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, Arrays.asList("cold_sweat:chameleon_scale_leggings", 10, 0.0085, "adaptive"));
            ConfigUpdater.addConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, Arrays.asList("cold_sweat:chameleon_scale_boots", 8, 0.0085, "adaptive"));
            ArrayList whitelist = new ArrayList((Collection)WorldSettingsConfig.SOURCE_SPREAD_WHITELIST.get());
            whitelist.remove("cold_sweat:hearth_bottom");
            WorldSettingsConfig.SOURCE_SPREAD_WHITELIST.set(whitelist);
            if (CompatManager.isTwilightForestLoaded()) {
                ConfigUpdater.addConfigSetting(WorldSettingsConfig.DIMENSION_TEMP_OFFSETS, Arrays.asList("twilightforest:twilight_forest_type", 0.2));
            }
            if (CompatManager.isAetherLoaded()) {
                ConfigUpdater.addConfigSetting(WorldSettingsConfig.DIMENSION_TEMP_OFFSETS, Arrays.asList("aether:the_aether", 0.7));
            }
        }
        MainSettingsConfig.VERSION.set((Object)version);
        MainSettingsConfig.save();
        ItemSettingsConfig.save();
        WorldSettingsConfig.save();
    }

    public static void updateFileNames() {
        for (File file : ConfigLoadingHandler.findFilesRecursive(FMLPaths.CONFIGDIR.get().resolve("coldsweat").toFile())) {
            if (!file.isFile()) continue;
            switch (file.getName()) {
                case "world_settings.toml": {
                    ConfigUpdater.renameFile(file, "world.toml");
                    break;
                }
                case "entity_settings.toml": {
                    ConfigUpdater.renameFile(file, "entity.toml");
                    break;
                }
                case "item_settings.toml": {
                    ConfigUpdater.renameFile(file, "item.toml");
                }
            }
        }
    }

    private static void renameFile(File file, String newName) {
        File newFile = file.toPath().resolveSibling(newName).toFile();
        try {
            Files.move((File)file, (File)newFile);
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("Failed to rename file {} to {}", (Object)file, (Object)newFile, (Object)e);
        }
    }

    public static String getVersionString(ArtifactVersion version) {
        String ver = version.getMajorVersion() + "." + version.getMinorVersion();
        if (version.getIncrementalVersion() != 0) {
            ver = ver + "." + version.getIncrementalVersion();
        }
        if (version.getQualifier() != null && !version.getQualifier().isEmpty()) {
            ver = ver + "-" + version.getQualifier();
        }
        return ver;
    }

    private static boolean isBehind(String version, String comparedTo) {
        boolean isBehind;
        boolean bl = isBehind = ConfigUpdater.compareVersions(version, comparedTo) < 0;
        if (isBehind) {
            ColdSweat.LOGGER.warn("Last launched version {} is less than {}. Updating config settings...", (Object)version, (Object)comparedTo);
        }
        return isBehind;
    }

    public static int compareVersions(String version, String comparedTo) {
        int i;
        String[] v1Parts = version.split("\\.|\\-");
        String[] v2Parts = comparedTo.split("\\.|\\-");
        for (i = 0; i < v1Parts.length && i < v2Parts.length; ++i) {
            if (v1Parts[i].matches("\\d+") && v2Parts[i].matches("\\d+")) {
                int num2;
                int num1 = Integer.parseInt(v1Parts[i]);
                if (num1 == (num2 = Integer.parseInt(v2Parts[i]))) continue;
                return Integer.compare(num1, num2);
            }
            if (!v1Parts[i].startsWith("b") && v2Parts[i].startsWith("b")) {
                return 1;
            }
            if (v1Parts[i].startsWith("b") && !v2Parts[i].startsWith("b")) {
                return -1;
            }
            int result = ConfigUpdater.comparePreReleaseVersions(v1Parts[i], v2Parts[i]);
            if (result == 0) continue;
            return result;
        }
        if (v1Parts.length != v2Parts.length) {
            if (i == v1Parts.length && i < v2Parts.length && v2Parts[i].startsWith("b")) {
                return 1;
            }
            if (i == v2Parts.length && i < v1Parts.length && v1Parts[i].startsWith("b")) {
                return -1;
            }
        }
        return Integer.compare(v1Parts.length, v2Parts.length);
    }

    private static int comparePreReleaseVersions(String v1, String v2) {
        if (v1.startsWith("b") && v2.startsWith("b")) {
            return ConfigUpdater.compareWithSubVersions(v1.substring(1), v2.substring(1));
        }
        return v1.compareTo(v2);
    }

    private static int compareWithSubVersions(String v1, String v2) {
        String[] parts1 = v1.split("(?<=\\d)(?=\\D)|(?<=\\D)(?=\\d)");
        String[] parts2 = v2.split("(?<=\\d)(?=\\D)|(?<=\\D)(?=\\d)");
        for (int i = 0; i < parts1.length && i < parts2.length; ++i) {
            if (parts1[i].matches("\\d+") && parts2[i].matches("\\d+")) {
                int num2;
                int num1 = Integer.parseInt(parts1[i]);
                if (num1 == (num2 = Integer.parseInt(parts2[i]))) continue;
                return Integer.compare(num1, num2);
            }
            int result = parts1[i].compareTo(parts2[i]);
            if (result == 0) continue;
            return result;
        }
        return Integer.compare(parts1.length, parts2.length);
    }

    public static void replaceConfigSetting(ForgeConfigSpec.ConfigValue<List<? extends List<?>>> config, String key, Consumer<List<Object>> modifier) {
        ArrayList setting = new ArrayList((Collection)config.get());
        for (int i = 0; i < setting.size(); ++i) {
            ArrayList element = new ArrayList((Collection)setting.get(i));
            if (element.isEmpty() || !element.get(0).equals(key)) continue;
            try {
                modifier.accept(element);
                setting.set(i, element);
                config.set(setting);
            }
            catch (Exception e) {
                ColdSweat.LOGGER.error("Failed to update config setting {} for key '{}'", (Object)config.getPath(), (Object)key, (Object)e);
            }
            break;
        }
    }

    public static void addConfigSetting(ForgeConfigSpec.ConfigValue<List<? extends List<?>>> config, List<?> newSetting) {
        ArrayList setting = new ArrayList((Collection)config.get());
        if (setting.stream().noneMatch(entry -> !entry.isEmpty() && entry.get(0).equals(newSetting.get(0)))) {
            config.clearCache();
            setting.add(newSetting);
            config.set(setting);
        }
    }

    public static void removeConfigSetting(ForgeConfigSpec.ConfigValue<List<? extends List<? extends Object>>> config, String key) {
        ArrayList<List> setting = new ArrayList<List>((Collection)config.get());
        setting.removeIf(entry -> !entry.isEmpty() && entry.get(0).equals(key));
        config.set(setting);
    }
}

