/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config.spec;

import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class MainSettingsConfig {
    private static final ForgeConfigSpec SPEC;
    private static final ForgeConfigSpec.Builder BUILDER;
    public static final ForgeConfigSpec.ConfigValue<Integer> DIFFICULTY;
    public static final ForgeConfigSpec.ConfigValue<String> VERSION;
    public static final ForgeConfigSpec.ConfigValue<Boolean> AUTO_UPDATE;
    public static final ForgeConfigSpec.ConfigValue<Double> MAX_HABITABLE_TEMPERATURE;
    public static final ForgeConfigSpec.ConfigValue<Double> MIN_HABITABLE_TEMPERATURE;
    public static final ForgeConfigSpec.ConfigValue<Double> TEMP_RATE_MULTIPLIER;
    public static final ForgeConfigSpec.ConfigValue<Double> TEMP_DAMAGE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> FIRE_RESISTANCE_BLOCKS_OVERHEATING;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ICE_RESISTANCE_BLOCKS_FREEZING;
    public static final ForgeConfigSpec.ConfigValue<Boolean> NULLIFY_IN_PEACEFUL;
    public static final ForgeConfigSpec.ConfigValue<Boolean> REQUIRE_THERMOMETER;
    public static final ForgeConfigSpec.ConfigValue<Integer> GRACE_PERIOD_LENGTH;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_GRACE_PERIOD;
    public static final ForgeConfigSpec.ConfigValue<Double> HEATSTROKE_FOG;
    public static final ForgeConfigSpec.ConfigValue<Double> FREEZING_HEARTS;
    public static final ForgeConfigSpec.ConfigValue<Double> COLD_KNOCKBACK;
    public static final ForgeConfigSpec.ConfigValue<Double> COLD_MINING;
    public static final ForgeConfigSpec.ConfigValue<Double> COLD_MOVEMENT;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> DISABLED_TEMP_MODIFIERS;
    public static final ForgeConfigSpec.DoubleValue MODIFIER_TICK_RATE;
    public static final ForgeConfigSpec.DoubleValue DRYOFF_SPEED;

    public static void setup() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path csConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "coldsweat");
        try {
            Files.createDirectory(csConfigPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, SPEC, "coldsweat/main.toml");
    }

    public static void save() {
        SPEC.save();
    }

    static {
        BUILDER = new ForgeConfigSpec.Builder();
        ConfigSettings.Difficulty defaultDiff = ConfigSettings.DEFAULT_DIFFICULTY;
        BUILDER.push("Builtin");
        DIFFICULTY = BUILDER.comment("DO NOT CHANGE THIS SETTING").defineInRange("Difficulty", defaultDiff.ordinal(), 0, ConfigSettings.Difficulty.values().length - 1);
        VERSION = BUILDER.comment("The current version of Cold Sweat. This is used by the auto-updater").define("Version", (Object)ColdSweat.getVersion());
        AUTO_UPDATE = BUILDER.comment("Allows Cold Sweat's configs to be automatically updated with new additions & formatting changes").define("Auto Update", true);
        BUILDER.pop();
        BUILDER.push("Difficulty");
        MIN_HABITABLE_TEMPERATURE = BUILDER.comment("Defines the minimum habitable temperature").defineInRange("Minimum Habitable Temperature", defaultDiff.getOrDefault(ConfigSettings.MIN_TEMP, Double.valueOf(Temperature.convert(50.0, Temperature.Units.F, Temperature.Units.MC, true))).doubleValue(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        MAX_HABITABLE_TEMPERATURE = BUILDER.comment("Defines the maximum habitable temperature").defineInRange("Maximum Habitable Temperature", defaultDiff.getOrDefault(ConfigSettings.MAX_TEMP, Double.valueOf(Temperature.convert(100.0, Temperature.Units.F, Temperature.Units.MC, true))).doubleValue(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        TEMP_RATE_MULTIPLIER = BUILDER.comment("Rate at which the player's body temperature changes (default: 1.0 (100%))").defineInRange("Rate Multiplier", defaultDiff.getOrDefault(ConfigSettings.TEMP_RATE, Double.valueOf(1.0)).doubleValue(), 0.0, Double.POSITIVE_INFINITY);
        TEMP_DAMAGE = BUILDER.comment("Damage dealt to the player when they are too hot or too cold").defineInRange("Temperature Damage", defaultDiff.getOrDefault(ConfigSettings.TEMP_DAMAGE, Double.valueOf(2.0)).doubleValue(), 0.0, Double.POSITIVE_INFINITY);
        NULLIFY_IN_PEACEFUL = BUILDER.comment("Sets whether damage scales with difficulty").define("Damage Scaling", (Object)defaultDiff.getOrDefault("damage_scaling", Boolean.valueOf(true)));
        BUILDER.pop();
        BUILDER.push("Items");
        FIRE_RESISTANCE_BLOCKS_OVERHEATING = BUILDER.comment("Allow fire resistance to block overheating damage").define("Fire Resistance Immunity", (Object)defaultDiff.getOrDefault(ConfigSettings.FIRE_RESISTANCE_ENABLED, Boolean.valueOf(true)));
        ICE_RESISTANCE_BLOCKS_FREEZING = BUILDER.comment("Allow ice resistance to block freezing damage").define("Ice Resistance Immunity", (Object)defaultDiff.getOrDefault(ConfigSettings.ICE_RESISTANCE_ENABLED, Boolean.valueOf(true)));
        REQUIRE_THERMOMETER = BUILDER.comment("Thermometer item is required to see detailed world temperature").define("Require Thermometer", (Object)defaultDiff.getOrDefault(ConfigSettings.REQUIRE_THERMOMETER, Boolean.valueOf(true)));
        BUILDER.pop();
        BUILDER.push("Temperature Effects");
        BUILDER.push("Hot");
        HEATSTROKE_FOG = BUILDER.comment(new String[]{"Defines the distance at which the player's vision is obscured by heatstroke fog", "Set to a value above 64 to disable the effect"}).defineInRange("Heatstroke Fog", defaultDiff.getOrDefault(ConfigSettings.HEATSTROKE_FOG_DISTANCE, Double.valueOf(6.0)).doubleValue(), 0.0, Double.POSITIVE_INFINITY);
        BUILDER.pop();
        BUILDER.push("Cold");
        FREEZING_HEARTS = BUILDER.comment(new String[]{"Up to a certain portion of the player's hearts will freeze over when they are too cold, preventing regeneration", "Represented as a percentage in decimal form"}).defineInRange("Max Frozen Health Percentage", defaultDiff.getOrDefault(ConfigSettings.HEARTS_FREEZING_PERCENTAGE, Double.valueOf(0.5)).doubleValue(), 0.0, 1.0);
        COLD_KNOCKBACK = BUILDER.comment(new String[]{"The player's attack knockback will be reduced by this amount when they are too cold", "Represented as a percentage in decimal form"}).defineInRange("Freezing Knockback Reduction", defaultDiff.getOrDefault(ConfigSettings.COLD_KNOCKBACK_REDUCTION, Double.valueOf(0.5)).doubleValue(), 0.0, 1.0);
        COLD_MOVEMENT = BUILDER.comment(new String[]{"The player's movement speed will be reduced by this amount when they are too cold", "Represented as a percentage in decimal form"}).defineInRange("Freezing Sluggishness", defaultDiff.getOrDefault(ConfigSettings.COLD_MOVEMENT_SLOWDOWN, Double.valueOf(0.5)).doubleValue(), 0.0, 1.0);
        COLD_MINING = BUILDER.comment(new String[]{"The player's mining speed will be reduced by this amount when they are too cold", "Represented as a percentage in decimal form"}).defineInRange("Freezing Mining Impairment", defaultDiff.getOrDefault(ConfigSettings.COLD_MINING_IMPAIRMENT, Double.valueOf(0.5)).doubleValue(), 0.0, 1.0);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Grace Period");
        GRACE_PERIOD_LENGTH = BUILDER.comment("The amount of time (in ticks) after the player spawns during which they are immune to temperature effects").defineInRange("Grace Period Length", defaultDiff.getOrDefault(ConfigSettings.GRACE_LENGTH, Integer.valueOf(6000)).intValue(), 0, Integer.MAX_VALUE);
        ENABLE_GRACE_PERIOD = BUILDER.comment("Enables the grace period").define("Grace Period Enabled", (Object)defaultDiff.getOrDefault(ConfigSettings.GRACE_ENABLED, Boolean.valueOf(true)));
        BUILDER.pop();
        BUILDER.push("Misc");
        DISABLED_TEMP_MODIFIERS = BUILDER.comment(new String[]{"Add TempModifier IDs to this list to disable them", "Allows for more granular control of Cold Sweat's features", " Run \"/temp debug @s <trait>\" to see IDs of all modifiers affecting the player", "See the Cold Sweat documentation for a list of default TempModifiers"}).defineListAllowEmpty(Arrays.asList("Disabled Temperature Modifiers"), () -> Arrays.asList(new String[0]), o -> o instanceof String);
        MODIFIER_TICK_RATE = BUILDER.comment(new String[]{"Changes the update rate for temperature modifiers on entities", "Temperature modifiers control most of Cold Sweat's behavior, so lowering this value will improve performance at the cost of responsiveness"}).defineInRange("Modifier Tick Rate", 1.0, 0.1, 1.0);
        DRYOFF_SPEED = BUILDER.comment("A multiplier to the speed at which wet players dry off").defineInRange("Dryoff Speed", 1.0, 0.0, Double.POSITIVE_INFINITY);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

