/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.event;

import com.google.common.collect.Maps;
import com.momosoftworks.coldsweat.api.event.core.init.EnableTemperatureEvent;
import com.momosoftworks.coldsweat.api.event.vanilla.ServerConfigsLoadedEvent;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModAttributes;
import com.momosoftworks.coldsweat.util.registries.ModEntities;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class AddTempAttributes {
    private static final Field FORGE_ATTRIBUTES;
    private static final Field ATTRIBUTE_MAP_INSTANCES;

    private static Map<EntityType<? extends LivingEntity>, AttributeModifierMap> getForgeAttributes() {
        try {
            return (Map)FORGE_ATTRIBUTES.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<Attribute, ModifiableAttributeInstance> getAttributeInstances(AttributeModifierMap map) {
        try {
            return (Map)ATTRIBUTE_MAP_INSTANCES.get(map);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public static void onEntitiesCreated(ServerConfigsLoadedEvent event) {
        for (EntityType entityType : ForgeRegistries.ENTITIES.getValues()) {
            EntityType type;
            try {
                type = entityType;
            }
            catch (ClassCastException e) {
                continue;
            }
            if (type == EntityType.field_200729_aH) continue;
            EnableTemperatureEvent enableEvent = new EnableTemperatureEvent(type);
            MinecraftForge.EVENT_BUS.post((Event)enableEvent);
            if (!enableEvent.isEnabled() || enableEvent.isCanceled()) continue;
            EntityTempManager.TEMPERATURE_ENABLED_ENTITIES.add((EntityType<? extends LivingEntity>)type);
            AttributeModifierMap attributes = CSMath.orElse(AddTempAttributes.getForgeAttributes().get(type), GlobalEntityTypeAttributes.func_233835_a_((EntityType)type));
            if (attributes == null) continue;
            Builder builder = new Builder(attributes);
            builder.add(ModAttributes.COLD_DAMPENING, Double.NaN);
            builder.add(ModAttributes.HEAT_DAMPENING, Double.NaN);
            builder.add(ModAttributes.COLD_RESISTANCE, Double.NaN);
            builder.add(ModAttributes.HEAT_RESISTANCE, Double.NaN);
            builder.add(ModAttributes.BURNING_POINT, Double.NaN);
            builder.add(ModAttributes.FREEZING_POINT, Double.NaN);
            builder.add(ModAttributes.BASE_BODY_TEMPERATURE, Double.NaN);
            builder.add(ModAttributes.WORLD_TEMPERATURE, Double.NaN);
            AddTempAttributes.getForgeAttributes().put((EntityType<? extends LivingEntity>)type, builder.build());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEnableTemperatureEvent(EnableTemperatureEvent event) {
        if (event.getEntityType() == ModEntities.CHAMELEON) {
            event.setEnabled(true);
        }
    }

    static {
        try {
            FORGE_ATTRIBUTES = ForgeHooks.class.getDeclaredField("FORGE_ATTRIBUTES");
            ATTRIBUTE_MAP_INSTANCES = ObfuscationReflectionHelper.findField(AttributeModifierMap.class, (String)"field_233802_a_");
            FORGE_ATTRIBUTES.setAccessible(true);
            ATTRIBUTE_MAP_INSTANCES.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        private final Map<Attribute, ModifiableAttributeInstance> builder = Maps.newHashMap();
        private boolean instanceFrozen;
        private final List<Builder> others = new ArrayList<Builder>();

        public Builder() {
        }

        public Builder(AttributeModifierMap attributeMap) {
            this.builder.putAll(AddTempAttributes.getAttributeInstances(attributeMap));
        }

        public void combine(Builder other) {
            this.builder.putAll(other.builder);
            this.others.add(other);
        }

        public boolean hasAttribute(Attribute attribute) {
            return this.builder.containsKey(attribute);
        }

        private ModifiableAttributeInstance create(Attribute pAttribute) {
            ModifiableAttributeInstance attributeinstance = new ModifiableAttributeInstance(pAttribute, p_22273_ -> {
                if (this.instanceFrozen) {
                    throw new UnsupportedOperationException("Tried to change value for default attribute instance: " + Registry.field_239692_aP_.func_177774_c((Object)pAttribute));
                }
            });
            this.builder.put(pAttribute, attributeinstance);
            return attributeinstance;
        }

        public Builder add(Attribute pAttribute) {
            this.create(pAttribute);
            return this;
        }

        public Builder add(Attribute pAttribute, double pValue) {
            ModifiableAttributeInstance attributeinstance = this.create(pAttribute);
            attributeinstance.func_111128_a(pValue);
            return this;
        }

        public AttributeModifierMap build() {
            this.instanceFrozen = true;
            this.others.forEach(p_70141_ -> {
                p_70141_.instanceFrozen = true;
            });
            return new AttributeModifierMap(this.builder);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ForPlayer {
        @SubscribeEvent
        public static void addPlayerAttributes(EntityAttributeModificationEvent event) {
            event.add(EntityType.field_200729_aH, ModAttributes.COLD_DAMPENING, Double.NaN);
            event.add(EntityType.field_200729_aH, ModAttributes.HEAT_DAMPENING, Double.NaN);
            event.add(EntityType.field_200729_aH, ModAttributes.COLD_RESISTANCE, Double.NaN);
            event.add(EntityType.field_200729_aH, ModAttributes.HEAT_RESISTANCE, Double.NaN);
            event.add(EntityType.field_200729_aH, ModAttributes.BURNING_POINT, Double.NaN);
            event.add(EntityType.field_200729_aH, ModAttributes.FREEZING_POINT, Double.NaN);
            event.add(EntityType.field_200729_aH, ModAttributes.BASE_BODY_TEMPERATURE, Double.NaN);
            event.add(EntityType.field_200729_aH, ModAttributes.WORLD_TEMPERATURE, Double.NaN);
        }
    }
}

