/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class BlockDataUpdateMessage {
    BlockPos blockPos;
    TileEntity blockEntity;
    CompoundNBT tag;

    public BlockDataUpdateMessage(TileEntity blockEntity) {
        this.blockPos = blockEntity.func_174877_v();
        this.blockEntity = blockEntity;
    }

    public BlockDataUpdateMessage(BlockPos blockPos, CompoundNBT tag) {
        this.blockPos = blockPos;
        this.tag = tag;
    }

    public static void encode(BlockDataUpdateMessage message, PacketBuffer buffer) {
        buffer.func_179255_a(message.blockPos);
        buffer.func_150786_a(message.blockEntity.func_189517_E_());
    }

    public static BlockDataUpdateMessage decode(PacketBuffer buffer) {
        return new BlockDataUpdateMessage(buffer.func_179259_c(), buffer.func_150793_b());
    }

    public static void handle(BlockDataUpdateMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> {
                TileEntity be;
                ClientWorld world = Minecraft.func_71410_x().field_71441_e;
                if (world != null && (be = world.func_175625_s(message.blockPos)) != null) {
                    be.handleUpdateTag(be.func_195044_w(), message.tag);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

