/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class EntityMountMessage {
    int entity;
    int vehicle;
    Action action;

    public EntityMountMessage(int entity, int vehicle, Action action) {
        this.entity = entity;
        this.vehicle = vehicle;
        this.action = action;
    }

    public static void encode(EntityMountMessage message, PacketBuffer buffer) {
        buffer.writeInt(message.entity);
        buffer.writeInt(message.vehicle);
        buffer.func_179249_a((Enum)message.action);
    }

    public static EntityMountMessage decode(PacketBuffer buffer) {
        return new EntityMountMessage(buffer.readInt(), buffer.readInt(), (Action)buffer.func_179257_a(Action.class));
    }

    public static void handle(EntityMountMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Minecraft mc = Minecraft.func_71410_x();
                Entity entity = mc.field_71441_e.func_73045_a(message.entity);
                Entity vehicle = mc.field_71441_e.func_73045_a(message.vehicle);
                if (message.action == Action.MOUNT) {
                    entity.func_184205_a(vehicle, true);
                } else if (entity.func_184187_bx().func_145782_y() == message.vehicle) {
                    entity.func_184210_p();
                }
            });
        }
        context.setPacketHandled(true);
    }

    public static enum Action {
        MOUNT,
        DISMOUNT;

    }
}

