/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.data.codec.configuration.BiomeTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.BlockTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DepthTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DimensionTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DryingItemData;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.FoodData;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemCarryTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.MountData;
import com.momosoftworks.coldsweat.data.codec.configuration.RemoveRegistryData;
import com.momosoftworks.coldsweat.data.codec.configuration.SpawnBiomeData;
import com.momosoftworks.coldsweat.data.codec.configuration.StructureTempData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.util.exceptions.RegistryFailureException;
import com.momosoftworks.coldsweat.util.math.FastMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.FallbackResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.packs.ModFileResourcePack;

public class ModRegistries {
    private static final FallbackResourceManager RESOURCE_MANAGER = new FallbackResourceManager(ResourcePackType.SERVER_DATA, "cold_sweat");
    private static final Map<String, ConfigRegistry<?>> REGISTRIES = new FastMap();
    public static final ConfigRegistry<InsulatorData> INSULATOR_DATA;
    public static final ConfigRegistry<FuelData> FUEL_DATA;
    public static final ConfigRegistry<FoodData> FOOD_DATA;
    public static final ConfigRegistry<ItemCarryTempData> CARRY_TEMP_DATA;
    public static final ConfigRegistry<DryingItemData> DRYING_ITEM_DATA;
    public static final ConfigRegistry<BlockTempData> BLOCK_TEMP_DATA;
    public static final ConfigRegistry<BiomeTempData> BIOME_TEMP_DATA;
    public static final ConfigRegistry<DimensionTempData> DIMENSION_TEMP_DATA;
    public static final ConfigRegistry<StructureTempData> STRUCTURE_TEMP_DATA;
    public static final ConfigRegistry<DepthTempData> DEPTH_TEMP_DATA;
    public static final ConfigRegistry<MountData> MOUNT_DATA;
    public static final ConfigRegistry<SpawnBiomeData> ENTITY_SPAWN_BIOME_DATA;
    public static final ConfigRegistry<EntityTempData> ENTITY_TEMP_DATA;
    public static final ConfigRegistry<RemoveRegistryData<?>> REMOVE_REGISTRY_DATA;

    public static IResourceManager getResourceManager() {
        return RESOURCE_MANAGER;
    }

    public static <V extends ConfigData> ConfigRegistry<V> createRegistry(RegistryKey<Registry<V>> registry, Codec<V> codec, Class<V> type) {
        ConfigRegistry<V> holder = new ConfigRegistry<V>(registry, codec, type);
        REGISTRIES.put(registry.func_240901_a_().func_110623_a(), new ConfigRegistry<V>(registry, codec, type));
        return holder;
    }

    public static Map<String, ConfigRegistry<?>> getRegistries() {
        return ImmutableMap.copyOf(REGISTRIES);
    }

    public static RegistryKey<Registry<? extends ConfigData>> getRegistry(String name) {
        return Optional.ofNullable(REGISTRIES.get(name)).map(holder -> holder.key()).orElseThrow(() -> (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Unknown Cold Sweat registry: " + name)));
    }

    public static <T> RegistryKey<Registry<T>> getRegistry(T object) {
        return REGISTRIES.values().stream().filter(holder -> ((ConfigRegistry)holder).type.isInstance(object)).findFirst().map(holder -> holder.key()).orElse(RegistryKey.func_240904_a_((ResourceLocation)new ResourceLocation("cold_sweat", "unknown")));
    }

    public static String getRegistryName(RegistryKey<Registry<? extends ConfigData>> key) {
        return key.func_240901_a_().func_110623_a();
    }

    public static <T extends ConfigData> Codec<T> getCodec(RegistryKey<ConfigRegistry<T>> registry) {
        return Optional.of(REGISTRIES.get(ModRegistries.getRegistryName(registry))).map(holder -> ((ConfigRegistry)holder).codec).orElseThrow(() -> (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Unknown Cold Sweat registry: " + registry.func_240901_a_().func_110623_a())));
    }

    static {
        RESOURCE_MANAGER.func_199021_a((IResourcePack)new ModFileResourcePack(ModList.get().getModFileById("cold_sweat").getFile()));
        INSULATOR_DATA = ModRegistries.createRegistry(RegistryKey.func_240904_a_((ResourceLocation)new ResourceLocation("cold_sweat", "item/insulator")), InsulatorData.CODEC, InsulatorData.class);
        FUEL_DATA = ModRegistries.createRegistry(RegistryKey.func_240904_a_((ResourceLocation)new ResourceLocation("cold_sweat", "item/fuel")), FuelData.CODEC, FuelData.class);
        FOOD_DATA = ModRegistries.createRegistry(RegistryKey.func_240904_a_((ResourceLocation)new ResourceLocation("cold_sweat", "item/food")), FoodData.CODEC, FoodData.class);
        CARRY_TEMP_DATA = ModRegistries.createRegistry(RegistryKey.func_240904_a_((ResourceLocation)new ResourceLocation("cold_sweat", "item/carried_temp")), ItemCarryTempData.CODEC, ItemCarryTempData.class);
        DRYING_ITEM_DATA = ModRegistries.createRegistry(RegistryKey.func_240904_a_((ResourceLocation)new ResourceLocation("cold_sweat", "item/drying_item")), DryingItemData.CODEC, DryingItemData.class);
        BLOCK_TEMP_DATA = ModRegistries.createRegistry(RegistryKey.func_240904_a_((ResourceLocation)new ResourceLocation("cold_sweat", "block/block_temp")), BlockTempData.CODEC, BlockTempData.class);
        BIOME_TEMP_DATA = ModRegistries.createRegistry(RegistryKey.func_240904_a_((ResourceLocation)new ResourceLocation("cold_sweat", "world/biome_temp")), BiomeTempData.CODEC, BiomeTempData.class);
        DIMENSION_TEMP_DATA = ModRegistries.createRegistry(RegistryKey.func_240904_a_((ResourceLocation)new ResourceLocation("cold_sweat", "world/dimension_temp")), DimensionTempData.CODEC, DimensionTempData.class);
        STRUCTURE_TEMP_DATA = ModRegistries.createRegistry(RegistryKey.func_240904_a_((ResourceLocation)new ResourceLocation("cold_sweat", "world/structure_temp")), StructureTempData.CODEC, StructureTempData.class);
        DEPTH_TEMP_DATA = ModRegistries.createRegistry(RegistryKey.func_240904_a_((ResourceLocation)new ResourceLocation("cold_sweat", "world/temp_region")), DepthTempData.CODEC, DepthTempData.class);
        MOUNT_DATA = ModRegistries.createRegistry(RegistryKey.func_240904_a_((ResourceLocation)new ResourceLocation("cold_sweat", "entity/mount")), MountData.CODEC, MountData.class);
        ENTITY_SPAWN_BIOME_DATA = ModRegistries.createRegistry(RegistryKey.func_240904_a_((ResourceLocation)new ResourceLocation("cold_sweat", "entity/spawn_biome")), SpawnBiomeData.CODEC, SpawnBiomeData.class);
        ENTITY_TEMP_DATA = ModRegistries.createRegistry(RegistryKey.func_240904_a_((ResourceLocation)new ResourceLocation("cold_sweat", "entity/entity_temp")), EntityTempData.CODEC, EntityTempData.class);
        REMOVE_REGISTRY_DATA = ModRegistries.createRegistry(RegistryKey.func_240904_a_((ResourceLocation)new ResourceLocation("cold_sweat", "remove")), RemoveRegistryData.CODEC, RemoveRegistryData.class);
    }

    public static class ConfigRegistry<V extends ConfigData> {
        private final RegistryKey<Registry<V>> key;
        private final Codec<V> codec;
        private final Class<V> type;
        private final Map<ResourceLocation, V> data = new HashMap<ResourceLocation, V>();

        public ConfigRegistry(RegistryKey<Registry<V>> key, Codec<V> codec, Class<V> type) {
            this.key = key;
            this.codec = codec;
            this.type = type;
        }

        public RegistryKey<Registry<V>> key() {
            return this.key;
        }

        public Codec<V> codec() {
            return this.codec;
        }

        public Class<V> type() {
            return this.type;
        }

        public Map<ResourceLocation, V> data() {
            return this.data;
        }

        public void register(ResourceLocation id, V data) {
            if (this.data.put(id, data) != null) {
                throw (RegistryFailureException)ColdSweat.LOGGER.throwing((Throwable)new RegistryFailureException(data, this.key.func_240901_a_().toString(), "Duplicate entry", null));
            }
        }

        public void flush() {
            this.data.clear();
        }
    }
}

