/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;

public class BiomeTempData
extends ConfigData {
    final NegatableList<Biome> biomes;
    final double min;
    final double max;
    final Temperature.Units units;
    final boolean isOffset;
    public static final Codec<BiomeTempData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NegatableList.listCodec(ConfigHelper.dynamicCodec(Registry.field_239720_u_)).fieldOf("biomes").forGetter(data -> data.biomes), (App)Codec.mapEither((MapCodec)Codec.DOUBLE.fieldOf("temperature"), (MapCodec)Codec.DOUBLE.fieldOf("min_temp")).xmap(either -> (Double)either.map(left -> left, right -> right), Either::right).forGetter(data -> data.min), (App)Codec.mapEither((MapCodec)Codec.DOUBLE.fieldOf("temperature"), (MapCodec)Codec.DOUBLE.fieldOf("max_temp")).xmap(either -> (Double)either.map(left -> left, right -> right), Either::right).forGetter(data -> data.max), (App)Temperature.Units.CODEC.optionalFieldOf("units", (Object)Temperature.Units.MC).forGetter(data -> data.units), (App)Codec.BOOL.optionalFieldOf("is_offset", (Object)false).forGetter(data -> data.isOffset), (App)Codec.STRING.listOf().optionalFieldOf("required_mods", Arrays.asList(new String[0])).forGetter(ConfigData::requiredMods)).apply((Applicative)instance, BiomeTempData::new));

    public BiomeTempData(NegatableList<Biome> biomes, double min, double max, Temperature.Units units, boolean isOffset, List<String> requiredMods) {
        super(requiredMods);
        this.biomes = biomes;
        this.min = min;
        this.max = max;
        this.units = units;
        this.isOffset = isOffset;
    }

    public BiomeTempData(NegatableList<Biome> biomes, double min, double max, Temperature.Units units, boolean isOffset) {
        this(biomes, min, max, units, isOffset, Arrays.asList(new String[0]));
    }

    public BiomeTempData(Biome biome, double min, double max, Temperature.Units units, boolean isOffset) {
        this(new NegatableList<Biome>(biome), min, max, units, isOffset);
    }

    public NegatableList<Biome> biomes() {
        return this.biomes;
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public Temperature.Units units() {
        return this.units;
    }

    public boolean isOffset() {
        return this.isOffset;
    }

    public double minTemp() {
        return Temperature.convert(this.min, this.units, Temperature.Units.MC, !this.isOffset);
    }

    public double maxTemp() {
        return Temperature.convert(this.max, this.units, Temperature.Units.MC, !this.isOffset);
    }

    @Nullable
    public static BiomeTempData fromToml(List<?> entry, boolean isOffset, DynamicRegistries registryAccess) {
        if (entry.size() < 3) {
            ColdSweat.LOGGER.error("Error parsing biome config: not enough arguments");
            return null;
        }
        List biomes = ConfigHelper.parseRegistryItems(Registry.field_239720_u_, registryAccess, (String)entry.get(0));
        if (biomes.isEmpty()) {
            return null;
        }
        Temperature.Units units = entry.size() == 4 ? Temperature.Units.valueOf(((String)entry.get(3)).toUpperCase()) : Temperature.Units.MC;
        double min = ((Number)entry.get(1)).doubleValue();
        double max = ((Number)entry.get(2)).doubleValue();
        return new BiomeTempData(new NegatableList<Biome>(biomes), min, max, units, isOffset);
    }

    public Codec<BiomeTempData> getCodec() {
        return CODEC;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BiomeTempData that = (BiomeTempData)obj;
        return super.equals(obj) && Double.compare(that.min, this.min) == 0 && Double.compare(that.max, this.max) == 0 && this.isOffset == that.isOffset && this.biomes.equals(that.biomes) && this.units == that.units;
    }
}

