/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.StringRepresentable;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;

public class DepthTempData
extends ConfigData {
    final List<TempRegion> temperatures;
    final NegatableList<DimensionType> dimensions;
    public static final Codec<DepthTempData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TempRegion.CODEC.listOf().fieldOf("regions").forGetter(data -> data.temperatures), (App)NegatableList.listCodec(ConfigHelper.dynamicCodec(Registry.field_239698_ad_)).fieldOf("dimensions").forGetter(data -> data.dimensions), (App)Codec.STRING.listOf().optionalFieldOf("required_mods", Arrays.asList(new String[0])).forGetter(ConfigData::requiredMods)).apply((Applicative)instance, DepthTempData::new));

    public DepthTempData(List<TempRegion> temperatures, NegatableList<DimensionType> dimensions, List<String> requiredMods) {
        super(requiredMods);
        this.temperatures = temperatures;
        this.dimensions = dimensions;
    }

    public DepthTempData(List<TempRegion> temperatures, NegatableList<DimensionType> dimensions) {
        this(temperatures, dimensions, Arrays.asList(new String[0]));
    }

    public List<TempRegion> temperatures() {
        return this.temperatures;
    }

    public NegatableList<DimensionType> dimensions() {
        return this.dimensions;
    }

    public boolean withinBounds(World level, BlockPos pos) {
        return this.getRegion(level, pos) != null;
    }

    public TempRegion getRegion(World level, BlockPos pos) {
        DimensionType dim = level.func_230315_m_();
        if (!this.dimensions.test(dim::equals)) {
            return null;
        }
        for (TempRegion region : this.temperatures) {
            if (!region.withinBounds(level, pos)) continue;
            return region;
        }
        return null;
    }

    public Double getTemperature(double temperature, BlockPos pos, World level) {
        for (TempRegion region : this.temperatures) {
            if (!region.withinBounds(level, pos)) continue;
            return region.getTemperature(temperature, pos, level);
        }
        return null;
    }

    public Codec<DepthTempData> getCodec() {
        return CODEC;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DepthTempData that = (DepthTempData)obj;
        return super.equals(obj) && this.temperatures.equals(that.temperatures) && this.dimensions.equals(that.dimensions);
    }

    public static enum VerticalAnchor implements StringRepresentable
    {
        CONSTANT("constant"),
        WORLD_TOP("world_top"),
        WORLD_BOTTOM("world_bottom"),
        GROUND_LEVEL("ground_level");

        private final String name;
        public static final Codec<VerticalAnchor> CODEC;

        private VerticalAnchor(String name) {
            this.name = name;
        }

        @Override
        public String func_176610_l() {
            return this.name;
        }

        public static VerticalAnchor byName(String name) {
            for (VerticalAnchor type : VerticalAnchor.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown vertical anchor: " + name);
        }

        static {
            CODEC = Codec.STRING.xmap(VerticalAnchor::byName, VerticalAnchor::func_176610_l);
        }
    }

    public static enum RampType implements StringRepresentable
    {
        CONSTANT("constant"),
        LINEAR("linear"),
        EXPONENTIAL("exponential"),
        LOGARITHMIC("logarithmic");

        private final String name;
        public static final Codec<RampType> CODEC;

        private RampType(String name) {
            this.name = name;
        }

        @Override
        public String func_176610_l() {
            return this.name;
        }

        public static RampType byName(String name) {
            for (RampType type : RampType.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Unknown ramp type: " + name));
        }

        static {
            CODEC = Codec.STRING.xmap(RampType::byName, RampType::func_176610_l);
        }
    }

    public static class VerticalBound {
        public static final VerticalBound NONE = new VerticalBound(VerticalAnchor.CONSTANT, 0, Temperature.Units.MC, TempContainer.NONE);
        public static final Codec<VerticalBound> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VerticalAnchor.CODEC.optionalFieldOf("anchor", (Object)VerticalAnchor.CONSTANT).forGetter(bound -> bound.anchor), (App)Codec.INT.fieldOf("depth").forGetter(bound -> bound.depth), (App)Temperature.Units.CODEC.optionalFieldOf("units", (Object)Temperature.Units.MC).forGetter(bound -> bound.units), (App)TempContainer.CODEC.fieldOf("temperature").forGetter(bound -> bound.temperature)).apply((Applicative)instance, VerticalBound::new));
        public final VerticalAnchor anchor;
        public final Integer depth;
        public final Temperature.Units units;
        public final TempContainer temperature;

        public VerticalBound(VerticalAnchor anchor, Integer depth, Temperature.Units units, TempContainer temperature) {
            this.anchor = anchor;
            this.depth = depth;
            this.units = units;
            this.temperature = temperature;
        }

        public int getHeight(BlockPos checkPos, World level) {
            switch (this.anchor) {
                case CONSTANT: {
                    return this.depth;
                }
                case WORLD_TOP: {
                    return level.func_217301_I() + this.depth;
                }
                case WORLD_BOTTOM: {
                    return 0 + this.depth;
                }
                case GROUND_LEVEL: {
                    return WorldHelper.getHeight(checkPos, level) + this.depth;
                }
            }
            return 0;
        }

        public double getTemperature(double temperature) {
            switch (this.temperature.type) {
                case STATIC: {
                    if (this.temperature.strength == 0.0) {
                        return temperature;
                    }
                    return CSMath.blend(temperature, this.temperature.temperature, this.temperature.strength, 0.0, 1.0);
                }
                case MIDPOINT: {
                    if (this.temperature.strength == 0.0) {
                        return temperature;
                    }
                    return CSMath.blend(temperature, (ConfigSettings.MIN_TEMP.get() + ConfigSettings.MAX_TEMP.get()) / 2.0, this.temperature.strength, 0.0, 1.0);
                }
            }
            return 0.0;
        }

        public String toString() {
            return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            VerticalBound that = (VerticalBound)obj;
            return this.anchor == that.anchor && this.depth.equals(that.depth) && this.units == that.units && this.temperature.equals(that.temperature);
        }

        public static enum ContainerType implements StringRepresentable
        {
            STATIC("static"),
            MIDPOINT("midpoint");

            private final String name;
            public static final Codec<ContainerType> CODEC;

            private ContainerType(String name) {
                this.name = name;
            }

            @Override
            public String func_176610_l() {
                return this.name;
            }

            public static ContainerType byName(String name) {
                for (ContainerType type : ContainerType.values()) {
                    if (!type.name.equals(name)) continue;
                    return type;
                }
                throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Unknown special temperature value: " + name));
            }

            static {
                CODEC = Codec.STRING.xmap(ContainerType::byName, ContainerType::func_176610_l);
            }
        }

        public static class TempContainer {
            public static final TempContainer NONE = new TempContainer(0.0, ContainerType.STATIC, 1.0);
            public static final Codec<TempContainer> CODEC = Codec.either((Codec)RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.optionalFieldOf("value", (Object)Double.NaN).forGetter(container -> container.temperature), (App)ContainerType.CODEC.optionalFieldOf("type", (Object)ContainerType.STATIC).forGetter(container -> container.type), (App)Codec.doubleRange((double)0.0, (double)1.0).optionalFieldOf("strength", (Object)1.0).forGetter(container -> container.strength)).apply((Applicative)instance, (temp, type, strength) -> {
                if (type == ContainerType.STATIC && temp.equals(Double.NaN) && strength > 0.0) {
                    throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Static temperature container must have a temperature"));
                }
                return new TempContainer((double)temp, (ContainerType)type, (double)strength);
            })), (Codec)Codec.DOUBLE.xmap(d -> new TempContainer((double)d, ContainerType.STATIC, 1.0), container -> container.temperature)).xmap(either -> (TempContainer)either.map(c -> c, c -> c), container -> container.type == ContainerType.STATIC ? Either.right((Object)container) : Either.left((Object)container));
            public final double temperature;
            public final ContainerType type;
            public final double strength;

            public TempContainer(double temperature, ContainerType type, double strength) {
                this.temperature = temperature;
                this.type = type;
                this.strength = strength;
            }

            public boolean equals(Object obj) {
                if (obj instanceof TempContainer) {
                    TempContainer container = (TempContainer)obj;
                    return Double.valueOf(container.temperature).equals(this.temperature) && container.type == this.type && container.strength == this.strength;
                }
                return false;
            }
        }
    }

    public static class TempRegion {
        public static final TempRegion NONE = new TempRegion(RampType.CONSTANT, VerticalBound.NONE, VerticalBound.NONE);
        public static final Codec<TempRegion> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RampType.CODEC.optionalFieldOf("type", (Object)RampType.CONSTANT).forGetter(region -> region.rampType), (App)VerticalBound.CODEC.optionalFieldOf("top", (Object)VerticalBound.NONE).forGetter(region -> region.top), (App)VerticalBound.CODEC.optionalFieldOf("bottom", (Object)VerticalBound.NONE).forGetter(region -> region.bottom)).apply((Applicative)instance, (type, top, bottom) -> {
            if (top == VerticalBound.NONE && bottom == VerticalBound.NONE) {
                throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Temperature region must have at least one bound"));
            }
            if (top == VerticalBound.NONE) {
                if (type != RampType.CONSTANT) {
                    throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("\"top\" region undefined. Boundless temperature region must have a constant temperature"));
                }
                top = new VerticalBound(VerticalAnchor.CONSTANT, Integer.MAX_VALUE, bottom.units, bottom.temperature);
            }
            if (bottom == VerticalBound.NONE) {
                if (type != RampType.CONSTANT) {
                    throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("\"bottom\" region undefined. Boundless temperature region must have a constant temperature"));
                }
                bottom = new VerticalBound(VerticalAnchor.CONSTANT, Integer.MIN_VALUE, top.units, top.temperature);
            }
            if (type == RampType.CONSTANT && !top.temperature.equals(bottom.temperature)) {
                throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Constant temperature ramp type must have a constant temperature; got " + top.temperature + " and " + bottom.temperature));
            }
            return new TempRegion((RampType)type, (VerticalBound)top, (VerticalBound)bottom);
        }));
        RampType rampType;
        VerticalBound top;
        VerticalBound bottom;

        public TempRegion(RampType rampType, VerticalBound top, VerticalBound bottom) {
            this.rampType = rampType;
            this.top = top;
            this.bottom = bottom;
        }

        public boolean withinBounds(World level, BlockPos pos) {
            return pos.func_177956_o() <= this.top.getHeight(pos, level) && pos.func_177956_o() >= this.bottom.getHeight(pos, level);
        }

        public double getTemperature(double temperature, BlockPos pos, World level) {
            double topTemp = Temperature.convert(this.top.getTemperature(temperature), this.top.units, Temperature.Units.MC, true);
            double bottomTemp = Temperature.convert(this.bottom.getTemperature(temperature), this.bottom.units, Temperature.Units.MC, true);
            switch (this.rampType) {
                case CONSTANT: {
                    return pos.func_177956_o() <= this.bottom.getHeight(pos, level) ? bottomTemp : topTemp;
                }
                case LINEAR: {
                    return CSMath.blend(bottomTemp, topTemp, (double)pos.func_177956_o(), (double)this.bottom.getHeight(pos, level), (double)this.top.getHeight(pos, level));
                }
                case EXPONENTIAL: {
                    return CSMath.blendExp(bottomTemp, topTemp, (double)pos.func_177956_o(), (double)this.bottom.getHeight(pos, level), (double)this.top.getHeight(pos, level));
                }
                case LOGARITHMIC: {
                    return CSMath.blendLog(bottomTemp, topTemp, (double)pos.func_177956_o(), (double)this.bottom.getHeight(pos, level), (double)this.top.getHeight(pos, level));
                }
            }
            return topTemp;
        }

        public String toString() {
            return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TempRegion that = (TempRegion)obj;
            return this.rampType == that.rampType && this.top.equals(that.top) && this.bottom.equals(that.bottom);
        }
    }
}

