/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.insulation.StaticInsulation;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.impl.RequirementHolder;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.util.AttributeModifierMap;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;

public class InsulatorData
extends ConfigData
implements RequirementHolder {
    final NegatableList<ItemRequirement> item;
    final Insulation.Slot slot;
    final List<Insulation> insulation;
    final NegatableList<EntityRequirement> entity;
    final AttributeModifierMap attributes;
    final Map<ResourceLocation, Double> immuneTempModifiers;
    final boolean fillSlots;
    private static final Codec<List<Insulation>> INSULATION_CODEC = Codec.either((Codec)Insulation.getCodec().listOf(), Insulation.getCodec()).xmap(either -> (List)either.map(left -> left.stream().filter(insul -> !insul.isEmpty()).collect(Collectors.toList()), right -> right.isEmpty() ? Arrays.asList(new Insulation[0]) : Arrays.asList(right)), list -> list.size() == 1 ? Either.right(list.get(0)) : Either.left((Object)list));
    public static final Codec<InsulatorData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NegatableList.codec(ItemRequirement.CODEC).optionalFieldOf("item", new NegatableList()).forGetter(InsulatorData::item), (App)Insulation.Slot.CODEC.fieldOf("type").forGetter(InsulatorData::slot), (App)INSULATION_CODEC.fieldOf("insulation").forGetter(InsulatorData::insulation), (App)NegatableList.codec(EntityRequirement.getCodec()).optionalFieldOf("entity", new NegatableList()).forGetter(InsulatorData::entity), (App)AttributeModifierMap.CODEC.optionalFieldOf("attributes", (Object)new AttributeModifierMap()).forGetter(InsulatorData::attributes), (App)Codec.unboundedMap((Codec)ResourceLocation.field_240908_a_, (Codec)Codec.DOUBLE).optionalFieldOf("immune_temp_modifiers", new HashMap()).forGetter(InsulatorData::immuneTempModifiers), (App)Codec.BOOL.optionalFieldOf("fill_slots", (Object)false).forGetter(InsulatorData::fillSlots), (App)Codec.STRING.listOf().optionalFieldOf("required_mods", Arrays.asList(new String[0])).forGetter(ConfigData::requiredMods)).apply((Applicative)instance, InsulatorData::new));

    public InsulatorData(NegatableList<ItemRequirement> item, Insulation.Slot slot, List<Insulation> insulation, NegatableList<EntityRequirement> entity, AttributeModifierMap attributes, Map<ResourceLocation, Double> immuneTempModifiers, boolean fillSlots, List<String> requiredMods) {
        super(requiredMods);
        this.item = item;
        this.slot = slot;
        this.insulation = insulation;
        this.entity = entity;
        this.attributes = attributes;
        this.immuneTempModifiers = immuneTempModifiers;
        this.fillSlots = fillSlots;
    }

    public InsulatorData(NegatableList<ItemRequirement> item, Insulation.Slot slot, List<Insulation> insulation, NegatableList<EntityRequirement> entity, AttributeModifierMap attributes, Map<ResourceLocation, Double> immuneTempModifiers, boolean fillSlots) {
        this(item, slot, insulation, entity, attributes, immuneTempModifiers, fillSlots, Arrays.asList(new String[0]));
    }

    public NegatableList<ItemRequirement> item() {
        return this.item;
    }

    public Insulation.Slot slot() {
        return this.slot;
    }

    public List<Insulation> insulation() {
        return this.insulation;
    }

    public NegatableList<EntityRequirement> entity() {
        return this.entity;
    }

    public AttributeModifierMap attributes() {
        return this.attributes;
    }

    public Map<ResourceLocation, Double> immuneTempModifiers() {
        return this.immuneTempModifiers;
    }

    public boolean fillSlots() {
        return this.fillSlots;
    }

    public double getCold() {
        return this.insulation.stream().mapToDouble(Insulation::getCold).sum();
    }

    public double getHeat() {
        return this.insulation.stream().mapToDouble(Insulation::getHeat).sum();
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.item.test((T rq) -> rq.test(stack, true));
    }

    @Override
    public boolean test(Entity entity) {
        return entity == null || this.entity.test((T rq) -> rq.test(entity));
    }

    @Nullable
    public static InsulatorData fromToml(List<?> entry, Insulation.Slot slot) {
        if (entry.size() < 3) {
            ColdSweat.LOGGER.error("Error parsing {} insulator config: not enough arguments", (Object)slot.func_176610_l());
            return null;
        }
        List<Either<ITag<Item>, Item>> items = ConfigHelper.getItems((String)entry.get(0));
        if (items.isEmpty()) {
            return null;
        }
        boolean adaptive = entry.size() > 3 && entry.get(3).equals("adaptive");
        ArrayList<Insulation> insulation = new ArrayList<Insulation>();
        if (!adaptive) {
            if (!(entry.get(1) instanceof Number || entry.get(1) instanceof List && ((List)entry.get(1)).stream().allMatch(val -> val instanceof Number))) {
                ColdSweat.LOGGER.error("Error parsing {} insulator config: invalid cold insulation value: {}", (Object)slot.func_176610_l(), entry.get(1));
                return null;
            }
            if (!(entry.get(2) instanceof Number || entry.get(2) instanceof List && ((List)entry.get(1)).stream().allMatch(val -> val instanceof Number))) {
                ColdSweat.LOGGER.error("Error parsing {} insulator config: invalid heat insulation valueL {}", (Object)slot.func_176610_l(), entry.get(2));
                return null;
            }
            List<Number> insulVal1 = entry.get(1) instanceof List ? (List<Number>)entry.get(1) : Arrays.asList((Number)entry.get(1));
            List<Number> insulVal2 = entry.get(2) instanceof List ? (List<Number>)entry.get(2) : Arrays.asList((Number)entry.get(2));
            List<Insulation> coldList = insulVal1.stream().map(val -> new StaticInsulation(val.doubleValue(), 0.0)).collect(Collectors.toList());
            List<Insulation> hotList = insulVal2.stream().map(val -> new StaticInsulation(0.0, val.doubleValue())).collect(Collectors.toList());
            insulation.addAll(Insulation.combine(coldList, hotList));
        } else {
            insulation.add(new AdaptiveInsulation(((Number)entry.get(1)).doubleValue(), ((Number)entry.get(2)).doubleValue()));
        }
        CompoundNBT tag = entry.size() > 4 ? NBTHelper.parseCompoundNbt((String)entry.get(4)) : new CompoundNBT();
        boolean multiSlot = entry.size() > 5 && (Boolean)entry.get(5) != false;
        ItemRequirement itemRequirement = new ItemRequirement(items, new NbtRequirement(tag));
        return new InsulatorData(new NegatableList<ItemRequirement>(itemRequirement), slot, insulation, new NegatableList<EntityRequirement>(), new AttributeModifierMap(), new HashMap<ResourceLocation, Double>(), multiSlot);
    }

    public InsulatorData copy() {
        return new InsulatorData(this.item, this.slot, Insulation.deepCopy(this.insulation), this.entity, this.attributes, new HashMap<ResourceLocation, Double>(this.immuneTempModifiers), this.fillSlots);
    }

    public Codec<InsulatorData> getCodec() {
        return CODEC;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InsulatorData that = (InsulatorData)obj;
        return super.equals(obj) && this.slot == that.slot && this.insulation.equals(that.insulation) && this.item.equals(that.item) && this.entity.equals(that.entity) && this.attributes.equals(that.attributes) && this.immuneTempModifiers.equals(that.immuneTempModifiers);
    }
}

