/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.impl.RequirementHolder;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.tags.ITag;

public class MountData
extends ConfigData
implements RequirementHolder {
    final NegatableList<EntityRequirement> entity;
    final NegatableList<EntityRequirement> rider;
    final double coldInsulation;
    final double heatInsulation;
    public static Codec<MountData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NegatableList.codec(EntityRequirement.getCodec()).fieldOf("entity").forGetter(MountData::entity), (App)NegatableList.codec(EntityRequirement.getCodec()).optionalFieldOf("rider", new NegatableList()).forGetter(MountData::rider), (App)Codec.DOUBLE.fieldOf("cold_insulation").forGetter(MountData::coldInsulation), (App)Codec.DOUBLE.fieldOf("heat_insulation").forGetter(MountData::heatInsulation), (App)Codec.STRING.listOf().optionalFieldOf("required_mods", Arrays.asList(new String[0])).forGetter(ConfigData::requiredMods)).apply((Applicative)instance, MountData::new));

    public MountData(NegatableList<EntityRequirement> entity, NegatableList<EntityRequirement> rider, double coldInsulation, double heatInsulation, List<String> requiredMods) {
        super(requiredMods);
        this.entity = entity;
        this.rider = rider;
        this.coldInsulation = coldInsulation;
        this.heatInsulation = heatInsulation;
    }

    public MountData(NegatableList<EntityRequirement> entity, NegatableList<EntityRequirement> rider, double coldInsulation, double heatInsulation) {
        this(entity, rider, coldInsulation, heatInsulation, Arrays.asList(new String[0]));
    }

    public NegatableList<EntityRequirement> entity() {
        return this.entity;
    }

    public NegatableList<EntityRequirement> rider() {
        return this.rider;
    }

    public double coldInsulation() {
        return this.coldInsulation;
    }

    public double heatInsulation() {
        return this.heatInsulation;
    }

    @Nullable
    public static MountData fromToml(List<?> entry) {
        if (entry.size() < 2) {
            ColdSweat.LOGGER.error("Error parsing insulating mount config: not enough arguments");
            return null;
        }
        List<Either<ITag<EntityType<?>>, EntityType<?>>> entities = ConfigHelper.getEntityTypes((String)entry.get(0));
        if (entities.isEmpty()) {
            return null;
        }
        double coldInsul = ((Number)entry.get(1)).doubleValue();
        double hotInsul = entry.size() < 3 ? coldInsul : ((Number)entry.get(2)).doubleValue();
        return new MountData(new NegatableList<EntityRequirement>(new EntityRequirement(entities)), new NegatableList<EntityRequirement>(), coldInsul, hotInsul);
    }

    @Override
    public boolean test(Entity entity) {
        return this.entity.test((T rq) -> rq.test(entity));
    }

    public Codec<MountData> getCodec() {
        return CODEC;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MountData that = (MountData)obj;
        return super.equals(obj) && this.entity.equals(that.entity) && this.rider.equals(that.rider) && Double.compare(that.coldInsulation, this.coldInsulation) == 0 && Double.compare(that.heatInsulation, this.heatInsulation) == 0;
    }
}

