/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.ModRegistries;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;

public class RemoveRegistryData<T extends ConfigData>
extends ConfigData {
    private final RegistryKey<Registry<T>> registry;
    private final List<CompoundNBT> entries;
    public static final Codec<RemoveRegistryData<? extends ConfigData>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.xmap(ModRegistries::getRegistry, ModRegistries::getRegistryName).fieldOf("registry").forGetter(data -> data.registry), (App)CompoundNBT.field_240597_a_.listOf().fieldOf("matches").forGetter(data -> data.entries)).apply((Applicative)instance, (key, ent) -> new RemoveRegistryData((RegistryKey)key, (List)ent)));

    public RemoveRegistryData(RegistryKey<Registry<T>> registry, List<CompoundNBT> entries) {
        super(Arrays.asList(new String[0]));
        this.registry = registry;
        this.entries = entries;
    }

    public RegistryKey<Registry<T>> registry() {
        return this.registry;
    }

    public List<CompoundNBT> entries() {
        return this.entries;
    }

    public boolean matches(T object) {
        Optional serialized = ModRegistries.getCodec(this.registry).encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, object).result();
        if (serialized.isPresent()) {
            for (CompoundNBT data : this.entries) {
                if (!NbtRequirement.compareNbt((INBT)data, (INBT)serialized.get(), true)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Codec<? extends ConfigData> getCodec() {
        return CODEC;
    }
}

