/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.requirement.LocationRequirement;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.tags.ITag;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;

public class SpawnBiomeData
extends ConfigData {
    final List<Biome> biomes;
    final List<Either<ITag<EntityType<?>>, EntityType<?>>> entities;
    final EntityClassification category;
    final int weight;
    final IntegerBounds count;
    final NegatableList<LocationRequirement> location;
    public static final Codec<SpawnBiomeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConfigHelper.dynamicCodec(Registry.field_239720_u_).listOf().fieldOf("biomes").forGetter(SpawnBiomeData::biomes), (App)ConfigHelper.tagOrBuiltinCodec(Registry.field_239713_n_, Registry.field_212629_r).listOf().fieldOf("entities").forGetter(SpawnBiomeData::entities), (App)EntityClassification.field_233667_g_.fieldOf("category").forGetter(SpawnBiomeData::category), (App)Codec.INT.fieldOf("weight").forGetter(SpawnBiomeData::weight), (App)IntegerBounds.CODEC.optionalFieldOf("count", (Object)IntegerBounds.NONE).forGetter(SpawnBiomeData::count), (App)NegatableList.codec(LocationRequirement.CODEC).optionalFieldOf("location", new NegatableList()).forGetter(SpawnBiomeData::location), (App)Codec.STRING.listOf().optionalFieldOf("required_mods", Arrays.asList(new String[0])).forGetter(ConfigData::requiredMods)).apply((Applicative)instance, SpawnBiomeData::new));

    public SpawnBiomeData(List<Biome> biomes, List<Either<ITag<EntityType<?>>, EntityType<?>>> entities, EntityClassification category, int weight, IntegerBounds count, NegatableList<LocationRequirement> location, List<String> requiredMods) {
        super(requiredMods);
        this.biomes = biomes;
        this.entities = entities;
        this.category = category;
        this.weight = weight;
        this.count = count;
        this.location = location;
    }

    public SpawnBiomeData(List<Biome> biomes, List<Either<ITag<EntityType<?>>, EntityType<?>>> entities, EntityClassification category, int weight, IntegerBounds count, NegatableList<LocationRequirement> location) {
        this(biomes, entities, category, weight, count, location, Arrays.asList(new String[0]));
    }

    public SpawnBiomeData(Collection<Biome> biomes, EntityClassification category, int weight, Collection<EntityType<?>> entities, IntegerBounds count, NegatableList<LocationRequirement> location) {
        this(new ArrayList<Biome>(biomes), entities.stream().map(Either::right).collect(Collectors.toList()), category, weight, count, location);
    }

    public List<Biome> biomes() {
        return this.biomes;
    }

    public EntityClassification category() {
        return this.category;
    }

    public int weight() {
        return this.weight;
    }

    public List<Either<ITag<EntityType<?>>, EntityType<?>>> entities() {
        return this.entities;
    }

    public IntegerBounds count() {
        return this.count;
    }

    public NegatableList<LocationRequirement> location() {
        return this.location;
    }

    @Nullable
    public static SpawnBiomeData fromToml(List<?> entry, EntityType<?> entityType, DynamicRegistries registryAccess) {
        if (entry.size() < 2) {
            ColdSweat.LOGGER.error("Error parsing entity spawn biome config: not enough arguments");
            return null;
        }
        List<Biome> biomes = ConfigHelper.parseRegistryItems(Registry.field_239720_u_, registryAccess, (String)entry.get(0));
        if (biomes.isEmpty()) {
            return null;
        }
        return new SpawnBiomeData(biomes, Arrays.asList(Either.right(entityType)), EntityClassification.CREATURE, ((Number)entry.get(1)).intValue(), new IntegerBounds(1, 1), new NegatableList<LocationRequirement>());
    }

    public Codec<SpawnBiomeData> getCodec() {
        return CODEC;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SpawnBiomeData that = (SpawnBiomeData)obj;
        return this.biomes.equals(that.biomes) && this.category == that.category && this.weight == that.weight && this.entities.equals(that.entities) && this.count.equals(that.count) && this.location.equals(that.location);
    }
}

