/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.StructureFeature;

public class StructureTempData
extends ConfigData {
    NegatableList<StructureFeature<?, ?>> structures;
    double temperature;
    Temperature.Units units;
    boolean isOffset;
    public static final Codec<StructureTempData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NegatableList.listCodec(ConfigHelper.dynamicCodec(Registry.field_243553_av)).fieldOf("structures").forGetter(data -> data.structures), (App)Codec.DOUBLE.fieldOf("temperature").forGetter(data -> data.temperature), (App)Temperature.Units.CODEC.optionalFieldOf("units", (Object)Temperature.Units.MC).forGetter(data -> data.units), (App)Codec.BOOL.optionalFieldOf("offset", (Object)false).forGetter(data -> data.isOffset), (App)Codec.STRING.listOf().optionalFieldOf("required_mods", Arrays.asList(new String[0])).forGetter(ConfigData::requiredMods)).apply((Applicative)instance, StructureTempData::new));

    public StructureTempData(NegatableList<StructureFeature<?, ?>> structures, double temperature, Temperature.Units units, boolean isOffset, List<String> requiredMods) {
        super(requiredMods);
        this.structures = structures;
        this.temperature = temperature;
        this.units = units;
        this.isOffset = isOffset;
    }

    public StructureTempData(NegatableList<StructureFeature<?, ?>> structures, double temperature, Temperature.Units units, boolean isOffset) {
        this(structures, temperature, units, isOffset, Arrays.asList(new String[0]));
    }

    public StructureTempData(StructureFeature<?, ?> structure, double temperature, Temperature.Units units, boolean isOffset) {
        this(new NegatableList(structure), temperature, units, isOffset);
    }

    public NegatableList<StructureFeature<?, ?>> structures() {
        return this.structures;
    }

    public double temperature() {
        return this.temperature;
    }

    public Temperature.Units units() {
        return this.units;
    }

    public boolean isOffset() {
        return this.isOffset;
    }

    public double getTemperature() {
        return Temperature.convert(this.temperature, this.units, Temperature.Units.MC, this.isOffset);
    }

    @Nullable
    public static StructureTempData fromToml(List<?> entry, boolean isOffset, DynamicRegistries registryAccess) {
        if (entry.size() < 2) {
            ColdSweat.LOGGER.error("Error parsing structure config: {} does not have enough arguments", entry);
            return null;
        }
        List structures = ConfigHelper.parseRegistryItems(Registry.field_243553_av, registryAccess, (String)entry.get(0));
        if (structures.isEmpty()) {
            return null;
        }
        double temp = ((Number)entry.get(1)).doubleValue();
        Temperature.Units units = entry.size() == 3 ? Temperature.Units.valueOf(((String)entry.get(2)).toUpperCase()) : Temperature.Units.MC;
        return new StructureTempData(new NegatableList(structures), temp, units, isOffset);
    }

    public Codec<StructureTempData> getCodec() {
        return CODEC;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StructureTempData that = (StructureTempData)obj;
        return super.equals(obj) && Double.compare(that.temperature, this.temperature) == 0 && this.isOffset == that.isOffset && this.structures.equals(that.structures) && this.units == that.units;
    }
}

