/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.impl;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.util.serialization.NbtSerializable;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;

public abstract class ConfigData
implements NbtSerializable {
    private UUID id;
    private Type type;
    List<String> requiredMods;

    public ConfigData(List<String> requiredMods) {
        this.requiredMods = requiredMods;
    }

    public abstract Codec<? extends ConfigData> getCodec();

    public UUID getId() {
        if (this.id == null) {
            this.id = UUID.randomUUID();
        }
        return this.id;
    }

    public Type getType() {
        return this.type;
    }

    public List<String> requiredMods() {
        return this.requiredMods;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public CompoundNBT serialize() {
        return this.getCodec().encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this).result().orElse(new CompoundNBT());
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.getCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("");
    }

    public boolean areRequiredModsLoaded() {
        return this.requiredMods.stream().allMatch(mod -> mod.equals("minecraft") || CompatManager.modLoaded(mod));
    }

    public boolean equals(Object obj) {
        return obj instanceof ConfigData && ((ConfigData)obj).requiredMods().equals(this.requiredMods());
    }

    public static enum Type {
        TOML,
        JSON,
        KUBEJS;

    }
}

