/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import java.util.Map;
import java.util.Optional;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.registry.Registry;

public class EnchantmentRequirement {
    private final Enchantment enchantment;
    private final Optional<IntegerBounds> level;
    public static final Codec<EnchantmentRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.field_212628_q.fieldOf("enchantment").forGetter(requirement -> requirement.enchantment), (App)IntegerBounds.CODEC.optionalFieldOf("levels").forGetter(requirement -> requirement.level)).apply((Applicative)instance, EnchantmentRequirement::new));

    public EnchantmentRequirement(Enchantment enchantment, Optional<IntegerBounds> level) {
        this.enchantment = enchantment;
        this.level = level;
    }

    public Enchantment enchantment() {
        return this.enchantment;
    }

    public Optional<IntegerBounds> level() {
        return this.level;
    }

    public boolean test(Enchantment enchantment, int level) {
        return this.enchantment == enchantment && this.level.map(bounds -> bounds.test(level)).orElse(true) != false;
    }

    public boolean test(Map<Enchantment, Integer> enchantments) {
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            if (!this.test(entry.getKey(), entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EnchantmentRequirement that = (EnchantmentRequirement)obj;
        return this.enchantment.equals(that.enchantment) && this.level.equals(that.level);
    }
}

