/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.BlockRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class FluidRequirement {
    private final Optional<List<Either<ITag<Fluid>, Fluid>>> fluids;
    private final Optional<ITag<Fluid>> tag;
    private final Optional<BlockRequirement.StateRequirement> state;
    private final Optional<NbtRequirement> nbt;
    public static final Codec<FluidRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConfigHelper.tagOrBuiltinCodec(Registry.field_239709_j_, Registry.field_212619_h).listOf().optionalFieldOf("fluids").forGetter(predicate -> predicate.fluids), (App)ITag.func_232947_a_(FluidTags::func_226157_a_).optionalFieldOf("tag").forGetter(predicate -> predicate.tag), (App)BlockRequirement.StateRequirement.CODEC.optionalFieldOf("state").forGetter(predicate -> predicate.state), (App)NbtRequirement.CODEC.optionalFieldOf("nbt").forGetter(predicate -> predicate.nbt)).apply((Applicative)instance, FluidRequirement::new));

    public FluidRequirement(Optional<List<Either<ITag<Fluid>, Fluid>>> fluids, Optional<ITag<Fluid>> tag, Optional<BlockRequirement.StateRequirement> state, Optional<NbtRequirement> nbt) {
        this.fluids = fluids;
        this.tag = tag;
        this.state = state;
        this.nbt = nbt;
    }

    public Optional<List<Either<ITag<Fluid>, Fluid>>> fluids() {
        return this.fluids;
    }

    public Optional<ITag<Fluid>> tag() {
        return this.tag;
    }

    public Optional<BlockRequirement.StateRequirement> state() {
        return this.state;
    }

    public Optional<NbtRequirement> nbt() {
        return this.nbt;
    }

    public boolean test(World pLevel, BlockPos pPos) {
        if (!pLevel.func_195588_v(pPos)) {
            return false;
        }
        FluidState lState = pLevel.func_204610_c(pPos);
        return this.test(lState);
    }

    public boolean test(FluidState fluidState) {
        if (this.tag.isPresent() && !fluidState.func_206884_a(this.tag.get())) {
            return false;
        }
        if (this.fluids.isPresent() && this.fluids.get().stream().noneMatch(either -> (Boolean)either.map(tag -> tag.func_230235_a_((Object)fluidState.func_206886_c()), fluid -> fluid == fluidState.func_206886_c()))) {
            return false;
        }
        return !this.state.isPresent() || this.state.get().test(fluidState);
    }

    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FluidRequirement that = (FluidRequirement)obj;
        return this.fluids.equals(that.fluids) && this.tag.equals(that.tag) && this.state.equals(that.state) && this.nbt.equals(that.nbt);
    }
}

