/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.EnchantmentRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tags.ITag;
import net.minecraft.util.registry.Registry;

public class ItemRequirement {
    private final List<Either<ITag<Item>, Item>> items;
    private final Optional<IntegerBounds> count;
    private final Optional<IntegerBounds> durability;
    private final Optional<List<EnchantmentRequirement>> enchantments;
    private final Optional<Potion> potion;
    private final NbtRequirement nbt;
    private final Optional<Predicate<ItemStack>> predicate;
    public static final Codec<ItemRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConfigHelper.tagOrBuiltinCodec(Registry.field_239714_o_, Registry.field_212630_s).listOf().optionalFieldOf("items", Arrays.asList(new Either[0])).forGetter(predicate -> predicate.items), (App)IntegerBounds.CODEC.optionalFieldOf("count").forGetter(predicate -> predicate.count), (App)IntegerBounds.CODEC.optionalFieldOf("durability").forGetter(predicate -> predicate.durability), (App)EnchantmentRequirement.CODEC.listOf().optionalFieldOf("enchantments").forGetter(predicate -> predicate.enchantments), (App)Registry.field_212621_j.optionalFieldOf("potion").forGetter(predicate -> predicate.potion), (App)NbtRequirement.CODEC.optionalFieldOf("nbt", (Object)new NbtRequirement()).forGetter(predicate -> predicate.nbt)).apply((Applicative)instance, ItemRequirement::new));
    public static final ItemRequirement NONE = new ItemRequirement(Arrays.asList(new Either[0]), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), new NbtRequirement());

    public ItemRequirement(List<Either<ITag<Item>, Item>> items, Optional<IntegerBounds> count, Optional<IntegerBounds> durability, Optional<List<EnchantmentRequirement>> enchantments, Optional<Potion> potion, NbtRequirement nbt, Optional<Predicate<ItemStack>> predicate) {
        this.items = items;
        this.count = count;
        this.durability = durability;
        this.enchantments = enchantments;
        this.potion = potion;
        this.nbt = nbt;
        this.predicate = predicate;
    }

    public ItemRequirement(List<Either<ITag<Item>, Item>> items, Optional<IntegerBounds> count, Optional<IntegerBounds> durability, Optional<List<EnchantmentRequirement>> enchantments, Optional<Potion> potion, NbtRequirement nbt) {
        this(items, count, durability, enchantments, potion, nbt, Optional.empty());
    }

    public ItemRequirement(List<Either<ITag<Item>, Item>> items, NbtRequirement nbt) {
        this(items, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), nbt);
    }

    public ItemRequirement(Collection<Item> items, Predicate<ItemStack> predicate) {
        this(items.stream().map(Either::right).collect(Collectors.toList()), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), new NbtRequirement(), Optional.ofNullable(predicate));
    }

    public ItemRequirement(Predicate<ItemStack> predicate) {
        this(Arrays.asList(new Either[0]), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), new NbtRequirement(), Optional.of(predicate));
    }

    public List<Either<ITag<Item>, Item>> items() {
        return this.items;
    }

    public Optional<IntegerBounds> count() {
        return this.count;
    }

    public Optional<IntegerBounds> durability() {
        return this.durability;
    }

    public Optional<List<EnchantmentRequirement>> enchantments() {
        return this.enchantments;
    }

    public Optional<Potion> potion() {
        return this.potion;
    }

    public NbtRequirement nbt() {
        return this.nbt;
    }

    public Optional<Predicate<ItemStack>> predicate() {
        return this.predicate;
    }

    public boolean test(ItemStack stack, boolean ignoreCount) {
        block12: {
            if (stack.func_190926_b() && !this.items.isEmpty()) {
                return false;
            }
            if (!this.items.isEmpty()) {
                for (int i = 0; i < this.items.size(); ++i) {
                    Either<ITag<Item>, Item> either = this.items.get(i);
                    if (!((Boolean)either.map(tag -> tag.func_230235_a_((Object)stack.func_77973_b()), item -> stack.func_77973_b() == item)).booleanValue()) {
                        continue;
                    }
                    break block12;
                }
                return false;
            }
        }
        if (this.predicate.isPresent()) {
            return this.predicate.get().test(stack);
        }
        if (!this.nbt.test((INBT)stack.func_77978_p())) {
            return false;
        }
        if (!ignoreCount && this.count.isPresent() && !this.count.get().test(stack.func_190916_E())) {
            return false;
        }
        if (this.durability.isPresent() && !this.durability.get().test(stack.func_77958_k() - stack.func_77952_i())) {
            return false;
        }
        if (this.potion.isPresent() && !this.potion.get().func_185170_a().equals(PotionUtils.func_185191_c((ItemStack)stack).func_185170_a())) {
            return false;
        }
        if (!this.nbt.test((INBT)stack.func_77978_p())) {
            return false;
        }
        if (this.enchantments.isPresent()) {
            Map stackEnchantments = EnchantmentHelper.func_226652_a_((ListNBT)stack.func_77986_q());
            stackEnchantments.putAll(EnchantmentHelper.func_226652_a_((ListNBT)EnchantedBookItem.func_92110_g((ItemStack)stack)));
            for (EnchantmentRequirement enchantment : this.enchantments.get()) {
                if (enchantment.test(stackEnchantments)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ItemRequirement that = (ItemRequirement)obj;
        return this.items.equals(that.items) && this.count.equals(that.count) && this.durability.equals(that.durability) && this.enchantments.equals(that.enchantments) && this.potion.equals(that.potion) && this.nbt.equals(that.nbt) && this.predicate.equals(that.predicate);
    }
}

