/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.BlockRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.FluidRequirement;
import com.momosoftworks.coldsweat.data.codec.util.BlockInWorld;
import com.momosoftworks.coldsweat.data.codec.util.ExtraCodecs;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.data.codec.util.WorldTempBounds;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;

public class LocationRequirement {
    private final Optional<IntegerBounds> x;
    private final Optional<IntegerBounds> y;
    private final Optional<IntegerBounds> z;
    int xOffset;
    int yOffset;
    int zOffset;
    private final Optional<RegistryKey<Biome>> biome;
    private final Optional<RegistryKey<Structure<?>>> structure;
    private final Optional<RegistryKey<World>> dimension;
    private final Optional<IntegerBounds> light;
    private final Optional<BlockRequirement> block;
    private final Optional<FluidRequirement> fluid;
    private final Optional<WorldTempBounds> temperature;
    private final Optional<Predicate<BlockInWorld>> predicate;
    public static final Codec<LocationRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntegerBounds.CODEC.optionalFieldOf("x").forGetter(location -> location.x), (App)IntegerBounds.CODEC.optionalFieldOf("y").forGetter(location -> location.y), (App)IntegerBounds.CODEC.optionalFieldOf("z").forGetter(location -> location.z), (App)Codec.INT.optionalFieldOf("x_offset", (Object)0).forGetter(location -> location.xOffset), (App)Codec.INT.optionalFieldOf("y_offset", (Object)0).forGetter(location -> location.yOffset), (App)Codec.INT.optionalFieldOf("z_offset", (Object)0).forGetter(location -> location.zOffset), (App)ExtraCodecs.codec(Registry.field_239720_u_).optionalFieldOf("biome").forGetter(location -> location.biome), (App)ExtraCodecs.codec(Registry.field_239671_I_).optionalFieldOf("structure").forGetter(location -> location.structure), (App)ExtraCodecs.codec(Registry.field_239699_ae_).optionalFieldOf("dimension").forGetter(location -> location.dimension), (App)IntegerBounds.CODEC.optionalFieldOf("light").forGetter(location -> location.light), (App)BlockRequirement.CODEC.optionalFieldOf("block").forGetter(location -> location.block), (App)FluidRequirement.CODEC.optionalFieldOf("fluid").forGetter(location -> location.fluid), (App)WorldTempBounds.CODEC.optionalFieldOf("temperature").forGetter(location -> location.temperature)).apply((Applicative)instance, LocationRequirement::new));
    public static final LocationRequirement NONE = new LocationRequirement(Optional.empty(), Optional.empty(), Optional.empty(), 0, 0, 0, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());

    public LocationRequirement(Optional<IntegerBounds> x, Optional<IntegerBounds> y, Optional<IntegerBounds> z, int xOffset, int yOffset, int zOffset, Optional<RegistryKey<Biome>> biome, Optional<RegistryKey<Structure<?>>> structure, Optional<RegistryKey<World>> dimension, Optional<IntegerBounds> light, Optional<BlockRequirement> block, Optional<FluidRequirement> fluid, Optional<WorldTempBounds> temperature, Optional<Predicate<BlockInWorld>> predicate) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
        this.biome = biome;
        this.structure = structure;
        this.dimension = dimension;
        this.light = light;
        this.block = block;
        this.fluid = fluid;
        this.temperature = temperature;
        this.predicate = predicate;
    }

    public LocationRequirement(Optional<IntegerBounds> x, Optional<IntegerBounds> y, Optional<IntegerBounds> z, int xOffset, int yOffset, int zOffset, Optional<RegistryKey<Biome>> biome, Optional<RegistryKey<Structure<?>>> structure, Optional<RegistryKey<World>> dimension, Optional<IntegerBounds> light, Optional<BlockRequirement> block, Optional<FluidRequirement> fluid, Optional<WorldTempBounds> temperature) {
        this(x, y, z, xOffset, yOffset, zOffset, biome, structure, dimension, light, block, fluid, temperature, Optional.empty());
    }

    public LocationRequirement(Predicate<BlockInWorld> predicate) {
        this(Optional.empty(), Optional.empty(), Optional.empty(), 0, 0, 0, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(predicate));
    }

    public Optional<IntegerBounds> x() {
        return this.x;
    }

    public Optional<IntegerBounds> y() {
        return this.y;
    }

    public Optional<IntegerBounds> z() {
        return this.z;
    }

    public int xOffset() {
        return this.xOffset;
    }

    public int yOffset() {
        return this.yOffset;
    }

    public int zOffset() {
        return this.zOffset;
    }

    public Optional<RegistryKey<Biome>> biome() {
        return this.biome;
    }

    public Optional<RegistryKey<Structure<?>>> structure() {
        return this.structure;
    }

    public Optional<RegistryKey<World>> dimension() {
        return this.dimension;
    }

    public Optional<IntegerBounds> light() {
        return this.light;
    }

    public Optional<BlockRequirement> block() {
        return this.block;
    }

    public Optional<FluidRequirement> fluid() {
        return this.fluid;
    }

    public Optional<WorldTempBounds> temperature() {
        return this.temperature;
    }

    public boolean test(World level, Vector3d pos) {
        return this.test(level, new BlockPos(pos));
    }

    public boolean test(World level, BlockPos origin) {
        int light;
        if (this.predicate.isPresent()) {
            return this.predicate.get().test(new BlockInWorld((IWorldReader)level, origin, true));
        }
        BlockPos.Mutable pos = origin.func_239590_i_();
        pos.func_196234_d(this.xOffset, this.yOffset, this.zOffset);
        if (!this.x.map(range -> range.test(pos.func_177958_n())).orElse(true).booleanValue()) {
            return false;
        }
        if (!this.y.map(range -> range.test(pos.func_177956_o())).orElse(true).booleanValue()) {
            return false;
        }
        if (!this.z.map(range -> range.test(pos.func_177952_p())).orElse(true).booleanValue()) {
            return false;
        }
        if (this.dimension.isPresent() && !level.func_234923_W_().equals(this.dimension.get())) {
            return false;
        }
        if (this.biome.isPresent() && !this.biome.get().func_240901_a_().equals((Object)level.func_226691_t_((BlockPos)pos).getRegistryName())) {
            return false;
        }
        if (this.structure.isPresent() && WorldHelper.getServerLevel(level).func_241112_a_().func_235010_a_((BlockPos)pos, false, (Structure)level.func_241828_r().func_243612_b(Registry.field_239671_I_).func_230516_a_(this.structure.get())) == StructureStart.field_214630_a) {
            return false;
        }
        if (this.light.isPresent() && ((light = level.func_201696_r((BlockPos)pos)) < this.light.get().min || light > this.light.get().max)) {
            return false;
        }
        if (this.block.isPresent() && !this.block.get().test(level, (BlockPos)pos)) {
            return false;
        }
        if (this.fluid.isPresent() && !this.fluid.get().test(level, (BlockPos)pos)) {
            return false;
        }
        return !this.temperature.isPresent() || this.temperature.get().test(WorldHelper.getRoughTemperatureAt(level, (BlockPos)pos));
    }

    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LocationRequirement that = (LocationRequirement)obj;
        return this.x.equals(that.x) && this.y.equals(that.y) && this.z.equals(that.z) && this.biome.equals(that.biome) && this.structure.equals(that.structure) && this.dimension.equals(that.dimension) && this.light.equals(that.light) && this.block.equals(that.block) && this.fluid.equals(that.fluid);
    }
}

