/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.NBTPredicate;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.StringNBT;

public class NbtRequirement {
    private final CompoundNBT tag;
    public static final Codec<NbtRequirement> CODEC = CompoundNBT.field_240597_a_.xmap(NbtRequirement::new, req -> req.tag);
    public static final NbtRequirement NONE = new NbtRequirement();

    public NbtRequirement(CompoundNBT tag) {
        this.tag = tag;
    }

    public NbtRequirement() {
        this(new CompoundNBT());
    }

    public CompoundNBT tag() {
        return this.tag;
    }

    public boolean test(ItemStack pStack) {
        return this.tag.isEmpty() || this.test((INBT)pStack.func_77978_p());
    }

    public boolean test(Entity pEntity) {
        return this.tag.isEmpty() || this.test((INBT)NBTPredicate.func_196981_b((Entity)pEntity));
    }

    public boolean test(@Nullable INBT pTag) {
        if (pTag == null) {
            return this.tag.isEmpty();
        }
        return NbtRequirement.compareNbt((INBT)this.tag, pTag, true);
    }

    public boolean isEmpty() {
        return this.tag.isEmpty();
    }

    public static boolean compareNbt(@Nullable INBT tag, @Nullable INBT other, boolean compareListNBT) {
        if (tag == other) {
            return true;
        }
        if (tag == null) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (tag.equals(other)) {
            return true;
        }
        if (tag instanceof CompoundNBT) {
            return NbtRequirement.handleCompoundNBTComparison((CompoundNBT)tag, other, compareListNBT);
        }
        if (tag instanceof ListNBT && other instanceof ListNBT && compareListNBT) {
            return NbtRequirement.compareListNBTs((ListNBT)tag, (ListNBT)other, compareListNBT);
        }
        if (tag instanceof StringNBT && other instanceof NumberNBT) {
            return NbtRequirement.compareNumericRange((StringNBT)tag, (NumberNBT)other);
        }
        if (tag instanceof NumberNBT && other instanceof NumberNBT) {
            return NbtRequirement.compareNumbers((NumberNBT)tag, (NumberNBT)other);
        }
        return false;
    }

    private static boolean handleCompoundNBTComparison(CompoundNBT compoundTag, INBT other, boolean compareListNBT) {
        ListNBT containsAllValues;
        if (other instanceof CompoundNBT) {
            CompoundNBT otherCompound = (CompoundNBT)other;
            for (String key : compoundTag.func_150296_c()) {
                if (NbtRequirement.compareNbt(compoundTag.func_74781_a(key), otherCompound.func_74781_a(key), compareListNBT)) continue;
                return false;
            }
            return true;
        }
        if (compoundTag.func_150296_c().size() != 1) {
            return false;
        }
        ListNBT anyOfValues = (ListNBT)compoundTag.func_74781_a("cs:any_of");
        if (anyOfValues != null && !anyOfValues.isEmpty()) {
            for (int i = 0; i < anyOfValues.size(); ++i) {
                INBT value = anyOfValues.get(i);
                if (!NbtRequirement.compareNbt(value, other, compareListNBT)) continue;
                return true;
            }
            return false;
        }
        ListNBT containsAnyValues = (ListNBT)compoundTag.func_74781_a("cs:contains_any");
        if (containsAnyValues != null && !containsAnyValues.isEmpty() && other instanceof ListNBT) {
            ListNBT otherList = (ListNBT)other;
            for (int i = 0; i < containsAnyValues.size(); ++i) {
                INBT value = containsAnyValues.get(i);
                for (int i1 = 0; i1 < otherList.size(); ++i1) {
                    INBT otherValue = otherList.get(i1);
                    if (!NbtRequirement.compareNbt(value, otherValue, compareListNBT)) continue;
                    return true;
                }
            }
        }
        if ((containsAllValues = (ListNBT)compoundTag.func_74781_a("cs:contains_all")) != null && !containsAllValues.isEmpty() && other instanceof ListNBT) {
            ListNBT otherList = (ListNBT)other;
            block4: for (int i = 0; i < containsAllValues.size(); ++i) {
                INBT value = containsAllValues.get(i);
                for (int i1 = 0; i1 < otherList.size(); ++i1) {
                    INBT otherValue = otherList.get(i1);
                    if (NbtRequirement.compareNbt(value, otherValue, compareListNBT)) continue block4;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean compareListNBTs(ListNBT list1, ListNBT list2, boolean compareListNBT) {
        if (list1.isEmpty()) {
            return list2.isEmpty();
        }
        return list1.stream().allMatch(element -> IntStream.range(0, list2.size()).anyMatch(j -> NbtRequirement.compareNbt(element, list2.get(j), compareListNBT)));
    }

    private static boolean compareNumericRange(StringNBT rangeTag, NumberNBT numberTag) {
        try {
            String[] parts = rangeTag.func_150285_a_().split("-");
            if (parts.length != 2) {
                return false;
            }
            double min = Double.parseDouble(parts[0]);
            double max = Double.parseDouble(parts[1]);
            double value = numberTag.func_150286_g();
            return CSMath.betweenInclusive(value, min, max);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean compareNumbers(NumberNBT tag, NumberNBT other) {
        return tag.func_150286_g() == other.func_150286_g();
    }

    public String toString() {
        return "NbtRequirement{tag=" + this.tag + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NbtRequirement that = (NbtRequirement)obj;
        return this.tag.equals((Object)that.tag);
    }
}

