/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement.sub_type;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.PlayerDataRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.sub_type.FishingHookRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.sub_type.PiglinNeutralArmorRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.sub_type.RaiderRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.sub_type.SlimeRequirement;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public interface EntitySubRequirement {
    public static final BiMap<ResourceLocation, Supplier<MapCodec<? extends EntitySubRequirement>>> REQUIREMENT_MAP = HashBiMap.create(CSMath.mapOf(new ResourceLocation("fishing_hook"), () -> FishingHookRequirement.CODEC, new ResourceLocation("piglin_neutral_armor"), () -> PiglinNeutralArmorRequirement.CODEC, new ResourceLocation("player"), () -> PlayerDataRequirement.getCodec(EntityRequirement.getCodec()), new ResourceLocation("raider"), () -> RaiderRequirement.CODEC, new ResourceLocation("slime"), () -> SlimeRequirement.CODEC));
    public static final Codec<EntitySubRequirement> CODEC = ResourceLocation.field_240908_a_.dispatch("type", requirement -> {
        Supplier matchingSupplier = REQUIREMENT_MAP.values().stream().filter(supplier -> ((MapCodec)supplier.get()).equals(((EntitySubRequirement)requirement).getCodec())).findFirst().orElseThrow(() -> new IllegalStateException("Unknown requirement type: " + requirement.getClass()));
        return (ResourceLocation)REQUIREMENT_MAP.inverse().get((Object)matchingSupplier);
    }, location -> {
        Supplier supplier = (Supplier)REQUIREMENT_MAP.get(location);
        if (supplier == null) {
            throw new IllegalStateException("Unknown requirement type: " + location);
        }
        return (Codec)supplier.get();
    });

    default public ResourceLocation getType() {
        return (ResourceLocation)REQUIREMENT_MAP.inverse().get(this.getCodec());
    }

    public boolean test(Entity var1, World var2, @Nullable Vector3d var3);

    public MapCodec<? extends EntitySubRequirement> getCodec();
}

