/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.data.codec.util.AttributeCodecs;
import com.momosoftworks.coldsweat.util.math.FastMultiMap;
import com.momosoftworks.coldsweat.util.serialization.NbtSerializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AttributeModifierMap
implements NbtSerializable {
    public static final Codec<AttributeModifierMap> CODEC = Codec.unboundedMap(AttributeCodecs.ATTRIBUTE_CODEC, (Codec)AttributeCodecs.MODIFIER_CODEC.listOf()).xmap(AttributeModifierMap::new, map -> map.getMap().asMap().entrySet().stream().collect(HashMap::new, (mp, ent) -> {
        List cfr_ignored_0 = mp.put(ent.getKey(), new ArrayList((Collection)ent.getValue()));
    }, HashMap::putAll));
    private final Multimap<Attribute, AttributeModifier> map = new FastMultiMap<Attribute, AttributeModifier>();

    public AttributeModifierMap() {
    }

    public AttributeModifierMap(Map<Attribute, ?> attributeListMap) {
        attributeListMap.forEach((attribute, list) -> {
            if (list instanceof Collection) {
                this.map.putAll(attribute, (Iterable)((Collection)list));
            } else if (list instanceof AttributeModifier) {
                this.map.put(attribute, (Object)((AttributeModifier)list));
            }
        });
    }

    public AttributeModifierMap(Multimap<Attribute, AttributeModifier> map) {
        this.map.putAll(map);
    }

    public void put(Attribute attribute, AttributeModifier modifier) {
        this.map.put((Object)attribute, (Object)modifier);
    }

    public Collection<AttributeModifier> get(Attribute attribute) {
        return this.map.get((Object)attribute);
    }

    public Multimap<Attribute, AttributeModifier> getMap() {
        return this.map;
    }

    public AttributeModifierMap putAll(AttributeModifierMap other) {
        this.map.putAll(other.map);
        return this;
    }

    public AttributeModifierMap putAll(Attribute attribute, Collection<AttributeModifier> modifiers) {
        this.map.putAll((Object)attribute, modifiers);
        return this;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clear() {
        this.map.clear();
    }

    @Override
    public CompoundNBT serialize() {
        CompoundNBT tag = new CompoundNBT();
        this.map.asMap().forEach((attribute, modifier) -> {
            String key = ForgeRegistries.ATTRIBUTES.getKey((IForgeRegistryEntry)attribute).toString();
            ListNBT list = new ListNBT();
            modifier.forEach(mod -> list.add((Object)mod.func_233801_e_()));
            tag.func_218657_a(key, (INBT)list);
        });
        return tag;
    }

    public static AttributeModifierMap deserialize(CompoundNBT tag) {
        if (tag.isEmpty()) {
            return new AttributeModifierMap();
        }
        HashMultimap map = HashMultimap.create();
        tag.func_150296_c().forEach(arg_0 -> AttributeModifierMap.lambda$deserialize$6(tag, (Multimap)map, arg_0));
        return new AttributeModifierMap((Multimap<Attribute, AttributeModifier>)map);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeModifierMap that = (AttributeModifierMap)obj;
        for (Map.Entry entry : this.map.asMap().entrySet()) {
            if (!that.map.containsKey(entry.getKey())) {
                return false;
            }
            Collection other = that.map.get(entry.getKey());
            if (((Collection)entry.getValue()).size() != other.size()) {
                return false;
            }
            Iterator thatIterator = other.iterator();
            for (AttributeModifier modifier : (Collection)entry.getValue()) {
                if (!thatIterator.hasNext()) {
                    return false;
                }
                AttributeModifier thatModifier = (AttributeModifier)thatIterator.next();
                if (Double.compare(modifier.func_111164_d(), thatModifier.func_111164_d()) == 0 && modifier.func_220375_c() == thatModifier.func_220375_c() && modifier.func_111166_b().equals(thatModifier.func_111166_b())) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void lambda$deserialize$6(CompoundNBT tag, Multimap map, String key) {
        Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(key));
        ListNBT list = tag.func_150295_c(key, 10);
        list.forEach(mod -> map.put((Object)attribute, (Object)AttributeModifier.func_233800_a_((CompoundNBT)((CompoundNBT)mod))));
    }
}

