/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.util;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class ExtraCodecs {
    public static final Codec<EquipmentSlotType> EQUIPMENT_SLOT = Codec.STRING.xmap(EquipmentSlotType::func_188451_a, EquipmentSlotType::func_188450_d);
    private static final Map<String, RegistryKey<?>> REGISTRY_VALUES = Collections.synchronizedMap(Maps.newIdentityHashMap());

    public static <T> Codec<RegistryKey<T>> codec(RegistryKey<? extends Registry<T>> p_195967_) {
        return ResourceLocation.field_240908_a_.xmap(p_195979_ -> ExtraCodecs.create(p_195967_, p_195979_), RegistryKey::func_240901_a_);
    }

    public static <T> RegistryKey<T> create(RegistryKey<? extends Registry<T>> pRegistryKey, ResourceLocation pLocation) {
        String s = (pRegistryKey + ":" + pLocation).intern();
        return REGISTRY_VALUES.computeIfAbsent(s, p_195971_ -> RegistryKey.func_240903_a_((RegistryKey)pRegistryKey, (ResourceLocation)pLocation));
    }

    public static Codec<Object> anyOf(final Codec<?> ... codecs) {
        return new Codec<Object>(){

            public <T> DataResult<T> encode(Object input, DynamicOps<T> ops, T prefix) {
                for (Codec codec : codecs) {
                    try {
                        DataResult result = codec.encode(input, ops, prefix);
                        if (!result.result().isPresent()) continue;
                        return result;
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                return DataResult.error((String)("No codecs could encode input " + input));
            }

            public <T> DataResult<Pair<Object, T>> decode(DynamicOps<T> ops, T input) {
                for (Codec codec : codecs) {
                    DataResult result = codec.decode(ops, input);
                    if (!result.result().isPresent()) continue;
                    return result;
                }
                return DataResult.error((String)("No codecs could decode input " + input));
            }
        };
    }

    public static <E> Codec<E> orCompressed(final Codec<E> pFirst, final Codec<E> pSecond) {
        return new Codec<E>(){

            public <T> DataResult<T> encode(E p_184483_, DynamicOps<T> p_184484_, T p_184485_) {
                return p_184484_.compressMaps() ? pSecond.encode(p_184483_, p_184484_, p_184485_) : pFirst.encode(p_184483_, p_184484_, p_184485_);
            }

            public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> p_184480_, T p_184481_) {
                return p_184480_.compressMaps() ? pSecond.decode(p_184480_, p_184481_) : pFirst.decode(p_184480_, p_184481_);
            }

            public String toString() {
                return pFirst + " orCompressed " + pSecond;
            }
        };
    }

    public static <E> Codec<E> stringResolverCodec(Function<E, String> encoder, Function<String, E> decoder) {
        return Codec.STRING.flatXmap(p_184404_ -> Optional.ofNullable(decoder.apply((String)p_184404_)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown element name:" + p_184404_))), p_184401_ -> Optional.ofNullable(encoder.apply(p_184401_)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Element with unknown name: " + p_184401_))));
    }

    public static <E> Codec<E> idResolverCodec(ToIntFunction<E> encoder, IntFunction<E> decoder, int id) {
        return Codec.INT.flatXmap(p_184414_ -> Optional.ofNullable(decoder.apply((int)p_184414_)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown element id: " + p_184414_))), p_274850_ -> {
            int i = encoder.applyAsInt(p_274850_);
            return i == id ? DataResult.error((String)("Element with unknown id: " + p_274850_)) : DataResult.success((Object)i);
        });
    }
}

