/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class NegatableList<T> {
    private final List<T> requirements;
    private final List<T> exclusions;
    private final boolean singleton;

    public static <T> Codec<NegatableList<T>> codec(Codec<T> codec) {
        Codec listCodec = RecordCodecBuilder.create(instance -> instance.group((App)codec.listOf().fieldOf("require").forGetter(predicate -> predicate.requirements), (App)codec.listOf().optionalFieldOf("exclude", Arrays.asList(new Object[0])).forGetter(predicate -> predicate.exclusions)).apply((Applicative)instance, NegatableList::new));
        return Codec.either((Codec)listCodec, codec).comapFlatMap(either -> {
            if (either.left().isPresent()) {
                return DataResult.success(either.left().get());
            }
            return DataResult.success(new NegatableList<Object>(Arrays.asList(either.right().get())));
        }, list -> {
            if (list.singleton && list.exclusions.isEmpty()) {
                return Either.right(list.requirements.get(0));
            }
            return Either.left((Object)list);
        });
    }

    public static <T> Codec<NegatableList<T>> listCodec(Codec<T> codec) {
        Codec listCodec = RecordCodecBuilder.create(instance -> instance.group((App)codec.listOf().fieldOf("require").forGetter(predicate -> predicate.requirements), (App)codec.listOf().optionalFieldOf("exclude", Arrays.asList(new Object[0])).forGetter(predicate -> predicate.exclusions)).apply((Applicative)instance, NegatableList::new));
        return Codec.either((Codec)listCodec, (Codec)codec.listOf()).comapFlatMap(either -> {
            if (either.left().isPresent()) {
                return DataResult.success(either.left().get());
            }
            return DataResult.success(new NegatableList((List)either.right().get()));
        }, list -> {
            if (list.singleton && list.exclusions.isEmpty()) {
                return Either.right(list.requirements);
            }
            return Either.left((Object)list);
        });
    }

    public NegatableList() {
        this.requirements = new ArrayList<T>();
        this.exclusions = new ArrayList<T>();
        this.singleton = false;
    }

    public NegatableList(T requirement) {
        this.requirements = new ArrayList<Object>(Arrays.asList(requirement));
        this.exclusions = new ArrayList<T>();
        this.singleton = true;
    }

    public NegatableList(List<T> requirements) {
        this.requirements = new ArrayList<T>(requirements);
        this.exclusions = new ArrayList<T>();
        this.singleton = requirements.size() == 1;
    }

    public NegatableList(List<T> requirements, List<T> exclusions) {
        this.requirements = new ArrayList<T>(requirements);
        this.exclusions = new ArrayList<T>(exclusions);
        this.singleton = exclusions.isEmpty() && requirements.size() == 1;
    }

    public List<T> requirements() {
        return this.requirements;
    }

    public List<T> exclusions() {
        return this.exclusions;
    }

    public void add(T element, boolean negate) {
        if (negate) {
            this.exclusions.add(element);
        } else {
            this.requirements.add(element);
        }
    }

    public boolean isEmpty() {
        return this.requirements.isEmpty() && this.exclusions.isEmpty();
    }

    public <N> Optional<N> flatMap(Function<T, N> mapper, BinaryOperator<N> reducer, BiConsumer<N, N> remover) {
        Optional<N> requiredResult = this.requirements.stream().map(mapper).reduce(reducer);
        Optional<N> exclusionResult = this.exclusions.stream().map(mapper).reduce(reducer);
        if (requiredResult.isPresent() && exclusionResult.isPresent()) {
            remover.accept(requiredResult.get(), exclusionResult.get());
        }
        return requiredResult;
    }

    public <N> Optional<N> flatMap(Function<T, N> mapper, BinaryOperator<N> reducer) {
        return this.flatMap(mapper, reducer, (a, b) -> {});
    }

    public <N> List<N> listMap(Function<T, N> mapper) {
        return this.flatMap(mapper.andThen(p -> CSMath.mutable(Arrays.asList(p))), (xva$0, xva$1) -> CSMath.merge(xva$0, xva$1), List::removeAll).orElse(Arrays.asList(new Object[0]));
    }

    public List<T> flatten() {
        return this.listMap(p -> p);
    }

    public <N> List<N> flatListMap(Function<T, List<N>> mapper) {
        return this.listMap(mapper).stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean test(Predicate<T> test) {
        int i;
        if (!this.requirements.isEmpty()) {
            for (i = 0; i < this.requirements.size(); ++i) {
                if (test.test(this.requirements.get(i))) continue;
                return false;
            }
        }
        if (!this.exclusions.isEmpty()) {
            for (i = 0; i < this.exclusions.size(); ++i) {
                if (!test.test(this.exclusions.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NegatableList that = (NegatableList)obj;
        return this.requirements.equals(that.requirements) && this.exclusions.equals(that.exclusions);
    }

    public String toString() {
        return "NegatableList{requirements=" + this.requirements + ", exclusions=" + this.exclusions + '}';
    }
}

