/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.WorldTempRequirement;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.Objects;

public class WorldTempBounds {
    private final WorldTempRequirement min;
    private final WorldTempRequirement max;
    public static final Codec<WorldTempBounds> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)WorldTempRequirement.CODEC.optionalFieldOf("min", (Object)WorldTempRequirement.NEGATIVE_INFINITY).forGetter(bounds -> bounds.min), (App)WorldTempRequirement.CODEC.optionalFieldOf("max", (Object)WorldTempRequirement.INFINITY).forGetter(bounds -> bounds.max)).apply((Applicative)instance, WorldTempBounds::new));
    public static final Codec<WorldTempBounds> CODEC = Codec.either(DIRECT_CODEC, WorldTempRequirement.CODEC).xmap(either -> (WorldTempBounds)either.map(left -> left, right -> new WorldTempBounds((WorldTempRequirement)right, (WorldTempRequirement)right)), bounds -> bounds.max.equals(bounds.min) ? Either.right((Object)bounds.min) : Either.left((Object)bounds));

    public WorldTempBounds(WorldTempRequirement min, WorldTempRequirement max) {
        this.min = min;
        this.max = max;
    }

    public WorldTempRequirement min() {
        return this.min;
    }

    public WorldTempRequirement max() {
        return this.max;
    }

    public boolean test(double value) {
        return value >= this.min.get() && value <= this.max.get();
    }

    public boolean contains(WorldTempBounds bounds) {
        return bounds.min.get() >= this.min.get() && bounds.max.get() <= this.max.get();
    }

    public double getRandom() {
        return this.min.get() + Math.random() * (this.max.get() - this.min.get());
    }

    public double clamp(double value) {
        return CSMath.clamp(value, this.min.get(), this.max.get());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorldTempBounds that = (WorldTempBounds)o;
        return Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max);
    }
}

