/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.Overlays;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModEffects;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.gui.ForgeIngameGui;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ForgeIngameGui.class})
public abstract class MixinHeartRender {
    private static final ResourceLocation HEART_TEXTURE = new ResourceLocation("cold_sweat", "textures/gui/overlay/hearts_frozen.png");
    private static int HEART_INDEX = 0;
    private static boolean IS_CONTAINER = false;

    @Shadow(remap=false)
    protected abstract void bind(ResourceLocation var1);

    @Inject(method={"renderHealth"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/client/gui/ForgeIngameGui;blit(Lcom/mojang/blaze3d/matrix/MatrixStack;IIIIII)V", shift=At.Shift.AFTER)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;ceil(F)I", ordinal=3), to=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;disableBlend()V"))}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true, remap=false)
    private void renderHeart(int width, int height, MatrixStack ps, CallbackInfo ci, PlayerEntity player, int health, boolean blink, int healthLast, ModifiableAttributeInstance attrMaxHealth, float healthMax, float absorb, int healthRows, int rowHeight, int left, int top, int regen, int TOP, int BACKGROUND, int MARGIN, float absorbRemaining, int i, int row, int x, int y) {
        int u;
        boolean halfHeart;
        double heartsFreezePercentage = ConfigSettings.HEARTS_FREEZING_PERCENTAGE.get();
        int hearts = CSMath.ceil((double)health / 2.0);
        int lastHeartIndex = (int)(healthMax / 2.0f - (float)hearts);
        boolean bl = halfHeart = HEART_INDEX == lastHeartIndex + 1 && health % 2 == 1;
        if (player == null) {
            return;
        }
        if (heartsFreezePercentage == 0.0 || player.func_70644_a(ModEffects.GRACE)) {
            return;
        }
        if (player.func_70644_a(ModEffects.ICE_RESISTANCE)) {
            return;
        }
        double temp = Overlays.BODY_TEMP;
        float maxHealth = player.func_110138_aP();
        boolean isHardcore = player.field_70170_p.func_72912_H().func_76093_s();
        float maxFrozenHealth = (float)CSMath.blend((double)maxHealth * heartsFreezePercentage, 0.0, Temperature.get((LivingEntity)player, Temperature.Trait.COLD_RESISTANCE), 0.0, 1.0);
        if (maxFrozenHealth == 0.0f) {
            return;
        }
        int frozenHealth = (int)CSMath.blend(0.0, (double)maxHealth * heartsFreezePercentage, temp, -50.0, -100.0);
        int frozenHearts = Math.round((float)frozenHealth / 2.0f);
        boolean partialFrozen = frozenHealth % 2 == 1 && HEART_INDEX == frozenHearts;
        int n = u = isHardcore ? 7 : 0;
        int v = partialFrozen ? (halfHeart ? 21 : 14) : (halfHeart ? 7 : 0);
        this.bind(HEART_TEXTURE);
        if (HEART_INDEX <= frozenHearts) {
            if (IS_CONTAINER) {
                AbstractGui.func_238463_a_((MatrixStack)ps, (int)(x + 1), (int)(y + 1), (float)14.0f, (float)v, (int)7, (int)7, (int)21, (int)28);
            } else {
                AbstractGui.func_238463_a_((MatrixStack)ps, (int)(x + 1), (int)(y + 1), (float)u, (float)v, (int)7, (int)7, (int)21, (int)28);
            }
        }
        this.bind(AbstractGui.field_230665_h_);
        IS_CONTAINER = false;
    }

    @Inject(method={"renderHealth"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;ceil(F)I", ordinal=4)}, remap=false)
    private void incrementHeartIndex(int width, int height, MatrixStack mStack, CallbackInfo ci) {
        ++HEART_INDEX;
        IS_CONTAINER = true;
    }

    @Inject(method={"renderHealth"}, at={@At(value="HEAD")}, remap=false)
    private void resetHeartIndex(int width, int height, MatrixStack mStack, CallbackInfo ci) {
        HEART_INDEX = 0;
    }
}

