/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.client.event.TooltipHandler;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.capability.insulation.IInsulatableCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.util.AttributeModifierMap;
import com.momosoftworks.coldsweat.util.math.FastMultiMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ItemStack.class})
public class MixinItemTooltip {
    ItemStack stack = (ItemStack)this;
    private static EquipmentSlotType CURRENT_SLOT_QUERY = null;
    private static Multimap<Attribute, AttributeModifier> INSULATION_MODIFIERS = new FastMultiMap<Attribute, AttributeModifier>();
    private static Multimap<Attribute, AttributeModifier> UNMET_MODIFIERS = new FastMultiMap<Attribute, AttributeModifier>();
    private static Attribute ATTRIBUTE = null;
    private static AttributeModifier MODIFIER = null;

    @Inject(method={"getTooltipLines"}, at={@At(value="FIELD", target="Lnet/minecraft/item/ItemStack$TooltipDisplayFlags;MODIFIERS:Lnet/minecraft/item/ItemStack$TooltipDisplayFlags;", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void injectBeforeAttributes(PlayerEntity player, ITooltipFlag advanced, CallbackInfoReturnable<List<ITextComponent>> cir, List<ITextComponent> tooltip) {
        ItemStack stack = (ItemStack)this;
        AttributeModifierMap insulatorAttributes = new AttributeModifierMap();
        AttributeModifierMap unmetInsulatorAttributes = new AttributeModifierMap();
        for (InsulatorData insulator : ConfigSettings.INSULATION_ITEMS.get().get((Object)stack.func_77973_b())) {
            if (TooltipHandler.passesRequirement(insulator)) {
                insulatorAttributes.putAll(insulator.attributes());
                continue;
            }
            unmetInsulatorAttributes.putAll(insulator.attributes());
        }
        if (!insulatorAttributes.isEmpty() || !unmetInsulatorAttributes.isEmpty()) {
            tooltip.add((ITextComponent)new StringTextComponent(""));
            tooltip.add((ITextComponent)new TranslationTextComponent("item.modifiers.insulation").func_240699_a_(TextFormatting.GRAY));
            TooltipHandler.addModifierTooltipLines(tooltip, insulatorAttributes, true, false);
            TooltipHandler.addModifierTooltipLines(tooltip, unmetInsulatorAttributes, true, true);
        }
        AttributeModifierMap curioAttributes = new AttributeModifierMap();
        AttributeModifierMap unmetCurioAttributes = new AttributeModifierMap();
        for (InsulatorData insulator : ConfigSettings.INSULATING_CURIOS.get().get((Object)stack.func_77973_b())) {
            if (TooltipHandler.passesRequirement(insulator)) {
                curioAttributes.putAll(insulator.attributes());
                continue;
            }
            unmetCurioAttributes.putAll(insulator.attributes());
        }
        if (!curioAttributes.isEmpty() || !unmetCurioAttributes.isEmpty()) {
            tooltip.add((ITextComponent)new StringTextComponent(""));
            tooltip.add((ITextComponent)new TranslationTextComponent("item.modifiers.curio").func_240699_a_(TextFormatting.GRAY));
            TooltipHandler.addModifierTooltipLines(tooltip, curioAttributes, true, false);
            TooltipHandler.addModifierTooltipLines(tooltip, unmetCurioAttributes, true, true);
        }
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getAttributeModifiers(Lnet/minecraft/inventory/EquipmentSlotType;)Lcom/google/common/collect/Multimap;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void setCurrentSlot(PlayerEntity pPlayer, ITooltipFlag pIsAdvanced, CallbackInfoReturnable<List<ITextComponent>> cir, List<TextComponent> tooltip, IFormattableTextComponent itemName, int i, EquipmentSlotType[] allSlots, int var7, int var8, EquipmentSlotType slot) {
        CURRENT_SLOT_QUERY = slot;
    }

    @ModifyVariable(method={"getTooltipLines"}, at=@At(value="STORE", ordinal=0), ordinal=0)
    private Multimap<Attribute, AttributeModifier> modifyAttributeModifiers(Multimap<Attribute, AttributeModifier> original, PlayerEntity player, ITooltipFlag advanced) {
        INSULATION_MODIFIERS.clear();
        UNMET_MODIFIERS.clear();
        ListMultimap modifiers = MultimapBuilder.linkedHashKeys().arrayListValues().build(original);
        if (MobEntity.func_184640_d((ItemStack)this.stack) == CURRENT_SLOT_QUERY) {
            for (InsulatorData insulator : ConfigSettings.INSULATING_ARMORS.get().get((Object)this.stack.func_77973_b())) {
                modifiers.putAll(insulator.attributes().getMap());
                if (TooltipHandler.passesRequirement(insulator)) {
                    INSULATION_MODIFIERS.putAll(insulator.attributes().getMap());
                    continue;
                }
                UNMET_MODIFIERS.putAll(insulator.attributes().getMap());
            }
            ItemInsulationManager.getInsulationCap(this.stack).ifPresent(arg_0 -> MixinItemTooltip.lambda$modifyAttributeModifiers$1((Multimap)modifiers, arg_0));
        }
        return modifiers;
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z")}, slice={@Slice(from=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=7), to=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=9))}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void setupCustomAttributeDisplay(PlayerEntity pPlayer, ITooltipFlag pIsAdvanced, CallbackInfoReturnable<List<ITextComponent>> cir, List<ITextComponent> tooltip, IFormattableTextComponent name, int hideFlags, EquipmentSlotType[] var6, int var7, int var8, EquipmentSlotType equipmentslot, Multimap<Attribute, AttributeModifier> attributeMap, Iterator<AttributeModifier> entryIterator, Map.Entry<Attribute, AttributeModifier> entry) {
        ATTRIBUTE = entry.getKey();
        MODIFIER = entry.getValue();
    }

    @ModifyArg(method={"getTooltipLines"}, at=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z"), slice=@Slice(from=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=7), to=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=9)))
    private <E> E customAttributeFormatting(E obj) {
        if (obj instanceof IFormattableTextComponent && ATTRIBUTE != null && MODIFIER != null) {
            boolean isFromInsulation;
            IFormattableTextComponent component = (IFormattableTextComponent)obj;
            boolean hasUnmetRequirements = UNMET_MODIFIERS.remove((Object)ATTRIBUTE, (Object)MODIFIER);
            boolean bl = isFromInsulation = INSULATION_MODIFIERS.remove((Object)ATTRIBUTE, (Object)MODIFIER) || hasUnmetRequirements;
            if (EntityTempManager.isTemperatureAttribute(ATTRIBUTE)) {
                IFormattableTextComponent newline = TooltipHandler.getFormattedAttributeModifier(ATTRIBUTE, MODIFIER.func_111164_d(), MODIFIER.func_220375_c(), isFromInsulation, hasUnmetRequirements);
                for (ITextComponent sibling : component.func_150253_a()) {
                    newline = newline.func_230529_a_(sibling);
                }
                return (E)newline;
            }
            return (E)TooltipHandler.addTooltipFlags(component, isFromInsulation, hasUnmetRequirements);
        }
        return obj;
    }

    private static /* synthetic */ void lambda$modifyAttributeModifiers$1(Multimap modifiers, IInsulatableCap cap) {
        cap.getInsulation().stream().map(Pair::getFirst).forEach(item -> {
            for (InsulatorData insulator : ConfigSettings.INSULATION_ITEMS.get().get((Object)item.func_77973_b())) {
                modifiers.putAll(insulator.attributes().getMap());
                if (TooltipHandler.passesRequirement(insulator)) {
                    INSULATION_MODIFIERS.putAll(insulator.attributes().getMap());
                    continue;
                }
                UNMET_MODIFIERS.putAll(insulator.attributes().getMap());
            }
        });
    }
}

