/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.client.event.HandleSoulLampAnim;
import com.momosoftworks.coldsweat.client.event.RenderLampHand;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.entity.EntityHelper;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={BipedModel.class})
public class MixinSoulLampRendering {
    BipedModel model = (BipedModel)this;
    @Final
    @Shadow
    public ModelRenderer field_178723_h;
    @Final
    @Shadow
    public ModelRenderer field_178724_i;

    @Inject(method={"poseRightArm"}, at={@At(value="TAIL")})
    public void poseRightArm(LivingEntity entity, CallbackInfo ci) {
        boolean holdingLamp = EntityHelper.holdingLamp(entity, HandSide.RIGHT);
        Pair<Float, Float> armRot = HandleSoulLampAnim.RIGHT_ARM_ROTATIONS.getOrDefault(entity, (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)));
        float rightArmRot = CSMath.toRadians(CSMath.blend(((Float)armRot.getSecond()).floatValue(), ((Float)armRot.getFirst()).floatValue(), Minecraft.func_71410_x().func_184121_ak(), 0.0f, 1.0f));
        if (!CSMath.betweenInclusive(rightArmRot, -0.01, 0.01)) {
            switch (this.model.field_187076_m) {
                case EMPTY: {
                    this.field_178723_h.field_78795_f -= rightArmRot;
                    this.field_178723_h.field_78808_h = this.field_178723_h.field_78808_h - (holdingLamp ? 0.05f : 0.0f);
                    this.field_178723_h.field_78796_g = 0.0f;
                    break;
                }
                case ITEM: {
                    this.field_178723_h.field_78795_f = (holdingLamp ? this.field_178723_h.field_78795_f * 0.15f - 0.35f : this.field_178723_h.field_78795_f) - rightArmRot;
                    this.field_178723_h.field_78808_h = this.field_178723_h.field_78808_h - (holdingLamp ? 0.05f : 0.0f);
                    this.field_178723_h.field_78796_g = 0.0f;
                }
            }
        }
        RenderLampHand.transformArm(entity, this.field_178723_h, HandSide.RIGHT);
    }

    @Inject(method={"poseLeftArm"}, at={@At(value="TAIL")})
    public void poseLeftArm(LivingEntity entity, CallbackInfo ci) {
        boolean holdingLamp = EntityHelper.holdingLamp(entity, HandSide.LEFT);
        Pair<Float, Float> armRot = HandleSoulLampAnim.LEFT_ARM_ROTATIONS.getOrDefault(entity, (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)));
        float leftArmRot = CSMath.blend(CSMath.toRadians(((Float)armRot.getSecond()).floatValue()), CSMath.toRadians(((Float)armRot.getFirst()).floatValue()), Minecraft.func_71410_x().func_184121_ak(), 0.0f, 1.0f);
        if (!CSMath.betweenInclusive(leftArmRot, -0.01, 0.01)) {
            switch (this.model.field_187075_l) {
                case EMPTY: {
                    this.field_178724_i.field_78795_f -= leftArmRot;
                    this.field_178724_i.field_78808_h = this.field_178724_i.field_78808_h + (holdingLamp ? 0.05f : 0.0f);
                    this.field_178724_i.field_78796_g = 0.0f;
                    break;
                }
                case ITEM: {
                    this.field_178724_i.field_78795_f = (holdingLamp ? this.field_178724_i.field_78795_f * 0.15f - 0.35f : this.field_178724_i.field_78795_f) - leftArmRot;
                    this.field_178724_i.field_78808_h = this.field_178724_i.field_78808_h + (holdingLamp ? 0.05f : 0.0f);
                    this.field_178724_i.field_78796_g = 0.0f;
                }
            }
        }
        RenderLampHand.transformArm(entity, this.field_178724_i, HandSide.LEFT);
    }

    @Mixin(value={BipedModel.class})
    public static class ShiftWidePlayerArm {
        BipedModel self = (BipedModel)this;

        @Inject(method={"setupAnim(Lnet/minecraft/entity/LivingEntity;FFFFF)V"}, at={@At(value="TAIL")})
        public void shiftWidePlayerArm(LivingEntity entity, float limbSwing, float limbSwingAmount, float age, float headYaw, float headPitch, CallbackInfo ci) {
            if (this.self instanceof PlayerModel && !ClientOnlyHelper.isPlayerModelSlim(this.self)) {
                PlayerModel playerModel = (PlayerModel)this.self;
                if (EntityHelper.holdingLamp(entity, HandSide.RIGHT)) {
                    playerModel.field_178723_h.field_78797_d += 1.0f;
                    if (entity instanceof PlayerEntity && entity.func_70678_g(Minecraft.func_71410_x().func_184121_ak()) > 0.0f && EntityHelper.getArmFromHand(entity.field_184622_au, (PlayerEntity)entity) == HandSide.RIGHT) {
                        playerModel.field_178723_h.field_78800_c -= 1.0f;
                    }
                }
                if (EntityHelper.holdingLamp(entity, HandSide.LEFT)) {
                    playerModel.field_178724_i.field_78797_d += 1.0f;
                    if (entity instanceof PlayerEntity && entity.func_70678_g(Minecraft.func_71410_x().func_184121_ak()) > 0.0f && EntityHelper.getArmFromHand(entity.field_184622_au, (PlayerEntity)entity) == HandSide.LEFT) {
                        playerModel.field_178724_i.field_78800_c += 1.0f;
                    }
                }
            }
        }
    }

    @Mixin(value={BipedArmorLayer.class})
    public static class ChestplateArms<T extends LivingEntity, M extends BipedModel<T>, A extends BipedModel<T>> {
        BipedArmorLayer<T, M, A> self = (BipedArmorLayer)this;

        @Inject(method={"renderArmorPiece"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/model/BipedModel;copyPropertiesTo(Lnet/minecraft/client/renderer/entity/model/BipedModel;)V", shift=At.Shift.AFTER)})
        public void renderChestplateArms(MatrixStack poseStack, IRenderTypeBuffer buffer, T entity, EquipmentSlotType slot, int light, A model, CallbackInfo ci) {
            if (slot == EquipmentSlotType.CHEST) {
                if (EntityHelper.holdingLamp(entity, HandSide.RIGHT)) {
                    RenderLampHand.rotateArmorShoulder(entity, model, HandSide.RIGHT, ClientOnlyHelper.isPlayerModelSlim(this.self));
                }
                if (EntityHelper.holdingLamp(entity, HandSide.LEFT)) {
                    RenderLampHand.rotateArmorShoulder(entity, model, HandSide.LEFT, ClientOnlyHelper.isPlayerModelSlim(this.self));
                }
            }
        }
    }

    @Mixin(value={HeldItemLayer.class})
    public static class HeldItem {
        HeldItemLayer self = (HeldItemLayer)this;
        private static boolean WAS_RIGHT_HAND_ADJUSTED = false;

        @Inject(method={"render(Lcom/mojang/blaze3d/matrix/MatrixStack;Lnet/minecraft/client/renderer/IRenderTypeBuffer;ILnet/minecraft/entity/LivingEntity;FFFFFF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/layers/HeldItemLayer;renderArmWithItem(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/model/ItemCameraTransforms$TransformType;Lnet/minecraft/util/HandSide;Lcom/mojang/blaze3d/matrix/MatrixStack;Lnet/minecraft/client/renderer/IRenderTypeBuffer;I)V", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD)
        public void shiftRightArmLamp(MatrixStack ms, IRenderTypeBuffer bufferSource, int light, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci, boolean isMainArm, ItemStack leftHand, ItemStack rightHand) {
            if (rightHand.func_77973_b() == ModItems.SOULSPRING_LAMP && ClientOnlyHelper.isPlayerModelSlim(this.self)) {
                ms.func_227861_a_(-0.03125, 0.0, 0.0);
                WAS_RIGHT_HAND_ADJUSTED = true;
            }
        }

        @Inject(method={"render(Lcom/mojang/blaze3d/matrix/MatrixStack;Lnet/minecraft/client/renderer/IRenderTypeBuffer;ILnet/minecraft/entity/LivingEntity;FFFFFF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/layers/HeldItemLayer;renderArmWithItem(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/model/ItemCameraTransforms$TransformType;Lnet/minecraft/util/HandSide;Lcom/mojang/blaze3d/matrix/MatrixStack;Lnet/minecraft/client/renderer/IRenderTypeBuffer;I)V", ordinal=1)}, locals=LocalCapture.CAPTURE_FAILHARD)
        public void shiftLeftArmLamp(MatrixStack ms, IRenderTypeBuffer bufferSource, int light, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci, boolean isMainArm, ItemStack leftHand, ItemStack rightHand) {
            if (WAS_RIGHT_HAND_ADJUSTED) {
                ms.func_227861_a_(0.03125, 0.0, 0.0);
                WAS_RIGHT_HAND_ADJUSTED = false;
            }
            if (leftHand.func_77973_b() == ModItems.SOULSPRING_LAMP && ClientOnlyHelper.isPlayerModelSlim(this.self)) {
                ms.func_227861_a_(0.03125, 0.0, 0.0);
            }
        }
    }
}

