/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.math;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.util.math.InterruptibleIterator;
import com.momosoftworks.coldsweat.util.math.MapN;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class CSMath {
    private CSMath() {
    }

    public static <T> void doIfNotNull(T object, Consumer<T> run) {
        if (object != null) {
            run.accept(object);
        }
    }

    public static <T, R> R getIfNotNull(T object, Function<T, R> valueGetter, R defaultValue) {
        if (object != null) {
            return valueGetter.apply(object);
        }
        return defaultValue;
    }

    public static float toRadians(float input) {
        return input * ((float)Math.PI / 180);
    }

    public static float toRadians(double input) {
        return (float)input * ((float)Math.PI / 180);
    }

    public static float toDegrees(float input) {
        return input * 57.29578f;
    }

    public static Vector3d toEulerAngles(Quaternion quat) {
        double ysqr = quat.func_195889_a() * quat.func_195889_a();
        double t0 = 2.0 * (double)(quat.func_195894_d() * quat.func_195889_a() + quat.func_195891_b() * quat.func_195893_c());
        double t1 = 1.0 - 2.0 * (ysqr + (double)(quat.func_195891_b() * quat.func_195891_b()));
        double roll = Math.atan2(t0, t1);
        double t2 = 2.0 * (double)(quat.func_195894_d() * quat.func_195891_b() - quat.func_195893_c() * quat.func_195889_a());
        t2 = Math.min(t2, 1.0);
        t2 = Math.max(t2, -1.0);
        double pitch = Math.asin(t2);
        double t3 = 2.0 * (double)(quat.func_195894_d() * quat.func_195893_c() + quat.func_195889_a() * quat.func_195891_b());
        double t4 = 1.0 - 2.0 * (ysqr + (double)(quat.func_195893_c() * quat.func_195893_c()));
        double yaw = Math.atan2(t3, t4);
        return new Vector3d(roll, pitch, yaw);
    }

    public static Quaternion toQuaternion(double x, double y, double z) {
        double cy = Math.cos(z * 0.5);
        double sy = Math.sin(z * 0.5);
        double cp = Math.cos(y * 0.5);
        double sp = Math.sin(y * 0.5);
        double cr = Math.cos(x * 0.5);
        double sr = Math.sin(x * 0.5);
        return new Quaternion((float)(sr * cp * cy - cr * sp * sy), (float)(cr * sp * cy + sr * cp * sy), (float)(cr * cp * sy - sr * sp * cy), (float)(cr * cp * cy + sr * sp * sy));
    }

    public static double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static int ceil(double value) {
        if (value >= 0.0) {
            return (int)Math.ceil(value);
        }
        return (int)Math.floor(value);
    }

    public static int floor(double value) {
        if (value >= 0.0) {
            return (int)Math.floor(value);
        }
        return (int)Math.ceil(value);
    }

    @SafeVarargs
    public static <T extends Comparable<T>> T min(T ... values) {
        T min = values[0];
        for (T value : values) {
            if (value.compareTo(min) >= 0) continue;
            min = value;
        }
        return min;
    }

    @SafeVarargs
    public static <T extends Comparable<T>> T max(T ... values) {
        T max = values[0];
        for (T value : values) {
            if (value.compareTo(max) <= 0) continue;
            max = value;
        }
        return max;
    }

    public static double min(double ... values) {
        double min = values[0];
        for (double value : values) {
            if (!(value < min)) continue;
            min = value;
        }
        return min;
    }

    public static double max(double ... values) {
        double max = values[0];
        for (double value : values) {
            if (!(value > max)) continue;
            max = value;
        }
        return max;
    }

    public static boolean betweenInclusive(double value, double min, double max) {
        return value >= min && value <= max;
    }

    public static boolean betweenExclusive(double value, double min, double max) {
        return value > min && value < max;
    }

    public static double blend(double blendFrom, double blendTo, double factor, double rangeMin, double rangeMax) {
        if (rangeMin > rangeMax) {
            return CSMath.blend(blendTo, blendFrom, factor, rangeMax, rangeMin);
        }
        if (factor <= rangeMin) {
            return blendFrom;
        }
        if (factor >= rangeMax) {
            return blendTo;
        }
        return (blendTo - blendFrom) / (rangeMax - rangeMin) * (factor - rangeMin) + blendFrom;
    }

    public static float blend(float blendFrom, float blendTo, float factor, float rangeMin, float rangeMax) {
        if (rangeMin > rangeMax) {
            return CSMath.blend(blendTo, blendFrom, factor, rangeMax, rangeMin);
        }
        if (factor <= rangeMin) {
            return blendFrom;
        }
        if (factor >= rangeMax) {
            return blendTo;
        }
        return (blendTo - blendFrom) / (rangeMax - rangeMin) * (factor - rangeMin) + blendFrom;
    }

    public static double blendLog(double blendFrom, double blendTo, double factor, double rangeMin, double rangeMax) {
        if (factor <= rangeMin) {
            return blendFrom;
        }
        if (factor >= rangeMax) {
            return blendTo;
        }
        return (blendTo - blendFrom) / Math.sqrt(rangeMax - rangeMin) * Math.sqrt(factor - rangeMin) + blendFrom;
    }

    public static float blendLog(float blendFrom, float blendTo, float factor, float rangeMin, float rangeMax) {
        if (factor <= rangeMin) {
            return blendFrom;
        }
        if (factor >= rangeMax) {
            return blendTo;
        }
        return (blendTo - blendFrom) / (float)Math.sqrt(rangeMax - rangeMin) * (float)Math.sqrt(factor - rangeMin) + blendFrom;
    }

    public static double blendExp(double blendFrom, double blendTo, double factor, double rangeMin, double rangeMax, double intensity) {
        factor = CSMath.clamp(factor, rangeMin, rangeMax);
        double normalizedFactor = (factor - rangeMin) / (rangeMax - rangeMin);
        double expFactor = (Math.pow(intensity, normalizedFactor) - 1.0) / (intensity - 1.0);
        return blendFrom + (blendTo - blendFrom) * expFactor;
    }

    public static float blendExp(float blendFrom, float blendTo, float factor, float rangeMin, float rangeMax, double intensity) {
        return (float)CSMath.blendExp((double)blendFrom, (double)blendTo, (double)factor, (double)rangeMin, (double)rangeMax, intensity);
    }

    public static double blendExp(double blendFrom, double blendTo, double factor, double rangeMin, double rangeMax) {
        return CSMath.blendExp(blendFrom, blendTo, factor, rangeMin, rangeMax, Math.E);
    }

    public static float blendExp(float blendFrom, float blendTo, float factor, float rangeMin, float rangeMax) {
        return CSMath.blendExp(blendFrom, blendTo, factor, rangeMin, rangeMax, Math.E);
    }

    public static float blendInOut(float blendFrom, float blendTo, float factor, float rangeMin, float rangeMax) {
        factor = Math.max(rangeMin, Math.min(factor, rangeMax));
        float normalizedFactor = (factor - rangeMin) / (rangeMax - rangeMin);
        float expFactor = (float)(Math.pow(normalizedFactor, 2.0) / (Math.pow(normalizedFactor, 2.0) + Math.pow(1.0f - normalizedFactor, 2.0)));
        return blendFrom + (blendTo - blendFrom) * expFactor;
    }

    public static double averagePair(Pair<? extends Number, ? extends Number> pair) {
        return (((Number)pair.getFirst()).doubleValue() + ((Number)pair.getSecond()).doubleValue()) / 2.0;
    }

    @SafeVarargs
    public static Pair<Double, Double> addPairs(Pair<? extends Number, ? extends Number> ... pairs) {
        double first = 0.0;
        double second = 0.0;
        for (Pair<? extends Number, ? extends Number> pair : pairs) {
            first += ((Number)pair.getFirst()).doubleValue();
            second += ((Number)pair.getSecond()).doubleValue();
        }
        return Pair.of((Object)first, (Object)second);
    }

    public static double getDistanceSqr(double x1, double y1, double z1, double x2, double y2, double z2) {
        double xDistance = Math.abs(x1 - x2);
        double yDistance = Math.abs(y1 - y2);
        double zDistance = Math.abs(z1 - z2);
        return xDistance * xDistance + yDistance * yDistance + zDistance * zDistance;
    }

    public static double getDistance(Entity entity, Vector3d pos) {
        return CSMath.getDistance(entity, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    public static double getDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(CSMath.getDistanceSqr(x1, y1, z1, x2, y2, z2));
    }

    public static double getDistance(Vector3d pos1, Vector3d pos2) {
        return CSMath.getDistance(pos1.field_72450_a, pos1.field_72448_b, pos1.field_72449_c, pos2.field_72450_a, pos2.field_72448_b, pos2.field_72449_c);
    }

    public static double getDistance(Entity entity, double x, double y, double z) {
        return CSMath.getDistance(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)(entity.func_213302_cg() / 2.0f), entity.func_226281_cx_(), x, y, z);
    }

    public static double getDistance(Vector3i pos1, Vector3i pos2) {
        return Math.sqrt(pos1.func_177951_i(pos2));
    }

    public static double average(Number ... values) {
        double sum = 0.0;
        for (Number value : values) {
            sum += value.doubleValue();
        }
        return sum / (double)values.length;
    }

    public static double weightedAverage(double val1, double val2, double weight1, double weight2) {
        return (val1 * weight1 + val2 * weight2) / (weight1 + weight2);
    }

    public static <A extends Number, B extends Number> double weightedAverage(List<Pair<A, B>> values) {
        double sum = 0.0;
        double weightSum = 0.0;
        for (Pair<A, B> entry : values) {
            double weight = ((Number)entry.getSecond()).doubleValue();
            sum += ((Number)entry.getFirst()).doubleValue() * weight;
            weightSum += weight;
        }
        return sum / Math.max(1.0, weightSum);
    }

    public static Vector3d vectorToVec(Vector3d vec) {
        return new Vector3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public static Direction getDirectionFrom(double x, double y, double z) {
        Direction direction = Direction.NORTH;
        double f = 1.4E-45f;
        for (Direction direction1 : Direction.values()) {
            double f1 = x * (double)direction1.func_82601_c() + y * (double)direction1.func_96559_d() + z * (double)direction1.func_82599_e();
            if (!(f1 > f)) continue;
            f = f1;
            direction = direction1;
        }
        return direction;
    }

    public static Direction getDirectionFrom(Vector3d vec3) {
        return CSMath.getDirectionFrom(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c);
    }

    public static Direction getDirectionFrom(BlockPos from, BlockPos to) {
        return CSMath.getDirectionFrom(to.func_177958_n() - from.func_177958_n(), to.func_177956_o() - from.func_177956_o(), to.func_177952_p() - from.func_177952_p());
    }

    public static <T> void breakableForEach(Collection<T> collection, BiConsumer<T, InterruptibleIterator<T>> consumer) {
        new InterruptibleIterator<T>(collection).run(consumer);
    }

    public static void tryCatch(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static <T> T tryCatch(Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static int sign(double value) {
        if (value == 0.0) {
            return 0;
        }
        return value < 0.0 ? -1 : 1;
    }

    public static int signForRange(double value, double min, double max) {
        return value > max ? 1 : (value < min ? -1 : 0);
    }

    public static double truncate(double value, int sigFigs) {
        return (double)((int)(value * Math.pow(10.0, sigFigs))) / Math.pow(10.0, sigFigs);
    }

    public static boolean isInteger(Number value) {
        return Math.abs(value.doubleValue() - (double)value.intValue()) < 1.0E-4;
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException("Argument \"places\" must be a positive integer.");
        }
        if (CSMath.isInteger(value)) {
            return value;
        }
        BigDecimal bd = new BigDecimal(Double.toString(value));
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static double roundNearest(double value, double multipleOf) {
        return (double)Math.round(value / multipleOf) * multipleOf;
    }

    public static double roundDownNearest(double value, double multipleOf) {
        return Math.floor(value / multipleOf) * multipleOf;
    }

    public static double roundUpNearest(double value, double multipleOf) {
        return Math.ceil(value / multipleOf) * multipleOf;
    }

    public static int blendColors(int colorA, int colorB, float ratio) {
        int aFrom = colorA >> 24 & 0xFF;
        int rFrom = colorA >> 16 & 0xFF;
        int gFrom = colorA >> 8 & 0xFF;
        int bFrom = colorA & 0xFF;
        int aTo = colorB >> 24 & 0xFF;
        int rTo = colorB >> 16 & 0xFF;
        int gTo = colorB >> 8 & 0xFF;
        int bTo = colorB & 0xFF;
        int a = (int)((float)aFrom + (float)(aTo - aFrom) * ratio);
        int r = (int)((float)rFrom + (float)(rTo - rFrom) * ratio);
        int g = (int)((float)gFrom + (float)(gTo - gFrom) * ratio);
        int b = (int)((float)bFrom + (float)(bTo - bFrom) * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static double maxAbs(double ... values) {
        double mostExtreme = 0.0;
        for (double value : values) {
            if (!(Math.abs(value) > Math.abs(mostExtreme))) continue;
            mostExtreme = value;
        }
        return mostExtreme;
    }

    public static double minAbs(double ... values) {
        double smallest = values[0];
        for (double value : values) {
            if (!(Math.abs(value) < Math.abs(smallest))) continue;
            smallest = value;
        }
        return smallest;
    }

    public static boolean equalAbs(double value1, double value2) {
        return Math.abs(value1) == Math.abs(value2);
    }

    public static boolean greaterAbs(double value1, double value2) {
        return Math.abs(value1) > Math.abs(value2);
    }

    public static boolean lessAbs(double value1, double value2) {
        return Math.abs(value1) < Math.abs(value2);
    }

    public static boolean greaterEqualAbs(double value1, double value2) {
        return Math.abs(value1) >= Math.abs(value2);
    }

    public static boolean lessEqualAbs(double value1, double value2) {
        return Math.abs(value1) <= Math.abs(value2);
    }

    public static double shrink(double value, double amount) {
        return Math.max(0.0, Math.abs(value) - amount) * (double)CSMath.sign(value);
    }

    public static double grow(double value, double amount) {
        return Math.abs(value) + amount * (double)CSMath.sign(value);
    }

    public static int shrink(int value, int amount) {
        return value > 0 ? Math.max(0, value - amount) : Math.min(0, value + amount);
    }

    public static int grow(int value, int amount) {
        return value > 0 ? value + amount : value - amount;
    }

    public static Vector3d getCenterPos(BlockPos pos) {
        return new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public static VoxelShape rotateShape(Direction to, VoxelShape shape) {
        VoxelShape[] shapeHolder = new VoxelShape[]{shape, VoxelShapes.func_197880_a()};
        int times = (to.func_176736_b() - Direction.NORTH.func_176736_b() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            shapeHolder[0].func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
                shapeHolder[1] = VoxelShapes.func_197872_a((VoxelShape)shapeHolder[1], (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(1.0 - maxZ, minY, minX, 1.0 - minZ, maxY, maxX)));
            });
            shapeHolder[0] = shapeHolder[1];
            shapeHolder[1] = VoxelShapes.func_197880_a();
        }
        return shapeHolder[0];
    }

    public static VoxelShape flattenShape(Direction.Axis axis, VoxelShape shape) {
        VoxelShape[] shapeHolder = new VoxelShape[]{shape, VoxelShapes.func_197880_a()};
        switch (axis) {
            case X: {
                shapeHolder[0].func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    shapeHolder[1] = VoxelShapes.func_197872_a((VoxelShape)shapeHolder[1], (VoxelShape)VoxelShapes.func_197873_a((double)0.0, (double)minY, (double)minZ, (double)1.0, (double)maxY, (double)maxZ));
                });
                break;
            }
            case Y: {
                shapeHolder[0].func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    shapeHolder[1] = VoxelShapes.func_197872_a((VoxelShape)shapeHolder[1], (VoxelShape)VoxelShapes.func_197873_a((double)minX, (double)0.0, (double)minZ, (double)maxX, (double)1.0, (double)maxZ));
                });
                break;
            }
            case Z: {
                shapeHolder[0].func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    shapeHolder[1] = VoxelShapes.func_197872_a((VoxelShape)shapeHolder[1], (VoxelShape)VoxelShapes.func_197873_a((double)minX, (double)minY, (double)0.0, (double)maxX, (double)maxY, (double)1.0));
                });
            }
        }
        return shapeHolder[1];
    }

    public static boolean withinCubeDistance(BlockPos pos1, BlockPos pos2, double maxDistance) {
        return (double)Math.abs(pos1.func_177958_n() - pos2.func_177958_n()) <= maxDistance && (double)Math.abs(pos1.func_177956_o() - pos2.func_177956_o()) <= maxDistance && (double)Math.abs(pos1.func_177952_p() - pos2.func_177952_p()) <= maxDistance;
    }

    public static Optional<Double> safeDouble(Double value) {
        return value == null || Double.isNaN(value) || Double.isInfinite(value) ? Optional.empty() : Optional.of(value);
    }

    @Nullable
    public static <Key> Key getExactKey(Map<Key, ?> map, Key key) {
        return map.keySet().stream().filter(key::equals).findFirst().orElse(null);
    }

    @SafeVarargs
    @Nullable
    public static <T> T orElse(T ... values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            return values[i];
        }
        return null;
    }

    public static <T> List<T> listOrEmpty(Optional<List<T>> list) {
        return list.orElseGet(Collections::emptyList);
    }

    public static <T> void setOrAppend(List<T> list, int index, T entry) {
        if (index < 0 || index >= list.size()) {
            list.add(entry);
        } else {
            list.set(index, entry);
        }
    }

    @SafeVarargs
    public static <T> List<T> merge(Collection<T> ... lists) {
        ArrayList<T> appended = new ArrayList<T>();
        for (Collection<T> list : lists) {
            appended.addAll(list);
        }
        return appended;
    }

    public static <T> List<T> mutable(List<T> list) {
        return new ArrayList<T>(list);
    }

    public static Class<?> getCallerClass(int depth) {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        String callerClassName = null;
        for (int i = 1 + depth; i < stElements.length; ++i) {
            StackTraceElement ste = stElements[i];
            if (ste.getClassName().indexOf("java.lang.Thread") == 0) continue;
            if (callerClassName == null) {
                callerClassName = ste.getClassName();
                continue;
            }
            if (callerClassName.equals(ste.getClassName())) continue;
            try {
                return Class.forName(ste.getClassName());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public static <K, V> Map<K, V> mapOf() {
        return new MapN(new Object[0]);
    }

    public static <K, V> Map<K, V> mapOf(K k, V v) {
        return new MapN(k, v);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2) {
        return new MapN(k1, v1, k2, v2);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3) {
        return new MapN(k1, v1, k2, v2, k3, v3);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return new MapN(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return new MapN(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        return new MapN(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        return new MapN(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        return new MapN(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        return new MapN(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8, k9, v9);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10) {
        return new MapN(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7, k8, v8, k9, v9, k10, v10);
    }

    public static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static <T> int getIndexOf(T o, List<T> list, BiPredicate<T, T> equals) {
        Object[] es = list.toArray(new Object[0]);
        int size = list.size();
        if (o == null) {
            for (int i = 0; i < size - 1; ++i) {
                if (es[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < size - 1; ++i) {
                if (!equals.test(o, es[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> int getIndexOf(List<T> list, Predicate<T> equals) {
        Object[] es = list.toArray(new Object[0]);
        int size = list.size();
        for (int i = 0; i < size - 1; ++i) {
            if (!equals.test(es[i])) continue;
            return i;
        }
        return -1;
    }

    public static String formatDoubleOrInt(double value) {
        return CSMath.isInteger(value) ? String.valueOf((int)value) : String.valueOf(value);
    }

    @SafeVarargs
    public static <T> boolean containsAny(List<T> list, T ... values) {
        for (T value : values) {
            if (!list.contains(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(String string, String ... values) {
        for (String value : values) {
            if (!string.contains(value)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean anyMatch(List<T> list, Predicate<T> predicate) {
        for (int i = 0; i < list.size(); ++i) {
            if (!predicate.test(list.get(i))) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean anyMatch(Collection<T> collection, Predicate<T> predicate) {
        for (T t : collection) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    public static void fillHorizontalGradient(MatrixStack ps, int x1, int y1, int x2, int y2, int colorFrom, int colorTo) {
        int width = x2 - x1;
        int strips = 50;
        for (int i = 0; i < strips; ++i) {
            int stripX = x1 + width * i / strips;
            int nextStripX = x1 + width * (i + 1) / strips;
            float fraction = (float)i / (float)strips;
            int color = CSMath.blendColors(colorFrom, colorTo, fraction);
            AbstractGui.func_238467_a_((MatrixStack)ps, (int)stripX, (int)y1, (int)nextStripX, (int)y2, (int)color);
        }
    }
}

